%define name cln
%define version 1.1.7
%define release 1

Summary: Class Library for Numbers
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: System Environment/Libraries
Source: %{name}-%{version}.tar.gz
URL: http://clisp.cons.org/~haible/packages-cln.html
Packager: Christian Bauer <cbauer@ginac.de>
Prereq: /sbin/install-info
BuildRoot: %{_tmppath}/%{name}-root
Prefix: %{_prefix}

%description
A GPLed collection of math classes and functions, that will bring
efficiency, type safety, algebraic syntax to everyone in a memory
and speed efficient library.

%package devel
Summary: Development files for programs using the CLN library
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
This package is necessary if you wish to develop software based on
the CLN library.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS -fno-exceptions" ./configure --prefix=%{_prefix} --mandir=%{_mandir} --infodir=%{_infodir}
make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/usr
make prefix=%{_prefix} DESTDIR=${RPM_BUILD_ROOT} install
gzip -9nf ${RPM_BUILD_ROOT}%{_infodir}/cln.info*
mkdir -p ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-devel-%{version}
mv ${RPM_BUILD_ROOT}%{_datadir}/dvi/cln.dvi ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-devel-%{version}
rmdir ${RPM_BUILD_ROOT}%{_datadir}/dvi
mv ${RPM_BUILD_ROOT}%{_datadir}/html ${RPM_BUILD_ROOT}%{_defaultdocdir}/%{name}-devel-%{version}

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%post devel
/sbin/install-info --section="Math" %{_infodir}/cln.info.gz %{_infodir}/dir

%preun devel
if [ "$1" = 0 ]; then
  /sbin/install-info --delete %{_infodir}/cln.info.gz %{_infodir}/dir
fi

%files
%defattr(-,root,root)
%doc COPYING ChangeLog FILES NEWS README TODO*
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{_defaultdocdir}/%{name}-devel-%{version}
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/cln.pc
%{_includedir}/cln
%{_infodir}/*.info*
%{_mandir}/man1/cln-config.1*
%{_bindir}/cln-config
%{_datadir}/aclocal/cln.m4

%changelog
* Thu Nov 20 2003 Christian Bauer <Christian.Bauer@uni-mainz.de>
  Added pkg-config metadata file to devel package
* Wed Nov  6 2002 Christian Bauer <Christian.Bauer@uni-mainz.de>
  Added HTML and DVI docs to devel package
* Tue Nov  5 2001 Christian Bauer <Christian.Bauer@uni-mainz.de>
  Added Packager
