###########################################################################
# clive, video extraction utility
# Copyright (C) 2007 Toni Gundogdu
#
# clive is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 0.1.2-1307 USA
###########################################################################

import os.path


__all__ = [
  'PACKAGE_NAME',
  'PACKAGE_VERSION',
  'PACKAGE_USAGE',
  'PACKAGE_DESC',
  'PACKAGE_SCRIPT',
  'PACKAGE_NOTICE'
]


def read_svnrev():
  """Reads revision from .svn/entries' file and returns it."""
  ENTRIES_FILE = '.svn/entries'
  rev = ''

  if not os.path.exists(ENTRIES_FILE):
    return rev

  f = open(ENTRIES_FILE,'r')

  for ln in f.readlines():
    if ln.find('committed-rev=') != -1:
      rev = 'r'+ln.strip().replace('"','').split('=')[1]
      break
  return rev


PACKAGE_NAME = \
  'clive'

PACKAGE_VERSION = \
  '0.2.1' +read_svnrev()

PACKAGE_USAGE = \
  '%prog [options] url|file'

PACKAGE_DESC = \
  'Video extraction utility for YouTube, Google Video and Dailymotion'

PACKAGE_SCRIPT = \
  'scripts/clive'

PACKAGE_NOTICE = \
  'Copyright (C) 2007 Toni Gundogdu.\n' \
  +PACKAGE_NAME+ ' comes with NO WARRANTY, to the extent permitted by law.\n' \
  'You may redistribute copies of '+PACKAGE_NAME+' under the terms of the\n' \
  'GNU General Public License. For more information about these\n' \
  'matters, see the files named COPYING.'
