#!/bin/sh
# Copyright (c) 2002 Kevin M. Rosenberg
# GNU GPL v2 license
 
if [ ! -f /usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp ] ; then
  echo "*** Can't find common-lisp-controller.lisp ***" >&2
  echo "Please report this as a bug" 2>&1
  exit 1
fi

clisp_dir=/usr/lib/clisp-2.48
clc_lib_dir=/usr/lib/common-lisp/clisp

builder=/usr/bin/clisp

case $1 in
    install-clc)
	echo Installing clc...
	orig_mem=${clisp_dir}/full/lispinit-orig.mem
	target_mem=${clisp_dir}/full/lispinit.mem
	if [ ! -f ${orig_mem} ] ; then
	   echo "Cannot find the orignal memory file"
	   echo "\"${orig_mem}\"."
	   echo "we do have in ${clisp_dir}/full:"
	   ls -ltr ${clisp_dir}/full
	   exit 5
	fi
	if [ -x ${builder} ]; then
	    if ${builder} -norc -q -M ${orig_mem} \
		-on-error exit -x "
(handler-case
  (progn 
    (when (find-package :c-l-c) ; have to remove 
      (delete-package :c-l-c))  ; for clisp workaround
    (load \"$clisp_dir/install-clc.lisp\") 
    (saveinitmem \"${target_mem}\")
    (ext:exit 0))
  (error (e)
    (ignore-errors (format t \"~&install-clc error: ~A~%\" e))
    (finish-output)
    (ext:exit 1)))" ; then
               # build worked?
	       if [ -f ${target_mem} ] ; then
	         echo "created ${target_mem} as expected."
		 ls -l ${target_mem}
	       else
	         echo "Did not find resulting ${target_file} that I expected"
		 exit 3
	       fi
	    else
	      echo "Building of new image failed!"
	      exit 4
	   fi
        else
	   echo "Builder $builder not found!"
	   exit 2
	fi
	;;
    *)
	echo "`basename $0`: Unknown command $1" >&2
	echo "Known commands are:" >&2 
	echo "install-clc" >&2
	exit 1
	;;
esac

exit 0
