/*
 * Copyright 2013 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "application.h"
#include <QStringList>
#include <apt-pkg/debversion.h>
#include <QDebug>

namespace ClickPlugin {

Application::Application(QQuickItem *parent) :
    QQuickItem(parent)
{
    this->m_packagename = "";
    this->m_title = "";
    this->m_local_version = "";
    this->m_remote_version = "";
    this->m_dbuspath = "";
    this->m_update = false;
    this->m_update_state = false;
    this->m_selected = false;
    this->m_icon_url = "";
    this->m_binary_filesize = 0;
}

void Application::initializeApplication(QString packagename, QString title, QString version)
{
    this->m_packagename = packagename;
    this->m_title = title;
    this->m_local_version = version;
}

void Application::setRemoteVersion(QString& version)
{
    this->m_remote_version = version;

    int result = debVS.CmpVersion(this->m_local_version.toUtf8().data(),
                                  this->m_remote_version.toUtf8().data());

    this->m_update = result < 0;
}

void Application::setError(QString error) {
    this->m_error = error;
    if(!this->m_error.isEmpty()) {
        emit this->errorChanged();
    }
}

}
