# test bytecode interpreter - statements

# Copyright (c) 2007 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use Language::INTERCAL::GenericIO '1.-94.-3', qw($devnull);
use Language::INTERCAL::Interpreter '1.-94.-3';
use Language::INTERCAL::Rcfile '1.-94.-3';
use Language::INTERCAL::ByteCode '1.-94.-3', qw(:BC reg_code);
use Language::INTERCAL::Splats '1.-94.-3', qw(:SP);
use Language::INTERCAL::Sick '1.-94.-3';

my @all_tests = (
    ['Comment 1', undef, '', "*000 ERROR\n", 0,
     'ERROR', [], [BC_MSP, BC(0), BC(1), _str('ERROR')]],
    ['Comment 2', undef, '', "*578 Invalid bytecode pattern in NAME: PROBLEM\n", 578,
     '(Invalid code)', [],
     [BC_MSP, BC(578), BC(2), _str('NAME'), _str('PROBLEM')]],
    ['Compiler BUG 1', undef, '', "*774 Compiler error\n", 774,
     'BUG', [], [BC_BUG, BC(0)]],
    ['Compiler BUG 2', undef, '', "*775 Unexplainable compiler error\n", 775,
     'BUG', [], [BC_BUG, BC(1)]],
    ['READ OUT 1', undef, '', "II\n", undef,
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['READ OUT 2', undef, '', "ABCD\n", undef,
     'DO READ OUT <ARRAY>', [],
     [BC_ROU, BC(1), _str("[_CYNI")]],
    ['READ OUT 3', undef, '', "ABCD\n", undef,
     'DO ,2 <- #6', [], [BC_STO, BC(6), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #89', [], [BC_STO, BC(89), BC_SUB, BC(4), BC_TAI, BC(2)],
     'DO ,2 SUB #4 <- #78', [], [BC_STO, BC(78), BC_SUB, BC(5), BC_TAI, BC(2)],
     'DO ,2 SUB #5 <- #73', [], [BC_STO, BC(73), BC_SUB, BC(6), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['READ OUT 4', undef, '', "Hi\n", undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #29', [], [BC_STO, BC(29), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #1118', [], [BC_STO, BC(1118), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #3 <- #92', [], [BC_STO, BC(92), BC_SUB, BC(3), BC_HYB, BC(2)],
     'DO READ OUT ;2', [], [BC_ROU, BC(1), BC_HYB, BC(2)]],
    ['READ OUT 5', undef, '', "Hi\n", undef,
     'DO %IO <- ?C', [], [BC_STO, _str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #238', [], [BC_STO, BC(238), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #124', [], [BC_STO, BC(124), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #70', [], [BC_STO, BC(70), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ;2 + ,2', [], [BC_ROU, BC(2), BC_HYB, BC(2), BC_TAI, BC(2)]],
# XXX READ OUT 6 - CLASS
    ['WRITE IN 1', undef, 'TWO SIX', "XXVI\n", undef,
     'DO WRITE IN .2', [], [BC_WIN, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['WRITE IN 2', undef, 'ABCD', "ABCD\n", undef,
     'DO ,2 <- #7', [], [BC_STO, BC(7), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['WRITE IN 3', undef, 'TWO SIX', "XXVI\n", undef,
     'DO WRITE IN #2', [], [BC_WIN, BC(1), BC(2)],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['WRITE IN 4', undef, "Hi\n", "XV\nLXIII\nXV\n", undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO WRITE IN ;2', [], [BC_WIN, BC(1), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #1', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #2', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #3', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(3), BC_HYB, BC(2)]],
    ['WRITE IN 5', undef, "Hi\n", "LXXII\nXXXIII\nCLXI\n", undef,
     'DO %IO <- ?C', [], [BC_STO, _str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ;2 + ,2', [], [BC_WIN, BC(2), BC_HYB, BC(2), BC_TAI, BC(2)],
     'DO READ OUT ;2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT ;2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT ,2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_TAI, BC(2)]],
# XXX WRITE IN 6 - CLASS
    ['NOT', undef, '', "IV\n", undef,
     'DO NOT READ OUT #2', [BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['Double Oh Seven 1', undef, '', [10, '', "II\n"], undef,
     'DO %50 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)]],
    ['Double Oh Seven 2', undef, '', [10, '', "II\n", "IV\n", "II\nIV\n"], undef,
     'DO %50 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)],
     'DO %50 READ OUT #4', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(4)]],
    ['Double Oh Seven 3', undef, '', [10, '', "II\n", "IV\n", "II\nIV\n"], undef,
     'DO %75 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)],
     'DO %25 READ OUT #4', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE LABEL', undef, '', "II\nIV\n", undef,
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE COMPUTED LABEL', undef, '', "II\nIV\n", undef,
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     '(.1) DO NOT READ OUT #2', [BC_LAB, BC_SPO, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['COMPUTED REINSTATE LABEL', undef, '', "II\nIV\n", undef,
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO REINSTATE (.1)', [], [BC_REL, BC_SPO, BC(1)],
     '(2) DO NOT READ OUT #2', [BC_LAB, BC(2), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE OVERLOADED LABEL', undef, '', "II\nIV\n", undef,
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['OVERLOADED REINSTATE LABEL', undef, '', "II\nIV\n", undef,
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(2) DO NOT READ OUT #2', [BC_LAB, BC(2), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE GERUND', undef, '', "II\nIV\n", undef,
     'DO REINSTATE READING OUT', [], [BC_REG, BC(1), BC_ROU],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM LABEL', undef, '', "IV\n", undef,
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM COMPUTED LABEL', undef, '', "IV\n", undef,
     'DO ABSTAIN FROM (2)', [], [BC_ABL, BC(2)],
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     '(.1) DO READ OUT #2', [BC_LAB, BC_SPO, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['COMPUTED ABSTAIN FROM LABEL', undef, '', "IV\n", undef,
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ABSTAIN FROM (.1)', [], [BC_ABL, BC_SPO, BC(1)],
     '(2) DO READ OUT #2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM OVERLOADED LABEL', undef, '', "IV\n", undef,
     'DO ABSTAIN FROM (2)', [], [BC_ABL, BC(2)],
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['OVERLOADED ABSTAIN FROM LABEL', undef, '', "IV\n", undef,
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     '(2) DO READ OUT #2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM GERUND', undef, '', '', undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN + REINSTATE 1', undef, '', "II\n", undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN + REINSTATE 2', undef, '', "", undef,
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['STASH/RETRIEVE 1', undef, '', "II\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['STASH/RETRIEVE 2', undef, '', "A\n", undef,
     'DO ,1 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(1)],
     'DO ,1 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO STASH ,1', [], [BC_STA, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #68', [], [BC_STO, BC(68), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO READ OUT ,1', [], [BC_ROU, BC(1), BC_TAI, BC(1)]],
    ['STASH/RETRIEVE 3', undef, '', "*436 Register ,1 stashed away too well\n", SP_HIDDEN,
     'DO ,1 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(1)],
     'DO ,1 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO STASH ,1', [], [BC_STA, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #68', [], [BC_STO, BC(68), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO READ OUT ,1', [], [BC_ROU, BC(1), BC_TAI, BC(1)]],
    ['IGNORE 1', undef, '', "II\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['IGNORE 2', undef, 'TWO SIX', "II\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO WRITE IN .1', [], [BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['IGNORE 3', undef, 'TEST', "A\n", undef,
     'DO ,2 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO IGNORE ,2', [], [BC_IGN, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['IGNORE 5', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 1', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 2', undef, 'TWO SIX', "XXVI\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO WRITE IN .1', [], [BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 3', undef, 'TEST', "TEST\n", undef,
     'DO ,2 <- #7', [], [BC_STO, BC(7), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO IGNORE ,2', [], [BC_IGN, BC(1), BC_TAI, BC(2)],
     'DO REMEMBER ,2', [], [BC_REM, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['REMEMBER 5', undef, '', "II\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['ENSLAVE 1', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .1', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO $.2 <- #4', [], [BC_STO, BC(4), BC_OWN, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['ENSLAVE 2', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .1', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .3', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO ENSLAVE .2 TO .4', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO 3.2 <- #4', [], [BC_STO, BC(4), BC_OWN, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['ENSLAVE 3', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .1', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .3', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO ENSLAVE .2 TO .4', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO ENSLAVE .3 TO .2', [], [BC_ENS, BC_SPO, BC(3), BC_SPO, BC(2)],
     'DO ENSLAVE .3 TO .1', [], [BC_ENS, BC_SPO, BC(3), BC_SPO, BC(1)],
     'DO ENSLAVE .4 TO .3', [], [BC_ENS, BC_SPO, BC(4), BC_SPO, BC(3)],
     'DO $23.4 <- #4', [], [BC_STO, BC(4), BC_OWN, BC(3), BC_OWN, BC(2), BC_OWN, BC(1), BC_SPO, BC(4)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['FREE 1', undef, '', "IV\n", undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .1', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .3', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO ENSLAVE .2 TO .4', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO ENSLAVE .3 TO .2', [], [BC_ENS, BC_SPO, BC(3), BC_SPO, BC(2)],
     'DO ENSLAVE .3 TO .1', [], [BC_ENS, BC_SPO, BC(3), BC_SPO, BC(1)],
     'DO ENSLAVE .4 TO .1', [], [BC_ENS, BC_SPO, BC(4), BC_SPO, BC(1)],
     'DO ENSLAVE .4 TO .3', [], [BC_ENS, BC_SPO, BC(4), BC_SPO, BC(3)],
     'DO FREE .4 FROM .1', [], [BC_FRE, BC_SPO, BC(4), BC_SPO, BC(1)],
     'DO FREE .2 FROM .3', [], [BC_FRE, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO $22.4 <- #4', [], [BC_STO, BC(4), BC_OWN, BC(2), BC_OWN, BC(2), BC_OWN, BC(1), BC_SPO, BC(4)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['FREE 2', undef, '', "*511 Register .4 is not a slave\n", 511,
     'DO FREE .4 FROM .1', [], [BC_FRE, BC_SPO, BC(4), BC_SPO, BC(1)]],
    ['FREE 3', undef, '', "*512 Register .2 does not belong to register .2\n", 512,
     'DO ENSLAVE .2 TO .1', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO ENSLAVE .2 TO .3', [], [BC_ENS, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO FREE .2 FROM .2', [], [BC_FRE, BC_SPO, BC(2), BC_SPO, BC(2)]],
    ['COME FROM LABEL', undef, '', "X\nV\n", undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COMPUTED COME FROM LABEL', undef, '', "X\nV\n", undef,
     '(69) DO .1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (.1)', [], [BC_CFL, BC_SPO, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COME FROM COMPUTED LABEL', undef, '', "X\nV\n", undef,
     '(.1) DO .1 <- #69', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COME FROM OVERLOADED LABEL', undef, '', "X\nV\n", undef,
     '(1) DO #1 <- #69', [BC_LAB, BC(1)], [BC_STO, BC(69), BC(1)],
     'DO #1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT #69', [], [BC_ROU, BC(1), BC(69)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO #1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC(1)]],
    ['OVERLOADED COME FROM LABEL', undef, '', "X\nV\n", undef,
     '(69) DO #1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC(1)],
     'DO #1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT #69', [], [BC_ROU, BC(1), BC(69)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO #1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC(1)]],
    ['COME FROM GERUND', undef, '', "X\nV\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO ABSTAIN FROM (99)', [], [BC_ABL, BC(99)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM ABSTAINING', [], [BC_CFG, BC(2), BC_ABL, BC_ABG],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['%50 COME FROM LABEL', undef, '', [10, "X\nV\n", "II\n"], undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO %50 COME FROM (69)', [BC_DSX, BC(50)], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['NOT COME FROM LABEL', undef, '', "II\n", undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NOT COME FROM (69)', [BC_NOT], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['ABSTAINED COME FROM LABEL', undef, '', "II\n", undef,
     'DO ABSTAIN FROM COMING FROM', [], [BC_ABG, BC(2), BC_CFL, BC_CFG],
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['REINSTATED NOT COME FROM LABEL', undef, '', "X\nV\n", undef,
     'DO REINSTATE COMING FROM', [], [BC_REG, BC(2), BC_CFL, BC_CFG],
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NOT COME FROM (69)', [BC_NOT], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['MULTIPLE COME FROM - UNTHREADED', undef, '', "*555 Multiple \"COME FROM\" 69\n", 555,
     '(69) DO .1 <- #2', [BC_LAB, BC(69)], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SWB, BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)]],
    ['MULTIPLE COME FROM - THREADED', undef, '', [1, "II\n", "III\n", "X\n"], undef,
     'DO %CF <- #1', [], [BC_STO, BC(1), reg_code('%CF')],
     '(69) DO .1 <- #2', [BC_LAB, BC(69)], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SWB, BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)]],
    ['NEXT', undef, '', "I\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(60) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['RESUME 1', undef, '', "I\nX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['RESUME 2', undef, '', "I\n*632 Program terminated via RESUME\n", 632,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['RESUME 3', undef, '', "I\n*621 Pointless RESUME\n", 621,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #0', [], [BC_RES, BC(0)]],
    ['RESUME 4', undef, '', "I\nV\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     '(68) DO (69) NEXT', [BC_LAB, BC(68)], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (68)', [], [BC_CFL, BC(68)],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['FORGET 1', undef, '', "I\n*632 Program terminated via RESUME\n", 632,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO FORGET #1', [], [BC_FOR, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['FORGET 2', undef, '', "XX\nX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['NEXT FROM LABEL', undef, '', "X\nII\n", undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME .1', [], [BC_RES, BC_SPO, BC(1)]],
    ['COMPUTED NEXT FROM LABEL', undef, '', "X\nII\n", undef,
     '(69) DO .1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (.1)', [], [BC_NXL, BC_SPO, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['NEXT FROM COMPUTED LABEL', undef, '', "X\nV\n", undef,
     '(.1) DO .1 <- #69', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO .1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['OVERLOADED NEXT FROM LABEL', undef, '', "X\nIII\n", undef,
     'DO #2 <- #1', [], [BC_STO, BC(1), BC(2)],
     '(69) DO #1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC(1)],
     'DO READ OUT #3', [], [BC_ROU, BC(1), BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (1)', [], [BC_NXL, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['NEXT FROM OVERLOADED LABEL', undef, '', "X\nV\n", undef,
     'DO #2 <- #1', [], [BC_STO, BC(1), BC(2)],
     '(1) DO #1 <- #69', [BC_LAB, BC(1)], [BC_STO, BC(69), BC(1)],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO #1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['NEXT FROM GERUND', undef, '', "X\nV\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO ABSTAIN FROM (99)', [], [BC_ABL, BC(99)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM ABSTAINING', [], [BC_NXG, BC(2), BC_ABL, BC_ABG],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO .1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['STUDY 1', undef, '', "M\nMM\n", undef,
     'DO STUDY #1 AT (1000) IN CLASS @2', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)]],
    ['STUDY 2', undef, '', "*999 Lecture at 100 is too early\n", 999,
     'DO STUDY #1 AT (100) IN CLASS @2', [], [BC_STU, BC(1), BC(100), BC_WHP, BC(2)]],
    ['ENROL 1', undef, '', "M\nMM\n", undef,
     'DO STUDY #1 AT (1000) IN CLASS @2', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO ENROL .2 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(2)],
     'DO ENROL .3 TO LEARN #1 + #2', [], [BC_ENR, BC(2), BC(1), BC(2), BC_SPO, BC(3)],
     'DO READ OUT @2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)]],
    ['ENROL 2', undef, '', "*799 No class teaches subjects #1 + #2\n", 799,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1 + #2', [], [BC_ENR, BC(2), BC(1), BC(2), BC_SPO, BC(1)]],
    ['ENROL 3', undef, '', "*603 Class war between \@1 and \@2\n", 603,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #1 AT (2000) IN CLASS @2', [], [BC_STU, BC(1), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)]],
    ['LEARNS 1', undef, '', "M\n", undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)]],
    ['LEARNS 2', undef, '', "*822 Register .1 is not a student\n", 822,
     'DO .1 LEARNS #4', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['LEARNS 3', undef, '', "*823 Subject #4 is not in .1's curriculum\n", 823,
     'DO STUDY #2 AT (3000) IN CLASS @1', [], [BC_STU, BC(2), BC(3000), BC_WHP, BC(1)],
     'DO STUDY #3 AT (4000) IN CLASS @2', [], [BC_STU, BC(3), BC(4000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(1)],
     'DO ENROL .1 TO LEARN #3', [], [BC_ENR, BC(1), BC(3), BC_SPO, BC(1)],
     'DO .1 LEARNS #4', [], [BC_LEA, BC(4), BC_SPO, BC(1)]],
    ['LEARNS 4', undef, '', "*603 Class war between \@1 and \@2\n", 603,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #1 AT (2000) IN CLASS @2', [], [BC_STU, BC(1), BC(2000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (3000) IN CLASS @1', [], [BC_STU, BC(2), BC(3000), BC_WHP, BC(1)],
     'DO STUDY #3 AT (4000) IN CLASS @2', [], [BC_STU, BC(3), BC(4000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(1)],
     'DO ENROL .1 TO LEARN #3', [], [BC_ENR, BC(1), BC(3), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['FINISH LECTURE 1', undef, '', "M\nV\n", undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)],
     'DO $@1 <- #5', [], [BC_STO, BC(5), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['FINISH LECTURE 2', undef, '', "M\nX\n", undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     '(69) DO .1 LEARNS #1', [BC_LAB, BC(69)], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)],
     'DO $@1 <- #5', [], [BC_STO, BC(5), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['FINISH LECTURE 3', undef, '', "*699 Not in a lecture\n", 699,
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['GRADUATES', undef, '', "*822 Register .1 is not a student\n", 822,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 GRADUATES', [], [BC_GRA, BC_SPO, BC(1)],
     'DO .1 LEARNS #4', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['SWAP 1', undef, '', "XX\nX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP RESUME EXPRESSION AND FORGET EXPRESSION', [], [BC_SWA, BC_RES, BC_FOR],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO RESUME #1', [], [BC_RES, BC(1)],  # really executed as FORGET
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['SWAP 2', undef, '', "XX\nX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP SWAP STATEMENT AND STATEMENT AND CONVERT STATEMENT TO STATEMENT', [], [BC_SWA, BC_SWA, BC_CON],
     'DO CONVERT RESUME EXPRESSION TO FORGET EXPRESSION', [], [BC_CON, BC_RES, BC_FOR],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO RESUME #1', [], [BC_RES, BC(1)],  # really executed as FORGET
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['SWAP 3', undef, '', "*445 Cannot swap RES and FIN\n", 445,
     'DO SWAP RESUME EXPRESSION AND FINISH LECTURE', [], [BC_SWA, BC_RES, BC_FIN]],
    ['CONVERT 1', undef, '', "XX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO CONVERT FORGET EXPRESSION TO RESUME EXPRESSION', [], [BC_CON, BC_FOR, BC_RES],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['CONVERT 2', undef, '', "XX\n", undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP SWAP STATEMENT AND STATEMENT AND CONVERT STATEMENT TO STATEMENT', [], [BC_SWA, BC_SWA, BC_CON],
     'DO SWAP FORGET EXPRESSION AND RESUME EXPRESSION', [], [BC_SWA, BC_FOR, BC_RES],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['CONVERT 3', undef, '', "*444 Cannot convert RES to FIN\n", 444,
     'DO CONVERT RESUME EXPRESSION AND FINISH LECTURE', [], [BC_CON, BC_RES, BC_FIN]],
    ['CREATE 1', '1972', '', "\nII\n\nIII\n", undef,
     # extend the 1972 compiler with Unary Division and call it D
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO .1 <- #D8', [], [BC_MSP, BC(0), BC(1), _str('DO .1 <- #D8')],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #D3', [], [BC_MSP, BC(0), BC(1), _str('DO .1 <- #D3')],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['DESTROY', 'sick', '', "II\n*000 DO .1 <- #-8\n", 0,
     # extend sick to have another name for unary division, then destroy original
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO DESTROY ?UNARY ,#45,', [],
     [BC_DES, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('-')],
     'DO .1 <- #D8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #-8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['CREATE 2', 'sick', '', "II\nII\n", undef,
     # add D as unary division; delete original and new; then add them again;
     # note that the program needs only be recompiled once even though there
     # are many creations/destructions
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO DESTROY ?UNARY ,#45,', [],
     [BC_DES, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('-')],
     'DO DESTROY ?UNARY ,D,', [],
     [BC_DES, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('D')],
     'DO CREATE ?UNARY ,#45, AS UDV', [],
     [BC_CRE, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('-'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), _str('UNARY'), BC(1), BC(0), BC(1), _str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO .1 <- #D8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #-8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['EVENTS 1', undef, '', "IV\nVI\nII\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO #1 WHILE READ OUT .2', [], [BC_ECB, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 2', undef, '', "VI\nII\n*456 No splat\nIV\n", 456,
     'DO * WHILE READ OUT .2', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 3', undef, '', "VI\nII\nIV\n", undef,
     'DO * WHILE READ OUT .2', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 4', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE #1', [], [BC_EBC, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 5', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO READ OUT .2 WHILE *', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 6', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO READ OUT .2 WHILE *', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 7', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE #1', [], [BC_ECB, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 8', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO READ OUT .2 WHILE *', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 9', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO READ OUT .2 WHILE *', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 10', undef, '', "IV\nVI\nII\n", undef,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO #1 WHILE READ OUT .2', [], [BC_EBC, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 11', undef, '', "VI\nII\n*456 No splat\nIV\n", 456,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO * WHILE READ OUT .2', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 12', undef, '', "VI\nII\nIV\n", undef,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO * WHILE READ OUT .2', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 13', undef, '', "VI\n*456 No splat\nIII\n", 456,
     'DO * WHILE (1) NEXT', [], [BC_ECB, BC_SPL, BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 14', undef, '', "VI\nIII\n", undef,
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 15', undef, '', "VI\n", undef,
     'DO ABSTAIN FROM NEXTING', [], [BC_ABG, BC(1), BC_NXT],
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 16', undef, '', "VI\n", undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(2) DO READ OUT .2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 17', undef, '', "III\nVI\n", undef,
     '(1) DO #1 WHILE (2) NEXT', [BC_LAB, BC(1)], [BC_ECB, BC(1), BC_NXT, BC(2)],
     'DO .2 <- #8', [], [BC_STO, BC(8), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .1 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO .2 <- #3', [BC_LAB, BC(2)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 18', undef, '', [1, "VI\n", "IV\n", "III\n"], undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO #1 WHILE REINSTATE READING OUT', [], [BC_ECB, BC(1), BC_REG, BC(1), BC_ROU],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO NOT READ OUT %CF', [BC_NOT], [BC_ROU, BC(1), reg_code('%CF')],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP]],
    ['LOOPS 1a', undef, 'SIX', "IV\nVI\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['LOOPS 1b', undef, 'SIX', "IV\nVI\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['LOOPS 2a', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 2b', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 3a', undef, '', "IV\nIV\nII\nII\nII\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO .2 LEARNS #1 WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_LEA, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 3b', undef, '', "IV\nIV\nII\nII\nII\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO .2 LEARNS #1 WHILE READ OUT .2', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 4a', undef, '', "IV\nV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO READ OUT .2 WHILE (2) NEXT', [],
      [BC_CWB, BC_NXT, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 4b', undef, '', "IV\nV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO READ OUT .2 WHILE (2) NEXT', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 5a', undef, '', "V\nV\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE (2) NEXT', [],
      [BC_CWB, BC_NXT, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 5b', undef, '', "V\nV\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE (2) NEXT', [],
      [BC_BWC, BC_NXT, BC(1), BC_NXT, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 6a', undef, '', "V\nII\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE (1) NEXT', [],
      [BC_CWB, BC_NXT, BC(1), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(1) DO READ OUT .3', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 6b', undef, '', "V\nII\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE (1) NEXT', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(3), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(1) DO READ OUT .3', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 7a', undef, '', "IV\nV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE .2 LEARNS #1', [],
      [BC_CWB, BC_LEA, BC(1), BC_SPO, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT .3', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 7b', undef, '', "IV\nV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE .2 LEARNS #1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_LEA, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT .3', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 8a', undef, '', "V\nV\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE .3 LEARHS #1', [],
      [BC_CWB, BC_LEA, BC(1), BC_SPO, BC(3), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(1000) DO READ OUT $@1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 8b', undef, '', "V\nV\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE .3 LEARHS #1', [],
      [BC_BWC, BC_NXT, BC(1), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(1000) DO READ OUT $@1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 9a', undef, '', "V\nII\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @1', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE .3 LEARNS #2', [],
      [BC_CWB, BC_LEA, BC(2), BC_SPO, BC(3), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(2000) DO READ OUT $@1', [BC_LAB, BC(2000)], [BC_ROU, BC(1), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 9b', undef, '', "V\nII\n", undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @1', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE .3 LEARNS #2', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(3), BC_LEA, BC(2), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(2000) DO READ OUT $@1', [BC_LAB, BC(2000)], [BC_ROU, BC(1), BC_OWN, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 10a', undef, '', "IV\nIV\nIV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 10b', undef, '', "IV\nIV\nIV\n", undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 11a', undef, 'SIX', "IV\nVI\nV\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 11b', undef, 'SIX', "IV\nVI\nV\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 12a', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 12b', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\n", undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 13a', undef, 'SIX', "IV\nVI\nV\nV\n", undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 13b', undef, 'SIX', "IV\nVI\nV\nV\n", undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 14a', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\nXII\n", undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 14b', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\nXII\n", undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 15a', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef,
     'DO SWAP CONDITION WHILE BODY AND BODY WHILE CONDITION', [], [BC_SWA, BC_CWB, BC_BWC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 15b', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef,
     'DO SWAP CONDITION WHILE BODY AND BODY WHILE CONDITION', [], [BC_SWA, BC_CWB, BC_BWC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
);

$| = 1;

my $maxtest = 0;
for my $tester (@all_tests) {
    my ($name, $load, $in, $out, $splat, @data) = @$tester;
    $maxtest += 2;
    $maxtest += $out->[0] - 1 if ref $out;
}
print "1..$maxtest\n";

my $testnum = 1;
my $rc = new Language::INTERCAL::Rcfile;
my $compiler = new Language::INTERCAL::Sick($rc);
TESTER:
for my $tester (@all_tests) {
    my ($name, $load, $in, $out, $splat, @data) = @$tester;
    my ($iter, @out) = ref $out ? @$out : (1, $out);
    my $obj;
    if ($load) {
	eval {
	    $compiler->reset();
	    $compiler->setoption('default_charset', 'ASCII');
	    $compiler->setoption('default_backend', 'Run');
	    $compiler->clearoption('preload');
	    $compiler->setoption('preload', $load);
	    $compiler->setoption('trace', 0);
	    $compiler->source('null.iacc');
	    $compiler->load_objects();
	    $obj = $compiler->get_object('null.iacc')
		or die "Internal error: no compiler object\n";
	};
	if ($@) {
	    print STDERR "FAILED $name: $@";
	    print "not ok ", $testnum++, "\n" for (-1..$iter);
	    next;
	}
    } else {
	$obj = new Language::INTERCAL::Interpreter($rc);
    }
    $obj->object->setbug(0, 0);
    my $source = '';
    my @code = ();
    while (@data) {
	my $ss = (shift @data) . "\n";
	my $sp = shift @data;
	my $sc = shift @data;
	push @code, pack('C*', BC_STS, BC(length $source), BC(length $ss),
			       BC(0), BC(0), @$sp, @$sc);
	$source .= $ss;
    }
    push @code, pack('C*', BC_STS, BC(length $source), BC(11),
			   BC(0), BC(0), BC_GUP);
    $source .= "DO GIVE UP\n";
    my $i_data = $in;
    my $i_fh = Language::INTERCAL::GenericIO->new('STRING', 'w', \$i_data);
    my $o_data = '';
    my $o_fh = Language::INTERCAL::GenericIO->new('STRING', 'r', \$o_data);
    eval {
	$obj->object->source($source);
	$obj->object->code(\@code);
	$obj->setreg('@TRFH', $devnull);
	$obj->setreg('@OWFH', $i_fh);
	$obj->setreg('@OSFH', $o_fh);
	$obj->setreg('@ORFH', $o_fh);
	$obj->start()->run()->stop();
    };
    if ($@) {
	print "not ok ", $testnum++, "\n" for (0..$iter);
	print STDERR "Failed $name: $@";
	next;
    }
    my $os = $obj->splat;
    if (defined $os) {
	print defined $splat && $os == $splat ? "" : "not ", "ok ", $testnum++, "\n";
	print STDERR "Failed $name (*$os)\n" unless defined $splat && $os == $splat;
    } else {
	print defined $splat ? "not " : "", "ok ", $testnum++, "\n";
	print STDERR "Failed $name (no splat)\n" if defined $splat;
    }
    my %out = map { ($_ => 0) } @out;
    if (ref $out && $out->[0] == 1) {
	my $ok = 1;
	for my $o (@out) {
	    my $i = index($o_data, $o);
	    if ($i < 0) {
		print STDERR "Failed $name: no $o", $o =~ /\n$/ ? '' : "\n";
		$ok = 0;
	    } else {
		substr($o_data, $i, length($o)) = '';
	    }
	}
	if ($o_data ne '') {
	    $ok and print STDERR "Failed $name: did not print $o_data", $o_data =~ /\n$/ ? '' : "\n";
	    $ok = 0;
	}
	print $ok ? '' : 'not ', "ok ", $testnum++, "\n";
    } else {
	print STDERR "Failed $name: no $o_data", $o_data =~ /\n$/ ? '' : "\n" if ! exists $out{$o_data};
	print exists $out{$o_data} ? '' : 'not ', "ok ", $testnum++, "\n";
	$out{$o_data}++ if exists $out{$o_data};
    }
    next unless ref $out;
    next if $out->[0] == 1;
    for (my $inum = 1; $inum < $iter; $inum++) {
	$i_data = $in;
	$o_data = '';
	$o_fh->reset;
	eval { $obj->start()->run()->stop() };
	print STDERR "Failed $name: no $o_data", $o_data =~ /\n$/ ? '' : "\n" if ! exists $out{$o_data};
	print exists $out{$o_data} ? '' : 'not ', "ok ", $testnum++, "\n";
	$out{$o_data}++ if exists $out{$o_data};
    }
}

sub _str {
    my ($str) = @_;
    return (BC_STR, BC(length $str), unpack('C*', $str));
}

