# test the options for intercalc

use IPC::Open3 qw(open3);

my @tests = (
    ['Base 2', '2', '1972', ['#V6'], ['VII #V6']],
    ['Base 3', '3', '1972', ['#V6'], ['VIII #V6']],
    ['Base 4', '4', '1972', ['#V6'], ['xxxiiDCCLXXIV #V6']],
    ['Base 5', '5', '1972', ['#V6'], ['MMMCXXXI #V6']],
    ['Base 6', '6', '1972', ['#V6'], ['VII #V6']],
    ['Base 7', '7', '1972', ['#V6'], ['xivCDXII #V6']],
    ['Bitwise divide 1', 'bitwise-divide', 'sick', ['#-65535'], ['I #-65535']],
    ['Bitwise divide 2', '2', 'sick', ['#-65535'], ['II #-65535']],
);

my $maxtest = @tests;
print "1..$maxtest\n";

my @l = map { "-I$_" } @INC;

my $testnum = 1;
for my $test (@tests) {
    my ($name, $option, $lang, $in, $out) = @$test;
    open3(\*READ, \*WRITE, \*WRITE, $^X, @l, 'bin/intercalc', '--batch', '-mexpr', '-l' . $lang, '-o' . $option);
    select READ; $| = 1; select STDOUT;
    print READ "$_\n" for @$in;
    close READ;
    my $line = <WRITE>;
    chomp $line;
    while ($line =~ /loading compiler/i) {
	$line = <WRITE>;
	chomp $line;
    }
    my $ok = 1;
    for my $o (@$out) {
	$line =~ s/\s+/ /g;
	$line =~ s/^ //;
	$line =~ s/ $//;
	next if $o eq $line;
	print STDERR "FAIL $name ($o ne $line)\n" if $ok;
	$ok = 0;
    }
    while (<WRITE>) {
	print STDERR "FAIL $name (extra line $line)\n" if $ok;
	$ok = 0;
    }
    close READ;
    close WRITE;
    print $ok ? '' : "not ", "ok ", $testnum++, "\n";
}

