# test the calculator in sick mode

use IPC::Open3 qw(open3);

my @tests = (
    ['#1', 'I'],
    ['.1 <- #V2', 'OK'],
    ['.1', 'III'],
    ['.V1', 'xxxiiDCCLXXI'],
    ['.3 <- #666', 'OK'],
    ['#666 <- #2', 'OK'],
    ['#666', 'II'],
    ['#2 <- .3', 'OK'],
    ['.3', 'DCLXVI'],
    ['#2', 'DCLXVI'],
    # note that from now on #2 and #666 have been swapped
    # XXX more tests are necessary
);

my $maxtest = @tests;
print "1..$maxtest\n";

my @l = map { "-I$_" } @INC;
my $pid = open3(\*READ, \*WRITE, \*WRITE, $^X, @l, 'bin/intercalc', '--batch', '-mexpr', '-lsick');

select READ; $| = 1; select STDOUT;

my $testnum = 1;
for my $test (@tests) {
    my ($cmd, $res) = @$test;
    print READ "$cmd\n";
    my $line = <WRITE>;
    chomp $line;
    while ($line =~ /loading compiler/i) {
	$line = <WRITE>;
	chomp $line;
    }
    $line =~ s/^\s+//;
    my ($gr, $gc) = split(/\s+/, $line, 2);
    my $not = 'not ';
    if ($gr ne $res) {
	print STDERR "FAIL $testnum res ($gr ne $res)\n";
    } else {
	$not = '';
    }
    print "${not}ok ", $testnum++, "\n";
}

