use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@@@@@@@@K@L`@{
@@@@@@@@@@L`@@@@@
@@@@@@@@K@@{
@@@@@@@@@@K
@@@@@@@@@{@@M]@@@|
@@@@@@@@@K@@@{
@@@@@@@@K@L`@{
@@@@@@@@@@K
@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@K@@@{
@@@@@@@@@@K
M]@@@@@@@@@@@
@@@@@@@@@
@@@@@@@@M]@
@@@@@@@@@@K
M]@@@@@@@@@@@
@@@@@@@@@
@@@@@@@@@@M]
@@@@@@@@@@K
@@@@@@@@@@@@@@@
@@@@@@@@@@K
@@@@@@@@@@@@@
@@@@@@@@@
M]@@[|@@{
@@@@@@@@@
';

print "1..32\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 6 ? "" : "not ", "ok 2\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 8\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 9\n";
print @foo == 6 ? "" : "not ", "ok 10\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 14\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 16\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 17\n";
print @foo == 6 ? "" : "not ", "ok 18\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 19\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 20\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 24\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 25\n";
print @foo == 6 ? "" : "not ", "ok 26\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 27\n";
print "III\n" eq (shift @foo) ? "" : "not ", "ok 28\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 29\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 30\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "XII\n" eq (shift @foo) ? "" : "not ", "ok 32\n";

sub foo {
    push @foo, join('', @_);
}

