#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Creates a dialog window to display command output)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import commands
import gtk, pygtk

def show_command_output(command):
	'''This function takes a command and prints it's output to a text
	box in a window'''

	main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	main_window.set_title("Claw 4 Command Output")
	main_window.connect("delete-event", kill_me)
	main_window.set_title(command)

	main_scroll = gtk.ScrolledWindow()
	main_scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
	main_window.add(main_scroll)

	main_text_view = gtk.TextView()
	main_text_view.set_wrap_mode(gtk.WRAP_WORD)
	main_text_view.set_editable(False)

	main_scroll.add_with_viewport(main_text_view)
	main_window.show_all()

	result = commands.getstatusoutput(command)
	main_text_view.get_buffer().set_text(result[1])

	while gtk.events_pending():
		gtk.main_iteration()
		
	width, height = main_text_view.size_request()
	main_window.resize(width*2, 200)

def kill_me(main_window, event):
	'''This function destroy's the main widget'''
	
	main_window.destroy()