;;;; $Id: cliki-bot.asd,v 1.1 2004/01/17 19:19:55 bmastenbrook Exp $
;;;; $Source: /project/cl-irc/cvsroot/cl-irc/example/cliki-bot.asd,v $

;;;; See the LICENSE file for licensing information.

(in-package #:cl-user)

(defpackage #:cliki-bot-system
    (:use #:cl #:asdf))

(in-package #:cliki-bot-system)

(defsystem cliki-bot
    :name "cliki-bot"
    :author "Brian Mastenbrook"
    :version "0.1.0"
    :licence "MIT"
    :description "IRC bot for SBCL"
    :depends-on
      #+sbcl (:cl-irc :cl-ppcre)
      #-sbcl (:sbcl)
    :properties ((#:author-email . "cl-irc-devel@common-lisp.net")
                 (#:date . "$Date: 2004/01/17 19:19:55 $")
                 ((#:albert #:output-dir) . "doc/api-doc/")
                 ((#:albert #:formats) . ("docbook"))
                 ((#:albert #:docbook #:template) . "book")
                 ((#:albert #:docbook #:bgcolor) . "white")
                 ((#:albert #:docbook #:textcolor) . "black"))
    :components ((:file "mp2eliza")
                 (:file "eliza-rules"
                        :depends-on ("mp2eliza"))
                 (:file "cliki"
                        :depends-on ("mp2eliza"))))