;;; -*- Mode:Lisp; Package:USER; Syntax:COMMON-LISP; Base:10; Lowercase:T -*-

;;;
;;;			 TEXAS INSTRUMENTS INCORPORATED
;;;				  P.O. BOX 149149
;;;			       AUSTIN, TEXAS 78714-9149
;;;
;;; Copyright (C)1988,1989,1990 Texas Instruments Incorporated.
;;;
;;; Permission is granted to any individual or institution to use, copy, modify,
;;; and distribute this software, provided that this complete copyright and
;;; permission notice is maintained, intact, in all copies and supporting
;;; documentation.
;;;
;;; Texas Instruments Incorporated provides this software "as is" without
;;; express or implied warranty.
;;;

(in-package "USER")
;;
;; Check required packages
;;
(unless (find-package "XLIB")
  #-explorer
  (error "CLX must be loaded before making CLUE.")
  #+explorer
  (make-system 'clx :noconfirm))

(assert
  (find-package "COMMON-LISP") ()
  "COMMON-LISP package does not exist. 

 Please create a package named COMMON-LISP which exports CLOS and CLCS.
 (You may need to make this a nickname of the LISP package.)
")

;;
;; Make packages
;;
;;
;; Internal interfaces...
#-ansi-cl
(unless (find-package "CLUEI")
  (make-package "CLUEI" :use '(common-lisp xlib)))

;; External interfaces...
#-ansi-cl
(unless (find-package "CLUE")
  (make-package "CLUE" :use '(common-lisp xlib cluei)))

;; generate CLOS package for pcl
(when (find-package 'pcl)
  (pushnew :pcl  *features*)
  (pushnew :clos *features*)
  (unless (find-package :clos)
    (rename-package :pcl :pcl '(:clos))))

;; Ensure *features* knows about the Common Lisp Error Handler
(when (find-package 'conditions)
  (pushnew :cleh *features*))


;;
;; Ensure CLUE and CLUEI use a CLOS
;;
#-ansi-cl
(cond ((find-symbol "DEFCLASS" 'cluei)) ;; clos-kludge must be around      

      ((find-package "CLOS")
       (use-package "CLOS" "CLUEI")
       (use-package "CLOS" "CLUE"))

      ((find-package "PCL")
       (use-package "PCL" "CLUEI")
       (use-package "PCL" "CLUE"))

      (t (error "CLOS must be loaded before making CLUE.")))

#+ansi-cl
(defpackage "CLUEI" (:use "COMMON-LISP" "XLIB")
  (:shadow "EVENT-KEY")
  (:export "EVENT-PARSE")
  (:export "DEFCONTACT")
  (:export "DISPLAY-ROOT" "DISPLAY-ROOT-LIST" "DISPLAY-MULTIPRESS-DELAY-LIMIT"
	   "DISPLAY-MULTIPRESS-VERIFY-P" "*DEFAULT-HOST*" "*DEFAULT-DISPLAY*"
	   "*DEFAULT-MULTIPRESS-DELAY-LIMIT*" "*DEFAULT-MULTIPRESS-VERIFY-P*"
	   "*PARENT*" "OPEN-CONTACT-DISPLAY" "BASIC-CONTACT" "CONTACT"
	   "MAKE-CONTACT" "DISPLAY" "PARENT" "COMPLETE-NAME" "COMPLETE-CLASS"
	   "CALLBACKS" "EVENT-TRANSLATIONS" "STATE" "SENSITIVE"
	   "COMPRESS-MOTION" "COMPRESS-EXPOSURES" "X" "Y" "WIDTH" "HEIGHT"
	   "BORDER-WIDTH" "BACKGROUND" "DEPTH" "EVENT-MASK" "ID" "PLIST")

  (:export "CONTACT-BACKGROUND" "CONTACT-BORDER-WIDTH" "CONTACT-CALLBACKS"
	   "CONTACT-COMPRESS-EXPOSURES" "CONTACT-COMPRESS-MOTION"
	   "CONTACT-DEPTH" "CONTACT-DISPLAY" "CONTACT-EVENT-MASK"
	   "CONTACT-HEIGHT" "CONTACT-PARENT" "CONTACT-SENSITIVE" "CONTACT-STATE"
	   "CONTACT-WIDTH" "CONTACT-X" "CONTACT-Y" "COMPOSITE" "CHILDREN"
	   "FOCUS" "SHELLS" "COMPOSITE-CHILDREN" "COMPOSITE-FOCUS"
	   "COMPOSITE-SHELLS" "DESTROY" "CONTACT-COMPLETE-NAME"
	   "CONTACT-COMPLETE-CLASS" "CONTACT-NAME" "DISPLAY-NAME"
	   "DISPLAY-CLASS" "ANCESTOR-P" "REALIZED-P" "DESTROYED-P" "MAPPED-P"
	   "TOP-LEVEL-P" "MANAGED-P" "SENSITIVE-P" "EVENT-MASK" "RESOURCE"
	   "UPDATE-STATE" "INITIALIZE-GEOMETRY" "PRESENT" "DISMISS" "REALIZE"
	   "DISPLAY" "REFRESH" "OWNS-FOCUS-P" "INSIDE-CONTACT-P"
	   "ADD-CALLBACK" "APPLY-CALLBACK" "APPLY-CALLBACK-ELSE" "CALLBACK-P"
	   "DELETE-CALLBACK" "ROOT" "CONTACT-ROOT" "CONTACT-SCREEN"
	   "CONTACT-TRANSLATE" "CONTACT-TOP-LEVEL"
	   "READ-CHARACTER" "UNREAD-CHARACTER" "LISTEN-CHARACTER"
	   "APPEND-CHARACTERS" "CLEAR-CHARACTERS"
	   "ADD-CHILD" "DELETE-CHILD" "PREVIOUS-SIBLING" "NEXT-SIBLING"
	   "CHANGE-PRIORITY" "MANAGE-PRIORITY" "ACCEPT-FOCUS-P" "MOVE-FOCUS"
	   "CHANGE-LAYOUT" "WHILE-CHANGING-LAYOUT" "CHANGE-GEOMETRY"
	   "PREFERRED-SIZE" "MOVE" "RESIZE" "MANAGE-GEOMETRY"
	   "SPRING-LOADED" "SHADOW-WIDTH" "CONTACT-CONSTRAINTS"
	   "CONTACT-CONSTRAINT" "CLASS-CONSTRAINTS"
	   "DISPLAY-CURSOR" "CONTACT-IMAGE-CURSOR" "CONTACT-GLYPH-CURSOR")

  (:export "CONTACT-MASK" "CONTACT-IMAGE-MASK" "CONTACT-IMAGE-PIXMAP"
	   "CONTACT-PIXMAP" "DISPLAY-MASK" "DISPLAY-PIXMAP" "USING-GCONTEXT")
  (:export "*DATABASE*" "CONVERT" "DEFINE-RESOURCES" "UNDEFINE-RESOURCES")
  (:export "DEFAULT-RESOURCES" "CLASS-RESOURCES" "DESCRIBE-RESOURCE")
  (:export "DEFIMAGE" "0%GRAY" "6%GRAYR" "6%GRAY" "12%GRAYR" "12%GRAY"
	   "25%GRAYR" "25%GRAY" "37%GRAYR" "37%GRAY" "33%GRAY" "50%GRAYR"
	   "50%GRAY" "66%GRAY" "62%GRAYR" "62%GRAY" "75%GRAYR" "75%GRAYH"
	   "75%GRAY" "88%GRAYR" "88%GRAY" "93%GRAYR" "93%GRAY" "100%GRAY")
  (:export "X-CURSOR" "ARROW-CURSOR" "BASED-ARROW-DOWN-CURSOR"
	   "BASED-ARROW-UP-CURSOR" "BOAT-CURSOR" "BOGOSITY-CURSOR"
	   "BOTTOM-LEFT-CORNER-CURSOR" "BOTTOM-RIGHT-CORNER-CURSOR"
	   "BOTTOM-SIDE-CURSOR" "BOTTOM-TEE-CURSOR" "BOX-SPIRAL-CURSOR"
	   "CENTER-PTR-CURSOR" "CIRCLE-CURSOR" "CLOCK-CURSOR"
	   "COFFEE-MUG-CURSOR" "CROSS-CURSOR" "CROSS-REVERSE-CURSOR"
	   "CROSSHAIR-CURSOR" "DIAMOND-CROSS-CURSOR" "DOT-CURSOR"
	   "DOTBOX-CURSOR" "DOUBLE-ARROW-CURSOR" "DRAFT-LARGE-CURSOR"
	   "DRAFT-SMALL-CURSOR" "DRAPED-BOX-CURSOR" "EXCHANGE-CURSOR"
	   "FLEUR-CURSOR" "GOBBLER-CURSOR" "GUMBY-CURSOR" "HAND1-CURSOR"
	   "HAND2-CURSOR" "HEART-CURSOR" "ICON-CURSOR" "IRON-CROSS-CURSOR"
	   "LEFT-PTR-CURSOR" "LEFT-SIDE-CURSOR" "LEFT-TEE-CURSOR"
	   "LEFTBUTTON-CURSOR" "LL-ANGLE-CURSOR" "LR-ANGLE-CURSOR"
	   "MAN-CURSOR" "MIDDLEBUTTON-CURSOR" "MOUSE-CURSOR" "PENCIL-CURSOR"
	   "PIRATE-CURSOR" "PLUS-CURSOR" "QUESTION-ARROW-CURSOR"
	   "RIGHT-PTR-CURSOR" "RIGHT-SIDE-CURSOR" "RIGHT-TEE-CURSOR"
	   "RIGHTBUTTON-CURSOR" "RTL-LOGO-CURSOR" "SAILBOAT-CURSOR"
	   "SB-DOWN-ARROW-CURSOR" "SB-H-DOUBLE-ARROW-CURSOR"
	   "SB-LEFT-ARROW-CURSOR" "SB-RIGHT-ARROW-CURSOR"
	   "SB-UP-ARROW-CURSOR" "SB-V-DOUBLE-ARROW-CURSOR" "SHUTTLE-CURSOR"
	   "SIZING-CURSOR" "SPIDER-CURSOR" "SPRAYCAN-CURSOR" "STAR-CURSOR"
	   "TARGET-CURSOR" "TCROSS-CURSOR" "TOP-LEFT-ARROW-CURSOR"
	   "TOP-LEFT-CORNER-CURSOR" "TOP-RIGHT-CORNER-CURSOR"
	   "TOP-SIDE-CURSOR" "TOP-TEE-CURSOR" "TREK-CURSOR" "UL-ANGLE-CURSOR"
	   "UMBRELLA-CURSOR" "UR-ANGLE-CURSOR" "WATCH-CURSOR" "I-BAR-CURSOR")

  (:export "EVENT" "KEY" "DISPLAY" "CONTACT" "CHARACTER" "KEYSYM"
	   "ABOVE-SIBLING" "ATOM" "BORDER-WIDTH" "CHILD" "CODE" "COLORMAP"
	   "CONFIGURE-P" "COUNT" "DATA" "DRAWABLE" "EVENT-WINDOW" "FOCUS-P"
	   "FORMAT" "HEIGHT" "HINT-P" "INSTALLED-P" "KEYMAP" "KIND"
	   "MAJOR" "MINOR" "MODE" "NAME" "NEW-P" "OVERRIDE-REDIRECT-P"
	   "PARENT" "PLACE" "PROPERTY" "REQUESTOR" "ROOT" "ROOT-X" "ROOT-Y"
	   "SAME-SCREEN-P" "SELECTION" "SEND-EVENT-P" "STATE" "TARGET"
	   "TIME" "TYPE" "WINDOW" "MODE-TYPE" "*REMAP-EVENTS*"
	   "*RESTRICT-EVENTS*" "ADD-MODE" "DELETE-MODE" "WITH-MODE"
	   "WITH-EVENT-MODE" "CONTACT-MODE" "CONTACT-SUPER-MODE"
	   "*CONTACT*" "APPLY-ACTION" "CALL-ACTION" "DEFACTION"
	   "DESCRIBE-ACTION" "EVAL-ACTION" "IGNORE-ACTION" "PERFORM-CALLBACK"
	   "THROW-ACTION" "TRACE-ACTION" "WITH-EVENT" "PROCESSING-EVENT-P"
	   "ADD-BEFORE-ACTION" "DELETE-BEFORE-ACTION" "PROCESS-ALL-EVENTS"
	   "PROCESS-NEXT-EVENT" "HANDLE-EVENT" "TRANSLATE-EVENT"
	   "DEFEVENT" "UNDEFEVENT" "EVENT-ACTIONS" "ADD-EVENT" "DELETE-EVENT"
	   "DESCRIBE-EVENT-TRANSLATIONS" "ADD-TIMER" "DELETE-TIMER")
  (:export "VIRTUAL" "VIRTUAL-COMPOSITE")
  (:export "CONTACT-ROOT-SHELL" "OVERRIDE-SHELL" "SHELL" "SHELL-MAPPED"
	   "SHELL-OWNER" "SHELL-UNMAPPED" "SM-CLIENT-HOST" "SM-COMMAND"
	   "TOP-LEVEL-SESSION" "TOP-LEVEL-SHELL" "TRANSIENT-SHELL"
	   "WITH-WM-PROPERTIES" "WITH-WM-PROPERTIES" "WM-BASE-HEIGHT"
	   "WM-BASE-WIDTH" "WM-COLORMAP-OWNERS" "WM-DELTA-HEIGHT"
	   "WM-DELTA-WIDTH" "WM-GRAVITY" "WM-GROUP" "WM-ICON" "WM-ICON-MASK"
	   "WM-ICON-TITLE" "WM-ICON-X" "WM-ICON-Y" "WM-INITIAL-STATE"
	   "WM-KEYBOARD-INPUT" "WM-MAX-ASPECT" "WM-MAX-HEIGHT" "WM-MAX-WIDTH"
	   "WM-MESSAGE" "WM-MESSAGE-PROTOCOL" "WM-MESSAGE-TIMESTAMP"
	   "WM-MIN-ASPECT" "WM-MIN-HEIGHT" "WM-MIN-WIDTH" "WM-PROTOCOLS-USED"
	   "WM-SHELL" "WM-TITLE" "WM-USER-SPECIFIED-POSITION-P"
	   "WM-USER-SPECIFIED-SIZE-P"))

#+ansi-cl
(defpackage "CLUE" (:use "COMMON-LISP" "CLUEI" "XLIB"))
