<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Core/Dashboard.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Core_DAO_Dashboard extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_dashboard';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = false;
  /**
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Domain for dashboard
   *
   * @var int unsigned
   */
  public $domain_id;
  /**
   * Internal name of dashlet.
   *
   * @var string
   */
  public $name;
  /**
   * dashlet title
   *
   * @var string
   */
  public $label;
  /**
   * url in case of external dashlet
   *
   * @var string
   */
  public $url;
  /**
   * Permission for the dashlet
   *
   * @var string
   */
  public $permission;
  /**
   * Permission Operator
   *
   * @var string
   */
  public $permission_operator;
  /**
   * column no for this dashlet
   *
   * @var boolean
   */
  public $column_no;
  /**
   * Is Minimized?
   *
   * @var boolean
   */
  public $is_minimized;
  /**
   * fullscreen url for dashlet
   *
   * @var string
   */
  public $fullscreen_url;
  /**
   * Is Fullscreen?
   *
   * @var boolean
   */
  public $is_fullscreen;
  /**
   * Is this dashlet active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Is this dashlet reserved?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Ordering of the dashlets.
   *
   * @var int
   */
  public $weight;
  /**
   * class constructor
   *
   * @return civicrm_dashboard
   */
  function __construct()
  {
    $this->__table = 'civicrm_dashboard';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'domain_id', 'civicrm_domain', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('DashletID') ,
          'required' => true,
        ) ,
        'domain_id' => array(
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Dashlet Domain') ,
          'description' => 'Domain for dashboard',
          'required' => true,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'pseudoconstant' => array(
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Dashlet Name') ,
          'description' => 'Internal name of dashlet.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'label' => array(
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Dashlet Title') ,
          'description' => 'dashlet title',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'url' => array(
          'name' => 'url',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Dashlet URL') ,
          'description' => 'url in case of external dashlet',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'permission' => array(
          'name' => 'permission',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Dashlet Permission') ,
          'description' => 'Permission for the dashlet',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'permission_operator' => array(
          'name' => 'permission_operator',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Dashlet Permission Operator') ,
          'description' => 'Permission Operator',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
        ) ,
        'column_no' => array(
          'name' => 'column_no',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Dashlet Column') ,
          'description' => 'column no for this dashlet',
        ) ,
        'is_minimized' => array(
          'name' => 'is_minimized',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Minimize Dashlet?') ,
          'description' => 'Is Minimized?',
        ) ,
        'fullscreen_url' => array(
          'name' => 'fullscreen_url',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Fullscreen URL') ,
          'description' => 'fullscreen url for dashlet',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'is_fullscreen' => array(
          'name' => 'is_fullscreen',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Fullscreen?') ,
          'description' => 'Is Fullscreen?',
          'default' => '1',
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Dashlet Active?') ,
          'description' => 'Is this dashlet active?',
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Dashlet Reserved?') ,
          'description' => 'Is this dashlet reserved?',
        ) ,
        'weight' => array(
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order') ,
          'description' => 'Ordering of the dashlets.',
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'domain_id' => 'domain_id',
        'name' => 'name',
        'label' => 'label',
        'url' => 'url',
        'permission' => 'permission',
        'permission_operator' => 'permission_operator',
        'column_no' => 'column_no',
        'is_minimized' => 'is_minimized',
        'fullscreen_url' => 'fullscreen_url',
        'is_fullscreen' => 'is_fullscreen',
        'is_active' => 'is_active',
        'is_reserved' => 'is_reserved',
        'weight' => 'weight',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['dashboard'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['dashboard'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
