#include "cp_types.h"
#include "cp_proto.h"

/* connect all nodes of bdry containing v to a new node (which 
becomes interior). Return 1 if successful. */

int ideal_bdry_node(struct p_data *p,int v)
{
  int i,j,next_vert,start,newnode,numb,flag,count,bdry_no=1;
  int *newflower,node;
  double *newoverlaps;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
	
  if ( (node=p->nodecount+1) > (p->sizelimit)
       && !alloc_pack_space(p,node,1) )
    {
      sprintf(msgbuf,
	      "Space allocation problem with adding vertex.");
      emsg();
      return 0;
    }
  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  /* find starting point of bdry containing v */
  if (p->num_bdry_comp<=0) return 0;
  flag=0;
  for (j=1;j<=p->num_bdry_comp;j++)
    {
      if ((start=p->bdry_starts[j])==v) flag=1;
      next_vert=start;
      while (!flag && (next_vert=pK_ptr[next_vert].flower[0])!=start)
	if (next_vert==v) flag=1;
      if (flag) 
	{
	  bdry_no=j;
	  break;
	}
    }
  if (!flag) return 0;
  next_vert=start=p->bdry_starts[bdry_no];
  count=1;
  while ((next_vert=pK_ptr[next_vert].flower[0])!=start) count++;
  if (count < 3) 
    {
      sprintf(msgbuf,"Bdry comp has too few vertices for a flower");
      emsg();
      return 0;
    }
  newnode=p->nodecount+1;
  pK_ptr[newnode].num=count;
  pK_ptr[newnode].bdry_flag=0;
  pK_ptr[newnode].plot_flag=1;
  pK_ptr[newnode].mark=0;
  pK_ptr[newnode].color=FG_COLOR;
  next_vert=start;
  pK_ptr[newnode].flower=(int *)calloc((size_t)(count+1),
				       sizeof(int));
  if (p->overlap_status)
    pK_ptr[newnode].overlaps=(double *)calloc((size_t)(count+1),
					      sizeof(double));
  /* fix up orig bdry verts */
  for (j=0;j<count;j++)
    {
      numb=pK_ptr[next_vert].num;
      newflower=(int *)calloc((size_t)(numb+3),sizeof(int));
      for (i=0;i<=numb;i++) 
	newflower[i]=pK_ptr[next_vert].flower[i];
      newflower[numb+1]=newnode;
      newflower[numb+2]=newflower[0];
      free(pK_ptr[next_vert].flower);
      pK_ptr[next_vert].flower=newflower;
      pK_ptr[next_vert].num=numb+2;
      pK_ptr[next_vert].bdry_flag=0;
      pK_ptr[newnode].flower[count-j]=next_vert;
      if (p->overlap_status)
	pK_ptr[newnode].overlaps[count-j]=1.0;
      next_vert=pK_ptr[next_vert].flower[0];
      if (pK_ptr[next_vert].overlaps)
	{
	  newoverlaps=(double *)calloc((size_t)(numb+3),
				       sizeof(double));
	  for (i=0;i<=numb;i++)
	    newoverlaps[i]=pK_ptr[next_vert].overlaps[i];
	  newoverlaps[numb+1]=1.0;
	  newoverlaps[numb+2]=
	    pK_ptr[next_vert].overlaps[0];
	  free(pK_ptr[next_vert].overlaps);
	  pK_ptr[next_vert].overlaps=newoverlaps;
	}
    }
  pK_ptr[newnode].flower[0]=pK_ptr[newnode].flower[count];
  if (p->overlap_status)
    pK_ptr[newnode].overlaps[0]=pK_ptr[newnode].overlaps[count];
  p->packR_ptr[newnode].rad=0.5;
  p->nodecount++;
  pR_ptr[newnode].center.re=pR_ptr[newnode].center.im=0.0;
  pR_ptr[newnode].rad=.5;
  if (p->hes>0) /* sphere: southern hemisphere. */
    {
      pR_ptr[newnode].center.im=M_PI;
      pR_ptr[newnode].rad=M_PI_2;
    }
  return 1;
} /* ideal_bdry_node */
