#!/usr/bin/perl -nw
# Read the options.in file and generate options.[cht] from it.
# $Id: genoptions.pl,v 1.3 2000/12/16 18:27:34 olaf Exp $

BEGIN {
    $h="File generated by genoptions.pl, do not edit";
    open(H, ">options.h"); print H "/* $h */\n\n";
    open(C, ">options.c"); print C "/* $h */\n\n";
    print C "#include \"ciped.h\"\n";
    print C "struct options opts[] = {\n";
    open(D, ">../options.t"); print D "\@c $h\n\n";
    print D "\@multitable \@columnfractions .14 .12 .10 .64\n";
    print D "\@item Name\t\@tab Type\t\@tab Req\n";
    $o=0;
    %T=("bool", "Bool",
	"int", "Int",
	"str", "String",
	"addr", "IP",
	"uaddr", "UDP",
	"taddr", "TCP",
	"secret", "String");
    $e=$e0=0;
}

/^\#/ && next;
/^\s*$/ && next;
if (/^\S/) {
    ($n,$t,$r)=split(/\s+/, $_, 3);
    $r=~tr/\n//d;
    if (!$T{$t}) {
	printf STDERR "%s:%d: unknown type\n", $ARGV, $.;
	$e=$e0=1;
    } else {
	printf H "#define O%s\t%d\n", $n, $o;
	printf C "{\"%s\",\tT%s,\t{0}},\n", $n, $t;
	printf D "\@item \@code{%s}\t\@tab %s\t\@tab %s\n\@tab",
	         $n, $T{$t}, $r;
	++$o;
	$e0=0;
    }
    next;
}
s/^\s*//;
tr/\n//d;
printf D " %s\n", $_ unless ($e0);

END {
    print C "{ NULL, 0, {0} }};\n";
    print D "\@end multitable\n";
    $?=$e;
}
