/* LIBGIMP - The GIMP Library                                                   
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball                
 *
 * gimpintl.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.             
 *                                                                              
 * This library is distributed in the hope that it will be useful,              
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIMPINTL_H__
#define __GIMPINTL_H__

#include <glib.h>
#include <gtk/gtk.h>
#include <locale.h>
#include "config.h"

/* Copied from gnome-i18n.h by Tom Tromey <tromey@creche.cygnus.com>
 * Heavily modified by Daniel Egger <Daniel.Egger@t-online.de>
 * So be sure to hit me instead of him if something is wrong here
 */ 

#ifdef G_OS_WIN32
/* Don't use hardcoded path */
#undef LOCALEDIR
#define LOCALEDIR g_strconcat (gimp_toplevel_directory (), \
			       "\\lib\\locale", \
			       NULL)
#else
#define LOCALEDIR "/opt/kai-uwe/share/locale"
#endif /* G_OS_WIN32 */


#ifdef ENABLE_NLS
#    include <libintl.h>
#    define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (char *) (String)
#    define dgettext(Domain,Message) (char *) (Message)
#    define dcgettext(Domain,Message,Type) (char *) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

#if GTK_MAJOR_VERSION < 2
#define SET_LC_NUMERIC   setlocale (LC_NUMERIC, "C");
#else
#define SET_LC_NUMERIC
#endif

#define INIT_LOCALE( domain )	G_STMT_START{	\
	setlocale (LC_ALL,"");			\
	SET_LC_NUMERIC				\
	bindtextdomain (domain, LOCALEDIR);	\
	textdomain (domain);			\
				}G_STMT_END

#endif /* __GIMPINTL_H__ */
