/*
 * help.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  help.hpp  --  help windows for Bracketing_to_HDR
*/
#ifndef help_hpp
#define help_hpp

// If we use a local HTML file of the HDR-Tutorial and show it via
//   Fl_Help_Dialog, then define it, else (if we show only a tip to the 
//   web location) undefine it...
//#define LOCAL_TUTORIAL

#include <FL/Fl_Window.H>

#  ifdef LOCAL_TUTORIAL
#    include <FL/Fl_Help_Dialog.H>
#  endif


/**================================================================
 *
 * class HelpAbout
 *
 *================================================================*/
class HelpAbout : public Fl_Window
{
public:
  HelpAbout (Fl_Widget* w);
  
private:
  static void cb_close_(Fl_Widget*, HelpAbout* I)
    { I -> do_callback(); }
};

/**================================================================
 *
 * class HelpTutorial
 *
 *================================================================*/
#ifdef LOCAL_TUTORIAL

class HelpTutorial : public Fl_Help_Dialog
{
public:
  HelpTutorial();
};

#else

class HelpTutorial : public Fl_Window
{
public:
  HelpTutorial();

private:
  static void cb_close_(Fl_Widget*, HelpTutorial* I)
    { I -> do_callback(); }
};

#endif  // LOCAL_TUTORIAL
 

#endif  // help_hpp

// END OF FILE
