/*
 * YS/ys_dbg.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  ys_dbg.cpp  --  Ausgabe-Funktion fuer die Debug-Makros in "ys_dbg.h".
  
  Im Gegensatz zu "ys_dbg.hpp" darf diese Datei nur einmal inkludiert werden
  (falls sie ueber ein ausschaltbares `#include ...' eingebunden werden soll;
  falls als Objektdatei gelinkt, natuerlich sowieso der Fall).
*/
#ifndef ys_dbg_cpp
#define ys_dbg_cpp


#include <cstdarg>      // v_start(), v_end()
#include <cstdio>       // vprintf()

#include "ys_dbg.hpp"   // damit "ys_dbg.cpp" auch allein vollstaendig


void ynsobs_dbg (const char *fmt, ...) 
{
    va_list p;
    if (fmt)
    {   va_start (p,fmt);
        vprintf (fmt, p);
        va_end (p);
    }
}

#endif  // ys_dbg_cpp

// END OF FILE
