/*
 * AUTHOR: Pedro Lineu Orso                          pedro.orso@gmail.com
 *                                                             1998, 2006
 * CHETCPASSWD System Password Change Utility http://sarg.sourceforge.net
 * ----------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

void fixnone(char *str)
{
   if(strstr(str,"\n") != 0)
      str[strlen(str)-1]='\0';
   if(strcmp(str,"none") == 0)
      str[0]='\0';

   return;
}

char wbuf[MAXLEN];
char Msg[255];

void getconf()
{
   FILE *fp_in;
   char buf[MAXLEN];

   bzero(AlertEmail, 512);
   bzero(PostChange, 512);
   strcpy(MaxUserLen,"20");

   if ((fp_in = fopen(ConfigFile, "r")) == NULL) {
      fprintf(stderr, "chetcpasswd: (getconf) Cannot open file: %s\n",ConfigFile);
      exit(1);
   }

   while (fgets(buf, MAXLEN, fp_in) != NULL) {
      if(strstr(buf,"\n") != 0)
         buf[strlen(buf)-1]='\n';

      if(strncmp(buf,"#",1) == 0 || strlen(buf) < 2)
         continue;

      parmtest(buf);

   }

   fclose(fp_in);
   language_load(Language);
   return;
}


int parmtest(char *buf)
{

	getword(wbuf,buf,' ');
	if(strcmp(wbuf,"language") == 0) {
		strcpy(Language,buf);
		fixnone(Language);
		return;
	}

	if(strcmp(wbuf,"title") == 0) {
		strcpy(Title,buf);
		fixnone(Title);
		return;
	}

	if(strcmp(wbuf,"subtitle") == 0) {
		strcpy(SubTitle,buf);
		fixnone(SubTitle);
		return;
	}

	if(strcmp(wbuf,"background-color") == 0) {
		strcpy(BackgroundColor,buf);
		fixnone(BackgroundColor);
		return;
	}

	if(strcmp(wbuf,"font-family") == 0) {
		strcpy(FontFamily,buf);
		fixnone(FontFamily);
		return;
	}

	if(strcmp(wbuf,"subtitle-font-size") == 0) {
		strcpy(SubTitleFontSize,buf);
		fixnone(SubTitleFontSize);
		return;
	}

	if(strcmp(wbuf,"subtitle-font-color") == 0) {
		strcpy(SubTitleFontColor,buf);
		fixnone(SubTitleFontColor);
		return;
	}

	if(strcmp(wbuf,"title-font-size") == 0) {
		strcpy(TitleFontSize,buf);
		fixnone(TitleFontSize);
		return;
	}

	if(strcmp(wbuf,"title-font-color") == 0) {
		strcpy(TitleFontColor,buf);
		fixnone(TitleFontColor);
		return;
	}

	if(strcmp(wbuf,"font-color") == 0) {
		strcpy(FontColor,buf);
		fixnone(FontColor);
		return;
	}

	if(strcmp(wbuf,"font-size") == 0) {
		strcpy(FontSize,buf);
		fixnone(FontSize);
		return;
	}

	if(strcmp(wbuf,"instructions-font-color") == 0) {
		strcpy(InstructionsFontColor,buf);
		fixnone(InstructionsFontColor);
		return;
	}

	if(strcmp(wbuf,"instructions-font-size") == 0) {
		strcpy(InstructionsFontSize,buf);
		fixnone(InstructionsFontSize);
		return;
	}

	if(strcmp(wbuf,"arrow-size") == 0) {
		strcpy(ArrowSize,buf);
		fixnone(ArrowSize);
		return;
	}

	if(strcmp(wbuf,"arrow-color") == 0) {
		strcpy(ArrowColor,buf);
		fixnone(ArrowColor);
		return;
	}

	if(strcmp(wbuf,"bottom-font-color") == 0) {
		strcpy(BottomFontColor,buf);
		fixnone(BottomFontColor);
		return;
	}

	if(strcmp(wbuf,"bottom-font-size") == 0) {
		strcpy(BottomFontSize,buf);
		fixnone(BottomFontSize);
		return;
	}

	if(strcmp(wbuf,"fields-font-color") == 0) {
		strcpy(FieldsFontColor,buf);
		fixnone(FieldsFontColor);
		return;
	}

	if(strcmp(wbuf,"fields-font-size") == 0) {
		strcpy(FieldsFontSize,buf);
		fixnone(FieldsFontSize);
		return;
	}

	if(strcmp(wbuf,"input-font-color") == 0) {
		strcpy(InputFontColor,buf);
		fixnone(InputFontColor);
		return;
	}

	if(strcmp(wbuf,"input-font-size") == 0) {
		strcpy(InputFontSize,buf);
		fixnone(InputFontSize);
		return;
	}

	if(strcmp(wbuf,"version-info") == 0) {
		strcpy(VersionInfo,buf);
		fixnone(VersionInfo);
		return;
	}

	if(strcmp(wbuf,"syslog") == 0) {
		strcpy(Syslog,buf);
		fixnone(Syslog);
		return;
	}

	if(strcmp(wbuf,"success-url") == 0) {
		getword(SuccessUrl,buf,'"');
		getword(SuccessUrl,buf,'"');
		fixnone(SuccessUrl);
		return;
	}

	if(strcmp(wbuf,"cancel-url") == 0) {
		getword(CancelUrl,buf,'"');
		getword(CancelUrl,buf,'"');
		fixnone(CancelUrl);
		return;
	}

	if(strcmp(wbuf,"warning-time") == 0) {
		strcpy(WarningTime,buf);
		fixnone(WarningTime);
		return;
	}

	if(strcmp(wbuf,"warning-font-color") == 0) {
		strcpy(WarningFontColor,buf);
		fixnone(WarningFontColor);
		return;
	}

	if(strcmp(wbuf,"warning-font-size") == 0) {
		strcpy(WarningFontSize,buf);
		fixnone(WarningFontSize);
		return;
	}

	if(strcmp(wbuf,"success-font-color") == 0) {
		strcpy(SuccessFontColor,buf);
		fixnone(SuccessFontColor);
		return;
	}

	if(strcmp(wbuf,"success-font-size") == 0) {
		strcpy(SuccessFontSize,buf);
		fixnone(SuccessFontSize);
		return;
	}

	if(strcmp(wbuf,"password-minimum-lenght") == 0) {
		strcpy(PasswordMinimumLenght,buf);
		fixnone(PasswordMinimumLenght);
		return;
	}

	if(strcmp(wbuf,"logo-image") == 0) {
		strcpy(LogoImage,buf);
		fixnone(LogoImage);
		return;
	}

	if(strcmp(wbuf,"logo-image-size") == 0) {
		getword(LogoImageWidth,buf,' ');
		strcpy(LogoImageHeight,buf);
		fixnone(LogoImageWidth);
		fixnone(LogoImageHeight);
		return;
	}

	if(strcmp(wbuf,"alert_email") == 0) {
		strcpy(AlertEmail,buf);
		fixnone(AlertEmail);
		return;
	}

	if(strcmp(wbuf,"post_change") == 0) {
		strcpy(PostChange,buf);
		fixnone(PostChange);
		return;
	}

	if(strcmp(wbuf,"maximum_user_length") == 0) {
		strcpy(MaxUserLen,buf);
		fixnone(MaxUserLen);
		return;
	}

	if(strcmp(wbuf,"password_maximum_length") == 0) {
		strcpy(MaxPwdLen,buf);
		fixnone(MaxPwdLen);
		return;
	}

	if(strcmp(wbuf,"use_md5") == 0) {
		strcpy(UseMD5,buf);
		fixnone(UseMD5);
		return;
	}

	return;
}
