#include "pdf/pilot.h"
*********************************************************************
*                                                                   *
*    POLARIZED RADIATIVELY GENERATED LO AND NLO PARTON DENSITIES    *
*                         AND DIS ASYMMETRIES                       *
*                                                                   *
*         M. GLUCK, E. REYA, M. STRATMANN AND W. VOGELSANG,         *
*                  (PHYS. REV. D53 (1996) 4775)                     *       
*          PROBLEMS/QUESTIONS TO VOGELSANG@V2.RL.AC.UK              *
*            OR TO STRAT@HAL1.PHYSIK.UNI-DORTMUND.DE                *
*                                                                   *
*   INPUT:   ISET = number of the parton set :                      *
*              ISET = 1  'STANDARD' SCENARIO, NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   * 
*                        (DATA FILE 'STDNLOA1.GRID' UNIT=11, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 2  'VALENCE' SCENARIO,  NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   *  
*                        (DATA FILE 'VALNLOA1.GRID' UNIT=22, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 3  'STANDARD' SCENARIO, LEADING ORDER         *
*                        (DATA FILE 'STDLOA1.GRID' UNIT=33, TO BE   *
*                         DEFINED BY THE USER )                     *
*              ISET = 4  'VALENCE' SCENARIO,  LEADING ORDER         *
*                        (DATA FILE 'VALLOA1.GRID' UNIT=44, TO BE   *
*                         DEFINED BY THE USER )                     *
*                                                                   *
*            X  = Bjorken-x       (between  1.E-4  and  1)          *
*            Q2 = scale in GeV**2 (between  0.4  and   1.E4)        *
*             (for values outside the allowed range the program     *
*              writes a warning and extrapolates to the x and       *
*              Q2 values requested)                                 *
*                                                                   *
*   OUTPUT:  UV = x * ( DELTA u - DELTA u(bar) ),                   *
*            DV = x * ( DELTA d - DELTA d(bar) ),                   *        
*            QB = x * POLARIZED LIGHT SEA,                          *   
*                 QB= x * ( (DELTA U(BAR) + DELTA D(BAR))/2 )       * 
*            ST = x * DELTA STRANGE = x * DELTA STRANGE(BAR)        *     
*            GL = x * DELTA GLUON                                   *
*                                                                   *
*          (  For the parton distributions always x times           *
*                   the distribution is returned   )                *
*                                                                   *
*            A1P = A1-Proton                                        *
*            A1N = A1-Neutron                                       *
*            A1D = A1-Deuteron                                      *
*                                                                   *
*            The sets are the result of a combined fit to           *
*            data for the spin asymmetries A_1 (p,n,d)              *
*                                                                   *
*            Note: No charm is included                             *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINI / IINI , and  IINI     *
*            has always to be zero when PARPOL is called for the    *
*            first time or when 'ISET' has been changed.            *
*                                                                   *
*********************************************************************
*
      SUBROUTINE GRSVH1 (DX,DQ,DUV,DDV,DSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRSVH1 (X, Q2, UV, DV, QB, ST, GL, A1P, A1N, A1D)
#include "pdf/impdp.inc"
      PARAMETER (NPART=8, NX=42, NQ=25, NARG=2)
      DIMENSION
     +          XUVF(NX,NQ), XDVF(NX,NQ), XQBF(NX,NQ), 
     1          XSF(NX,NQ), XGF(NX,NQ), 
     2          XAPF(NX,NQ), XANF(NX,NQ), XADF(NX,NQ),
     3          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ)
      DIMENSION
     +        PARTON (NPART,NQ,NX-1)
      COMMON / GRSVA1 / A1P, A1N, A1D
C      COMMON / INTINI / IINI
      SAVE XUVF, XDVF, XQBF, XSF, XGF, XAPF, XANF, XADF, NA, ARRF
       DATA ZEROD/0.D0/
*...BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.4D0, 0.5d0, 0.6d0, 0.75D0, 1.0D0,
     1           1.25d0, 1.5D0, 2.d0, 2.5D0, 
     1           4.0D0, 6.4D0, 1.0D1, 1.5D1, 2.5D1, 4.0D1, 6.4D1,
     2           1.0D2, 1.8D2, 3.2D2, 5.8D2, 1.0D3, 1.8D3,
     3           3.2D3, 5.8D3, 1.0D4 /
       DATA XB / 1.D-4, 1.5D-4, 2.2D-4, 3.2D-4, 4.8D-4, 7.D-4,
     2           1.D-3, 1.5D-3, 2.2D-3, 3.2D-3, 4.8D-3, 7.D-3,
     3           1.D-2, 1.5D-2, 2.2D-2, 3.2D-2, 5.0D-2, 7.5D-2,
     4           0.1D0, 0.125D0, 0.15D0, 0.175D0, 0.2D0, 0.225D0, 
     +           0.25D0, 0.275D0,
     5           0.3D0, 0.325D0, 0.35D0, 0.375D0, 0.4D0, 0.45D0,  
     +           0.5D0, 0.55D0,
     6           0.6D0, 0.65D0,  0.7D0,  0.75D0,  0.8D0, 0.85D0,  
     +           0.9D0, 1.0D0 /
       DATA IINI/0/
C
        DATA ((PARTON(I,N,1),I=1,8),N=1,8)/
     +   .1040D-02, -.3616D-02, -.2473D-03, -.2510D-03,  .6085D-03,
     +  -.1519D-02, -.2478D-01, -.1212D-01,
     +   .1280D-02, -.3812D-02, -.3920D-03, -.3999D-03,  .2376D-02,
     +  -.1312D-02, -.1575D-01, -.7830D-02,
     +   .1459D-02, -.3952D-02, -.5250D-03, -.5360D-03,  .4449D-02,
     +  -.1308D-02, -.1226D-01, -.6215D-02,
     +   .1660D-02, -.4105D-02, -.6963D-03, -.7105D-03,  .7568D-02,
     +  -.1353D-02, -.9812D-02, -.5111D-02,
     +   .1897D-02, -.4280D-02, -.9208D-03, -.9387D-03,  .1230D-01,
     +  -.1419D-02, -.7995D-02, -.4305D-02,
     +   .2066D-02, -.4401D-02, -.1094D-02, -.1114D-02,  .1638D-01,
     +  -.1460D-02, -.7090D-02, -.3908D-02,
     +   .2196D-02, -.4493D-02, -.1232D-02, -.1255D-02,  .1992D-01,
     +  -.1485D-02, -.6531D-02, -.3664D-02,
     +   .2390D-02, -.4627D-02, -.1446D-02, -.1471D-02,  .2583D-01,
     +  -.1511D-02, -.5863D-02, -.3369D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=9,16)/
     +   .2535D-02, -.4724D-02, -.1599D-02, -.1625D-02,  .3054D-01,
     +  -.1514D-02, -.5477D-02, -.3193D-02,
     +   .2814D-02, -.4908D-02, -.1882D-02, -.1913D-02,  .4046D-01,
     +  -.1490D-02, -.4872D-02, -.2906D-02,
     +   .3076D-02, -.5076D-02, -.2158D-02, -.2192D-02,  .5115D-01,
     +  -.1455D-02, -.4395D-02, -.2671D-02,
     +   .3311D-02, -.5224D-02, -.2412D-02, -.2449D-02,  .6191D-01,
     +  -.1418D-02, -.4030D-02, -.2488D-02,
     +   .3515D-02, -.5350D-02, -.2636D-02, -.2675D-02,  .7214D-01,
     +  -.1384D-02, -.3755D-02, -.2347D-02,
     +   .3761D-02, -.5500D-02, -.2905D-02, -.2947D-02,  .8554D-01,
     +  -.1341D-02, -.3471D-02, -.2197D-02,
     +   .3978D-02, -.5630D-02, -.3141D-02, -.3185D-02,  .9831D-01,
     +  -.1302D-02, -.3253D-02, -.2080D-02,
     +   .4189D-02, -.5754D-02, -.3371D-02, -.3417D-02,  .1116D+00,
     +  -.1264D-02, -.3065D-02, -.1977D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=17,25)/
     +   .4384D-02, -.5868D-02, -.3583D-02, -.3631D-02,  .1247D+00,
     +  -.1230D-02, -.2907D-02, -.1889D-02,
     +   .4632D-02, -.6012D-02, -.3853D-02, -.3904D-02,  .1425D+00,
     +  -.1188D-02, -.2728D-02, -.1788D-02,
     +   .4869D-02, -.6146D-02, -.4107D-02, -.4160D-02,  .1605D+00,
     +  -.1149D-02, -.2576D-02, -.1701D-02,
     +   .5106D-02, -.6279D-02, -.4358D-02, -.4413D-02,  .1796D+00,
     +  -.1111D-02, -.2440D-02, -.1621D-02,
     +   .5317D-02, -.6397D-02, -.4579D-02, -.4636D-02,  .1976D+00,
     +  -.1078D-02, -.2329D-02, -.1556D-02,
     +   .5539D-02, -.6519D-02, -.4807D-02, -.4866D-02,  .2174D+00,
     +  -.1044D-02, -.2223D-02, -.1492D-02,
     +   .5751D-02, -.6635D-02, -.5019D-02, -.5080D-02,  .2372D+00,
     +  -.1014D-02, -.2130D-02, -.1435D-02,
     +   .5965D-02, -.6751D-02, -.5228D-02, -.5290D-02,  .2580D+00,
     +  -.9831D-03, -.2043D-02, -.1381D-02,
     +   .6157D-02, -.6853D-02, -.5410D-02, -.5474D-02,  .2774D+00,
     +  -.9566D-03, -.1971D-02, -.1336D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=1,8)/
     +   .1393D-02, -.4144D-02, -.3416D-03, -.3464D-03,  .9160D-03,
     +  -.1055D-02, -.2784D-01, -.1331D-01,
     +   .1708D-02, -.4376D-02, -.5284D-03, -.5388D-03,  .3244D-02,
     +  -.1152D-02, -.1869D-01, -.9106D-02,
     +   .1941D-02, -.4542D-02, -.6940D-03, -.7083D-03,  .5836D-02,
     +  -.1285D-02, -.1492D-01, -.7427D-02,
     +   .2204D-02, -.4724D-02, -.9016D-03, -.9200D-03,  .9625D-02,
     +  -.1436D-02, -.1219D-01, -.6238D-02,
     +   .2511D-02, -.4931D-02, -.1167D-02, -.1190D-02,  .1523D-01,
     +  -.1582D-02, -.1009D-01, -.5339D-02,
     +   .2731D-02, -.5074D-02, -.1367D-02, -.1393D-02,  .1999D-01,
     +  -.1660D-02, -.9014D-02, -.4880D-02,
     +   .2900D-02, -.5183D-02, -.1526D-02, -.1555D-02,  .2408D-01,
     +  -.1707D-02, -.8344D-02, -.4593D-02,
     +   .3150D-02, -.5342D-02, -.1767D-02, -.1799D-02,  .3084D-01,
     +  -.1753D-02, -.7522D-02, -.4237D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=9,16)/
     +   .3336D-02, -.5458D-02, -.1938D-02, -.1972D-02,  .3618D-01,
     +  -.1761D-02, -.7033D-02, -.4018D-02,
     +   .3695D-02, -.5675D-02, -.2252D-02, -.2290D-02,  .4736D-01,
     +  -.1731D-02, -.6259D-02, -.3650D-02,
     +   .4030D-02, -.5874D-02, -.2553D-02, -.2595D-02,  .5931D-01,
     +  -.1690D-02, -.5649D-02, -.3352D-02,
     +   .4331D-02, -.6050D-02, -.2827D-02, -.2872D-02,  .7126D-01,
     +  -.1646D-02, -.5183D-02, -.3119D-02,
     +   .4591D-02, -.6199D-02, -.3066D-02, -.3114D-02,  .8257D-01,
     +  -.1606D-02, -.4832D-02, -.2940D-02,
     +   .4905D-02, -.6376D-02, -.3351D-02, -.3402D-02,  .9729D-01,
     +  -.1554D-02, -.4466D-02, -.2749D-02,
     +   .5180D-02, -.6530D-02, -.3598D-02, -.3652D-02,  .1113D+00,
     +  -.1507D-02, -.4188D-02, -.2600D-02,
     +   .5448D-02, -.6677D-02, -.3836D-02, -.3893D-02,  .1257D+00,
     +  -.1461D-02, -.3945D-02, -.2469D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=17,25)/
     +   .5694D-02, -.6811D-02, -.4055D-02, -.4114D-02,  .1399D+00,
     +  -.1420D-02, -.3743D-02, -.2357D-02,
     +   .6009D-02, -.6981D-02, -.4330D-02, -.4392D-02,  .1591D+00,
     +  -.1369D-02, -.3512D-02, -.2228D-02,
     +   .6307D-02, -.7140D-02, -.4585D-02, -.4650D-02,  .1785D+00,
     +  -.1320D-02, -.3316D-02, -.2116D-02,
     +   .6606D-02, -.7297D-02, -.4836D-02, -.4903D-02,  .1990D+00,
     +  -.1274D-02, -.3138D-02, -.2014D-02,
     +   .6872D-02, -.7435D-02, -.5053D-02, -.5121D-02,  .2181D+00,
     +  -.1233D-02, -.2995D-02, -.1930D-02,
     +   .7151D-02, -.7580D-02, -.5274D-02, -.5345D-02,  .2392D+00,
     +  -.1191D-02, -.2857D-02, -.1848D-02,
     +   .7417D-02, -.7716D-02, -.5477D-02, -.5550D-02,  .2601D+00,
     +  -.1152D-02, -.2735D-02, -.1775D-02,
     +   .7686D-02, -.7852D-02, -.5675D-02, -.5750D-02,  .2820D+00,
     +  -.1114D-02, -.2622D-02, -.1706D-02,
     +   .7926D-02, -.7973D-02, -.5845D-02, -.5921D-02,  .3023D+00,
     +  -.1080D-02, -.2527D-02, -.1647D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=1,8)/
     +   .1838D-02, -.4721D-02, -.4613D-03, -.4674D-03,  .1294D-02,
     +  -.4261D-03, -.3099D-01, -.1447D-01,
     +   .2244D-02, -.4995D-02, -.6966D-03, -.7098D-03,  .4261D-02,
     +  -.8507D-03, -.2187D-01, -.1043D-01,
     +   .2544D-02, -.5191D-02, -.8982D-03, -.9163D-03,  .7425D-02,
     +  -.1147D-02, -.1790D-01, -.8728D-02,
     +   .2880D-02, -.5405D-02, -.1145D-02, -.1168D-02,  .1193D-01,
     +  -.1426D-02, -.1491D-01, -.7475D-02,
     +   .3274D-02, -.5649D-02, -.1453D-02, -.1482D-02,  .1846D-01,
     +  -.1673D-02, -.1253D-01, -.6493D-02,
     +   .3553D-02, -.5819D-02, -.1681D-02, -.1714D-02,  .2391D-01,
     +  -.1800D-02, -.1127D-01, -.5975D-02,
     +   .3768D-02, -.5947D-02, -.1860D-02, -.1895D-02,  .2856D-01,
     +  -.1873D-02, -.1047D-01, -.5642D-02,
     +   .4087D-02, -.6134D-02, -.2129D-02, -.2168D-02,  .3617D-01,
     +  -.1947D-02, -.9480D-02, -.5222D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=9,16)/
     +   .4323D-02, -.6270D-02, -.2317D-02, -.2359D-02,  .4215D-01,
     +  -.1962D-02, -.8877D-02, -.4952D-02,
     +   .4776D-02, -.6526D-02, -.2659D-02, -.2706D-02,  .5460D-01,
     +  -.1931D-02, -.7908D-02, -.4494D-02,
     +   .5198D-02, -.6761D-02, -.2984D-02, -.3036D-02,  .6782D-01,
     +  -.1886D-02, -.7146D-02, -.4125D-02,
     +   .5577D-02, -.6967D-02, -.3276D-02, -.3332D-02,  .8096D-01,
     +  -.1838D-02, -.6562D-02, -.3836D-02,
     +   .5904D-02, -.7142D-02, -.3528D-02, -.3587D-02,  .9333D-01,
     +  -.1793D-02, -.6121D-02, -.3614D-02,
     +   .6296D-02, -.7351D-02, -.3826D-02, -.3889D-02,  .1094D+00,
     +  -.1734D-02, -.5662D-02, -.3377D-02,
     +   .6641D-02, -.7531D-02, -.4082D-02, -.4148D-02,  .1245D+00,
     +  -.1679D-02, -.5310D-02, -.3191D-02,
     +   .6974D-02, -.7703D-02, -.4326D-02, -.4395D-02,  .1401D+00,
     +  -.1626D-02, -.5004D-02, -.3027D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=17,25)/
     +   .7281D-02, -.7861D-02, -.4548D-02, -.4618D-02,  .1553D+00,
     +  -.1577D-02, -.4749D-02, -.2888D-02,
     +   .7673D-02, -.8059D-02, -.4824D-02, -.4897D-02,  .1759D+00,
     +  -.1515D-02, -.4455D-02, -.2726D-02,
     +   .8043D-02, -.8245D-02, -.5076D-02, -.5153D-02,  .1965D+00,
     +  -.1458D-02, -.4207D-02, -.2586D-02,
     +   .8414D-02, -.8429D-02, -.5321D-02, -.5400D-02,  .2182D+00,
     +  -.1402D-02, -.3979D-02, -.2457D-02,
     +   .8743D-02, -.8591D-02, -.5529D-02, -.5611D-02,  .2384D+00,
     +  -.1352D-02, -.3797D-02, -.2350D-02,
     +   .9089D-02, -.8759D-02, -.5739D-02, -.5822D-02,  .2605D+00,
     +  -.1301D-02, -.3619D-02, -.2246D-02,
     +   .9417D-02, -.8918D-02, -.5929D-02, -.6015D-02,  .2824D+00,
     +  -.1253D-02, -.3463D-02, -.2153D-02,
     +   .9748D-02, -.9077D-02, -.6110D-02, -.6198D-02,  .3053D+00,
     +  -.1206D-02, -.3318D-02, -.2065D-02,
     +   .1004D-01, -.9218D-02, -.6264D-02, -.6353D-02,  .3263D+00,
     +  -.1164D-02, -.3195D-02, -.1990D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=1,8)/
     +   .2412D-02, -.5375D-02, -.6162D-03, -.6239D-03,  .1762D-02,
     +   .4157D-03, -.3432D-01, -.1560D-01,
     +   .2931D-02, -.5697D-02, -.9083D-03, -.9247D-03,  .5471D-02,
     +  -.3581D-03, -.2539D-01, -.1181D-01,
     +   .3314D-02, -.5929D-02, -.1150D-02, -.1173D-02,  .9271D-02,
     +  -.8423D-03, -.2128D-01, -.1013D-01,
     +   .3743D-02, -.6182D-02, -.1440D-02, -.1468D-02,  .1456D-01,
     +  -.1276D-02, -.1806D-01, -.8848D-02,
     +   .4242D-02, -.6469D-02, -.1793D-02, -.1828D-02,  .2206D-01,
     +  -.1647D-02, -.1539D-01, -.7791D-02,
     +   .4596D-02, -.6669D-02, -.2050D-02, -.2090D-02,  .2825D-01,
     +  -.1833D-02, -.1394D-01, -.7212D-02,
     +   .4868D-02, -.6821D-02, -.2249D-02, -.2292D-02,  .3348D-01,
     +  -.1941D-02, -.1301D-01, -.6833D-02,
     +   .5270D-02, -.7041D-02, -.2544D-02, -.2592D-02,  .4197D-01,
     +  -.2051D-02, -.1183D-01, -.6342D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=9,16)/
     +   .5566D-02, -.7201D-02, -.2749D-02, -.2800D-02,  .4862D-01,
     +  -.2079D-02, -.1110D-01, -.6021D-02,
     +   .6135D-02, -.7503D-02, -.3121D-02, -.3178D-02,  .6241D-01,
     +  -.2054D-02, -.9907D-02, -.5463D-02,
     +   .6663D-02, -.7778D-02, -.3468D-02, -.3530D-02,  .7693D-01,
     +  -.2011D-02, -.8967D-02, -.5013D-02,
     +   .7135D-02, -.8019D-02, -.3777D-02, -.3843D-02,  .9129D-01,
     +  -.1963D-02, -.8245D-02, -.4662D-02,
     +   .7542D-02, -.8226D-02, -.4040D-02, -.4110D-02,  .1047D+00,
     +  -.1916D-02, -.7698D-02, -.4390D-02,
     +   .8030D-02, -.8469D-02, -.4348D-02, -.4421D-02,  .1221D+00,
     +  -.1851D-02, -.7127D-02, -.4099D-02,
     +   .8457D-02, -.8680D-02, -.4609D-02, -.4686D-02,  .1384D+00,
     +  -.1789D-02, -.6687D-02, -.3870D-02,
     +   .8870D-02, -.8882D-02, -.4856D-02, -.4936D-02,  .1551D+00,
     +  -.1729D-02, -.6306D-02, -.3668D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=17,25)/
     +   .9250D-02, -.9066D-02, -.5076D-02, -.5159D-02,  .1713D+00,
     +  -.1673D-02, -.5985D-02, -.3496D-02,
     +   .9733D-02, -.9298D-02, -.5348D-02, -.5434D-02,  .1932D+00,
     +  -.1601D-02, -.5616D-02, -.3295D-02,
     +   .1019D-01, -.9514D-02, -.5593D-02, -.5682D-02,  .2149D+00,
     +  -.1534D-02, -.5302D-02, -.3121D-02,
     +   .1065D-01, -.9728D-02, -.5825D-02, -.5917D-02,  .2378D+00,
     +  -.1467D-02, -.5016D-02, -.2959D-02,
     +   .1105D-01, -.9917D-02, -.6021D-02, -.6115D-02,  .2590D+00,
     +  -.1408D-02, -.4786D-02, -.2827D-02,
     +   .1147D-01, -.1011D-01, -.6213D-02, -.6310D-02,  .2820D+00,
     +  -.1346D-02, -.4560D-02, -.2696D-02,
     +   .1188D-01, -.1030D-01, -.6385D-02, -.6483D-02,  .3048D+00,
     +  -.1288D-02, -.4362D-02, -.2579D-02,
     +   .1228D-01, -.1048D-01, -.6544D-02, -.6645D-02,  .3284D+00,
     +  -.1230D-02, -.4175D-02, -.2467D-02,
     +   .1264D-01, -.1065D-01, -.6676D-02, -.6778D-02,  .3501D+00,
     +  -.1178D-02, -.4018D-02, -.2372D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=1,8)/
     +   .3239D-02, -.6201D-02, -.8396D-03, -.8492D-03,  .2395D-02,
     +   .1647D-02, -.3819D-01, -.1678D-01,
     +   .3916D-02, -.6589D-02, -.1204D-02, -.1225D-02,  .7046D-02,
     +   .4801D-03, -.2966D-01, -.1337D-01,
     +   .4414D-02, -.6868D-02, -.1496D-02, -.1524D-02,  .1163D-01,
     +  -.2321D-03, -.2548D-01, -.1177D-01,
     +   .4969D-02, -.7171D-02, -.1836D-02, -.1871D-02,  .1784D-01,
     +  -.8610D-03, -.2205D-01, -.1048D-01,
     +   .5613D-02, -.7517D-02, -.2241D-02, -.2285D-02,  .2650D-01,
     +  -.1393D-02, -.1910D-01, -.9367D-02,
     +   .6070D-02, -.7756D-02, -.2530D-02, -.2579D-02,  .3353D-01,
     +  -.1661D-02, -.1745D-01, -.8731D-02,
     +   .6419D-02, -.7938D-02, -.2751D-02, -.2803D-02,  .3943D-01,
     +  -.1817D-02, -.1635D-01, -.8299D-02,
     +   .6935D-02, -.8202D-02, -.3075D-02, -.3132D-02,  .4893D-01,
     +  -.1979D-02, -.1494D-01, -.7730D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=9,16)/
     +   .7313D-02, -.8393D-02, -.3298D-02, -.3359D-02,  .5634D-01,
     +  -.2029D-02, -.1405D-01, -.7344D-02,
     +   .8037D-02, -.8753D-02, -.3700D-02, -.3768D-02,  .7167D-01,
     +  -.2024D-02, -.1258D-01, -.6668D-02,
     +   .8708D-02, -.9081D-02, -.4070D-02, -.4144D-02,  .8770D-01,
     +  -.1996D-02, -.1141D-01, -.6123D-02,
     +   .9306D-02, -.9369D-02, -.4393D-02, -.4472D-02,  .1034D+00,
     +  -.1955D-02, -.1052D-01, -.5694D-02,
     +   .9820D-02, -.9614D-02, -.4665D-02, -.4748D-02,  .1181D+00,
     +  -.1909D-02, -.9834D-02, -.5361D-02,
     +   .1043D-01, -.9903D-02, -.4979D-02, -.5066D-02,  .1368D+00,
     +  -.1843D-02, -.9118D-02, -.5004D-02,
     +   .1097D-01, -.1015D-01, -.5241D-02, -.5332D-02,  .1544D+00,
     +  -.1776D-02, -.8563D-02, -.4720D-02,
     +   .1149D-01, -.1039D-01, -.5485D-02, -.5579D-02,  .1723D+00,
     +  -.1709D-02, -.8080D-02, -.4468D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=17,25)/
     +   .1197D-01, -.1061D-01, -.5700D-02, -.5797D-02,  .1897D+00,
     +  -.1645D-02, -.7674D-02, -.4254D-02,
     +   .1257D-01, -.1088D-01, -.5960D-02, -.6060D-02,  .2128D+00,
     +  -.1563D-02, -.7205D-02, -.4002D-02,
     +   .1314D-01, -.1114D-01, -.6189D-02, -.6293D-02,  .2358D+00,
     +  -.1484D-02, -.6803D-02, -.3783D-02,
     +   .1371D-01, -.1139D-01, -.6402D-02, -.6508D-02,  .2597D+00,
     +  -.1404D-02, -.6437D-02, -.3579D-02,
     +   .1421D-01, -.1161D-01, -.6575D-02, -.6684D-02,  .2818D+00,
     +  -.1332D-02, -.6138D-02, -.3410D-02,
     +   .1473D-01, -.1184D-01, -.6742D-02, -.6853D-02,  .3058D+00,
     +  -.1257D-02, -.5846D-02, -.3243D-02,
     +   .1523D-01, -.1206D-01, -.6885D-02, -.6999D-02,  .3293D+00,
     +  -.1185D-02, -.5588D-02, -.3092D-02,
     +   .1573D-01, -.1228D-01, -.7014D-02, -.7129D-02,  .3535D+00,
     +  -.1111D-02, -.5344D-02, -.2947D-02,
     +   .1618D-01, -.1247D-01, -.7114D-02, -.7232D-02,  .3758D+00,
     +  -.1046D-02, -.5141D-02, -.2825D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=1,8)/
     +   .4262D-02, -.7106D-02, -.1116D-02, -.1127D-02,  .3116D-02,
     +   .3175D-02, -.4201D-01, -.1780D-01,
     +   .5128D-02, -.7570D-02, -.1559D-02, -.1583D-02,  .8782D-02,
     +   .1648D-02, -.3403D-01, -.1482D-01,
     +   .5762D-02, -.7902D-02, -.1902D-02, -.1936D-02,  .1417D-01,
     +   .7122D-03, -.2990D-01, -.1335D-01,
     +   .6467D-02, -.8263D-02, -.2293D-02, -.2335D-02,  .2134D-01,
     +  -.1170D-03, -.2635D-01, -.1210D-01,
     +   .7283D-02, -.8674D-02, -.2748D-02, -.2800D-02,  .3114D-01,
     +  -.8230D-03, -.2316D-01, -.1096D-01,
     +   .7859D-02, -.8959D-02, -.3067D-02, -.3124D-02,  .3902D-01,
     +  -.1181D-02, -.2131D-01, -.1027D-01,
     +   .8299D-02, -.9174D-02, -.3307D-02, -.3369D-02,  .4557D-01,
     +  -.1392D-02, -.2006D-01, -.9795D-02,
     +   .8947D-02, -.9487D-02, -.3655D-02, -.3723D-02,  .5606D-01,
     +  -.1616D-02, -.1843D-01, -.9149D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=9,16)/
     +   .9422D-02, -.9714D-02, -.3894D-02, -.3966D-02,  .6423D-01,
     +  -.1697D-02, -.1737D-01, -.8706D-02,
     +   .1033D-01, -.1014D-01, -.4323D-02, -.4403D-02,  .8110D-01,
     +  -.1733D-02, -.1562D-01, -.7918D-02,
     +   .1116D-01, -.1053D-01, -.4710D-02, -.4796D-02,  .9859D-01,
     +  -.1731D-02, -.1422D-01, -.7279D-02,
     +   .1190D-01, -.1086D-01, -.5043D-02, -.5134D-02,  .1156D+00,
     +  -.1706D-02, -.1313D-01, -.6772D-02,
     +   .1254D-01, -.1115D-01, -.5318D-02, -.5413D-02,  .1314D+00,
     +  -.1669D-02, -.1230D-01, -.6377D-02,
     +   .1330D-01, -.1149D-01, -.5631D-02, -.5731D-02,  .1515D+00,
     +  -.1607D-02, -.1142D-01, -.5947D-02,
     +   .1396D-01, -.1179D-01, -.5889D-02, -.5993D-02,  .1703D+00,
     +  -.1539D-02, -.1074D-01, -.5605D-02,
     +   .1460D-01, -.1206D-01, -.6124D-02, -.6231D-02,  .1893D+00,
     +  -.1468D-02, -.1015D-01, -.5301D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=17,25)/
     +   .1518D-01, -.1232D-01, -.6328D-02, -.6438D-02,  .2076D+00,
     +  -.1399D-02, -.9645D-02, -.5040D-02,
     +   .1592D-01, -.1264D-01, -.6568D-02, -.6682D-02,  .2319D+00,
     +  -.1307D-02, -.9061D-02, -.4731D-02,
     +   .1662D-01, -.1294D-01, -.6774D-02, -.6891D-02,  .2558D+00,
     +  -.1216D-02, -.8560D-02, -.4461D-02,
     +   .1731D-01, -.1323D-01, -.6959D-02, -.7079D-02,  .2807D+00,
     +  -.1122D-02, -.8100D-02, -.4208D-02,
     +   .1792D-01, -.1349D-01, -.7105D-02, -.7227D-02,  .3035D+00,
     +  -.1037D-02, -.7723D-02, -.3997D-02,
     +   .1856D-01, -.1375D-01, -.7239D-02, -.7364D-02,  .3280D+00,
     +  -.9452D-03, -.7355D-02, -.3788D-02,
     +   .1916D-01, -.1401D-01, -.7348D-02, -.7475D-02,  .3520D+00,
     +  -.8567D-03, -.7028D-02, -.3598D-02,
     +   .1977D-01, -.1426D-01, -.7439D-02, -.7568D-02,  .3767D+00,
     +  -.7665D-03, -.6719D-02, -.3416D-02,
     +   .2031D-01, -.1448D-01, -.7504D-02, -.7636D-02,  .3992D+00,
     +  -.6850D-03, -.6458D-02, -.3260D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=1,8)/
     +   .5527D-02, -.8112D-02, -.1456D-02, -.1470D-02,  .3920D-02,
     +   .5055D-02, -.4576D-01, -.1860D-01,
     +   .6617D-02, -.8662D-02, -.1982D-02, -.2011D-02,  .1067D-01,
     +   .3212D-02, -.3848D-01, -.1610D-01,
     +   .7414D-02, -.9056D-02, -.2379D-02, -.2417D-02,  .1691D-01,
     +   .2067D-02, -.3449D-01, -.1480D-01,
     +   .8296D-02, -.9484D-02, -.2820D-02, -.2868D-02,  .2505D-01,
     +   .1043D-02, -.3092D-01, -.1363D-01,
     +   .9313D-02, -.9969D-02, -.3322D-02, -.3381D-02,  .3602D-01,
     +   .1603D-03, -.2756D-01, -.1250D-01,
     +   .1003D-01, -.1030D-01, -.3667D-02, -.3733D-02,  .4474D-01,
     +  -.2956D-03, -.2553D-01, -.1178D-01,
     +   .1058D-01, -.1056D-01, -.3924D-02, -.3995D-02,  .5194D-01,
     +  -.5662D-03, -.2414D-01, -.1127D-01,
     +   .1138D-01, -.1093D-01, -.4292D-02, -.4369D-02,  .6341D-01,
     +  -.8634D-03, -.2229D-01, -.1056D-01 /
        DATA ((PARTON(I,N,7),I=1,8),N=9,16)/
     +   .1196D-01, -.1119D-01, -.4544D-02, -.4626D-02,  .7235D-01,
     +  -.9848D-03, -.2108D-01, -.1006D-01,
     +   .1307D-01, -.1169D-01, -.4994D-02, -.5085D-02,  .9076D-01,
     +  -.1082D-02, -.1904D-01, -.9178D-02,
     +   .1410D-01, -.1214D-01, -.5393D-02, -.5490D-02,  .1097D+00,
     +  -.1122D-02, -.1740D-01, -.8448D-02,
     +   .1500D-01, -.1254D-01, -.5728D-02, -.5831D-02,  .1280D+00,
     +  -.1123D-02, -.1612D-01, -.7865D-02,
     +   .1578D-01, -.1287D-01, -.6001D-02, -.6108D-02,  .1449D+00,
     +  -.1103D-02, -.1513D-01, -.7406D-02,
     +   .1671D-01, -.1327D-01, -.6306D-02, -.6418D-02,  .1663D+00,
     +  -.1051D-02, -.1409D-01, -.6904D-02,
     +   .1751D-01, -.1361D-01, -.6552D-02, -.6668D-02,  .1861D+00,
     +  -.9847D-03, -.1327D-01, -.6500D-02,
     +   .1828D-01, -.1393D-01, -.6772D-02, -.6891D-02,  .2061D+00,
     +  -.9123D-03, -.1254D-01, -.6137D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=17,25)/
     +   .1899D-01, -.1422D-01, -.6958D-02, -.7080D-02,  .2252D+00,
     +  -.8390D-03, -.1193D-01, -.5825D-02,
     +   .1988D-01, -.1459D-01, -.7170D-02, -.7296D-02,  .2504D+00,
     +  -.7375D-03, -.1122D-01, -.5454D-02,
     +   .2072D-01, -.1494D-01, -.7345D-02, -.7474D-02,  .2752D+00,
     +  -.6343D-03, -.1060D-01, -.5126D-02,
     +   .2155D-01, -.1527D-01, -.7495D-02, -.7627D-02,  .3007D+00,
     +  -.5253D-03, -.1004D-01, -.4818D-02,
     +   .2228D-01, -.1557D-01, -.7606D-02, -.7741D-02,  .3240D+00,
     +  -.4242D-03, -.9571D-02, -.4559D-02,
     +   .2304D-01, -.1588D-01, -.7701D-02, -.7838D-02,  .3490D+00,
     +  -.3144D-03, -.9113D-02, -.4300D-02,
     +   .2376D-01, -.1616D-01, -.7770D-02, -.7909D-02,  .3732D+00,
     +  -.2069D-03, -.8705D-02, -.4065D-02,
     +   .2449D-01, -.1645D-01, -.7818D-02, -.7959D-02,  .3980D+00,
     +  -.9615D-04, -.8318D-02, -.3838D-02,
     +   .2513D-01, -.1670D-01, -.7843D-02, -.7986D-02,  .4205D+00,
     +   .4734D-05, -.7990D-02, -.3642D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=1,8)/
     +   .7438D-02, -.9488D-02, -.1965D-02, -.1981D-02,  .4999D-02,
     +   .7787D-02, -.5015D-01, -.1929D-01,
     +   .8857D-02, -.1016D-01, -.2595D-02, -.2629D-02,  .1316D-01,
     +   .5650D-02, -.4381D-01, -.1738D-01,
     +   .9887D-02, -.1064D-01, -.3054D-02, -.3099D-02,  .2046D-01,
     +   .4306D-02, -.4012D-01, -.1631D-01,
     +   .1102D-01, -.1116D-01, -.3551D-02, -.3608D-02,  .2980D-01,
     +   .3085D-02, -.3662D-01, -.1527D-01,
     +   .1233D-01, -.1175D-01, -.4103D-02, -.4172D-02,  .4220D-01,
     +   .2010D-02, -.3315D-01, -.1418D-01,
     +   .1324D-01, -.1215D-01, -.4475D-02, -.4551D-02,  .5194D-01,
     +   .1444D-02, -.3097D-01, -.1345D-01,
     +   .1394D-01, -.1246D-01, -.4748D-02, -.4829D-02,  .5995D-01,
     +   .1100D-02, -.2944D-01, -.1291D-01,
     +   .1496D-01, -.1290D-01, -.5131D-02, -.5220D-02,  .7261D-01,
     +   .7109D-03, -.2737D-01, -.1214D-01 /
        DATA ((PARTON(I,N,8),I=1,8),N=9,16)/
     +   .1570D-01, -.1322D-01, -.5394D-02, -.5488D-02,  .8247D-01,
     +   .5317D-03, -.2599D-01, -.1160D-01,
     +   .1710D-01, -.1381D-01, -.5861D-02, -.5964D-02,  .1028D+00,
     +   .3382D-03, -.2363D-01, -.1061D-01,
     +   .1839D-01, -.1435D-01, -.6263D-02, -.6372D-02,  .1234D+00,
     +   .2306D-03, -.2171D-01, -.9786D-02,
     +   .1952D-01, -.1482D-01, -.6592D-02, -.6707D-02,  .1432D+00,
     +   .1852D-03, -.2019D-01, -.9117D-02,
     +   .2049D-01, -.1522D-01, -.6853D-02, -.6972D-02,  .1613D+00,
     +   .1788D-03, -.1901D-01, -.8582D-02,
     +   .2164D-01, -.1569D-01, -.7136D-02, -.7261D-02,  .1841D+00,
     +   .2109D-03, -.1775D-01, -.7990D-02,
     +   .2263D-01, -.1609D-01, -.7359D-02, -.7487D-02,  .2050D+00,
     +   .2692D-03, -.1675D-01, -.7511D-02,
     +   .2359D-01, -.1647D-01, -.7550D-02, -.7682D-02,  .2260D+00,
     +   .3408D-03, -.1587D-01, -.7076D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=17,25)/
     +   .2446D-01, -.1681D-01, -.7705D-02, -.7840D-02,  .2460D+00,
     +   .4186D-03, -.1512D-01, -.6697D-02,
     +   .2555D-01, -.1724D-01, -.7873D-02, -.8012D-02,  .2721D+00,
     +   .5322D-03, -.1423D-01, -.6241D-02,
     +   .2658D-01, -.1764D-01, -.8001D-02, -.8142D-02,  .2975D+00,
     +   .6523D-03, -.1346D-01, -.5836D-02,
     +   .2759D-01, -.1804D-01, -.8098D-02, -.8242D-02,  .3236D+00,
     +   .7829D-03, -.1275D-01, -.5451D-02,
     +   .2849D-01, -.1838D-01, -.8159D-02, -.8306D-02,  .3471D+00,
     +   .9069D-03, -.1216D-01, -.5125D-02,
     +   .2942D-01, -.1874D-01, -.8198D-02, -.8347D-02,  .3722D+00,
     +   .1044D-02, -.1157D-01, -.4798D-02,
     +   .3029D-01, -.1907D-01, -.8211D-02, -.8362D-02,  .3965D+00,
     +   .1179D-02, -.1105D-01, -.4498D-02,
     +   .3116D-01, -.1940D-01, -.8200D-02, -.8353D-02,  .4211D+00,
     +   .1321D-02, -.1056D-01, -.4208D-02,
     +   .3194D-01, -.1969D-01, -.8171D-02, -.8325D-02,  .4433D+00,
     +   .1450D-02, -.1013D-01, -.3956D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=1,8)/
     +   .9871D-02, -.1107D-01, -.2596D-02, -.2615D-02,  .6199D-02,
     +   .1120D-01, -.5425D-01, -.1950D-01,
     +   .1168D-01, -.1188D-01, -.3331D-02, -.3370D-02,  .1585D-01,
     +   .8878D-02, -.4897D-01, -.1817D-01,
     +   .1299D-01, -.1246D-01, -.3849D-02, -.3900D-02,  .2425D-01,
     +   .7391D-02, -.4568D-01, -.1737D-01,
     +   .1443D-01, -.1309D-01, -.4397D-02, -.4461D-02,  .3483D-01,
     +   .6016D-02, -.4239D-01, -.1651D-01,
     +   .1607D-01, -.1379D-01, -.4990D-02, -.5067D-02,  .4868D-01,
     +   .4776D-02, -.3893D-01, -.1551D-01,
     +   .1722D-01, -.1427D-01, -.5380D-02, -.5465D-02,  .5948D-01,
     +   .4102D-02, -.3668D-01, -.1480D-01,
     +   .1809D-01, -.1464D-01, -.5662D-02, -.5754D-02,  .6830D-01,
     +   .3685D-02, -.3507D-01, -.1426D-01,
     +   .1936D-01, -.1517D-01, -.6053D-02, -.6152D-02,  .8218D-01,
     +   .3197D-02, -.3283D-01, -.1346D-01 /
        DATA ((PARTON(I,N,9),I=1,8),N=9,16)/
     +   .2028D-01, -.1554D-01, -.6320D-02, -.6424D-02,  .9298D-01,
     +   .2951D-02, -.3131D-01, -.1289D-01,
     +   .2202D-01, -.1625D-01, -.6789D-02, -.6902D-02,  .1151D+00,
     +   .2638D-02, -.2869D-01, -.1184D-01,
     +   .2360D-01, -.1688D-01, -.7180D-02, -.7300D-02,  .1375D+00,
     +   .2447D-02, -.2652D-01, -.1094D-01,
     +   .2499D-01, -.1743D-01, -.7490D-02, -.7615D-02,  .1587D+00,
     +   .2348D-02, -.2478D-01, -.1020D-01,
     +   .2618D-01, -.1789D-01, -.7727D-02, -.7857D-02,  .1779D+00,
     +   .2309D-02, -.2341D-01, -.9592D-02,
     +   .2758D-01, -.1844D-01, -.7975D-02, -.8110D-02,  .2020D+00,
     +   .2318D-02, -.2192D-01, -.8913D-02,
     +   .2879D-01, -.1890D-01, -.8162D-02, -.8301D-02,  .2238D+00,
     +   .2368D-02, -.2074D-01, -.8353D-02,
     +   .2994D-01, -.1934D-01, -.8313D-02, -.8455D-02,  .2456D+00,
     +   .2441D-02, -.1968D-01, -.7839D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=17,25)/
     +   .3099D-01, -.1974D-01, -.8427D-02, -.8572D-02,  .2661D+00,
     +   .2527D-02, -.1877D-01, -.7388D-02,
     +   .3231D-01, -.2024D-01, -.8537D-02, -.8685D-02,  .2929D+00,
     +   .2658D-02, -.1770D-01, -.6839D-02,
     +   .3355D-01, -.2070D-01, -.8605D-02, -.8756D-02,  .3186D+00,
     +   .2802D-02, -.1676D-01, -.6346D-02,
     +   .3476D-01, -.2115D-01, -.8639D-02, -.8792D-02,  .3448D+00,
     +   .2962D-02, -.1588D-01, -.5873D-02,
     +   .3583D-01, -.2154D-01, -.8641D-02, -.8797D-02,  .3683D+00,
     +   .3116D-02, -.1515D-01, -.5469D-02,
     +   .3694D-01, -.2195D-01, -.8615D-02, -.8773D-02,  .3932D+00,
     +   .3289D-02, -.1442D-01, -.5060D-02,
     +   .3798D-01, -.2233D-01, -.8565D-02, -.8724D-02,  .4170D+00,
     +   .3462D-02, -.1377D-01, -.4684D-02,
     +   .3901D-01, -.2270D-01, -.8488D-02, -.8649D-02,  .4410D+00,
     +   .3645D-02, -.1315D-01, -.4317D-02,
     +   .3993D-01, -.2303D-01, -.8400D-02, -.8562D-02,  .4626D+00,
     +   .3813D-02, -.1261D-01, -.3998D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=1,8)/
     +   .1304D-01, -.1297D-01, -.3398D-02, -.3419D-02,  .7546D-02,
     +   .1552D-01, -.5806D-01, -.1913D-01,
     +   .1534D-01, -.1395D-01, -.4235D-02, -.4278D-02,  .1882D-01,
     +   .1312D-01, -.5394D-01, -.1839D-01,
     +   .1699D-01, -.1465D-01, -.4807D-02, -.4864D-02,  .2841D-01,
     +   .1155D-01, -.5120D-01, -.1787D-01,
     +   .1879D-01, -.1540D-01, -.5396D-02, -.5466D-02,  .4033D-01,
     +   .1008D-01, -.4826D-01, -.1723D-01,
     +   .2084D-01, -.1624D-01, -.6017D-02, -.6101D-02,  .5577D-01,
     +   .8709D-02, -.4498D-01, -.1638D-01,
     +   .2227D-01, -.1681D-01, -.6416D-02, -.6509D-02,  .6771D-01,
     +   .7951D-02, -.4272D-01, -.1572D-01,
     +   .2335D-01, -.1724D-01, -.6700D-02, -.6799D-02,  .7741D-01,
     +   .7467D-02, -.4107D-01, -.1520D-01,
     +   .2492D-01, -.1786D-01, -.7085D-02, -.7192D-02,  .9257D-01,
     +   .6889D-02, -.3875D-01, -.1441D-01 /
        DATA ((PARTON(I,N,10),I=1,8),N=9,16)/
     +   .2605D-01, -.1831D-01, -.7346D-02, -.7458D-02,  .1044D+00,
     +   .6575D-02, -.3713D-01, -.1383D-01,
     +   .2817D-01, -.1913D-01, -.7800D-02, -.7921D-02,  .1285D+00,
     +   .6135D-02, -.3432D-01, -.1276D-01,
     +   .3010D-01, -.1987D-01, -.8162D-02, -.8290D-02,  .1525D+00,
     +   .5861D-02, -.3193D-01, -.1180D-01,
     +   .3179D-01, -.2051D-01, -.8435D-02, -.8569D-02,  .1750D+00,
     +   .5710D-02, -.2998D-01, -.1099D-01,
     +   .3322D-01, -.2105D-01, -.8634D-02, -.8772D-02,  .1953D+00,
     +   .5643D-02, -.2843D-01, -.1032D-01,
     +   .3490D-01, -.2167D-01, -.8830D-02, -.8972D-02,  .2204D+00,
     +   .5637D-02, -.2672D-01, -.9548D-02,
     +   .3636D-01, -.2221D-01, -.8965D-02, -.9111D-02,  .2430D+00,
     +   .5690D-02, -.2534D-01, -.8903D-02,
     +   .3774D-01, -.2271D-01, -.9062D-02, -.9210D-02,  .2654D+00,
     +   .5773D-02, -.2410D-01, -.8300D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=17,25)/
     +   .3899D-01, -.2317D-01, -.9121D-02, -.9272D-02,  .2862D+00,
     +   .5877D-02, -.2302D-01, -.7765D-02,
     +   .4057D-01, -.2373D-01, -.9158D-02, -.9312D-02,  .3132D+00,
     +   .6041D-02, -.2174D-01, -.7108D-02,
     +   .4203D-01, -.2425D-01, -.9153D-02, -.9309D-02,  .3389D+00,
     +   .6223D-02, -.2060D-01, -.6509D-02,
     +   .4347D-01, -.2476D-01, -.9111D-02, -.9269D-02,  .3648D+00,
     +   .6430D-02, -.1954D-01, -.5930D-02,
     +   .4473D-01, -.2521D-01, -.9043D-02, -.9203D-02,  .3879D+00,
     +   .6632D-02, -.1864D-01, -.5432D-02,
     +   .4603D-01, -.2566D-01, -.8943D-02, -.9104D-02,  .4121D+00,
     +   .6858D-02, -.1775D-01, -.4925D-02,
     +   .4725D-01, -.2608D-01, -.8820D-02, -.8983D-02,  .4351D+00,
     +   .7084D-02, -.1694D-01, -.4455D-02,
     +   .4846D-01, -.2650D-01, -.8671D-02, -.8835D-02,  .4581D+00,
     +   .7324D-02, -.1617D-01, -.3995D-02,
     +   .4953D-01, -.2687D-01, -.8517D-02, -.8682D-02,  .4786D+00,
     +   .7544D-02, -.1551D-01, -.3592D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=1,8)/
     +   .1769D-01, -.1556D-01, -.4527D-02, -.4550D-02,  .9225D-02,
     +   .2160D-01, -.6174D-01, -.1784D-01,
     +   .2064D-01, -.1676D-01, -.5464D-02, -.5511D-02,  .2249D-01,
     +   .1922D-01, -.5905D-01, -.1775D-01,
     +   .2274D-01, -.1761D-01, -.6081D-02, -.6142D-02,  .3354D-01,
     +   .1764D-01, -.5703D-01, -.1758D-01,
     +   .2504D-01, -.1852D-01, -.6699D-02, -.6774D-02,  .4712D-01,
     +   .1612D-01, -.5466D-01, -.1722D-01,
     +   .2763D-01, -.1953D-01, -.7328D-02, -.7418D-02,  .6451D-01,
     +   .1469D-01, -.5171D-01, -.1658D-01,
     +   .2942D-01, -.2021D-01, -.7720D-02, -.7819D-02,  .7784D-01,
     +   .1386D-01, -.4965D-01, -.1603D-01,
     +   .3077D-01, -.2073D-01, -.7993D-02, -.8097D-02,  .8859D-01,
     +   .1333D-01, -.4801D-01, -.1556D-01,
     +   .3272D-01, -.2147D-01, -.8352D-02, -.8465D-02,  .1053D+00,
     +   .1269D-01, -.4570D-01, -.1481D-01 /
        DATA ((PARTON(I,N,11),I=1,8),N=9,16)/
     +   .3413D-01, -.2199D-01, -.8592D-02, -.8710D-02,  .1183D+00,
     +   .1231D-01, -.4405D-01, -.1425D-01,
     +   .3675D-01, -.2296D-01, -.9000D-02, -.9126D-02,  .1445D+00,
     +   .1176D-01, -.4112D-01, -.1319D-01,
     +   .3911D-01, -.2382D-01, -.9301D-02, -.9434D-02,  .1703D+00,
     +   .1143D-01, -.3856D-01, -.1219D-01,
     +   .4117D-01, -.2457D-01, -.9510D-02, -.9647D-02,  .1942D+00,
     +   .1125D-01, -.3641D-01, -.1130D-01,
     +   .4292D-01, -.2519D-01, -.9645D-02, -.9786D-02,  .2154D+00,
     +   .1118D-01, -.3465D-01, -.1055D-01,
     +   .4496D-01, -.2591D-01, -.9759D-02, -.9904D-02,  .2414D+00,
     +   .1120D-01, -.3270D-01, -.9665D-02,
     +   .4671D-01, -.2652D-01, -.9817D-02, -.9965D-02,  .2645D+00,
     +   .1128D-01, -.3111D-01, -.8909D-02,
     +   .4837D-01, -.2710D-01, -.9834D-02, -.9985D-02,  .2871D+00,
     +   .1141D-01, -.2965D-01, -.8193D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=17,25)/
     +   .4987D-01, -.2762D-01, -.9818D-02, -.9970D-02,  .3080D+00,
     +   .1156D-01, -.2838D-01, -.7547D-02,
     +   .5175D-01, -.2826D-01, -.9754D-02, -.9909D-02,  .3347D+00,
     +   .1180D-01, -.2684D-01, -.6744D-02,
     +   .5348D-01, -.2885D-01, -.9653D-02, -.9809D-02,  .3599D+00,
     +   .1206D-01, -.2547D-01, -.6003D-02,
     +   .5518D-01, -.2942D-01, -.9512D-02, -.9670D-02,  .3849D+00,
     +   .1235D-01, -.2417D-01, -.5281D-02,
     +   .5667D-01, -.2991D-01, -.9356D-02, -.9516D-02,  .4070D+00,
     +   .1264D-01, -.2307D-01, -.4654D-02,
     +   .5820D-01, -.3042D-01, -.9163D-02, -.9324D-02,  .4299D+00,
     +   .1295D-01, -.2197D-01, -.4012D-02,
     +   .5962D-01, -.3089D-01, -.8953D-02, -.9115D-02,  .4514D+00,
     +   .1327D-01, -.2097D-01, -.3413D-02,
     +   .6104D-01, -.3135D-01, -.8717D-02, -.8879D-02,  .4728D+00,
     +   .1361D-01, -.2000D-01, -.2824D-02,
     +   .6228D-01, -.3175D-01, -.8486D-02, -.8649D-02,  .4916D+00,
     +   .1391D-01, -.1917D-01, -.2307D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=1,8)/
     +   .2355D-01, -.1864D-01, -.5881D-02, -.5905D-02,  .1106D-01,
     +   .2887D-01, -.6453D-01, -.1555D-01,
     +   .2726D-01, -.2009D-01, -.6886D-02, -.6935D-02,  .2649D-01,
     +   .2659D-01, -.6335D-01, -.1611D-01,
     +   .2989D-01, -.2110D-01, -.7523D-02, -.7587D-02,  .3914D-01,
     +   .2507D-01, -.6216D-01, -.1631D-01,
     +   .3274D-01, -.2218D-01, -.8141D-02, -.8219D-02,  .5453D-01,
     +   .2358D-01, -.6046D-01, -.1625D-01,
     +   .3594D-01, -.2337D-01, -.8746D-02, -.8839D-02,  .7403D-01,
     +   .2215D-01, -.5810D-01, -.1588D-01,
     +   .3814D-01, -.2418D-01, -.9109D-02, -.9210D-02,  .8884D-01,
     +   .2133D-01, -.5626D-01, -.1546D-01,
     +   .3979D-01, -.2478D-01, -.9353D-02, -.9459D-02,  .1007D+00,
     +   .2079D-01, -.5481D-01, -.1505D-01,
     +   .4217D-01, -.2563D-01, -.9662D-02, -.9776D-02,  .1190D+00,
     +   .2014D-01, -.5259D-01, -.1437D-01 /
        DATA ((PARTON(I,N,12),I=1,8),N=9,16)/
     +   .4387D-01, -.2624D-01, -.9863D-02, -.9982D-02,  .1331D+00,
     +   .1976D-01, -.5099D-01, -.1384D-01,
     +   .4702D-01, -.2735D-01, -.1019D-01, -.1031D-01,  .1614D+00,
     +   .1920D-01, -.4802D-01, -.1278D-01,
     +   .4985D-01, -.2833D-01, -.1040D-01, -.1053D-01,  .1887D+00,
     +   .1889D-01, -.4536D-01, -.1174D-01,
     +   .5231D-01, -.2918D-01, -.1052D-01, -.1065D-01,  .2136D+00,
     +   .1876D-01, -.4306D-01, -.1077D-01,
     +   .5438D-01, -.2988D-01, -.1057D-01, -.1071D-01,  .2354D+00,
     +   .1875D-01, -.4115D-01, -.9918D-02,
     +   .5679D-01, -.3069D-01, -.1058D-01, -.1072D-01,  .2618D+00,
     +   .1885D-01, -.3897D-01, -.8898D-02,
     +   .5884D-01, -.3137D-01, -.1054D-01, -.1069D-01,  .2850D+00,
     +   .1903D-01, -.3716D-01, -.8008D-02,
     +   .6078D-01, -.3201D-01, -.1046D-01, -.1061D-01,  .3074D+00,
     +   .1925D-01, -.3550D-01, -.7154D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=17,25)/
     +   .6253D-01, -.3258D-01, -.1036D-01, -.1051D-01,  .3279D+00,
     +   .1951D-01, -.3402D-01, -.6377D-02,
     +   .6471D-01, -.3328D-01, -.1018D-01, -.1033D-01,  .3537D+00,
     +   .1988D-01, -.3222D-01, -.5397D-02,
     +   .6672D-01, -.3393D-01, -.9975D-02, -.1013D-01,  .3777D+00,
     +   .2028D-01, -.3060D-01, -.4487D-02,
     +   .6867D-01, -.3455D-01, -.9729D-02, -.9881D-02,  .4013D+00,
     +   .2071D-01, -.2906D-01, -.3592D-02,
     +   .7037D-01, -.3508D-01, -.9481D-02, -.9634D-02,  .4218D+00,
     +   .2112D-01, -.2774D-01, -.2811D-02,
     +   .7212D-01, -.3563D-01, -.9194D-02, -.9348D-02,  .4429D+00,
     +   .2157D-01, -.2642D-01, -.2007D-02,
     +   .7374D-01, -.3613D-01, -.8897D-02, -.9051D-02,  .4624D+00,
     +   .2202D-01, -.2521D-01, -.1256D-02,
     +   .7535D-01, -.3662D-01, -.8576D-02, -.8730D-02,  .4816D+00,
     +   .2249D-01, -.2404D-01, -.5134D-03,
     +   .7675D-01, -.3705D-01, -.8271D-02, -.8425D-02,  .4984D+00,
     +   .2291D-01, -.2303D-01,  .1383D-03 /
        DATA ((PARTON(I,N,13),I=1,8),N=1,8)/
     +   .3098D-01, -.2238D-01, -.7485D-02, -.7509D-02,  .1320D-01,
     +   .3745D-01, -.6644D-01, -.1222D-01,
     +   .3556D-01, -.2409D-01, -.8512D-02, -.8561D-02,  .3107D-01,
     +   .3527D-01, -.6693D-01, -.1349D-01,
     +   .3879D-01, -.2528D-01, -.9136D-02, -.9200D-02,  .4556D-01,
     +   .3384D-01, -.6669D-01, -.1407D-01,
     +   .4226D-01, -.2653D-01, -.9716D-02, -.9794D-02,  .6299D-01,
     +   .3247D-01, -.6582D-01, -.1437D-01,
     +   .4613D-01, -.2790D-01, -.1026D-01, -.1035D-01,  .8484D-01,
     +   .3113D-01, -.6418D-01, -.1428D-01,
     +   .4877D-01, -.2883D-01, -.1056D-01, -.1066D-01,  .1012D+00,
     +   .3038D-01, -.6271D-01, -.1399D-01,
     +   .5075D-01, -.2951D-01, -.1076D-01, -.1086D-01,  .1143D+00,
     +   .2989D-01, -.6142D-01, -.1365D-01,
     +   .5358D-01, -.3048D-01, -.1099D-01, -.1110D-01,  .1342D+00,
     +   .2934D-01, -.5937D-01, -.1302D-01 /
        DATA ((PARTON(I,N,13),I=1,8),N=9,16)/
     +   .5560D-01, -.3116D-01, -.1113D-01, -.1124D-01,  .1493D+00,
     +   .2903D-01, -.5788D-01, -.1250D-01,
     +   .5932D-01, -.3241D-01, -.1133D-01, -.1145D-01,  .1794D+00,
     +   .2862D-01, -.5499D-01, -.1142D-01,
     +   .6264D-01, -.3350D-01, -.1142D-01, -.1154D-01,  .2078D+00,
     +   .2847D-01, -.5226D-01, -.1028D-01,
     +   .6550D-01, -.3443D-01, -.1142D-01, -.1155D-01,  .2334D+00,
     +   .2850D-01, -.4982D-01, -.9180D-02,
     +   .6789D-01, -.3520D-01, -.1136D-01, -.1150D-01,  .2554D+00,
     +   .2865D-01, -.4775D-01, -.8196D-02,
     +   .7067D-01, -.3608D-01, -.1125D-01, -.1138D-01,  .2816D+00,
     +   .2895D-01, -.4536D-01, -.6995D-02,
     +   .7303D-01, -.3682D-01, -.1110D-01, -.1123D-01,  .3044D+00,
     +   .2932D-01, -.4335D-01, -.5933D-02,
     +   .7525D-01, -.3750D-01, -.1091D-01, -.1105D-01,  .3260D+00,
     +   .2972D-01, -.4147D-01, -.4903D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=17,25)/
     +   .7723D-01, -.3811D-01, -.1071D-01, -.1085D-01,  .3456D+00,
     +   .3015D-01, -.3979D-01, -.3958D-02,
     +   .7970D-01, -.3886D-01, -.1041D-01, -.1055D-01,  .3698D+00,
     +   .3074D-01, -.3772D-01, -.2760D-02,
     +   .8195D-01, -.3954D-01, -.1009D-01, -.1023D-01,  .3921D+00,
     +   .3135D-01, -.3585D-01, -.1642D-02,
     +   .8415D-01, -.4019D-01, -.9740D-02, -.9881D-02,  .4136D+00,
     +   .3200D-01, -.3406D-01, -.5379D-03,
     +   .8605D-01, -.4074D-01, -.9400D-02, -.9541D-02,  .4321D+00,
     +   .3260D-01, -.3252D-01,  .4285D-03,
     +   .8799D-01, -.4131D-01, -.9021D-02, -.9162D-02,  .4508D+00,
     +   .3325D-01, -.3096D-01,  .1426D-02,
     +   .8979D-01, -.4183D-01, -.8640D-02, -.8781D-02,  .4679D+00,
     +   .3387D-01, -.2954D-01,  .2359D-02,
     +   .9155D-01, -.4233D-01, -.8239D-02, -.8380D-02,  .4845D+00,
     +   .3453D-01, -.2815D-01,  .3282D-02,
     +   .9309D-01, -.4277D-01, -.7868D-02, -.8009D-02,  .4987D+00,
     +   .3513D-01, -.2696D-01,  .4094D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=1,8)/
     +   .4254D-01, -.2799D-01, -.9746D-02, -.9770D-02,  .1658D-01,
     +   .4939D-01, -.6778D-01, -.6974D-02,
     +   .4831D-01, -.3001D-01, -.1071D-01, -.1076D-01,  .3797D-01,
     +   .4730D-01, -.7055D-01, -.9231D-02,
     +   .5233D-01, -.3140D-01, -.1126D-01, -.1132D-01,  .5507D-01,
     +   .4602D-01, -.7164D-01, -.1035D-01,
     +   .5662D-01, -.3285D-01, -.1173D-01, -.1181D-01,  .7535D-01,
     +   .4484D-01, -.7191D-01, -.1106D-01,
     +   .6136D-01, -.3442D-01, -.1213D-01, -.1221D-01,  .1003D+00,
     +   .4383D-01, -.7120D-01, -.1127D-01,
     +   .6457D-01, -.3547D-01, -.1232D-01, -.1241D-01,  .1187D+00,
     +   .4330D-01, -.7022D-01, -.1109D-01,
     +   .6696D-01, -.3624D-01, -.1243D-01, -.1252D-01,  .1332D+00,
     +   .4301D-01, -.6922D-01, -.1079D-01,
     +   .7037D-01, -.3733D-01, -.1252D-01, -.1262D-01,  .1549D+00,
     +   .4276D-01, -.6743D-01, -.1014D-01 /
        DATA ((PARTON(I,N,14),I=1,8),N=9,16)/
     +   .7278D-01, -.3809D-01, -.1256D-01, -.1266D-01,  .1712D+00,
     +   .4269D-01, -.6603D-01, -.9580D-02,
     +   .7718D-01, -.3946D-01, -.1255D-01, -.1266D-01,  .2028D+00,
     +   .4272D-01, -.6323D-01, -.8323D-02,
     +   .8107D-01, -.4064D-01, -.1244D-01, -.1256D-01,  .2319D+00,
     +   .4304D-01, -.6039D-01, -.6938D-02,
     +   .8440D-01, -.4164D-01, -.1227D-01, -.1238D-01,  .2574D+00,
     +   .4350D-01, -.5781D-01, -.5584D-02,
     +   .8717D-01, -.4246D-01, -.1207D-01, -.1218D-01,  .2790D+00,
     +   .4401D-01, -.5554D-01, -.4353D-02,
     +   .9036D-01, -.4339D-01, -.1177D-01, -.1189D-01,  .3042D+00,
     +   .4474D-01, -.5290D-01, -.2836D-02,
     +   .9305D-01, -.4416D-01, -.1148D-01, -.1160D-01,  .3256D+00,
     +   .4548D-01, -.5062D-01, -.1487D-02,
     +   .9556D-01, -.4487D-01, -.1115D-01, -.1127D-01,  .3455D+00,
     +   .4627D-01, -.4847D-01, -.1749D-03 /
        DATA ((PARTON(I,N,14),I=1,8),N=17,25)/
     +   .9780D-01, -.4549D-01, -.1083D-01, -.1095D-01,  .3632D+00,
     +   .4701D-01, -.4655D-01,  .1033D-02,
     +   .1006D+00, -.4625D-01, -.1038D-01, -.1050D-01,  .3847D+00,
     +   .4801D-01, -.4415D-01,  .2564D-02,
     +   .1031D+00, -.4693D-01, -.9926D-02, -.1005D-01,  .4039D+00,
     +   .4901D-01, -.4198D-01,  .3998D-02,
     +   .1055D+00, -.4758D-01, -.9449D-02, -.9570D-02,  .4222D+00,
     +   .5002D-01, -.3986D-01,  .5411D-02,
     +   .1076D+00, -.4813D-01, -.9007D-02, -.9128D-02,  .4375D+00,
     +   .5094D-01, -.3805D-01,  .6648D-02,
     +   .1097D+00, -.4868D-01, -.8528D-02, -.8648D-02,  .4527D+00,
     +   .5193D-01, -.3621D-01,  .7924D-02,
     +   .1116D+00, -.4918D-01, -.8060D-02, -.8180D-02,  .4664D+00,
     +   .5287D-01, -.3453D-01,  .9118D-02,
     +   .1135D+00, -.4966D-01, -.7579D-02, -.7699D-02,  .4793D+00,
     +   .5383D-01, -.3288D-01,  .1030D-01,
     +   .1152D+00, -.5007D-01, -.7142D-02, -.7262D-02,  .4902D+00,
     +   .5469D-01, -.3146D-01,  .1133D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=1,8)/
     +   .5777D-01, -.3510D-01, -.1232D-01, -.1234D-01,  .2178D-01,
     +   .6268D-01, -.6879D-01, -.9166D-03,
     +   .6484D-01, -.3740D-01, -.1310D-01, -.1314D-01,  .4761D-01,
     +   .6069D-01, -.7418D-01, -.4292D-02,
     +   .6972D-01, -.3895D-01, -.1349D-01, -.1354D-01,  .6785D-01,
     +   .5966D-01, -.7668D-01, -.5917D-02,
     +   .7487D-01, -.4056D-01, -.1377D-01, -.1384D-01,  .9140D-01,
     +   .5886D-01, -.7811D-01, -.6950D-02,
     +   .8051D-01, -.4228D-01, -.1394D-01, -.1401D-01,  .1197D+00,
     +   .5844D-01, -.7830D-01, -.7282D-02,
     +   .8429D-01, -.4342D-01, -.1396D-01, -.1404D-01,  .1401D+00,
     +   .5842D-01, -.7769D-01, -.7056D-02,
     +   .8708D-01, -.4424D-01, -.1394D-01, -.1402D-01,  .1558D+00,
     +   .5851D-01, -.7688D-01, -.6670D-02,
     +   .9104D-01, -.4539D-01, -.1384D-01, -.1393D-01,  .1790D+00,
     +   .5887D-01, -.7531D-01, -.5832D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=9,16)/
     +   .9382D-01, -.4619D-01, -.1374D-01, -.1383D-01,  .1960D+00,
     +   .5924D-01, -.7396D-01, -.5079D-02,
     +   .9885D-01, -.4760D-01, -.1348D-01, -.1357D-01,  .2281D+00,
     +   .6014D-01, -.7108D-01, -.3390D-02,
     +   .1033D+00, -.4881D-01, -.1313D-01, -.1323D-01,  .2568D+00,
     +   .6128D-01, -.6809D-01, -.1551D-02,
     +   .1070D+00, -.4982D-01, -.1275D-01, -.1285D-01,  .2813D+00,
     +   .6244D-01, -.6524D-01,  .2358D-03,
     +   .1101D+00, -.5063D-01, -.1239D-01, -.1249D-01,  .3014D+00,
     +   .6352D-01, -.6276D-01,  .1847D-02,
     +   .1136D+00, -.5153D-01, -.1191D-01, -.1201D-01,  .3244D+00,
     +   .6495D-01, -.5981D-01,  .3820D-02,
     +   .1165D+00, -.5228D-01, -.1145D-01, -.1155D-01,  .3433D+00,
     +   .6627D-01, -.5726D-01,  .5566D-02,
     +   .1193D+00, -.5296D-01, -.1099D-01, -.1109D-01,  .3606D+00,
     +   .6757D-01, -.5482D-01,  .7255D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=17,25)/
     +   .1217D+00, -.5354D-01, -.1055D-01, -.1065D-01,  .3755D+00,
     +   .6881D-01, -.5261D-01,  .8804D-02,
     +   .1246D+00, -.5425D-01, -.9964D-02, -.1006D-01,  .3932D+00,
     +   .7038D-01, -.4988D-01,  .1076D-01,
     +   .1273D+00, -.5487D-01, -.9394D-02, -.9493D-02,  .4086D+00,
     +   .7191D-01, -.4738D-01,  .1258D-01,
     +   .1298D+00, -.5545D-01, -.8812D-02, -.8910D-02,  .4227D+00,
     +   .7341D-01, -.4497D-01,  .1436D-01,
     +   .1320D+00, -.5594D-01, -.8287D-02, -.8385D-02,  .4343D+00,
     +   .7478D-01, -.4289D-01,  .1592D-01,
     +   .1342D+00, -.5642D-01, -.7733D-02, -.7829D-02,  .4454D+00,
     +   .7619D-01, -.4079D-01,  .1753D-01,
     +   .1362D+00, -.5685D-01, -.7202D-02, -.7298D-02,  .4551D+00,
     +   .7752D-01, -.3885D-01,  .1902D-01,
     +   .1381D+00, -.5726D-01, -.6668D-02, -.6763D-02,  .4640D+00,
     +   .7888D-01, -.3697D-01,  .2049D-01,
     +   .1398D+00, -.5760D-01, -.6191D-02, -.6285D-02,  .4712D+00,
     +   .8006D-01, -.3534D-01,  .2177D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=1,8)/
     +   .7856D-01, -.4436D-01, -.1518D-01, -.1520D-01,  .3116D-01,
     +   .7687D-01, -.7112D-01,  .5040D-02,
     +   .8700D-01, -.4684D-01, -.1559D-01, -.1563D-01,  .6268D-01,
     +   .7526D-01, -.7924D-01,  .6413D-03,
     +   .9276D-01, -.4848D-01, -.1571D-01, -.1576D-01,  .8667D-01,
     +   .7482D-01, -.8301D-01, -.1267D-02,
     +   .9876D-01, -.5015D-01, -.1570D-01, -.1575D-01,  .1138D+00,
     +   .7491D-01, -.8534D-01, -.2285D-02,
     +   .1052D+00, -.5191D-01, -.1553D-01, -.1559D-01,  .1453D+00,
     +   .7563D-01, -.8606D-01, -.2295D-02,
     +   .1096D+00, -.5305D-01, -.1533D-01, -.1540D-01,  .1673D+00,
     +   .7650D-01, -.8563D-01, -.1710D-02,
     +   .1127D+00, -.5386D-01, -.1514D-01, -.1521D-01,  .1839D+00,
     +   .7729D-01, -.8487D-01, -.1003D-02,
     +   .1171D+00, -.5498D-01, -.1480D-01, -.1487D-01,  .2077D+00,
     +   .7869D-01, -.8321D-01,  .3632D-03 /
        DATA ((PARTON(I,N,16),I=1,8),N=9,16)/
     +   .1202D+00, -.5575D-01, -.1453D-01, -.1460D-01,  .2247D+00,
     +   .7981D-01, -.8175D-01,  .1532D-02,
     +   .1258D+00, -.5709D-01, -.1395D-01, -.1403D-01,  .2558D+00,
     +   .8207D-01, -.7849D-01,  .4044D-02,
     +   .1305D+00, -.5820D-01, -.1334D-01, -.1342D-01,  .2824D+00,
     +   .8442D-01, -.7509D-01,  .6651D-02,
     +   .1345D+00, -.5910D-01, -.1275D-01, -.1283D-01,  .3043D+00,
     +   .8663D-01, -.7191D-01,  .9106D-02,
     +   .1378D+00, -.5982D-01, -.1221D-01, -.1229D-01,  .3218D+00,
     +   .8860D-01, -.6907D-01,  .1128D-01,
     +   .1415D+00, -.6060D-01, -.1155D-01, -.1163D-01,  .3410D+00,
     +   .9094D-01, -.6570D-01,  .1388D-01,
     +   .1445D+00, -.6123D-01, -.1096D-01, -.1103D-01,  .3562D+00,
     +   .9306D-01, -.6282D-01,  .1616D-01,
     +   .1473D+00, -.6179D-01, -.1037D-01, -.1045D-01,  .3696D+00,
     +   .9505D-01, -.6006D-01,  .1834D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=17,25)/
     +   .1497D+00, -.6226D-01, -.9826D-02, -.9902D-02,  .3808D+00,
     +   .9692D-01, -.5757D-01,  .2031D-01,
     +   .1527D+00, -.6281D-01, -.9130D-02, -.9205D-02,  .3936D+00,
     +   .9923D-01, -.5450D-01,  .2279D-01,
     +   .1553D+00, -.6329D-01, -.8474D-02, -.8548D-02,  .4042D+00,
     +   .1014D+00, -.5168D-01,  .2507D-01,
     +   .1578D+00, -.6371D-01, -.7820D-02, -.7894D-02,  .4134D+00,
     +   .1036D+00, -.4896D-01,  .2730D-01,
     +   .1599D+00, -.6406D-01, -.7246D-02, -.7318D-02,  .4206D+00,
     +   .1054D+00, -.4663D-01,  .2922D-01,
     +   .1620D+00, -.6439D-01, -.6650D-02, -.6722D-02,  .4271D+00,
     +   .1074D+00, -.4429D-01,  .3119D-01,
     +   .1639D+00, -.6468D-01, -.6092D-02, -.6163D-02,  .4323D+00,
     +   .1092D+00, -.4212D-01,  .3302D-01,
     +   .1657D+00, -.6494D-01, -.5539D-02, -.5609D-02,  .4368D+00,
     +   .1110D+00, -.4002D-01,  .3480D-01,
     +   .1672D+00, -.6515D-01, -.5054D-02, -.5123D-02,  .4402D+00,
     +   .1126D+00, -.3821D-01,  .3636D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=1,8)/
     +   .1147D+00, -.5923D-01, -.1864D-01, -.1865D-01,  .5495D-01,
     +   .9353D-01, -.7962D-01,  .9447D-02,
     +   .1246D+00, -.6159D-01, -.1833D-01, -.1836D-01,  .9468D-01,
     +   .9396D-01, -.9002D-01,  .5079D-02,
     +   .1312D+00, -.6310D-01, -.1796D-01, -.1800D-01,  .1233D+00,
     +   .9542D-01, -.9439D-01,  .3870D-02,
     +   .1380D+00, -.6459D-01, -.1745D-01, -.1749D-01,  .1541D+00,
     +   .9785D-01, -.9676D-01,  .4012D-02,
     +   .1452D+00, -.6610D-01, -.1675D-01, -.1679D-01,  .1879D+00,
     +   .1013D+00, -.9698D-01,  .5600D-02,
     +   .1499D+00, -.6703D-01, -.1621D-01, -.1626D-01,  .2103D+00,
     +   .1041D+00, -.9599D-01,  .7375D-02,
     +   .1533D+00, -.6768D-01, -.1578D-01, -.1582D-01,  .2265D+00,
     +   .1063D+00, -.9472D-01,  .8992D-02,
     +   .1580D+00, -.6855D-01, -.1511D-01, -.1516D-01,  .2489D+00,
     +   .1096D+00, -.9237D-01,  .1167D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=9,16)/
     +   .1612D+00, -.6913D-01, -.1462D-01, -.1466D-01,  .2641D+00,
     +   .1121D+00, -.9033D-01,  .1377D-01,
     +   .1669D+00, -.7008D-01, -.1364D-01, -.1369D-01,  .2904D+00,
     +   .1168D+00, -.8607D-01,  .1796D-01,
     +   .1716D+00, -.7082D-01, -.1273D-01, -.1277D-01,  .3114D+00,
     +   .1213D+00, -.8175D-01,  .2199D-01,
     +   .1755D+00, -.7138D-01, -.1190D-01, -.1195D-01,  .3274D+00,
     +   .1251D+00, -.7785D-01,  .2560D-01,
     +   .1786D+00, -.7179D-01, -.1120D-01, -.1125D-01,  .3394D+00,
     +   .1283D+00, -.7446D-01,  .2868D-01,
     +   .1821D+00, -.7221D-01, -.1037D-01, -.1041D-01,  .3516D+00,
     +   .1321D+00, -.7043D-01,  .3228D-01,
     +   .1849D+00, -.7251D-01, -.9649D-02, -.9697D-02,  .3606D+00,
     +   .1353D+00, -.6708D-01,  .3536D-01,
     +   .1873D+00, -.7275D-01, -.8971D-02, -.9018D-02,  .3677D+00,
     +   .1383D+00, -.6388D-01,  .3823D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=17,25)/
     +   .1895D+00, -.7294D-01, -.8361D-02, -.8408D-02,  .3732D+00,
     +   .1411D+00, -.6105D-01,  .4082D-01,
     +   .1920D+00, -.7312D-01, -.7605D-02, -.7651D-02,  .3786D+00,
     +   .1444D+00, -.5756D-01,  .4399D-01,
     +   .1942D+00, -.7324D-01, -.6914D-02, -.6960D-02,  .3823D+00,
     +   .1475D+00, -.5439D-01,  .4690D-01,
     +   .1962D+00, -.7332D-01, -.6247D-02, -.6292D-02,  .3848D+00,
     +   .1504D+00, -.5135D-01,  .4967D-01,
     +   .1978D+00, -.7336D-01, -.5675D-02, -.5719D-02,  .3862D+00,
     +   .1529D+00, -.4878D-01,  .5206D-01,
     +   .1994D+00, -.7337D-01, -.5096D-02, -.5140D-02,  .3867D+00,
     +   .1555D+00, -.4617D-01,  .5448D-01,
     +   .2008D+00, -.7335D-01, -.4566D-02, -.4609D-02,  .3866D+00,
     +   .1579D+00, -.4383D-01,  .5670D-01,
     +   .2021D+00, -.7331D-01, -.4052D-02, -.4094D-02,  .3858D+00,
     +   .1602D+00, -.4153D-01,  .5886D-01,
     +   .2032D+00, -.7326D-01, -.3609D-02, -.3650D-02,  .3847D+00,
     +   .1623D+00, -.3957D-01,  .6073D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=1,8)/
     +   .1633D+00, -.7668D-01, -.2107D-01, -.2108D-01,  .1010D+00,
     +   .1069D+00, -.9869D-01,  .7573D-02,
     +   .1738D+00, -.7834D-01, -.1986D-01, -.1987D-01,  .1470D+00,
     +   .1131D+00, -.1076D+00,  .6837D-02,
     +   .1806D+00, -.7931D-01, -.1892D-01, -.1894D-01,  .1777D+00,
     +   .1186D+00, -.1101D+00,  .8520D-02,
     +   .1874D+00, -.8019D-01, -.1787D-01, -.1789D-01,  .2087D+00,
     +   .1252D+00, -.1102D+00,  .1180D-01,
     +   .1944D+00, -.8098D-01, -.1665D-01, -.1668D-01,  .2400D+00,
     +   .1330D+00, -.1079D+00,  .1673D-01,
     +   .1988D+00, -.8141D-01, -.1580D-01, -.1583D-01,  .2593D+00,
     +   .1384D+00, -.1053D+00,  .2064D-01,
     +   .2019D+00, -.8167D-01, -.1516D-01, -.1518D-01,  .2726D+00,
     +   .1425D+00, -.1029D+00,  .2374D-01,
     +   .2061D+00, -.8197D-01, -.1423D-01, -.1425D-01,  .2897D+00,
     +   .1484D+00, -.9895D-01,  .2841D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=9,16)/
     +   .2090D+00, -.8213D-01, -.1356D-01, -.1358D-01,  .3005D+00,
     +   .1525D+00, -.9592D-01,  .3181D-01,
     +   .2138D+00, -.8230D-01, -.1232D-01, -.1234D-01,  .3174D+00,
     +   .1599D+00, -.9004D-01,  .3817D-01,
     +   .2176D+00, -.8234D-01, -.1122D-01, -.1124D-01,  .3291D+00,
     +   .1664D+00, -.8452D-01,  .4388D-01,
     +   .2207D+00, -.8227D-01, -.1028D-01, -.1031D-01,  .3366D+00,
     +   .1718D+00, -.7969D-01,  .4877D-01,
     +   .2230D+00, -.8216D-01, -.9511D-02, -.9538D-02,  .3412D+00,
     +   .1763D+00, -.7565D-01,  .5282D-01,
     +   .2254D+00, -.8195D-01, -.8632D-02, -.8660D-02,  .3447D+00,
     +   .1814D+00, -.7101D-01,  .5743D-01,
     +   .2273D+00, -.8172D-01, -.7901D-02, -.7928D-02,  .3463D+00,
     +   .1856D+00, -.6718D-01,  .6126D-01,
     +   .2289D+00, -.8146D-01, -.7230D-02, -.7257D-02,  .3465D+00,
     +   .1894D+00, -.6362D-01,  .6478D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=17,25)/
     +   .2302D+00, -.8119D-01, -.6642D-02, -.6668D-02,  .3458D+00,
     +   .1929D+00, -.6047D-01,  .6789D-01,
     +   .2316D+00, -.8081D-01, -.5934D-02, -.5959D-02,  .3438D+00,
     +   .1970D+00, -.5669D-01,  .7167D-01,
     +   .2327D+00, -.8041D-01, -.5304D-02, -.5329D-02,  .3409D+00,
     +   .2007D+00, -.5329D-01,  .7506D-01,
     +   .2336D+00, -.7999D-01, -.4712D-02, -.4736D-02,  .3373D+00,
     +   .2042D+00, -.5007D-01,  .7829D-01,
     +   .2343D+00, -.7959D-01, -.4216D-02, -.4239D-02,  .3336D+00,
     +   .2073D+00, -.4736D-01,  .8104D-01,
     +   .2349D+00, -.7915D-01, -.3724D-02, -.3748D-02,  .3292D+00,
     +   .2103D+00, -.4468D-01,  .8382D-01,
     +   .2353D+00, -.7871D-01, -.3283D-02, -.3306D-02,  .3246D+00,
     +   .2132D+00, -.4223D-01,  .8633D-01,
     +   .2357D+00, -.7826D-01, -.2863D-02, -.2886D-02,  .3198D+00,
     +   .2159D+00, -.3987D-01,  .8875D-01,
     +   .2359D+00, -.7785D-01, -.2508D-02, -.2530D-02,  .3153D+00,
     +   .2182D+00, -.3789D-01,  .9086D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=1,8)/
     +   .2103D+00, -.9075D-01, -.2170D-01, -.2170D-01,  .1576D+00,
     +   .1173D+00, -.1210D+00,  .2872D-02,
     +   .2200D+00, -.9134D-01, -.1982D-01, -.1983D-01,  .2030D+00,
     +   .1312D+00, -.1245D+00,  .8567D-02,
     +   .2261D+00, -.9156D-01, -.1851D-01, -.1852D-01,  .2311D+00,
     +   .1414D+00, -.1235D+00,  .1429D-01,
     +   .2319D+00, -.9162D-01, -.1713D-01, -.1714D-01,  .2574D+00,
     +   .1522D+00, -.1201D+00,  .2136D-01,
     +   .2377D+00, -.9149D-01, -.1562D-01, -.1563D-01,  .2818D+00,
     +   .1640D+00, -.1145D+00,  .2988D-01,
     +   .2412D+00, -.9129D-01, -.1461D-01, -.1463D-01,  .2954D+00,
     +   .1715D+00, -.1100D+00,  .3585D-01,
     +   .2436D+00, -.9109D-01, -.1387D-01, -.1389D-01,  .3039D+00,
     +   .1772D+00, -.1064D+00,  .4035D-01,
     +   .2467D+00, -.9072D-01, -.1283D-01, -.1285D-01,  .3140D+00,
     +   .1848D+00, -.1009D+00,  .4675D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=9,16)/
     +   .2487D+00, -.9040D-01, -.1211D-01, -.1212D-01,  .3195D+00,
     +   .1901D+00, -.9699D-01,  .5122D-01,
     +   .2518D+00, -.8971D-01, -.1080D-01, -.1081D-01,  .3262D+00,
     +   .1993D+00, -.8962D-01,  .5923D-01,
     +   .2542D+00, -.8897D-01, -.9681D-02, -.9698D-02,  .3288D+00,
     +   .2071D+00, -.8312D-01,  .6616D-01,
     +   .2558D+00, -.8825D-01, -.8762D-02, -.8778D-02,  .3287D+00,
     +   .2135D+00, -.7761D-01,  .7191D-01,
     +   .2569D+00, -.8759D-01, -.8022D-02, -.8039D-02,  .3271D+00,
     +   .2186D+00, -.7312D-01,  .7657D-01,
     +   .2579D+00, -.8676D-01, -.7199D-02, -.7215D-02,  .3237D+00,
     +   .2243D+00, -.6808D-01,  .8180D-01,
     +   .2585D+00, -.8601D-01, -.6529D-02, -.6545D-02,  .3196D+00,
     +   .2289D+00, -.6399D-01,  .8606D-01,
     +   .2588D+00, -.8526D-01, -.5926D-02, -.5941D-02,  .3149D+00,
     +   .2331D+00, -.6023D-01,  .8994D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=17,25)/
     +   .2590D+00, -.8455D-01, -.5407D-02, -.5423D-02,  .3100D+00,
     +   .2368D+00, -.5695D-01,  .9332D-01,
     +   .2590D+00, -.8364D-01, -.4794D-02, -.4808D-02,  .3032D+00,
     +   .2413D+00, -.5304D-01,  .9742D-01,
     +   .2588D+00, -.8277D-01, -.4259D-02, -.4273D-02,  .2963D+00,
     +   .2452D+00, -.4957D-01,  .1011D+00,
     +   .2585D+00, -.8188D-01, -.3765D-02, -.3779D-02,  .2891D+00,
     +   .2490D+00, -.4630D-01,  .1045D+00,
     +   .2581D+00, -.8109D-01, -.3357D-02, -.3371D-02,  .2825D+00,
     +   .2521D+00, -.4358D-01,  .1074D+00,
     +   .2575D+00, -.8026D-01, -.2960D-02, -.2973D-02,  .2755D+00,
     +   .2552D+00, -.4085D-01,  .1103D+00,
     +   .2568D+00, -.7946D-01, -.2608D-02, -.2621D-02,  .2688D+00,
     +   .2582D+00, -.3844D-01,  .1130D+00,
     +   .2561D+00, -.7866D-01, -.2278D-02, -.2291D-02,  .2620D+00,
     +   .2610D+00, -.3612D-01,  .1155D+00,
     +   .2553D+00, -.7795D-01, -.2003D-02, -.2015D-02,  .2560D+00,
     +   .2634D+00, -.3413D-01,  .1177D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=1,8)/
     +   .2549D+00, -.1016D+00, -.2116D-01, -.2117D-01,  .2171D+00,
     +   .1301D+00, -.1419D+00,  .2872D-03,
     +   .2628D+00, -.1010D+00, -.1889D-01, -.1890D-01,  .2560D+00,
     +   .1519D+00, -.1382D+00,  .1342D-01,
     +   .2674D+00, -.1003D+00, -.1738D-01, -.1739D-01,  .2778D+00,
     +   .1663D+00, -.1330D+00,  .2330D-01,
     +   .2716D+00, -.9949D-01, -.1584D-01, -.1585D-01,  .2962D+00,
     +   .1806D+00, -.1260D+00,  .3397D-01,
     +   .2754D+00, -.9838D-01, -.1421D-01, -.1422D-01,  .3109D+00,
     +   .1953D+00, -.1172D+00,  .4562D-01,
     +   .2775D+00, -.9753D-01, -.1316D-01, -.1317D-01,  .3176D+00,
     +   .2044D+00, -.1109D+00,  .5329D-01,
     +   .2789D+00, -.9685D-01, -.1240D-01, -.1241D-01,  .3209D+00,
     +   .2109D+00, -.1062D+00,  .5883D-01,
     +   .2804D+00, -.9580D-01, -.1136D-01, -.1137D-01,  .3235D+00,
     +   .2197D+00, -.9940D-01,  .6652D-01 /
        DATA ((PARTON(I,N,20),I=1,8),N=9,16)/
     +   .2812D+00, -.9501D-01, -.1064D-01, -.1065D-01,  .3238D+00,
     +   .2256D+00, -.9467D-01,  .7174D-01,
     +   .2823D+00, -.9347D-01, -.9381D-02, -.9392D-02,  .3212D+00,
     +   .2357D+00, -.8627D-01,  .8087D-01,
     +   .2827D+00, -.9199D-01, -.8332D-02, -.8342D-02,  .3160D+00,
     +   .2441D+00, -.7907D-01,  .8856D-01,
     +   .2826D+00, -.9066D-01, -.7485D-02, -.7496D-02,  .3097D+00,
     +   .2508D+00, -.7312D-01,  .9482D-01,
     +   .2822D+00, -.8949D-01, -.6818D-02, -.6828D-02,  .3033D+00,
     +   .2562D+00, -.6834D-01,  .9982D-01,
     +   .2815D+00, -.8810D-01, -.6086D-02, -.6096D-02,  .2949D+00,
     +   .2620D+00, -.6304D-01,  .1053D+00,
     +   .2807D+00, -.8688D-01, -.5500D-02, -.5510D-02,  .2869D+00,
     +   .2668D+00, -.5879D-01,  .1098D+00,
     +   .2797D+00, -.8570D-01, -.4981D-02, -.4990D-02,  .2789D+00,
     +   .2710D+00, -.5495D-01,  .1138D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=17,25)/
     +   .2787D+00, -.8462D-01, -.4540D-02, -.4549D-02,  .2714D+00,
     +   .2748D+00, -.5166D-01,  .1174D+00,
     +   .2772D+00, -.8326D-01, -.4025D-02, -.4034D-02,  .2618D+00,
     +   .2792D+00, -.4771D-01,  .1216D+00,
     +   .2756D+00, -.8198D-01, -.3582D-02, -.3591D-02,  .2526D+00,
     +   .2831D+00, -.4422D-01,  .1253D+00,
     +   .2739D+00, -.8071D-01, -.3178D-02, -.3187D-02,  .2436D+00,
     +   .2869D+00, -.4097D-01,  .1288D+00,
     +   .2723D+00, -.7960D-01, -.2849D-02, -.2858D-02,  .2357D+00,
     +   .2899D+00, -.3826D-01,  .1317D+00,
     +   .2705D+00, -.7845D-01, -.2532D-02, -.2540D-02,  .2275D+00,
     +   .2931D+00, -.3561D-01,  .1347D+00,
     +   .2688D+00, -.7736D-01, -.2253D-02, -.2261D-02,  .2200D+00,
     +   .2959D+00, -.3320D-01,  .1373D+00,
     +   .2670D+00, -.7629D-01, -.1995D-02, -.2003D-02,  .2126D+00,
     +   .2987D+00, -.3091D-01,  .1398D+00,
     +   .2653D+00, -.7534D-01, -.1781D-02, -.1788D-02,  .2061D+00,
     +   .3010D+00, -.2896D-01,  .1420D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=1,8)/
     +   .2964D+00, -.1095D+00, -.1990D-01, -.1990D-01,  .2727D+00,
     +   .1480D+00, -.1584D+00,  .2673D-02,
     +   .3015D+00, -.1075D+00, -.1745D-01, -.1746D-01,  .3004D+00,
     +   .1764D+00, -.1471D+00,  .2281D-01,
     +   .3042D+00, -.1060D+00, -.1588D-01, -.1588D-01,  .3136D+00,
     +   .1938D+00, -.1380D+00,  .3625D-01,
     +   .3062D+00, -.1043D+00, -.1431D-01, -.1432D-01,  .3225D+00,
     +   .2105D+00, -.1276D+00,  .4982D-01,
     +   .3075D+00, -.1022D+00, -.1270D-01, -.1270D-01,  .3266D+00,
     +   .2268D+00, -.1161D+00,  .6380D-01,
     +   .3079D+00, -.1008D+00, -.1167D-01, -.1168D-01,  .3263D+00,
     +   .2368D+00, -.1084D+00,  .7265D-01,
     +   .3079D+00, -.9961D-01, -.1095D-01, -.1095D-01,  .3246D+00,
     +   .2437D+00, -.1029D+00,  .7893D-01,
     +   .3076D+00, -.9793D-01, -.9958D-02, -.9965D-02,  .3203D+00,
     +   .2530D+00, -.9510D-01,  .8744D-01 /
        DATA ((PARTON(I,N,21),I=1,8),N=9,16)/
     +   .3072D+00, -.9671D-01, -.9289D-02, -.9295D-02,  .3159D+00,
     +   .2591D+00, -.8977D-01,  .9310D-01,
     +   .3058D+00, -.9439D-01, -.8128D-02, -.8135D-02,  .3056D+00,
     +   .2695D+00, -.8064D-01,  .1029D+00,
     +   .3040D+00, -.9226D-01, -.7182D-02, -.7189D-02,  .2943D+00,
     +   .2778D+00, -.7296D-01,  .1109D+00,
     +   .3020D+00, -.9039D-01, -.6432D-02, -.6438D-02,  .2835D+00,
     +   .2846D+00, -.6676D-01,  .1174D+00,
     +   .3001D+00, -.8879D-01, -.5847D-02, -.5854D-02,  .2738D+00,
     +   .2898D+00, -.6182D-01,  .1225D+00,
     +   .2977D+00, -.8692D-01, -.5215D-02, -.5221D-02,  .2621D+00,
     +   .2955D+00, -.5646D-01,  .1281D+00,
     +   .2953D+00, -.8530D-01, -.4714D-02, -.4720D-02,  .2517D+00,
     +   .3003D+00, -.5214D-01,  .1326D+00,
     +   .2929D+00, -.8377D-01, -.4275D-02, -.4281D-02,  .2419D+00,
     +   .3043D+00, -.4829D-01,  .1367D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=17,25)/
     +   .2907D+00, -.8239D-01, -.3905D-02, -.3911D-02,  .2330D+00,
     +   .3079D+00, -.4496D-01,  .1402D+00,
     +   .2876D+00, -.8066D-01, -.3478D-02, -.3484D-02,  .2220D+00,
     +   .3123D+00, -.4104D-01,  .1444D+00,
     +   .2847D+00, -.7906D-01, -.3114D-02, -.3120D-02,  .2119D+00,
     +   .3159D+00, -.3758D-01,  .1480D+00,
     +   .2817D+00, -.7750D-01, -.2785D-02, -.2791D-02,  .2023D+00,
     +   .3195D+00, -.3438D-01,  .1515D+00,
     +   .2790D+00, -.7615D-01, -.2519D-02, -.2525D-02,  .1940D+00,
     +   .3225D+00, -.3172D-01,  .1545D+00,
     +   .2761D+00, -.7475D-01, -.2264D-02, -.2269D-02,  .1857D+00,
     +   .3254D+00, -.2909D-01,  .1574D+00,
     +   .2733D+00, -.7346D-01, -.2042D-02, -.2047D-02,  .1782D+00,
     +   .3282D+00, -.2672D-01,  .1600D+00,
     +   .2705D+00, -.7218D-01, -.1837D-02, -.1842D-02,  .1709D+00,
     +   .3307D+00, -.2449D-01,  .1625D+00,
     +   .2679D+00, -.7106D-01, -.1669D-02, -.1673D-02,  .1647D+00,
     +   .3330D+00, -.2257D-01,  .1647D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=1,8)/
     +   .3339D+00, -.1145D+00, -.1819D-01, -.1819D-01,  .3190D+00,
     +   .1718D+00, -.1688D+00,  .1126D-01,
     +   .3356D+00, -.1113D+00, -.1575D-01, -.1576D-01,  .3329D+00,
     +   .2044D+00, -.1508D+00,  .3697D-01,
     +   .3358D+00, -.1090D+00, -.1422D-01, -.1422D-01,  .3365D+00,
     +   .2235D+00, -.1383D+00,  .5304D-01,
     +   .3353D+00, -.1064D+00, -.1271D-01, -.1271D-01,  .3355D+00,
     +   .2411D+00, -.1253D+00,  .6857D-01,
     +   .3338D+00, -.1035D+00, -.1119D-01, -.1119D-01,  .3294D+00,
     +   .2581D+00, -.1117D+00,  .8402D-01,
     +   .3323D+00, -.1015D+00, -.1023D-01, -.1024D-01,  .3228D+00,
     +   .2682D+00, -.1030D+00,  .9355D-01,
     +   .3309D+00, -.9992D-01, -.9566D-02, -.9570D-02,  .3168D+00,
     +   .2752D+00, -.9674D-01,  .1002D+00,
     +   .3285D+00, -.9768D-01, -.8666D-02, -.8671D-02,  .3067D+00,
     +   .2844D+00, -.8830D-01,  .1091D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=9,16)/
     +   .3266D+00, -.9607D-01, -.8062D-02, -.8067D-02,  .2987D+00,
     +   .2904D+00, -.8271D-01,  .1150D+00,
     +   .3227D+00, -.9310D-01, -.7029D-02, -.7033D-02,  .2825D+00,
     +   .3005D+00, -.7307D-01,  .1249D+00,
     +   .3186D+00, -.9041D-01, -.6198D-02, -.6202D-02,  .2670D+00,
     +   .3086D+00, -.6518D-01,  .1330D+00,
     +   .3148D+00, -.8810D-01, -.5547D-02, -.5551D-02,  .2532D+00,
     +   .3150D+00, -.5885D-01,  .1395D+00,
     +   .3113D+00, -.8615D-01, -.5044D-02, -.5048D-02,  .2416D+00,
     +   .3199D+00, -.5388D-01,  .1445D+00,
     +   .3071D+00, -.8389D-01, -.4505D-02, -.4509D-02,  .2280D+00,
     +   .3255D+00, -.4849D-01,  .1501D+00,
     +   .3033D+00, -.8197D-01, -.4082D-02, -.4086D-02,  .2166D+00,
     +   .3298D+00, -.4419D-01,  .1546D+00,
     +   .2996D+00, -.8017D-01, -.3713D-02, -.3717D-02,  .2060D+00,
     +   .3338D+00, -.4035D-01,  .1586D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=17,25)/
     +   .2961D+00, -.7855D-01, -.3405D-02, -.3409D-02,  .1966D+00,
     +   .3371D+00, -.3707D-01,  .1620D+00,
     +   .2916D+00, -.7655D-01, -.3051D-02, -.3055D-02,  .1853D+00,
     +   .3412D+00, -.3319D-01,  .1661D+00,
     +   .2874D+00, -.7472D-01, -.2751D-02, -.2755D-02,  .1753D+00,
     +   .3446D+00, -.2977D-01,  .1697D+00,
     +   .2832D+00, -.7295D-01, -.2482D-02, -.2486D-02,  .1658D+00,
     +   .3480D+00, -.2661D-01,  .1731D+00,
     +   .2794D+00, -.7143D-01, -.2265D-02, -.2269D-02,  .1578D+00,
     +   .3508D+00, -.2400D-01,  .1760D+00,
     +   .2755D+00, -.6987D-01, -.2058D-02, -.2062D-02,  .1500D+00,
     +   .3535D+00, -.2140D-01,  .1788D+00,
     +   .2718D+00, -.6843D-01, -.1879D-02, -.1882D-02,  .1429D+00,
     +   .3562D+00, -.1907D-01,  .1814D+00,
     +   .2681D+00, -.6702D-01, -.1713D-02, -.1716D-02,  .1362D+00,
     +   .3584D+00, -.1685D-01,  .1838D+00,
     +   .2648D+00, -.6579D-01, -.1577D-02, -.1581D-02,  .1305D+00,
     +   .3606D+00, -.1497D-01,  .1859D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=1,8)/
     +   .3667D+00, -.1171D+00, -.1625D-01, -.1625D-01,  .3524D+00,
     +   .2005D+00, -.1726D+00,  .2607D-01,
     +   .3645D+00, -.1127D+00, -.1395D-01, -.1395D-01,  .3517D+00,
     +   .2347D+00, -.1493D+00,  .5546D-01,
     +   .3621D+00, -.1097D+00, -.1251D-01, -.1252D-01,  .3459D+00,
     +   .2542D+00, -.1343D+00,  .7308D-01,
     +   .3587D+00, -.1063D+00, -.1113D-01, -.1113D-01,  .3358D+00,
     +   .2717D+00, -.1194D+00,  .8963D-01,
     +   .3542D+00, -.1026D+00, -.9740D-02, -.9743D-02,  .3209D+00,
     +   .2885D+00, -.1043D+00,  .1057D+00,
     +   .3507D+00, -.1001D+00, -.8883D-02, -.8886D-02,  .3091D+00,
     +   .2983D+00, -.9488D-01,  .1155D+00,
     +   .3478D+00, -.9822D-01, -.8287D-02, -.8290D-02,  .2997D+00,
     +   .3049D+00, -.8832D-01,  .1222D+00,
     +   .3434D+00, -.9552D-01, -.7489D-02, -.7492D-02,  .2853D+00,
     +   .3138D+00, -.7950D-01,  .1311D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=9,16)/
     +   .3400D+00, -.9360D-01, -.6957D-02, -.6961D-02,  .2747D+00,
     +   .3194D+00, -.7373D-01,  .1370D+00,
     +   .3335D+00, -.9008D-01, -.6056D-02, -.6059D-02,  .2546D+00,
     +   .3289D+00, -.6392D-01,  .1468D+00,
     +   .3272D+00, -.8696D-01, -.5339D-02, -.5342D-02,  .2366D+00,
     +   .3363D+00, -.5591D-01,  .1547D+00,
     +   .3215D+00, -.8430D-01, -.4781D-02, -.4784D-02,  .2213D+00,
     +   .3424D+00, -.4959D-01,  .1611D+00,
     +   .3166D+00, -.8209D-01, -.4354D-02, -.4357D-02,  .2088D+00,
     +   .3471D+00, -.4462D-01,  .1660D+00,
     +   .3106D+00, -.7954D-01, -.3898D-02, -.3901D-02,  .1947D+00,
     +   .3522D+00, -.3929D-01,  .1714D+00,
     +   .3055D+00, -.7740D-01, -.3542D-02, -.3545D-02,  .1831D+00,
     +   .3562D+00, -.3502D-01,  .1757D+00,
     +   .3005D+00, -.7540D-01, -.3234D-02, -.3236D-02,  .1725D+00,
     +   .3599D+00, -.3124D-01,  .1795D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=17,25)/
     +   .2959D+00, -.7363D-01, -.2977D-02, -.2980D-02,  .1634D+00,
     +   .3630D+00, -.2802D-01,  .1829D+00,
     +   .2902D+00, -.7145D-01, -.2683D-02, -.2685D-02,  .1525D+00,
     +   .3667D+00, -.2417D-01,  .1868D+00,
     +   .2848D+00, -.6947D-01, -.2435D-02, -.2438D-02,  .1430D+00,
     +   .3700D+00, -.2082D-01,  .1903D+00,
     +   .2795D+00, -.6756D-01, -.2213D-02, -.2215D-02,  .1342D+00,
     +   .3730D+00, -.1771D-01,  .1936D+00,
     +   .2749D+00, -.6593D-01, -.2034D-02, -.2037D-02,  .1269D+00,
     +   .3755D+00, -.1512D-01,  .1963D+00,
     +   .2701D+00, -.6428D-01, -.1864D-02, -.1867D-02,  .1198D+00,
     +   .3783D+00, -.1256D-01,  .1991D+00,
     +   .2656D+00, -.6276D-01, -.1717D-02, -.1719D-02,  .1135D+00,
     +   .3805D+00, -.1026D-01,  .2016D+00,
     +   .2611D+00, -.6127D-01, -.1581D-02, -.1584D-02,  .1076D+00,
     +   .3827D+00, -.8061D-02,  .2040D+00,
     +   .2572D+00, -.5999D-01, -.1470D-02, -.1472D-02,  .1026D+00,
     +   .3848D+00, -.6194D-02,  .2060D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=1,8)/
     +   .3943D+00, -.1174D+00, -.1423D-01, -.1423D-01,  .3713D+00,
     +   .2327D+00, -.1701D+00,  .4632D-01,
     +   .3879D+00, -.1120D+00, -.1214D-01, -.1214D-01,  .3568D+00,
     +   .2663D+00, -.1430D+00,  .7742D-01,
     +   .3827D+00, -.1083D+00, -.1085D-01, -.1085D-01,  .3427D+00,
     +   .2850D+00, -.1262D+00,  .9555D-01,
     +   .3764D+00, -.1044D+00, -.9611D-02, -.9613D-02,  .3250D+00,
     +   .3018D+00, -.1101D+00,  .1123D+00,
     +   .3687D+00, -.1000D+00, -.8385D-02, -.8388D-02,  .3033D+00,
     +   .3174D+00, -.9429D-01,  .1283D+00,
     +   .3632D+00, -.9709D-01, -.7633D-02, -.7635D-02,  .2876D+00,
     +   .3266D+00, -.8461D-01,  .1380D+00,
     +   .3588D+00, -.9492D-01, -.7112D-02, -.7114D-02,  .2758D+00,
     +   .3327D+00, -.7785D-01,  .1445D+00,
     +   .3523D+00, -.9185D-01, -.6419D-02, -.6421D-02,  .2587D+00,
     +   .3409D+00, -.6894D-01,  .1533D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=9,16)/
     +   .3476D+00, -.8969D-01, -.5959D-02, -.5962D-02,  .2465D+00,
     +   .3461D+00, -.6306D-01,  .1589D+00,
     +   .3385D+00, -.8577D-01, -.5186D-02, -.5188D-02,  .2243D+00,
     +   .3548D+00, -.5325D-01,  .1684D+00,
     +   .3302D+00, -.8233D-01, -.4574D-02, -.4576D-02,  .2053D+00,
     +   .3618D+00, -.4532D-01,  .1760D+00,
     +   .3228D+00, -.7942D-01, -.4102D-02, -.4104D-02,  .1897D+00,
     +   .3672D+00, -.3906D-01,  .1820D+00,
     +   .3164D+00, -.7703D-01, -.3741D-02, -.3743D-02,  .1772D+00,
     +   .3715D+00, -.3419D-01,  .1868D+00,
     +   .3090D+00, -.7429D-01, -.3358D-02, -.3360D-02,  .1634D+00,
     +   .3762D+00, -.2893D-01,  .1920D+00,
     +   .3026D+00, -.7201D-01, -.3060D-02, -.3062D-02,  .1522D+00,
     +   .3799D+00, -.2476D-01,  .1961D+00,
     +   .2965D+00, -.6989D-01, -.2802D-02, -.2804D-02,  .1423D+00,
     +   .3831D+00, -.2103D-01,  .1997D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=17,25)/
     +   .2910D+00, -.6802D-01, -.2588D-02, -.2590D-02,  .1338D+00,
     +   .3861D+00, -.1784D-01,  .2030D+00,
     +   .2841D+00, -.6574D-01, -.2343D-02, -.2345D-02,  .1239D+00,
     +   .3893D+00, -.1407D-01,  .2067D+00,
     +   .2778D+00, -.6368D-01, -.2137D-02, -.2139D-02,  .1153D+00,
     +   .3924D+00, -.1078D-01,  .2101D+00,
     +   .2716D+00, -.6171D-01, -.1953D-02, -.1955D-02,  .1075D+00,
     +   .3954D+00, -.7706D-02,  .2133D+00,
     +   .2662D+00, -.6003D-01, -.1805D-02, -.1807D-02,  .1010D+00,
     +   .3978D+00, -.5145D-02,  .2159D+00,
     +   .2607D+00, -.5833D-01, -.1664D-02, -.1666D-02,  .9483D-01,
     +   .4001D+00, -.2611D-02,  .2185D+00,
     +   .2556D+00, -.5678D-01, -.1542D-02, -.1543D-02,  .8937D-01,
     +   .4022D+00, -.3293D-03,  .2209D+00,
     +   .2505D+00, -.5528D-01, -.1429D-02, -.1431D-02,  .8428D-01,
     +   .4042D+00,  .1851D-02,  .2232D+00,
     +   .2461D+00, -.5398D-01, -.1337D-02, -.1339D-02,  .8005D-01,
     +   .4060D+00,  .3709D-02,  .2251D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=1,8)/
     +   .4162D+00, -.1157D+00, -.1224D-01, -.1224D-01,  .3759D+00,
     +   .2666D+00, -.1617D+00,  .7078D-01,
     +   .4055D+00, -.1095D+00, -.1040D-01, -.1040D-01,  .3495D+00,
     +   .2979D+00, -.1325D+00,  .1019D+00,
     +   .3974D+00, -.1053D+00, -.9273D-02, -.9274D-02,  .3288D+00,
     +   .3150D+00, -.1148D+00,  .1196D+00,
     +   .3883D+00, -.1008D+00, -.8195D-02, -.8197D-02,  .3053D+00,
     +   .3304D+00, -.9816D-01,  .1359D+00,
     +   .3776D+00, -.9598D-01, -.7135D-02, -.7137D-02,  .2788D+00,
     +   .3445D+00, -.8210D-01,  .1513D+00,
     +   .3700D+00, -.9275D-01, -.6487D-02, -.6489D-02,  .2608D+00,
     +   .3528D+00, -.7232D-01,  .1605D+00,
     +   .3642D+00, -.9038D-01, -.6040D-02, -.6042D-02,  .2476D+00,
     +   .3585D+00, -.6564D-01,  .1669D+00,
     +   .3558D+00, -.8704D-01, -.5448D-02, -.5449D-02,  .2290D+00,
     +   .3657D+00, -.5672D-01,  .1750D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=9,16)/
     +   .3498D+00, -.8471D-01, -.5057D-02, -.5059D-02,  .2162D+00,
     +   .3706D+00, -.5094D-01,  .1805D+00,
     +   .3384D+00, -.8050D-01, -.4401D-02, -.4403D-02,  .1936D+00,
     +   .3784D+00, -.4131D-01,  .1894D+00,
     +   .3281D+00, -.7686D-01, -.3886D-02, -.3887D-02,  .1748D+00,
     +   .3847D+00, -.3355D-01,  .1967D+00,
     +   .3192D+00, -.7380D-01, -.3488D-02, -.3490D-02,  .1597D+00,
     +   .3897D+00, -.2742D-01,  .2024D+00,
     +   .3117D+00, -.7130D-01, -.3186D-02, -.3188D-02,  .1478D+00,
     +   .3934D+00, -.2264D-01,  .2068D+00,
     +   .3029D+00, -.6846D-01, -.2865D-02, -.2867D-02,  .1349D+00,
     +   .3978D+00, -.1749D-01,  .2118D+00,
     +   .2954D+00, -.6611D-01, -.2617D-02, -.2618D-02,  .1247D+00,
     +   .4010D+00, -.1341D-01,  .2157D+00,
     +   .2884D+00, -.6394D-01, -.2402D-02, -.2403D-02,  .1157D+00,
     +   .4042D+00, -.9761D-02,  .2192D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=17,25)/
     +   .2821D+00, -.6203D-01, -.2223D-02, -.2225D-02,  .1081D+00,
     +   .4066D+00, -.6637D-02,  .2222D+00,
     +   .2743D+00, -.5971D-01, -.2020D-02, -.2021D-02,  .9935D-01,
     +   .4100D+00, -.2936D-02,  .2259D+00,
     +   .2672D+00, -.5763D-01, -.1849D-02, -.1850D-02,  .9187D-01,
     +   .4125D+00,  .3087D-03,  .2290D+00,
     +   .2603D+00, -.5566D-01, -.1695D-02, -.1697D-02,  .8510D-01,
     +   .4151D+00,  .3338D-02,  .2320D+00,
     +   .2543D+00, -.5398D-01, -.1572D-02, -.1574D-02,  .7961D-01,
     +   .4173D+00,  .5870D-02,  .2345D+00,
     +   .2483D+00, -.5229D-01, -.1455D-02, -.1456D-02,  .7435D-01,
     +   .4195D+00,  .8380D-02,  .2371D+00,
     +   .2427D+00, -.5076D-01, -.1353D-02, -.1355D-02,  .6976D-01,
     +   .4216D+00,  .1064D-01,  .2394D+00,
     +   .2372D+00, -.4928D-01, -.1260D-02, -.1261D-02,  .6551D-01,
     +   .4234D+00,  .1281D-01,  .2415D+00,
     +   .2324D+00, -.4800D-01, -.1183D-02, -.1184D-02,  .6201D-01,
     +   .4250D+00,  .1466D-01,  .2434D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=1,8)/
     +   .4322D+00, -.1124D+00, -.1035D-01, -.1035D-01,  .3673D+00,
     +   .3004D+00, -.1485D+00,  .9806D-01,
     +   .4173D+00, -.1055D+00, -.8775D-02, -.8776D-02,  .3318D+00,
     +   .3284D+00, -.1183D+00,  .1277D+00,
     +   .4064D+00, -.1009D+00, -.7813D-02, -.7814D-02,  .3062D+00,
     +   .3437D+00, -.1005D+00,  .1446D+00,
     +   .3945D+00, -.9604D-01, -.6896D-02, -.6897D-02,  .2791D+00,
     +   .3573D+00, -.8395D-01,  .1599D+00,
     +   .3809D+00, -.9085D-01, -.5996D-02, -.5997D-02,  .2499D+00,
     +   .3698D+00, -.6801D-01,  .1743D+00,
     +   .3715D+00, -.8741D-01, -.5448D-02, -.5449D-02,  .2308D+00,
     +   .3773D+00, -.5842D-01,  .1829D+00,
     +   .3644D+00, -.8491D-01, -.5070D-02, -.5072D-02,  .2172D+00,
     +   .3822D+00, -.5186D-01,  .1888D+00,
     +   .3542D+00, -.8140D-01, -.4571D-02, -.4573D-02,  .1984D+00,
     +   .3887D+00, -.4323D-01,  .1965D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=9,16)/
     +   .3470D+00, -.7896D-01, -.4243D-02, -.4244D-02,  .1857D+00,
     +   .3928D+00, -.3757D-01,  .2015D+00,
     +   .3336D+00, -.7460D-01, -.3694D-02, -.3695D-02,  .1639D+00,
     +   .4000D+00, -.2821D-01,  .2100D+00,
     +   .3216D+00, -.7085D-01, -.3263D-02, -.3264D-02,  .1461D+00,
     +   .4054D+00, -.2067D-01,  .2167D+00,
     +   .3114D+00, -.6772D-01, -.2932D-02, -.2933D-02,  .1321D+00,
     +   .4101D+00, -.1473D-01,  .2221D+00,
     +   .3028D+00, -.6519D-01, -.2680D-02, -.2682D-02,  .1213D+00,
     +   .4134D+00, -.1008D-01,  .2263D+00,
     +   .2930D+00, -.6232D-01, -.2414D-02, -.2415D-02,  .1098D+00,
     +   .4172D+00, -.5064D-02,  .2309D+00,
     +   .2846D+00, -.5996D-01, -.2207D-02, -.2209D-02,  .1007D+00,
     +   .4202D+00, -.1085D-02,  .2345D+00,
     +   .2769D+00, -.5779D-01, -.2029D-02, -.2030D-02,  .9283D-01,
     +   .4231D+00,  .2475D-02,  .2379D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=17,25)/
     +   .2700D+00, -.5589D-01, -.1881D-02, -.1882D-02,  .8627D-01,
     +   .4254D+00,  .5532D-02,  .2407D+00,
     +   .2615D+00, -.5360D-01, -.1712D-02, -.1714D-02,  .7874D-01,
     +   .4283D+00,  .9163D-02,  .2442D+00,
     +   .2538D+00, -.5156D-01, -.1570D-02, -.1571D-02,  .7240D-01,
     +   .4309D+00,  .1235D-01,  .2472D+00,
     +   .2463D+00, -.4962D-01, -.1443D-02, -.1444D-02,  .6671D-01,
     +   .4333D+00,  .1534D-01,  .2501D+00,
     +   .2400D+00, -.4799D-01, -.1341D-02, -.1342D-02,  .6214D-01,
     +   .4351D+00,  .1784D-01,  .2525D+00,
     +   .2335D+00, -.4635D-01, -.1243D-02, -.1245D-02,  .5778D-01,
     +   .4372D+00,  .2033D-01,  .2549D+00,
     +   .2276D+00, -.4486D-01, -.1159D-02, -.1160D-02,  .5401D-01,
     +   .4387D+00,  .2258D-01,  .2569D+00,
     +   .2218D+00, -.4344D-01, -.1081D-02, -.1082D-02,  .5054D-01,
     +   .4409D+00,  .2473D-01,  .2592D+00,
     +   .2168D+00, -.4221D-01, -.1017D-02, -.1018D-02,  .4769D-01,
     +   .4422D+00,  .2658D-01,  .2609D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=1,8)/
     +   .4423D+00, -.1077D+00, -.8607D-02, -.8607D-02,  .3478D+00,
     +   .3332D+00, -.1312D+00,  .1269D+00,
     +   .4233D+00, -.1003D+00, -.7292D-02, -.7292D-02,  .3060D+00,
     +   .3572D+00, -.1014D+00,  .1542D+00,
     +   .4098D+00, -.9540D-01, -.6488D-02, -.6489D-02,  .2777D+00,
     +   .3705D+00, -.8399D-01,  .1697D+00,
     +   .3952D+00, -.9032D-01, -.5723D-02, -.5723D-02,  .2488D+00,
     +   .3821D+00, -.6786D-01,  .1837D+00,
     +   .3790D+00, -.8490D-01, -.4972D-02, -.4973D-02,  .2188D+00,
     +   .3930D+00, -.5244D-01,  .1969D+00,
     +   .3680D+00, -.8135D-01, -.4515D-02, -.4516D-02,  .1998D+00,
     +   .3995D+00, -.4322D-01,  .2049D+00,
     +   .3598D+00, -.7878D-01, -.4201D-02, -.4202D-02,  .1864D+00,
     +   .4038D+00, -.3691D-01,  .2103D+00,
     +   .3481D+00, -.7519D-01, -.3786D-02, -.3787D-02,  .1684D+00,
     +   .4095D+00, -.2856D-01,  .2174D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=9,16)/
     +   .3398D+00, -.7270D-01, -.3514D-02, -.3515D-02,  .1565D+00,
     +   .4133D+00, -.2314D-01,  .2220D+00,
     +   .3246D+00, -.6830D-01, -.3059D-02, -.3060D-02,  .1362D+00,
     +   .4194D+00, -.1412D-01,  .2297D+00,
     +   .3113D+00, -.6453D-01, -.2703D-02, -.2704D-02,  .1200D+00,
     +   .4244D+00, -.6857D-02,  .2360D+00,
     +   .3000D+00, -.6142D-01, -.2430D-02, -.2431D-02,  .1076D+00,
     +   .4282D+00, -.1114D-02,  .2410D+00,
     +   .2906D+00, -.5890D-01, -.2222D-02, -.2223D-02,  .9805D-01,
     +   .4315D+00,  .3378D-02,  .2450D+00,
     +   .2799D+00, -.5608D-01, -.2002D-02, -.2003D-02,  .8800D-01,
     +   .4349D+00,  .8247D-02,  .2492D+00,
     +   .2709D+00, -.5376D-01, -.1832D-02, -.1833D-02,  .8022D-01,
     +   .4376D+00,  .1212D-01,  .2527D+00,
     +   .2626D+00, -.5165D-01, -.1685D-02, -.1686D-02,  .7353D-01,
     +   .4402D+00,  .1559D-01,  .2558D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=17,25)/
     +   .2552D+00, -.4980D-01, -.1563D-02, -.1564D-02,  .6799D-01,
     +   .4423D+00,  .1857D-01,  .2585D+00,
     +   .2463D+00, -.4759D-01, -.1424D-02, -.1425D-02,  .6171D-01,
     +   .4450D+00,  .2213D-01,  .2618D+00,
     +   .2381D+00, -.4562D-01, -.1307D-02, -.1308D-02,  .5645D-01,
     +   .4472D+00,  .2527D-01,  .2646D+00,
     +   .2304D+00, -.4376D-01, -.1202D-02, -.1203D-02,  .5178D-01,
     +   .4493D+00,  .2821D-01,  .2673D+00,
     +   .2237D+00, -.4220D-01, -.1118D-02, -.1119D-02,  .4805D-01,
     +   .4511D+00,  .3068D-01,  .2696D+00,
     +   .2171D+00, -.4064D-01, -.1038D-02, -.1039D-02,  .4452D-01,
     +   .4530D+00,  .3314D-01,  .2719D+00,
     +   .2110D+00, -.3923D-01, -.9677D-03, -.9687D-03,  .4148D-01,
     +   .4547D+00,  .3537D-01,  .2739D+00,
     +   .2050D+00, -.3788D-01, -.9034D-03, -.9044D-03,  .3870D-01,
     +   .4563D+00,  .3751D-01,  .2760D+00,
     +   .1999D+00, -.3673D-01, -.8504D-03, -.8514D-03,  .3643D-01,
     +   .4576D+00,  .3935D-01,  .2777D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=1,8)/
     +   .4464D+00, -.1019D+00, -.7040D-02, -.7041D-02,  .3198D+00,
     +   .3638D+00, -.1109D+00,  .1561D+00,
     +   .4237D+00, -.9422D-01, -.5967D-02, -.5967D-02,  .2748D+00,
     +   .3838D+00, -.8224D-01,  .1805D+00,
     +   .4078D+00, -.8912D-01, -.5309D-02, -.5309D-02,  .2455D+00,
     +   .3950D+00, -.6565D-01,  .1944D+00,
     +   .3909D+00, -.8391D-01, -.4680D-02, -.4681D-02,  .2166D+00,
     +   .4049D+00, -.5033D-01,  .2070D+00,
     +   .3724D+00, -.7840D-01, -.4064D-02, -.4065D-02,  .1874D+00,
     +   .4145D+00, -.3568D-01,  .2190D+00,
     +   .3600D+00, -.7482D-01, -.3689D-02, -.3690D-02,  .1693D+00,
     +   .4199D+00, -.2690D-01,  .2261D+00,
     +   .3508D+00, -.7223D-01, -.3431D-02, -.3432D-02,  .1568D+00,
     +   .4235D+00, -.2089D-01,  .2310D+00,
     +   .3378D+00, -.6864D-01, -.3091D-02, -.3092D-02,  .1402D+00,
     +   .4286D+00, -.1296D-01,  .2375D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=9,16)/
     +   .3286D+00, -.6617D-01, -.2868D-02, -.2869D-02,  .1293D+00,
     +   .4319D+00, -.7794D-02,  .2418D+00,
     +   .3121D+00, -.6181D-01, -.2496D-02, -.2497D-02,  .1112D+00,
     +   .4372D+00,  .8233D-03,  .2488D+00,
     +   .2977D+00, -.5812D-01, -.2205D-02, -.2206D-02,  .9701D-01,
     +   .4416D+00,  .7779D-02,  .2546D+00,
     +   .2855D+00, -.5508D-01, -.1981D-02, -.1982D-02,  .8621D-01,
     +   .4451D+00,  .1330D-01,  .2592D+00,
     +   .2756D+00, -.5264D-01, -.1812D-02, -.1813D-02,  .7809D-01,
     +   .4481D+00,  .1763D-01,  .2629D+00,
     +   .2643D+00, -.4991D-01, -.1632D-02, -.1633D-02,  .6958D-01,
     +   .4511D+00,  .2234D-01,  .2669D+00,
     +   .2549D+00, -.4768D-01, -.1493D-02, -.1494D-02,  .6308D-01,
     +   .4535D+00,  .2609D-01,  .2701D+00,
     +   .2462D+00, -.4565D-01, -.1374D-02, -.1374D-02,  .5752D-01,
     +   .4556D+00,  .2947D-01,  .2730D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=17,25)/
     +   .2386D+00, -.4390D-01, -.1274D-02, -.1275D-02,  .5297D-01,
     +   .4578D+00,  .3239D-01,  .2756D+00,
     +   .2293D+00, -.4179D-01, -.1161D-02, -.1162D-02,  .4784D-01,
     +   .4598D+00,  .3586D-01,  .2785D+00,
     +   .2210D+00, -.3993D-01, -.1065D-02, -.1066D-02,  .4358D-01,
     +   .4621D+00,  .3894D-01,  .2813D+00,
     +   .2130D+00, -.3818D-01, -.9795D-03, -.9804D-03,  .3982D-01,
     +   .4641D+00,  .4184D-01,  .2839D+00,
     +   .2063D+00, -.3672D-01, -.9107D-03, -.9116D-03,  .3683D-01,
     +   .4658D+00,  .4427D-01,  .2860D+00,
     +   .1996D+00, -.3526D-01, -.8451D-03, -.8460D-03,  .3403D-01,
     +   .4675D+00,  .4670D-01,  .2882D+00,
     +   .1934D+00, -.3395D-01, -.7881D-03, -.7890D-03,  .3162D-01,
     +   .4690D+00,  .4891D-01,  .2901D+00,
     +   .1875D+00, -.3270D-01, -.7356D-03, -.7365D-03,  .2943D-01,
     +   .4705D+00,  .5103D-01,  .2920D+00,
     +   .1824D+00, -.3163D-01, -.6924D-03, -.6932D-03,  .2765D-01,
     +   .4717D+00,  .5285D-01,  .2937D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=1,8)/
     +   .4449D+00, -.9523D-01, -.5665D-02, -.5665D-02,  .2862D+00,
     +   .3918D+00, -.8824D-01,  .1847D+00,
     +   .4188D+00, -.8742D-01, -.4806D-02, -.4806D-02,  .2406D+00,
     +   .4082D+00, -.6156D-01,  .2061D+00,
     +   .4008D+00, -.8228D-01, -.4276D-02, -.4277D-02,  .2120D+00,
     +   .4174D+00, -.4604D-01,  .2183D+00,
     +   .3820D+00, -.7705D-01, -.3769D-02, -.3770D-02,  .1843D+00,
     +   .4259D+00, -.3171D-01,  .2295D+00,
     +   .3615D+00, -.7157D-01, -.3271D-02, -.3272D-02,  .1571D+00,
     +   .4336D+00, -.1799D-01,  .2401D+00,
     +   .3479D+00, -.6802D-01, -.2968D-02, -.2969D-02,  .1406D+00,
     +   .4384D+00, -.9745D-02,  .2465D+00,
     +   .3379D+00, -.6548D-01, -.2759D-02, -.2760D-02,  .1293D+00,
     +   .4417D+00, -.4085D-02,  .2510D+00,
     +   .3239D+00, -.6196D-01, -.2484D-02, -.2485D-02,  .1145D+00,
     +   .4460D+00,  .3406D-02,  .2569D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=9,16)/
     +   .3141D+00, -.5955D-01, -.2304D-02, -.2305D-02,  .1050D+00,
     +   .4488D+00,  .8292D-02,  .2607D+00,
     +   .2966D+00, -.5532D-01, -.2003D-02, -.2004D-02,  .8923D-01,
     +   .4534D+00,  .1647D-01,  .2671D+00,
     +   .2814D+00, -.5176D-01, -.1768D-02, -.1769D-02,  .7716D-01,
     +   .4574D+00,  .2311D-01,  .2725D+00,
     +   .2687D+00, -.4885D-01, -.1588D-02, -.1589D-02,  .6808D-01,
     +   .4604D+00,  .2840D-01,  .2767D+00,
     +   .2584D+00, -.4652D-01, -.1451D-02, -.1452D-02,  .6131D-01,
     +   .4629D+00,  .3257D-01,  .2801D+00,
     +   .2467D+00, -.4393D-01, -.1306D-02, -.1307D-02,  .5430D-01,
     +   .4659D+00,  .3711D-01,  .2839D+00,
     +   .2371D+00, -.4183D-01, -.1194D-02, -.1195D-02,  .4898D-01,
     +   .4680D+00,  .4075D-01,  .2868D+00,
     +   .2282D+00, -.3992D-01, -.1097D-02, -.1098D-02,  .4448D-01,
     +   .4699D+00,  .4402D-01,  .2895D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=17,25)/
     +   .2205D+00, -.3828D-01, -.1017D-02, -.1018D-02,  .4081D-01,
     +   .4717D+00,  .4686D-01,  .2919D+00,
     +   .2111D+00, -.3631D-01, -.9259D-03, -.9267D-03,  .3670D-01,
     +   .4739D+00,  .5026D-01,  .2948D+00,
     +   .2028D+00, -.3458D-01, -.8489D-03, -.8498D-03,  .3331D-01,
     +   .4758D+00,  .5327D-01,  .2973D+00,
     +   .1949D+00, -.3296D-01, -.7800D-03, -.7809D-03,  .3034D-01,
     +   .4776D+00,  .5612D-01,  .2997D+00,
     +   .1882D+00, -.3161D-01, -.7247D-03, -.7255D-03,  .2800D-01,
     +   .4791D+00,  .5851D-01,  .3017D+00,
     +   .1815D+00, -.3027D-01, -.6719D-03, -.6727D-03,  .2580D-01,
     +   .4807D+00,  .6091D-01,  .3038D+00,
     +   .1754D+00, -.2907D-01, -.6261D-03, -.6268D-03,  .2392D-01,
     +   .4821D+00,  .6308D-01,  .3057D+00,
     +   .1695D+00, -.2793D-01, -.5838D-03, -.5846D-03,  .2222D-01,
     +   .4835D+00,  .6518D-01,  .3075D+00,
     +   .1645D+00, -.2695D-01, -.5491D-03, -.5498D-03,  .2084D-01,
     +   .4846D+00,  .6699D-01,  .3090D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=1,8)/
     +   .4380D+00, -.8797D-01, -.4481D-02, -.4482D-02,  .2496D+00,
     +   .4169D+00, -.6431D-01,  .2123D+00,
     +   .4090D+00, -.8018D-01, -.3808D-02, -.3808D-02,  .2056D+00,
     +   .4303D+00, -.3983D-01,  .2306D+00,
     +   .3893D+00, -.7509D-01, -.3389D-02, -.3390D-02,  .1788D+00,
     +   .4377D+00, -.2556D-01,  .2412D+00,
     +   .3688D+00, -.6995D-01, -.2987D-02, -.2987D-02,  .1534D+00,
     +   .4447D+00, -.1234D-01,  .2510D+00,
     +   .3469D+00, -.6459D-01, -.2590D-02, -.2591D-02,  .1290D+00,
     +   .4514D+00,  .3744D-03,  .2604D+00,
     +   .3324D+00, -.6115D-01, -.2348D-02, -.2349D-02,  .1144D+00,
     +   .4554D+00,  .8053D-02,  .2661D+00,
     +   .3218D+00, -.5869D-01, -.2182D-02, -.2183D-02,  .1046D+00,
     +   .4579D+00,  .1334D-01,  .2700D+00,
     +   .3071D+00, -.5531D-01, -.1962D-02, -.1963D-02,  .9184D-01,
     +   .4616D+00,  .2037D-01,  .2752D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=9,16)/
     +   .2969D+00, -.5300D-01, -.1819D-02, -.1819D-02,  .8368D-01,
     +   .4641D+00,  .2497D-01,  .2787D+00,
     +   .2786D+00, -.4897D-01, -.1579D-02, -.1580D-02,  .7045D-01,
     +   .4683D+00,  .3271D-01,  .2847D+00,
     +   .2630D+00, -.4560D-01, -.1392D-02, -.1393D-02,  .6043D-01,
     +   .4715D+00,  .3902D-01,  .2894D+00,
     +   .2501D+00, -.4286D-01, -.1248D-02, -.1249D-02,  .5298D-01,
     +   .4743D+00,  .4407D-01,  .2934D+00,
     +   .2396D+00, -.4067D-01, -.1139D-02, -.1140D-02,  .4748D-01,
     +   .4768D+00,  .4807D-01,  .2966D+00,
     +   .2278D+00, -.3826D-01, -.1024D-02, -.1025D-02,  .4183D-01,
     +   .4792D+00,  .5245D-01,  .3000D+00,
     +   .2181D+00, -.3630D-01, -.9354D-03, -.9362D-03,  .3758D-01,
     +   .4813D+00,  .5596D-01,  .3028D+00,
     +   .2093D+00, -.3454D-01, -.8586D-03, -.8595D-03,  .3400D-01,
     +   .4831D+00,  .5913D-01,  .3053D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=17,25)/
     +   .2016D+00, -.3302D-01, -.7950D-03, -.7959D-03,  .3110D-01,
     +   .4847D+00,  .6190D-01,  .3076D+00,
     +   .1923D+00, -.3121D-01, -.7225D-03, -.7233D-03,  .2787D-01,
     +   .4866D+00,  .6521D-01,  .3102D+00,
     +   .1841D+00, -.2963D-01, -.6615D-03, -.6623D-03,  .2523D-01,
     +   .4884D+00,  .6816D-01,  .3126D+00,
     +   .1763D+00, -.2816D-01, -.6069D-03, -.6077D-03,  .2292D-01,
     +   .4900D+00,  .7094D-01,  .3149D+00,
     +   .1698D+00, -.2693D-01, -.5631D-03, -.5638D-03,  .2111D-01,
     +   .4915D+00,  .7330D-01,  .3168D+00,
     +   .1632D+00, -.2572D-01, -.5213D-03, -.5221D-03,  .1941D-01,
     +   .4928D+00,  .7566D-01,  .3188D+00,
     +   .1574D+00, -.2463D-01, -.4851D-03, -.4858D-03,  .1797D-01,
     +   .4941D+00,  .7780D-01,  .3205D+00,
     +   .1517D+00, -.2360D-01, -.4518D-03, -.4525D-03,  .1667D-01,
     +   .4954D+00,  .7987D-01,  .3222D+00,
     +   .1469D+00, -.2273D-01, -.4244D-03, -.4250D-03,  .1561D-01,
     +   .4965D+00,  .8167D-01,  .3237D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=1,8)/
     +   .4261D+00, -.8033D-01, -.3484D-02, -.3484D-02,  .2122D+00,
     +   .4396D+00, -.3955D-01,  .2384D+00,
     +   .3947D+00, -.7270D-01, -.2965D-02, -.2966D-02,  .1716D+00,
     +   .4501D+00, -.1750D-01,  .2539D+00,
     +   .3737D+00, -.6775D-01, -.2640D-02, -.2641D-02,  .1474D+00,
     +   .4562D+00, -.4553D-02,  .2630D+00,
     +   .3520D+00, -.6278D-01, -.2326D-02, -.2326D-02,  .1249D+00,
     +   .4617D+00,  .7518D-02,  .2714D+00,
     +   .3290D+00, -.5764D-01, -.2015D-02, -.2016D-02,  .1037D+00,
     +   .4672D+00,  .1921D-01,  .2796D+00,
     +   .3139D+00, -.5436D-01, -.1825D-02, -.1826D-02,  .9131D-01,
     +   .4704D+00,  .2631D-01,  .2846D+00,
     +   .3030D+00, -.5202D-01, -.1695D-02, -.1696D-02,  .8299D-01,
     +   .4728D+00,  .3123D-01,  .2881D+00,
     +   .2879D+00, -.4882D-01, -.1522D-02, -.1523D-02,  .7234D-01,
     +   .4760D+00,  .3779D-01,  .2928D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=9,16)/
     +   .2774D+00, -.4664D-01, -.1409D-02, -.1410D-02,  .6558D-01,
     +   .4782D+00,  .4210D-01,  .2960D+00,
     +   .2589D+00, -.4286D-01, -.1222D-02, -.1222D-02,  .5473D-01,
     +   .4819D+00,  .4940D-01,  .3014D+00,
     +   .2431D+00, -.3972D-01, -.1075D-02, -.1076D-02,  .4662D-01,
     +   .4850D+00,  .5539D-01,  .3058D+00,
     +   .2302D+00, -.3718D-01, -.9623D-03, -.9631D-03,  .4065D-01,
     +   .4874D+00,  .6022D-01,  .3094D+00,
     +   .2197D+00, -.3517D-01, -.8769D-03, -.8777D-03,  .3628D-01,
     +   .4894D+00,  .6405D-01,  .3123D+00,
     +   .2080D+00, -.3295D-01, -.7869D-03, -.7876D-03,  .3182D-01,
     +   .4917D+00,  .6825D-01,  .3155D+00,
     +   .1985D+00, -.3116D-01, -.7173D-03, -.7180D-03,  .2849D-01,
     +   .4935D+00,  .7164D-01,  .3181D+00,
     +   .1898D+00, -.2955D-01, -.6573D-03, -.6581D-03,  .2570D-01,
     +   .4951D+00,  .7472D-01,  .3205D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=17,25)/
     +   .1823D+00, -.2817D-01, -.6077D-03, -.6084D-03,  .2346D-01,
     +   .4966D+00,  .7740D-01,  .3225D+00,
     +   .1733D+00, -.2654D-01, -.5511D-03, -.5519D-03,  .2097D-01,
     +   .4984D+00,  .8064D-01,  .3251D+00,
     +   .1653D+00, -.2511D-01, -.5036D-03, -.5043D-03,  .1894D-01,
     +   .5000D+00,  .8349D-01,  .3273D+00,
     +   .1578D+00, -.2379D-01, -.4612D-03, -.4619D-03,  .1717D-01,
     +   .5015D+00,  .8623D-01,  .3294D+00,
     +   .1515D+00, -.2269D-01, -.4271D-03, -.4278D-03,  .1578D-01,
     +   .5028D+00,  .8854D-01,  .3313D+00,
     +   .1453D+00, -.2161D-01, -.3947D-03, -.3954D-03,  .1450D-01,
     +   .5041D+00,  .9084D-01,  .3331D+00,
     +   .1397D+00, -.2065D-01, -.3666D-03, -.3673D-03,  .1340D-01,
     +   .5052D+00,  .9296D-01,  .3347D+00,
     +   .1343D+00, -.1973D-01, -.3408D-03, -.3414D-03,  .1241D-01,
     +   .5064D+00,  .9501D-01,  .3364D+00,
     +   .1297D+00, -.1896D-01, -.3196D-03, -.3202D-03,  .1162D-01,
     +   .5074D+00,  .9674D-01,  .3377D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=1,8)/
     +   .3893D+00, -.6467D-01, -.1991D-02, -.1991D-02,  .1423D+00,
     +   .4773D+00,  .1034D-01,  .2853D+00,
     +   .3551D+00, -.5771D-01, -.1701D-02, -.1701D-02,  .1114D+00,
     +   .4834D+00,  .2765D-01,  .2960D+00,
     +   .3326D+00, -.5326D-01, -.1515D-02, -.1515D-02,  .9367D-01,
     +   .4873D+00,  .3803D-01,  .3025D+00,
     +   .3098D+00, -.4884D-01, -.1333D-02, -.1333D-02,  .7775D-01,
     +   .4913D+00,  .4789D-01,  .3089D+00,
     +   .2860D+00, -.4433D-01, -.1151D-02, -.1152D-02,  .6319D-01,
     +   .4948D+00,  .5762D-01,  .3151D+00,
     +   .2706D+00, -.4148D-01, -.1040D-02, -.1041D-02,  .5488D-01,
     +   .4973D+00,  .6364D-01,  .3190D+00,
     +   .2596D+00, -.3947D-01, -.9638D-03, -.9644D-03,  .4943D-01,
     +   .4992D+00,  .6785D-01,  .3219D+00,
     +   .2445D+00, -.3674D-01, -.8627D-03, -.8634D-03,  .4256D-01,
     +   .5015D+00,  .7354D-01,  .3256D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=9,16)/
     +   .2341D+00, -.3490D-01, -.7966D-03, -.7973D-03,  .3827D-01,
     +   .5031D+00,  .7732D-01,  .3282D+00,
     +   .2160D+00, -.3173D-01, -.6870D-03, -.6877D-03,  .3151D-01,
     +   .5059D+00,  .8378D-01,  .3326D+00,
     +   .2008D+00, -.2912D-01, -.6014D-03, -.6021D-03,  .2656D-01,
     +   .5083D+00,  .8918D-01,  .3363D+00,
     +   .1884D+00, -.2704D-01, -.5359D-03, -.5366D-03,  .2298D-01,
     +   .5103D+00,  .9356D-01,  .3394D+00,
     +   .1786D+00, -.2540D-01, -.4863D-03, -.4870D-03,  .2038D-01,
     +   .5120D+00,  .9705D-01,  .3418D+00,
     +   .1677D+00, -.2361D-01, -.4342D-03, -.4348D-03,  .1777D-01,
     +   .5137D+00,  .1010D+00,  .3446D+00,
     +   .1589D+00, -.2218D-01, -.3940D-03, -.3946D-03,  .1584D-01,
     +   .5152D+00,  .1041D+00,  .3468D+00,
     +   .1509D+00, -.2090D-01, -.3595D-03, -.3601D-03,  .1423D-01,
     +   .5166D+00,  .1070D+00,  .3489D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=17,25)/
     +   .1441D+00, -.1982D-01, -.3310D-03, -.3316D-03,  .1295D-01,
     +   .5179D+00,  .1095D+00,  .3507D+00,
     +   .1360D+00, -.1854D-01, -.2986D-03, -.2992D-03,  .1153D-01,
     +   .5193D+00,  .1126D+00,  .3529D+00,
     +   .1288D+00, -.1743D-01, -.2715D-03, -.2721D-03,  .1039D-01,
     +   .5207D+00,  .1153D+00,  .3549D+00,
     +   .1222D+00, -.1641D-01, -.2474D-03, -.2479D-03,  .9394D-02,
     +   .5220D+00,  .1179D+00,  .3568D+00,
     +   .1167D+00, -.1557D-01, -.2281D-03, -.2286D-03,  .8620D-02,
     +   .5231D+00,  .1201D+00,  .3584D+00,
     +   .1112D+00, -.1474D-01, -.2098D-03, -.2103D-03,  .7901D-02,
     +   .5241D+00,  .1223D+00,  .3599D+00,
     +   .1064D+00, -.1401D-01, -.1940D-03, -.1945D-03,  .7292D-02,
     +   .5251D+00,  .1243D+00,  .3614D+00,
     +   .1017D+00, -.1333D-01, -.1795D-03, -.1800D-03,  .6745D-02,
     +   .5261D+00,  .1262D+00,  .3628D+00,
     +   .9784D-01, -.1275D-01, -.1676D-03, -.1681D-03,  .6303D-02,
     +   .5269D+00,  .1280D+00,  .3641D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=1,8)/
     +   .3391D+00, -.4959D-01, -.1048D-02, -.1048D-02,  .8625D-01,
     +   .5065D+00,  .5883D-01,  .3253D+00,
     +   .3047D+00, -.4363D-01, -.8980D-03, -.8984D-03,  .6571D-01,
     +   .5104D+00,  .7211D-01,  .3327D+00,
     +   .2824D+00, -.3987D-01, -.7992D-03, -.7996D-03,  .5433D-01,
     +   .5129D+00,  .8031D-01,  .3374D+00,
     +   .2601D+00, -.3618D-01, -.7015D-03, -.7020D-03,  .4437D-01,
     +   .5154D+00,  .8830D-01,  .3421D+00,
     +   .2371D+00, -.3247D-01, -.6035D-03, -.6041D-03,  .3550D-01,
     +   .5179D+00,  .9637D-01,  .3468D+00,
     +   .2225D+00, -.3014D-01, -.5433D-03, -.5439D-03,  .3055D-01,
     +   .5199D+00,  .1014D+00,  .3500D+00,
     +   .2122D+00, -.2851D-01, -.5018D-03, -.5024D-03,  .2734D-01,
     +   .5212D+00,  .1051D+00,  .3522D+00,
     +   .1980D+00, -.2632D-01, -.4470D-03, -.4476D-03,  .2335D-01,
     +   .5230D+00,  .1100D+00,  .3553D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=9,16)/
     +   .1884D+00, -.2485D-01, -.4114D-03, -.4119D-03,  .2089D-01,
     +   .5243D+00,  .1133D+00,  .3574D+00,
     +   .1719D+00, -.2235D-01, -.3524D-03, -.3530D-03,  .1706D-01,
     +   .5265D+00,  .1190D+00,  .3611D+00,
     +   .1582D+00, -.2032D-01, -.3064D-03, -.3070D-03,  .1430D-01,
     +   .5284D+00,  .1239D+00,  .3642D+00,
     +   .1472D+00, -.1871D-01, -.2714D-03, -.2720D-03,  .1232D-01,
     +   .5301D+00,  .1279D+00,  .3668D+00,
     +   .1385D+00, -.1746D-01, -.2450D-03, -.2455D-03,  .1090D-01,
     +   .5313D+00,  .1311D+00,  .3689D+00,
     +   .1289D+00, -.1610D-01, -.2173D-03, -.2178D-03,  .9478D-02,
     +   .5329D+00,  .1347D+00,  .3713D+00,
     +   .1213D+00, -.1502D-01, -.1960D-03, -.1966D-03,  .8430D-02,
     +   .5341D+00,  .1376D+00,  .3732D+00,
     +   .1145D+00, -.1407D-01, -.1779D-03, -.1784D-03,  .7564D-02,
     +   .5352D+00,  .1403D+00,  .3750D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=17,25)/
     +   .1086D+00, -.1326D-01, -.1629D-03, -.1634D-03,  .6873D-02,
     +   .5363D+00,  .1427D+00,  .3766D+00,
     +   .1017D+00, -.1232D-01, -.1460D-03, -.1465D-03,  .6113D-02,
     +   .5375D+00,  .1455D+00,  .3785D+00,
     +   .9576D-01, -.1151D-01, -.1319D-03, -.1324D-03,  .5499D-02,
     +   .5386D+00,  .1481D+00,  .3802D+00,
     +   .9023D-01, -.1076D-01, -.1194D-03, -.1199D-03,  .4968D-02,
     +   .5397D+00,  .1505D+00,  .3818D+00,
     +   .8566D-01, -.1016D-01, -.1095D-03, -.1099D-03,  .4554D-02,
     +   .5406D+00,  .1526D+00,  .3833D+00,
     +   .8120D-01, -.9566D-02, -.1001D-03, -.1005D-03,  .4169D-02,
     +   .5415D+00,  .1547D+00,  .3846D+00,
     +   .7722D-01, -.9046D-02, -.9208D-04, -.9247D-04,  .3844D-02,
     +   .5423D+00,  .1566D+00,  .3860D+00,
     +   .7348D-01, -.8558D-02, -.8473D-04, -.8510D-04,  .3552D-02,
     +   .5433D+00,  .1585D+00,  .3873D+00,
     +   .7033D-01, -.8151D-02, -.7874D-04, -.7911D-04,  .3316D-02,
     +   .5439D+00,  .1601D+00,  .3883D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=1,8)/
     +   .2810D+00, -.3604D-01, -.5016D-03, -.5017D-03,  .4693D-01,
     +   .5302D+00,  .1050D+00,  .3596D+00,
     +   .2485D+00, -.3125D-01, -.4306D-03, -.4309D-03,  .3506D-01,
     +   .5326D+00,  .1153D+00,  .3648D+00,
     +   .2279D+00, -.2827D-01, -.3826D-03, -.3829D-03,  .2866D-01,
     +   .5340D+00,  .1218D+00,  .3682D+00,
     +   .2075D+00, -.2539D-01, -.3345D-03, -.3350D-03,  .2318D-01,
     +   .5358D+00,  .1283D+00,  .3717D+00,
     +   .1868D+00, -.2251D-01, -.2861D-03, -.2866D-03,  .1838D-01,
     +   .5377D+00,  .1351D+00,  .3755D+00,
     +   .1739D+00, -.2073D-01, -.2564D-03, -.2569D-03,  .1575D-01,
     +   .5391D+00,  .1394D+00,  .3780D+00,
     +   .1647D+00, -.1950D-01, -.2359D-03, -.2364D-03,  .1405D-01,
     +   .5401D+00,  .1425D+00,  .3798D+00,
     +   .1523D+00, -.1784D-01, -.2089D-03, -.2093D-03,  .1197D-01,
     +   .5416D+00,  .1468D+00,  .3823D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=9,16)/
     +   .1441D+00, -.1675D-01, -.1914D-03, -.1918D-03,  .1069D-01,
     +   .5425D+00,  .1498D+00,  .3841D+00,
     +   .1299D+00, -.1489D-01, -.1626D-03, -.1631D-03,  .8713D-02,
     +   .5444D+00,  .1549D+00,  .3872D+00,
     +   .1183D+00, -.1341D-01, -.1403D-03, -.1407D-03,  .7295D-02,
     +   .5460D+00,  .1593D+00,  .3899D+00,
     +   .1091D+00, -.1224D-01, -.1233D-03, -.1238D-03,  .6284D-02,
     +   .5473D+00,  .1629D+00,  .3921D+00,
     +   .1019D+00, -.1134D-01, -.1106D-03, -.1110D-03,  .5559D-02,
     +   .5485D+00,  .1659D+00,  .3939D+00,
     +   .9404D-01, -.1037D-01, -.9734D-04, -.9776D-04,  .4832D-02,
     +   .5496D+00,  .1693D+00,  .3960D+00,
     +   .8782D-01, -.9610D-02, -.8724D-04, -.8764D-04,  .4298D-02,
     +   .5507D+00,  .1719D+00,  .3977D+00,
     +   .8232D-01, -.8942D-02, -.7864D-04, -.7902D-04,  .3856D-02,
     +   .5517D+00,  .1745D+00,  .3992D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=17,25)/
     +   .7764D-01, -.8380D-02, -.7159D-04, -.7196D-04,  .3503D-02,
     +   .5525D+00,  .1766D+00,  .4005D+00,
     +   .7218D-01, -.7728D-02, -.6365D-04, -.6401D-04,  .3114D-02,
     +   .5537D+00,  .1793D+00,  .4023D+00,
     +   .6746D-01, -.7171D-02, -.5708D-04, -.5742D-04,  .2800D-02,
     +   .5546D+00,  .1818D+00,  .4038D+00,
     +   .6314D-01, -.6665D-02, -.5130D-04, -.5162D-04,  .2527D-02,
     +   .5555D+00,  .1840D+00,  .4052D+00,
     +   .5960D-01, -.6254D-02, -.4672D-04, -.4703D-04,  .2315D-02,
     +   .5562D+00,  .1860D+00,  .4065D+00,
     +   .5616D-01, -.5857D-02, -.4242D-04, -.4272D-04,  .2117D-02,
     +   .5570D+00,  .1880D+00,  .4077D+00,
     +   .5312D-01, -.5508D-02, -.3875D-04, -.3903D-04,  .1950D-02,
     +   .5578D+00,  .1898D+00,  .4088D+00,
     +   .5026D-01, -.5184D-02, -.3542D-04, -.3569D-04,  .1799D-02,
     +   .5583D+00,  .1915D+00,  .4098D+00,
     +   .4788D-01, -.4915D-02, -.3272D-04, -.3299D-04,  .1677D-02,
     +   .5589D+00,  .1931D+00,  .4108D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=1,8)/
     +   .2200D+00, -.2462D-01, -.2143D-03, -.2144D-03,  .2266D-01,
     +   .5494D+00,  .1492D+00,  .3893D+00,
     +   .1916D+00, -.2103D-01, -.1840D-03, -.1843D-03,  .1679D-01,
     +   .5508D+00,  .1573D+00,  .3931D+00,
     +   .1737D+00, -.1883D-01, -.1630D-03, -.1633D-03,  .1368D-01,
     +   .5519D+00,  .1626D+00,  .3958D+00,
     +   .1563D+00, -.1672D-01, -.1419D-03, -.1422D-03,  .1105D-01,
     +   .5533D+00,  .1681D+00,  .3986D+00,
     +   .1389D+00, -.1464D-01, -.1204D-03, -.1208D-03,  .8770D-02,
     +   .5548D+00,  .1738D+00,  .4016D+00,
     +   .1281D+00, -.1338D-01, -.1073D-03, -.1077D-03,  .7523D-02,
     +   .5559D+00,  .1776D+00,  .4037D+00,
     +   .1206D+00, -.1250D-01, -.9823D-04, -.9861D-04,  .6724D-02,
     +   .5567D+00,  .1804D+00,  .4052D+00,
     +   .1105D+00, -.1134D-01, -.8634D-04, -.8672D-04,  .5741D-02,
     +   .5579D+00,  .1842D+00,  .4073D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=9,16)/
     +   .1038D+00, -.1058D-01, -.7871D-04, -.7908D-04,  .5137D-02,
     +   .5587D+00,  .1868D+00,  .4088D+00,
     +   .9246D-01, -.9297D-02, -.6627D-04, -.6663D-04,  .4201D-02,
     +   .5602D+00,  .1915D+00,  .4115D+00,
     +   .8331D-01, -.8283D-02, -.5666D-04, -.5700D-04,  .3528D-02,
     +   .5616D+00,  .1955D+00,  .4137D+00,
     +   .7611D-01, -.7496D-02, -.4939D-04, -.4972D-04,  .3045D-02,
     +   .5627D+00,  .1988D+00,  .4157D+00,
     +   .7054D-01, -.6892D-02, -.4396D-04, -.4428D-04,  .2698D-02,
     +   .5636D+00,  .2015D+00,  .4172D+00,
     +   .6455D-01, -.6250D-02, -.3834D-04, -.3865D-04,  .2349D-02,
     +   .5647D+00,  .2045D+00,  .4189D+00,
     +   .5982D-01, -.5749D-02, -.3410D-04, -.3439D-04,  .2090D-02,
     +   .5655D+00,  .2071D+00,  .4204D+00,
     +   .5568D-01, -.5313D-02, -.3050D-04, -.3078D-04,  .1875D-02,
     +   .5663D+00,  .2095D+00,  .4218D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=17,25)/
     +   .5218D-01, -.4948D-02, -.2757D-04, -.2784D-04,  .1703D-02,
     +   .5670D+00,  .2115D+00,  .4230D+00,
     +   .4813D-01, -.4529D-02, -.2429D-04, -.2454D-04,  .1513D-02,
     +   .5680D+00,  .2140D+00,  .4245D+00,
     +   .4466D-01, -.4173D-02, -.2159D-04, -.2183D-04,  .1359D-02,
     +   .5687D+00,  .2162D+00,  .4258D+00,
     +   .4151D-01, -.3853D-02, -.1923D-04, -.1946D-04,  .1225D-02,
     +   .5695D+00,  .2184D+00,  .4270D+00,
     +   .3894D-01, -.3594D-02, -.1738D-04, -.1760D-04,  .1120D-02,
     +   .5702D+00,  .2202D+00,  .4281D+00,
     +   .3647D-01, -.3345D-02, -.1565D-04, -.1585D-04,  .1023D-02,
     +   .5706D+00,  .2221D+00,  .4291D+00,
     +   .3429D-01, -.3129D-02, -.1418D-04, -.1438D-04,  .9401D-03,
     +   .5715D+00,  .2238D+00,  .4302D+00,
     +   .3227D-01, -.2928D-02, -.1286D-04, -.1304D-04,  .8654D-03,
     +   .5719D+00,  .2254D+00,  .4311D+00,
     +   .3058D-01, -.2763D-02, -.1179D-04, -.1197D-04,  .8052D-03,
     +   .5725D+00,  .2269D+00,  .4320D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=1,8)/
     +   .1614D+00, -.1562D-01, -.7956D-04, -.7967D-04,  .9556D-02,
     +   .5655D+00,  .1922D+00,  .4158D+00,
     +   .1381D+00, -.1313D-01, -.6829D-04, -.6848D-04,  .7152D-02,
     +   .5667D+00,  .1989D+00,  .4189D+00,
     +   .1238D+00, -.1163D-01, -.6027D-04, -.6050D-04,  .5881D-02,
     +   .5676D+00,  .2034D+00,  .4210D+00,
     +   .1100D+00, -.1020D-01, -.5210D-04, -.5236D-04,  .4801D-02,
     +   .5687D+00,  .2081D+00,  .4233D+00,
     +   .9646D-01, -.8819D-02, -.4385D-04, -.4412D-04,  .3858D-02,
     +   .5700D+00,  .2132D+00,  .4259D+00,
     +   .8815D-01, -.7983D-02, -.3878D-04, -.3906D-04,  .3337D-02,
     +   .5708D+00,  .2166D+00,  .4276D+00,
     +   .8239D-01, -.7411D-02, -.3531D-04, -.3559D-04,  .2999D-02,
     +   .5716D+00,  .2190D+00,  .4289D+00,
     +   .7476D-01, -.6659D-02, -.3076D-04, -.3104D-04,  .2579D-02,
     +   .5726D+00,  .2224D+00,  .4307D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=9,16)/
     +   .6974D-01, -.6170D-02, -.2789D-04, -.2815D-04,  .2319D-02,
     +   .5732D+00,  .2248D+00,  .4320D+00,
     +   .6131D-01, -.5357D-02, -.2325D-04, -.2352D-04,  .1909D-02,
     +   .5745D+00,  .2290D+00,  .4342D+00,
     +   .5461D-01, -.4720D-02, -.1968D-04, -.1992D-04,  .1611D-02,
     +   .5756D+00,  .2326D+00,  .4362D+00,
     +   .4941D-01, -.4231D-02, -.1700D-04, -.1723D-04,  .1394D-02,
     +   .5765D+00,  .2357D+00,  .4378D+00,
     +   .4542D-01, -.3860D-02, -.1500D-04, -.1522D-04,  .1237D-02,
     +   .5772D+00,  .2382D+00,  .4391D+00,
     +   .4117D-01, -.3469D-02, -.1294D-04, -.1315D-04,  .1077D-02,
     +   .5781D+00,  .2410D+00,  .4407D+00,
     +   .3785D-01, -.3166D-02, -.1141D-04, -.1161D-04,  .9578D-03,
     +   .5788D+00,  .2434D+00,  .4419D+00,
     +   .3496D-01, -.2904D-02, -.1012D-04, -.1030D-04,  .8585D-03,
     +   .5795D+00,  .2455D+00,  .4431D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=17,25)/
     +   .3255D-01, -.2687D-02, -.9069D-05, -.9246D-05,  .7786D-03,
     +   .5801D+00,  .2474D+00,  .4442D+00,
     +   .2977D-01, -.2440D-02, -.7901D-05, -.8065D-05,  .6902D-03,
     +   .5811D+00,  .2497D+00,  .4455D+00,
     +   .2741D-01, -.2232D-02, -.6949D-05, -.7106D-05,  .6181D-03,
     +   .5815D+00,  .2518D+00,  .4466D+00,
     +   .2529D-01, -.2045D-02, -.6124D-05, -.6272D-05,  .5555D-03,
     +   .5820D+00,  .2539D+00,  .4476D+00,
     +   .2357D-01, -.1896D-02, -.5481D-05, -.5620D-05,  .5065D-03,
     +   .5826D+00,  .2556D+00,  .4485D+00,
     +   .2193D-01, -.1754D-02, -.4882D-05, -.5014D-05,  .4609D-03,
     +   .5832D+00,  .2573D+00,  .4495D+00,
     +   .2049D-01, -.1630D-02, -.4379D-05, -.4504D-05,  .4222D-03,
     +   .5838D+00,  .2589D+00,  .4504D+00,
     +   .1917D-01, -.1517D-02, -.3929D-05, -.4046D-05,  .3874D-03,
     +   .5843D+00,  .2604D+00,  .4512D+00,
     +   .1807D-01, -.1424D-02, -.3571D-05, -.3685D-05,  .3593D-03,
     +   .5847D+00,  .2618D+00,  .4520D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=1,8)/
     +   .1091D+00, -.9028D-02, -.2469D-04, -.2477D-04,  .3447D-02,
     +   .5798D+00,  .2354D+00,  .4403D+00,
     +   .9172D-01, -.7459D-02, -.2117D-04, -.2131D-04,  .2692D-02,
     +   .5809D+00,  .2412D+00,  .4429D+00,
     +   .8117D-01, -.6523D-02, -.1861D-04, -.1876D-04,  .2275D-02,
     +   .5817D+00,  .2451D+00,  .4447D+00,
     +   .7119D-01, -.5650D-02, -.1597D-04, -.1614D-04,  .1905D-02,
     +   .5826D+00,  .2492D+00,  .4467D+00,
     +   .6148D-01, -.4815D-02, -.1331D-04, -.1349D-04,  .1568D-02,
     +   .5837D+00,  .2537D+00,  .4489D+00,
     +   .5562D-01, -.4317D-02, -.1167D-04, -.1186D-04,  .1373D-02,
     +   .5844D+00,  .2566D+00,  .4503D+00,
     +   .5160D-01, -.3978D-02, -.1056D-04, -.1074D-04,  .1245D-02,
     +   .5851D+00,  .2590D+00,  .4515D+00,
     +   .4632D-01, -.3538D-02, -.9102D-05, -.9281D-05,  .1081D-02,
     +   .5859D+00,  .2621D+00,  .4530D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=9,16)/
     +   .4288D-01, -.3254D-02, -.8209D-05, -.8380D-05,  .9763D-03,
     +   .5865D+00,  .2642D+00,  .4541D+00,
     +   .3718D-01, -.2787D-02, -.6782D-05, -.6951D-05,  .8086D-03,
     +   .5873D+00,  .2681D+00,  .4559D+00,
     +   .3271D-01, -.2427D-02, -.5679D-05, -.5832D-05,  .6838D-03,
     +   .5884D+00,  .2714D+00,  .4577D+00,
     +   .2928D-01, -.2153D-02, -.4856D-05, -.5001D-05,  .5919D-03,
     +   .5892D+00,  .2742D+00,  .4591D+00,
     +   .2668D-01, -.1947D-02, -.4243D-05, -.4378D-05,  .5244D-03,
     +   .5899D+00,  .2765D+00,  .4603D+00,
     +   .2394D-01, -.1732D-02, -.3616D-05, -.3744D-05,  .4555D-03,
     +   .5905D+00,  .2791D+00,  .4616D+00,
     +   .2182D-01, -.1568D-02, -.3156D-05, -.3278D-05,  .4037D-03,
     +   .5912D+00,  .2813D+00,  .4627D+00,
     +   .1999D-01, -.1427D-02, -.2772D-05, -.2884D-05,  .3606D-03,
     +   .5917D+00,  .2832D+00,  .4637D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=17,25)/
     +   .1847D-01, -.1311D-02, -.2459D-05, -.2566D-05,  .3258D-03,
     +   .5922D+00,  .2850D+00,  .4645D+00,
     +   .1674D-01, -.1180D-02, -.2112D-05, -.2210D-05,  .2873D-03,
     +   .5928D+00,  .2871D+00,  .4656D+00,
     +   .1529D-01, -.1070D-02, -.1829D-05, -.1924D-05,  .2560D-03,
     +   .5933D+00,  .2891D+00,  .4666D+00,
     +   .1399D-01, -.9733D-03, -.1591D-05, -.1678D-05,  .2289D-03,
     +   .5939D+00,  .2909D+00,  .4675D+00,
     +   .1295D-01, -.8960D-03, -.1405D-05, -.1487D-05,  .2077D-03,
     +   .5944D+00,  .2925D+00,  .4683D+00,
     +   .1196D-01, -.8229D-03, -.1231D-05, -.1308D-05,  .1880D-03,
     +   .5948D+00,  .2942D+00,  .4692D+00,
     +   .1110D-01, -.7600D-03, -.1087D-05, -.1160D-05,  .1714D-03,
     +   .5952D+00,  .2956D+00,  .4699D+00,
     +   .1032D-01, -.7026D-03, -.9605D-06, -.1028D-05,  .1565D-03,
     +   .5956D+00,  .2971D+00,  .4706D+00,
     +   .9671D-02, -.6558D-03, -.8609D-06, -.9266D-06,  .1446D-03,
     +   .5959D+00,  .2983D+00,  .4712D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=1,8)/
     +   .6635D-01, -.4608D-02, -.6014D-05, -.6063D-05,  .1044D-02,
     +   .5930D+00,  .2802D+00,  .4638D+00,
     +   .5466D-01, -.3734D-02, -.5158D-05, -.5242D-05,  .8956D-03,
     +   .5940D+00,  .2853D+00,  .4660D+00,
     +   .4770D-01, -.3221D-02, -.4521D-05, -.4616D-05,  .7934D-03,
     +   .5948D+00,  .2888D+00,  .4677D+00,
     +   .4121D-01, -.2750D-02, -.3852D-05, -.3959D-05,  .6896D-03,
     +   .5956D+00,  .2925D+00,  .4693D+00,
     +   .3501D-01, -.2306D-02, -.3179D-05, -.3286D-05,  .5836D-03,
     +   .5965D+00,  .2966D+00,  .4712D+00,
     +   .3132D-01, -.2045D-02, -.2766D-05, -.2875D-05,  .5178D-03,
     +   .5971D+00,  .2992D+00,  .4724D+00,
     +   .2882D-01, -.1870D-02, -.2483D-05, -.2589D-05,  .4725D-03,
     +   .5974D+00,  .3012D+00,  .4732D+00,
     +   .2556D-01, -.1644D-02, -.2114D-05, -.2216D-05,  .4126D-03,
     +   .5982D+00,  .3041D+00,  .4746D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=9,16)/
     +   .2347D-01, -.1499D-02, -.1906D-05, -.2000D-05,  .3734D-03,
     +   .5988D+00,  .3060D+00,  .4756D+00,
     +   .2003D-01, -.1265D-02, -.1567D-05, -.1660D-05,  .3090D-03,
     +   .5995D+00,  .3095D+00,  .4772D+00,
     +   .1738D-01, -.1086D-02, -.1298D-05, -.1384D-05,  .2602D-03,
     +   .6003D+00,  .3125D+00,  .4786D+00,
     +   .1538D-01, -.9529D-03, -.1102D-05, -.1181D-05,  .2241D-03,
     +   .6009D+00,  .3150D+00,  .4798D+00,
     +   .1387D-01, -.8536D-03, -.9531D-06, -.1024D-05,  .1974D-03,
     +   .6015D+00,  .3171D+00,  .4808D+00,
     +   .1230D-01, -.7509D-03, -.7962D-06, -.8684D-06,  .1701D-03,
     +   .6021D+00,  .3196D+00,  .4819D+00,
     +   .1111D-01, -.6731D-03, -.6882D-06, -.7557D-06,  .1497D-03,
     +   .6025D+00,  .3216D+00,  .4828D+00,
     +   .1008D-01, -.6072D-03, -.5983D-06, -.6593D-06,  .1328D-03,
     +   .6030D+00,  .3232D+00,  .4836D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=17,25)/
     +   .9242D-02, -.5534D-03, -.5239D-06, -.5800D-06,  .1192D-03,
     +   .6035D+00,  .3250D+00,  .4845D+00,
     +   .8292D-02, -.4930D-03, -.4383D-06, -.4874D-06,  .1042D-03,
     +   .6039D+00,  .3269D+00,  .4853D+00,
     +   .7502D-02, -.4433D-03, -.3673D-06, -.4179D-06,  .9208D-04,
     +   .6043D+00,  .3287D+00,  .4861D+00,
     +   .6803D-02, -.3995D-03, -.3128D-06, -.3573D-06,  .8169D-04,
     +   .6047D+00,  .3304D+00,  .4869D+00,
     +   .6248D-02, -.3649D-03, -.2685D-06, -.3093D-06,  .7365D-04,
     +   .6051D+00,  .3319D+00,  .4877D+00,
     +   .5724D-02, -.3325D-03, -.2250D-06, -.2648D-06,  .6623D-04,
     +   .6056D+00,  .3332D+00,  .4883D+00,
     +   .5274D-02, -.3049D-03, -.1902D-06, -.2281D-06,  .6009D-04,
     +   .6059D+00,  .3346D+00,  .4890D+00,
     +   .4865D-02, -.2798D-03, -.1607D-06, -.1945D-06,  .5457D-04,
     +   .6062D+00,  .3359D+00,  .4896D+00,
     +   .4531D-02, -.2595D-03, -.1380D-06, -.1726D-06,  .5023D-04,
     +   .6064D+00,  .3371D+00,  .4900D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=1,8)/
     +   .3478D-01, -.1972D-02, -.1006D-05, -.1034D-05,  .2638D-03,
     +   .6056D+00,  .3283D+00,  .4870D+00,
     +   .2799D-01, -.1562D-02, -.8769D-06, -.9135D-06,  .2637D-03,
     +   .6063D+00,  .3329D+00,  .4888D+00,
     +   .2403D-01, -.1326D-02, -.7739D-06, -.8214D-06,  .2471D-03,
     +   .6071D+00,  .3360D+00,  .4903D+00,
     +   .2041D-01, -.1113D-02, -.6622D-06, -.7129D-06,  .2221D-03,
     +   .6079D+00,  .3393D+00,  .4917D+00,
     +   .1701D-01, -.9164D-03, -.5500D-06, -.6000D-06,  .1913D-03,
     +   .6083D+00,  .3429D+00,  .4931D+00,
     +   .1502D-01, -.8024D-03, -.4793D-06, -.5333D-06,  .1705D-03,
     +   .6090D+00,  .3453D+00,  .4942D+00,
     +   .1369D-01, -.7267D-03, -.4265D-06, -.4790D-06,  .1554D-03,
     +   .6094D+00,  .3471D+00,  .4950D+00,
     +   .1198D-01, -.6302D-03, -.3618D-06, -.4087D-06,  .1352D-03,
     +   .6099D+00,  .3497D+00,  .4961D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=9,16)/
     +   .1089D-01, -.5693D-03, -.3341D-06, -.3771D-06,  .1217D-03,
     +   .6103D+00,  .3514D+00,  .4968D+00,
     +   .9127D-02, -.4719D-03, -.2825D-06, -.3275D-06,  .9934D-04,
     +   .6110D+00,  .3543D+00,  .4982D+00,
     +   .7794D-02, -.3991D-03, -.2325D-06, -.2728D-06,  .8246D-04,
     +   .6116D+00,  .3571D+00,  .4993D+00,
     +   .6801D-02, -.3453D-03, -.1996D-06, -.2364D-06,  .7002D-04,
     +   .6121D+00,  .3594D+00,  .5003D+00,
     +   .6066D-02, -.3059D-03, -.1708D-06, -.2016D-06,  .6087D-04,
     +   .6125D+00,  .3612D+00,  .5011D+00,
     +   .5309D-02, -.2656D-03, -.1368D-06, -.1712D-06,  .5172D-04,
     +   .6130D+00,  .3634D+00,  .5021D+00,
     +   .4738D-02, -.2354D-03, -.1137D-06, -.1491D-06,  .4494D-04,
     +   .6133D+00,  .3651D+00,  .5027D+00,
     +   .4257D-02, -.2102D-03, -.1001D-06, -.1289D-06,  .3939D-04,
     +   .6137D+00,  .3667D+00,  .5035D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=17,25)/
     +   .3865D-02, -.1898D-03, -.8508D-07, -.1119D-06,  .3502D-04,
     +   .6140D+00,  .3682D+00,  .5041D+00,
     +   .3427D-02, -.1671D-03, -.6291D-07, -.8601D-07,  .3018D-04,
     +   .6144D+00,  .3699D+00,  .5048D+00,
     +   .3067D-02, -.1486D-03, -.4513D-07, -.6973D-07,  .2642D-04,
     +   .6147D+00,  .3715D+00,  .5055D+00,
     +   .2752D-02, -.1326D-03, -.3239D-07, -.5570D-07,  .2323D-04,
     +   .6150D+00,  .3731D+00,  .5062D+00,
     +   .2505D-02, -.1200D-03, -.2331D-07, -.4291D-07,  .2082D-04,
     +   .6154D+00,  .3743D+00,  .5067D+00,
     +   .2274D-02, -.1084D-03, -.1150D-07, -.3030D-07,  .1863D-04,
     +   .6158D+00,  .3757D+00,  .5074D+00,
     +   .2077D-02, -.9849D-04, -.2525D-08, -.2019D-07,  .1687D-04,
     +   .6160D+00,  .3769D+00,  .5079D+00,
     +   .1899D-02, -.8963D-04,  .5176D-08, -.1069D-07,  .1531D-04,
     +   .6162D+00,  .3780D+00,  .5084D+00,
     +   .1756D-02, -.8252D-04,  .8423D-08, -.7102D-08,  .1414D-04,
     +   .6165D+00,  .3792D+00,  .5088D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=1,8)/
     +   .1449D-01, -.6411D-03, -.5186D-07, -.6286D-07,  .5627D-04,
     +   .6178D+00,  .3819D+00,  .5105D+00,
     +   .1133D-01, -.4937D-03, -.5710D-07, -.7012D-07,  .6586D-04,
     +   .6184D+00,  .3860D+00,  .5120D+00,
     +   .9540D-02, -.4111D-03, -.6630D-07, -.8240D-07,  .6378D-04,
     +   .6189D+00,  .3886D+00,  .5131D+00,
     +   .7932D-02, -.3380D-03, -.6432D-07, -.8160D-07,  .5758D-04,
     +   .6195D+00,  .3916D+00,  .5143D+00,
     +   .6458D-02, -.2718D-03, -.6911D-07, -.8806D-07,  .4908D-04,
     +   .6201D+00,  .3946D+00,  .5155D+00,
     +   .5613D-02, -.2343D-03, -.6593D-07, -.8681D-07,  .4303D-04,
     +   .6205D+00,  .3966D+00,  .5163D+00,
     +   .5055D-02, -.2097D-03, -.6614D-07, -.8189D-07,  .3875D-04,
     +   .6208D+00,  .3982D+00,  .5169D+00,
     +   .4349D-02, -.1789D-03, -.5643D-07, -.7431D-07,  .3290D-04,
     +   .6210D+00,  .4004D+00,  .5177D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=9,16)/
     +   .3906D-02, -.1597D-03, -.6314D-07, -.7607D-07,  .2906D-04,
     +   .6215D+00,  .4018D+00,  .5184D+00,
     +   .3204D-02, -.1295D-03, -.6134D-07, -.8005D-07,  .2283D-04,
     +   .6221D+00,  .4045D+00,  .5195D+00,
     +   .2683D-02, -.1074D-03, -.5120D-07, -.6406D-07,  .1821D-04,
     +   .6225D+00,  .4068D+00,  .5204D+00,
     +   .2302D-02, -.9139D-04, -.4539D-07, -.6033D-07,  .1502D-04,
     +   .6226D+00,  .4087D+00,  .5210D+00,
     +   .2025D-02, -.7982D-04, -.3787D-07, -.5084D-07,  .1266D-04,
     +   .6230D+00,  .4103D+00,  .5217D+00,
     +   .1744D-02, -.6820D-04, -.2532D-07, -.4179D-07,  .1048D-04,
     +   .6234D+00,  .4121D+00,  .5224D+00,
     +   .1535D-02, -.5962D-04, -.1970D-07, -.3691D-07,  .8883D-05,
     +   .6237D+00,  .4137D+00,  .5230D+00,
     +   .1361D-02, -.5253D-04, -.1805D-07, -.3042D-07,  .7600D-05,
     +   .6240D+00,  .4151D+00,  .5236D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=17,25)/
     +   .1221D-02, -.4688D-04, -.1324D-07, -.2533D-07,  .6623D-05,
     +   .6243D+00,  .4163D+00,  .5241D+00,
     +   .1068D-02, -.4069D-04, -.1049D-08, -.8794D-08,  .5615D-05,
     +   .6245D+00,  .4179D+00,  .5247D+00,
     +   .9431D-03, -.3572D-04,  .8277D-08, -.4049D-08,  .4873D-05,
     +   .6248D+00,  .4192D+00,  .5252D+00,
     +   .8355D-03, -.3145D-04,  .1544D-07,  .1427D-08,  .4333D-05,
     +   .6251D+00,  .4206D+00,  .5258D+00,
     +   .7519D-03, -.2814D-04,  .1623D-07,  .8648D-08,  .3902D-05,
     +   .6255D+00,  .4217D+00,  .5263D+00,
     +   .6747D-03, -.2510D-04,  .2581D-07,  .1444D-07,  .3563D-05,
     +   .6256D+00,  .4231D+00,  .5268D+00,
     +   .6098D-03, -.2259D-04,  .3213D-07,  .2182D-07,  .3327D-05,
     +   .6258D+00,  .4241D+00,  .5272D+00,
     +   .5519D-03, -.2033D-04,  .3618D-07,  .2836D-07,  .3154D-05,
     +   .6261D+00,  .4252D+00,  .5277D+00,
     +   .5054D-03, -.1855D-04,  .3801D-07,  .2734D-07,  .3055D-05,
     +   .6265D+00,  .4262D+00,  .5281D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=1,8)/
     +   .3993D-02, -.1267D-03,  .5535D-07,  .5259D-07,  .9500D-05,
     +   .6296D+00,  .4442D+00,  .5349D+00,
     +   .3006D-02, -.9391D-04,  .3221D-07,  .3289D-07,  .1140D-04,
     +   .6301D+00,  .4476D+00,  .5361D+00,
     +   .2464D-02, -.7613D-04,  .1040D-07,  .7119D-08,  .1062D-04,
     +   .6305D+00,  .4497D+00,  .5369D+00,
     +   .1992D-02, -.6085D-04, -.4414D-08, -.7619D-08,  .8795D-05,
     +   .6306D+00,  .4520D+00,  .5375D+00,
     +   .1572D-02, -.4740D-04, -.2607D-07, -.2984D-07,  .6771D-05,
     +   .6313D+00,  .4545D+00,  .5386D+00,
     +   .1337D-02, -.3999D-04, -.3003D-07, -.3683D-07,  .5358D-05,
     +   .6312D+00,  .4560D+00,  .5389D+00,
     +   .1186D-02, -.3522D-04, -.3362D-07, -.3729D-07,  .4483D-05,
     +   .6316D+00,  .4572D+00,  .5395D+00,
     +   .9974D-03, -.2935D-04, -.3058D-07, -.3784D-07,  .3268D-05,
     +   .6319D+00,  .4589D+00,  .5401D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=9,16)/
     +   .8817D-03, -.2576D-04, -.4033D-07, -.4225D-07,  .2546D-05,
     +   .6320D+00,  .4601D+00,  .5405D+00,
     +   .7023D-03, -.2025D-04, -.4264D-07, -.4910D-07,  .1504D-05,
     +   .6324D+00,  .4620D+00,  .5412D+00,
     +   .5731D-03, -.1634D-04, -.3226D-07, -.3866D-07,  .7849D-06,
     +   .6327D+00,  .4640D+00,  .5419D+00,
     +   .4809D-03, -.1357D-04, -.3104D-07, -.3604D-07,  .3395D-06,
     +   .6330D+00,  .4654D+00,  .5425D+00,
     +   .4153D-03, -.1161D-04, -.2408D-07, -.2745D-07, -.2018D-07,
     +   .6332D+00,  .4667D+00,  .5429D+00,
     +   .3499D-03, -.9692D-05, -.1209D-07, -.2287D-07, -.1419D-06,
     +   .6334D+00,  .4683D+00,  .5434D+00,
     +   .3025D-03, -.8304D-05, -.6857D-08, -.1727D-07, -.1744D-06,
     +   .6339D+00,  .4695D+00,  .5440D+00,
     +   .2637D-03, -.7168D-05, -.4346D-08, -.1268D-07, -.1795D-06,
     +   .6339D+00,  .4707D+00,  .5443D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=17,25)/
     +   .2331D-03, -.6285D-05, -.7586D-09, -.6895D-08, -.2010D-06,
     +   .6345D+00,  .4718D+00,  .5450D+00,
     +   .1999D-03, -.5337D-05,  .1179D-07,  .7092D-08, -.2351D-06,
     +   .6349D+00,  .4733D+00,  .5456D+00,
     +   .1735D-03, -.4598D-05,  .2151D-07,  .1144D-07, -.1238D-06,
     +   .6352D+00,  .4748D+00,  .5462D+00,
     +   .1511D-03, -.3955D-05,  .2573D-07,  .1803D-07,  .8352D-08,
     +   .6357D+00,  .4763D+00,  .5468D+00,
     +   .1341D-03, -.3475D-05,  .2997D-07,  .2304D-07,  .1166D-06,
     +   .6361D+00,  .4776D+00,  .5474D+00,
     +   .1185D-03, -.3048D-05,  .3800D-07,  .3112D-07,  .2028D-06,
     +   .6367D+00,  .4791D+00,  .5482D+00,
     +   .1056D-03, -.2698D-05,  .4448D-07,  .3610D-07,  .4178D-06,
     +   .6374D+00,  .4805D+00,  .5490D+00,
     +   .9425D-04, -.2396D-05,  .4668D-07,  .4265D-07,  .5900D-06,
     +   .6378D+00,  .4824D+00,  .5497D+00,
     +   .8532D-04, -.2137D-05,  .5031D-07,  .4115D-07,  .7529D-06,
     +   .6384D+00,  .4839D+00,  .5504D+00 /
C
         X  = DX
         Q  = DQ
         Q2 = DQ*DQ
*...CHECK OF X AND Q2 VALUES : 
C       IF ( (X.LT.1.0D-4) .OR. (X.GT.1.0D0) ) THEN
C           WRITE(6,91) 
C  91       FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C          GOTO 60
C       ENDIF
C       IF ( (Q2.LT.0.4D0) .OR. (Q2.GT.1.D4) ) THEN
C           WRITE(6,92) 
C  92       FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C          GOTO 60
C       ENDIF
C
*...INITIALIZATION :
*    SELECTION AND READING OF THE GRID :
*    FILE - NO. = 11 FOR NLO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.040D-03 )     
*    FILE - NO. = 22 FOR NLO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 9.740D-04 )     
*    FILE - NO. = 33 FOR  LO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.731D-03 )     
*    FILE - NO. = 44 FOR  LO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.846D-03 )     
      IF (IINI.NE.0) GOTO 16
C      IF (ISET.EQ.1) THEN
C       IIREAD=11       
C       OPEN(UNIT=11,FILE='stdnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.2) THEN
C       IIREAD=22
C       OPEN(UNIT=22,FILE='valnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.3) THEN
C       IIREAD=33       
C       OPEN(UNIT=33,FILE='stdloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.4) THEN
C       IIREAD=44
C       OPEN(UNIT=44,FILE='valloa1.grid',STATUS='OLD')
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'PARTON INTERPOLATION: ISET OUT OF RANGE')
C        GOTO 60
C      END IF
C
C       DO 15 M = 1, NX-1 
C       DO 15 N = 1, NQ
C       READ(IIREAD,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1                 PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M),
C     2                 PARTON(7,N,M), PARTON(8,N,M)
C  90   FORMAT (8(1PE10.3))
C  15   CONTINUE
C
      IINI = 1
*....ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0 = XB(IX) 
        XB1 = 1.D0-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0**0.7)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0**0.6)
        XQBF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0**0.3) 
        XSF(IX,IQ)  = PARTON(4,IQ,IX) / (XB1**7 * XB0**0.3) 
        XGF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**10 * XB0**0.3)
        XAPF(IX,IQ)  = PARTON(6,IQ,IX) / XB0
        XANF(IX,IQ)  = PARTON(7,IQ,IX) / XB0
        XADF(IX,IQ)  = PARTON(8,IQ,IX) / XB0
  20  CONTINUE
        XUVF(NX,IQ) = 0.D0
        XDVF(NX,IQ) = 0.D0
        XQBF(NX,IQ) = 0.D0
        XSF(NX,IQ)  = 0.D0
        XGF(NX,IQ)  = 0.D0
        XAPF(NX,IQ)  = 0.D0
        XANF(NX,IQ)  = 0.D0
        XADF(NX,IQ)  = 0.D0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
  16  CONTINUE
C
*...INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * (1.D0-X)**3 * X**0.7
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * (1.D0-X)**4 * X**0.6
      DDV = DV 
      QB = DBFINT(NARG,XT,NA,ARRF,XQBF) * (1.D0-X)**7 * X**0.3
      DSEA = QB
      ST = DBFINT(NARG,XT,NA,ARRF,XSF)  * (1.D0-X)**7 * X**0.3
      DSTR = ST
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * (1.D0-X)**10 * X**0.3
      DGL = GL
      A1P = DBFINT(NARG,XT,NA,ARRF,XAPF)  * X
      A1N = DBFINT(NARG,XT,NA,ARRF,XANF)  * X
      A1D = DBFINT(NARG,XT,NA,ARRF,XADF)  * X
 60   RETURN
      END
