// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "Window.pypp.hpp"

namespace bp = boost::python;

struct Window_wrapper : CEGUI::Window, bp::wrapper< CEGUI::Window > {

    Window_wrapper(::CEGUI::String const & type, ::CEGUI::String const & name )
    : CEGUI::Window( boost::ref(type), boost::ref(name) )
      , bp::wrapper< CEGUI::Window >(){
        // constructor
    
    }

    virtual void beginInitialisation(  ) {
        if( bp::override func_beginInitialisation = this->get_override( "beginInitialisation" ) )
            func_beginInitialisation(  );
        else{
            this->CEGUI::Window::beginInitialisation(  );
        }
    }
    
    void default_beginInitialisation(  ) {
        CEGUI::Window::beginInitialisation( );
    }

    virtual void cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_cloneChildWidgetsTo = this->get_override( "cloneChildWidgetsTo" ) )
            func_cloneChildWidgetsTo( boost::ref(target) );
        else{
            this->CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
        }
    }
    
    void default_cloneChildWidgetsTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::cloneChildWidgetsTo( boost::ref(target) );
    }

    virtual void clonePropertiesTo( ::CEGUI::Window & target ) const  {
        if( bp::override func_clonePropertiesTo = this->get_override( "clonePropertiesTo" ) )
            func_clonePropertiesTo( boost::ref(target) );
        else{
            this->CEGUI::Window::clonePropertiesTo( boost::ref(target) );
        }
    }
    
    void default_clonePropertiesTo( ::CEGUI::Window & target ) const  {
        CEGUI::Window::clonePropertiesTo( boost::ref(target) );
    }

    virtual void destroy(  ) {
        if( bp::override func_destroy = this->get_override( "destroy" ) )
            func_destroy(  );
        else{
            this->CEGUI::Window::destroy(  );
        }
    }
    
    void default_destroy(  ) {
        CEGUI::Window::destroy( );
    }

    virtual void endInitialisation(  ) {
        if( bp::override func_endInitialisation = this->get_override( "endInitialisation" ) )
            func_endInitialisation(  );
        else{
            this->CEGUI::Window::endInitialisation(  );
        }
    }
    
    void default_endInitialisation(  ) {
        CEGUI::Window::endInitialisation( );
    }

    virtual void getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        if( bp::override func_getRenderingContext_impl = this->get_override( "getRenderingContext_impl" ) )
            func_getRenderingContext_impl( boost::ref(ctx) );
        else{
            this->CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
        }
    }
    
    void default_getRenderingContext_impl( ::CEGUI::RenderingContext & ctx ) const  {
        CEGUI::Window::getRenderingContext_impl( boost::ref(ctx) );
    }

    virtual ::CEGUI::Rect getUnclippedInnerRect_impl(  ) const  {
        if( bp::override func_getUnclippedInnerRect_impl = this->get_override( "getUnclippedInnerRect_impl" ) )
            return func_getUnclippedInnerRect_impl(  );
        else{
            return this->CEGUI::Window::getUnclippedInnerRect_impl(  );
        }
    }
    
    ::CEGUI::Rect default_getUnclippedInnerRect_impl(  ) const  {
        return CEGUI::Window::getUnclippedInnerRect_impl( );
    }

    virtual void initialiseComponents(  ) {
        if( bp::override func_initialiseComponents = this->get_override( "initialiseComponents" ) )
            func_initialiseComponents(  );
        else{
            this->CEGUI::Window::initialiseComponents(  );
        }
    }
    
    void default_initialiseComponents(  ) {
        CEGUI::Window::initialiseComponents( );
    }

    virtual bool isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        if( bp::override func_isHit = this->get_override( "isHit" ) )
            return func_isHit( boost::ref(position), allow_disabled );
        else{
            return this->CEGUI::Window::isHit( boost::ref(position), allow_disabled );
        }
    }
    
    bool default_isHit( ::CEGUI::Vector2 const & position, bool const allow_disabled=false ) const  {
        return CEGUI::Window::isHit( boost::ref(position), allow_disabled );
    }

    virtual void performChildWindowLayout(  ) {
        if( bp::override func_performChildWindowLayout = this->get_override( "performChildWindowLayout" ) )
            func_performChildWindowLayout(  );
        else{
            this->CEGUI::Window::performChildWindowLayout(  );
        }
    }
    
    void default_performChildWindowLayout(  ) {
        CEGUI::Window::performChildWindowLayout( );
    }

    virtual void setLookNFeel( ::CEGUI::String const & look ) {
        if( bp::override func_setLookNFeel = this->get_override( "setLookNFeel" ) )
            func_setLookNFeel( boost::ref(look) );
        else{
            this->CEGUI::Window::setLookNFeel( boost::ref(look) );
        }
    }
    
    void default_setLookNFeel( ::CEGUI::String const & look ) {
        CEGUI::Window::setLookNFeel( boost::ref(look) );
    }

    virtual void setMargin( ::CEGUI::UBox const & margin ) {
        if( bp::override func_setMargin = this->get_override( "setMargin" ) )
            func_setMargin( boost::ref(margin) );
        else{
            this->CEGUI::Window::setMargin( boost::ref(margin) );
        }
    }
    
    void default_setMargin( ::CEGUI::UBox const & margin ) {
        CEGUI::Window::setMargin( boost::ref(margin) );
    }

    virtual void update( float elapsed ) {
        if( bp::override func_update = this->get_override( "update" ) )
            func_update( elapsed );
        else{
            this->CEGUI::Window::update( elapsed );
        }
    }
    
    void default_update( float elapsed ) {
        CEGUI::Window::update( elapsed );
    }

    virtual void writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        if( bp::override func_writeXMLToStream = this->get_override( "writeXMLToStream" ) )
            func_writeXMLToStream( boost::ref(xml_stream) );
        else{
            this->CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
        }
    }
    
    void default_writeXMLToStream( ::CEGUI::XMLSerializer & xml_stream ) const  {
        CEGUI::Window::writeXMLToStream( boost::ref(xml_stream) );
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

};

void
Window_setUserData ( ::CEGUI::Window & me, PyObject * data ) {
    me.setUserData ( data );
    }
    
PyObject *
Window_getUserData ( ::CEGUI::Window & me) {
    void *  data = me.getUserData (  );
    Py_INCREF( (PyObject *) data );     // I'm passing a reference to this object so better inc the ref :)
    return  (PyObject *) data;
    }

void register_Window_class(){

    { //::CEGUI::Window
        typedef bp::class_< Window_wrapper, bp::bases< CEGUI::PropertySet, CEGUI::EventSet >, boost::noncopyable > Window_exposer_t;
        Window_exposer_t Window_exposer = Window_exposer_t( "Window", "*!\n\
        \n\
            An abstract base class providing common functionality and specifying the\n\
            required interface for derived classes.\n\
        \n\
            The Window base class is core UI object class that the the system knows\n\
            about; for this reason, every other window, widget, or similar item within\n\
            the system must be derived from Window.\n\
        \n\
            The base class provides the common functionality required by all UI objects,\n\
            and specifies the minimal interface required to be implemented by derived\n\
            classes.\n\
        *\n", bp::init< CEGUI::String const &, CEGUI::String const & >(( bp::arg("type"), bp::arg("name") ), "*!\n\
            \n\
                Constructor for Window base class\n\
        \n\
            @param type\n\
                String object holding Window type (usually provided by WindowFactory).\n\
        \n\
            @param name\n\
                String object holding unique name for the Window.\n\
            *\n") );
        bp::scope Window_scope( Window_exposer );
        { //::CEGUI::Window::activate
        
            typedef void ( ::CEGUI::Window::*activate_function_type )(  ) ;
            
            Window_exposer.def( 
                "activate"
                , activate_function_type( &::CEGUI::Window::activate )
                , "*!\n\
                \n\
                    Activate the Window giving it input focus and bringing it to the top of\n\
                    all windows with the same always-on-top settig as this Window.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::addChildWindow
        
            typedef void ( ::CEGUI::Window::*addChildWindow_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "addChildWindow"
                , addChildWindow_function_type( &::CEGUI::Window::addChildWindow )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Add the named Window as a child of this Window.  If the Window  name\n\
                    is already attached to a Window, it is detached before being added to\n\
                    this Window.\n\
            \n\
                @param name\n\
                    String object holding the name of the Window to be added.\n\
            \n\
                @return\n\
                    Nothing.\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if no Window named  name exists.\n\
                @exception InvalidRequestException\n\
                    thrown if Window  name is an ancestor of this Window, to prevent\n\
                    cyclic Window structures.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::addChildWindow
        
            typedef void ( ::CEGUI::Window::*addChildWindow_function_type )( ::CEGUI::Window * ) ;
            
            Window_exposer.def( 
                "addChildWindow"
                , addChildWindow_function_type( &::CEGUI::Window::addChildWindow )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Add the specified Window as a child of this Window.  If the Window\n\
                     window is already attached to a Window, it is detached before\n\
                    being added to this Window.\n\
            \n\
                @param window\n\
                    Pointer to the Window object to be added.\n\
            \n\
                @return\n\
                    Nothing\n\
            \n\
                @exception InvalidRequestException\n\
                    thrown if Window  window is an ancestor of this Window, to prevent\n\
                    cyclic Window structures.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::appendText
        
            typedef void ( ::CEGUI::Window::*appendText_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "appendText"
                , appendText_function_type( &::CEGUI::Window::appendText )
                , ( bp::arg("text") )
                , "*!\n\
            \n\
                Append the string  text to the currect text string for the Window\n\
                object.\n\
             \n\
            @param text\n\
                String object holding the text that is to be appended to the Window\n\
                object's current text string.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::banPropertyFromXML
        
            typedef void ( ::CEGUI::Window::*banPropertyFromXML_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "banPropertyFromXML"
                , banPropertyFromXML_function_type( &::CEGUI::Window::banPropertyFromXML )
                , ( bp::arg("property_name") )
                , "! Add the named property to the XML ban list for this window.\n" );
        
        }
        { //::CEGUI::Window::banPropertyFromXML
        
            typedef void ( ::CEGUI::Window::*banPropertyFromXML_function_type )( ::CEGUI::Property const * ) ;
            
            Window_exposer.def( 
                "banPropertyFromXML"
                , banPropertyFromXML_function_type( &::CEGUI::Window::banPropertyFromXML )
                , ( bp::arg("property") )
                , "! Add the given property to the XML ban list for this window.\n" );
        
        }
        { //::CEGUI::Window::beginInitialisation
        
            typedef void ( ::CEGUI::Window::*beginInitialisation_function_type )(  ) ;
            typedef void ( Window_wrapper::*default_beginInitialisation_function_type )(  ) ;
            
            Window_exposer.def( 
                "beginInitialisation"
                , beginInitialisation_function_type(&::CEGUI::Window::beginInitialisation)
                , default_beginInitialisation_function_type(&Window_wrapper::default_beginInitialisation) );
        
        }
        { //::CEGUI::Window::captureInput
        
            typedef bool ( ::CEGUI::Window::*captureInput_function_type )(  ) ;
            
            Window_exposer.def( 
                "captureInput"
                , captureInput_function_type( &::CEGUI::Window::captureInput )
                , "*!\n\
                \n\
                    Captures input to this window\n\
            \n\
                @return\n\
                    - true if input was successfully captured to this window.\n\
                    - false if input could not be captured to this window\n\
                      (maybe because the window is not active).\n\
                *\n" );
        
        }
        { //::CEGUI::Window::clone
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*clone_function_type )( ::CEGUI::String const &,bool const ) const;
            
            Window_exposer.def( 
                "clone"
                , clone_function_type( &::CEGUI::Window::clone )
                , ( bp::arg("newName"), bp::arg("deepCopy")=(bool const)(true) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Clones this Window and returns the result\n\
            \n\
                @param \n\
                    newName new name of the cloned window\n\
            \n\
                @param\n\
                    deepCopy if true, even children are copied (the old name prefix will\n\
                    be replaced with new name prefix)\n\
            \n\
                @return\n\
                    the cloned Window\n\
                *\n" );
        
        }
        { //::CEGUI::Window::cloneChildWidgetsTo
        
            typedef void ( ::CEGUI::Window::*cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( Window_wrapper::*default_cloneChildWidgetsTo_function_type )( ::CEGUI::Window & ) const;
            
            Window_exposer.def( 
                "cloneChildWidgetsTo"
                , cloneChildWidgetsTo_function_type(&::CEGUI::Window::cloneChildWidgetsTo)
                , default_cloneChildWidgetsTo_function_type(&Window_wrapper::default_cloneChildWidgetsTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::clonePropertiesTo
        
            typedef void ( ::CEGUI::Window::*clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            typedef void ( Window_wrapper::*default_clonePropertiesTo_function_type )( ::CEGUI::Window & ) const;
            
            Window_exposer.def( 
                "clonePropertiesTo"
                , clonePropertiesTo_function_type(&::CEGUI::Window::clonePropertiesTo)
                , default_clonePropertiesTo_function_type(&Window_wrapper::default_clonePropertiesTo)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::Window::deactivate
        
            typedef void ( ::CEGUI::Window::*deactivate_function_type )(  ) ;
            
            Window_exposer.def( 
                "deactivate"
                , deactivate_function_type( &::CEGUI::Window::deactivate )
                , "*!\n\
                \n\
                    Deactivate the window.  No further inputs will be received by the window\n\
                    until it is re-activated either programmatically or by the user\n\
                    interacting with the gui.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::destroy
        
            typedef void ( ::CEGUI::Window::*destroy_function_type )(  ) ;
            typedef void ( Window_wrapper::*default_destroy_function_type )(  ) ;
            
            Window_exposer.def( 
                "destroy"
                , destroy_function_type(&::CEGUI::Window::destroy)
                , default_destroy_function_type(&Window_wrapper::default_destroy) );
        
        }
        { //::CEGUI::Window::disable
        
            typedef void ( ::CEGUI::Window::*disable_function_type )(  ) ;
            
            Window_exposer.def( 
                "disable"
                , disable_function_type( &::CEGUI::Window::disable )
                , "*!\n\
                \n\
                    disable the Window to prevent interaction.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::distributesCapturedInputs
        
            typedef bool ( ::CEGUI::Window::*distributesCapturedInputs_function_type )(  ) const;
            
            Window_exposer.def( 
                "distributesCapturedInputs"
                , distributesCapturedInputs_function_type( &::CEGUI::Window::distributesCapturedInputs )
                , "*!\n\
                \n\
                    Return whether the window wants inputs passed to its attached\n\
                    child windows when the window has inputs captured.\n\
            \n\
                @return\n\
                    - true if System should pass captured input events to child windows.\n\
                    - false if System should pass captured input events to this window only.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::enable
        
            typedef void ( ::CEGUI::Window::*enable_function_type )(  ) ;
            
            Window_exposer.def( 
                "enable"
                , enable_function_type( &::CEGUI::Window::enable )
                , "*!\n\
                \n\
                    enable the Window to allow interaction.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::endInitialisation
        
            typedef void ( ::CEGUI::Window::*endInitialisation_function_type )(  ) ;
            typedef void ( Window_wrapper::*default_endInitialisation_function_type )(  ) ;
            
            Window_exposer.def( 
                "endInitialisation"
                , endInitialisation_function_type(&::CEGUI::Window::endInitialisation)
                , default_endInitialisation_function_type(&Window_wrapper::default_endInitialisation) );
        
        }
        { //::CEGUI::Window::getActiveChild
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getActiveChild_function_type )(  ) ;
            
            Window_exposer.def( 
                "getActiveChild"
                , getActiveChild_function_type( &::CEGUI::Window::getActiveChild )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the Window that currently has input focus starting\n\
                    with this Window.\n\
            \n\
                @return\n\
                    Pointer to the window that is active (has input focus) starting at this\n\
                    window.  The function will return 'this' if this Window is active\n\
                    and either no children are attached or if none of the attached children\n\
                    are active.  Returns NULL if this Window (and therefore all children)\n\
                    are not active.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getActiveChild
        
            typedef ::CEGUI::Window const * ( ::CEGUI::Window::*getActiveChild_function_type )(  ) const;
            
            Window_exposer.def( 
                "getActiveChild"
                , getActiveChild_function_type( &::CEGUI::Window::getActiveChild )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the Window that currently has input focus starting\n\
                    with this Window.\n\
            \n\
                @return\n\
                    Pointer to the window that is active (has input focus) starting at this\n\
                    window.  The function will return 'this' if this Window is active\n\
                    and either no children are attached or if none of the attached children\n\
                    are active.  Returns NULL if this Window (and therefore all children)\n\
                    are not active.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getActiveSibling
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getActiveSibling_function_type )(  ) ;
            
            Window_exposer.def( 
                "getActiveSibling"
                , getActiveSibling_function_type( &::CEGUI::Window::getActiveSibling )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Returns the active sibling window.\n\
            \n\
                    This searches the immediate children of this window's parent, and\n\
                    returns a pointer to the active window.  The method will return this if\n\
                    we are the immediate child of our parent that is active.  If our parent\n\
                    is not active, or if no immediate child of our parent is active then 0\n\
                    is returned.  If this window has no parent, and this window is not\n\
                    active then 0 is returned, else this is returned.\n\
            \n\
                @return\n\
                    A pointer to the immediate child window attached to our parent that is\n\
                    currently active, or 0 if no immediate child of our parent is active.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getAlpha
        
            typedef float ( ::CEGUI::Window::*getAlpha_function_type )(  ) const;
            
            Window_exposer.def( 
                "getAlpha"
                , getAlpha_function_type( &::CEGUI::Window::getAlpha )
                , "*!\n\
                \n\
                    return the current alpha value set for this Window\n\
            \n\
                \note\n\
                    The alpha value set for any given window may or may not be the final\n\
                    alpha value that is used when rendering.  All window objects, by\n\
                    default, inherit alpha from thier parent window(s) - this will blend\n\
                    child windows, relatively, down the line of inheritance.  This behaviour\n\
                    can be overridden via the setInheritsAlpha() method.  To return the true\n\
                    alpha value that will be applied when rendering, use the\n\
                    getEffectiveAlpha() method.\n\
            \n\
                @return\n\
                    the currently set alpha value for this Window.  The value returned Will\n\
                    be between 0.0f and 1.0f.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getArea
        
            typedef ::CEGUI::URect const & ( ::CEGUI::Window::*getArea_function_type )(  ) const;
            
            Window_exposer.def( 
                "getArea"
                , getArea_function_type( &::CEGUI::Window::getArea )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the windows area.\n\
            \n\
                    Returns the area occupied by this window.  The defined area is offset\n\
                    from the top-left corner of this windows parent window or from the\n\
                    top-left corner of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    URect describing the rectangle of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getAutoRepeatDelay
        
            typedef float ( ::CEGUI::Window::*getAutoRepeatDelay_function_type )(  ) const;
            
            Window_exposer.def( 
                "getAutoRepeatDelay"
                , getAutoRepeatDelay_function_type( &::CEGUI::Window::getAutoRepeatDelay )
                , "*!\n\
                \n\
                    Return the current auto-repeat delay setting for this window.\n\
            \n\
                @return\n\
                    float value indicating the delay, in seconds, defore the first repeat\n\
                    mouse button down event will be triggered when autorepeat is enabled.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getAutoRepeatRate
        
            typedef float ( ::CEGUI::Window::*getAutoRepeatRate_function_type )(  ) const;
            
            Window_exposer.def( 
                "getAutoRepeatRate"
                , getAutoRepeatRate_function_type( &::CEGUI::Window::getAutoRepeatRate )
                , "*!\n\
                \n\
                    Return the current auto-repeat rate setting for this window.\n\
            \n\
                @return\n\
                    float value indicating the rate, in seconds, at which repeat mouse\n\
                    button down events will be generated after the initial delay has\n\
                    expired.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getBiDiVisualMapping
        
            typedef ::CEGUI::BiDiVisualMapping const * ( ::CEGUI::Window::*getBiDiVisualMapping_function_type )(  ) const;
            
            Window_exposer.def( 
                "getBiDiVisualMapping"
                , getBiDiVisualMapping_function_type( &::CEGUI::Window::getBiDiVisualMapping )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! return the pointer to the BiDiVisualMapping for this window, if any.\n" );
        
        }
        { //::CEGUI::Window::getCaptureWindow
        
            typedef ::CEGUI::Window * ( *getCaptureWindow_function_type )(  );
            
            Window_exposer.def( 
                "getCaptureWindow"
                , getCaptureWindow_function_type( &::CEGUI::Window::getCaptureWindow )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return the Window that currently has inputs captured.\n\
            \n\
                @return\n\
                    Pointer to the Window object that currently has inputs captured, or NULL\n\
                    if no Window has captured input.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChild
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChild_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "getChild"
                , getChild_function_type( &::CEGUI::Window::getChild )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the child window with the specified name.\n\
            \n\
                    This function will throw an exception if no child object with the given\n\
                    name is attached.  This decision was made (over returning NULL if no\n\
                    window was found) so that client code can assume that if the call\n\
                    returns it has a valid window pointer.  We provide the isChild()\n\
                    functions for checking if a given window is attached.\n\
            \n\
                @param name\n\
                    String object holding the name of the child window for which a pointer\n\
                    is to be returned.\n\
            \n\
                @return\n\
                    Pointer to the Window object attached to this window that has the name\n\
                     name.\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if no window named  name is attached to this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChild
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChild_function_type )( ::CEGUI::uint ) const;
            
            Window_exposer.def( 
                "getChild"
                , getChild_function_type( &::CEGUI::Window::getChild )
                , ( bp::arg("ID") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the first attached child window with the specified\n\
                    ID value.\n\
            \n\
                    This function will throw an exception if no child object with the given\n\
                    ID is attached.  This decision was made (over returning NULL if no\n\
                    window was found) so that client code can assume that if the call\n\
                    returns it has a valid window pointer.  We provide the isChild()\n\
                    functions for checking if a given window is attached.\n\
            \n\
                @param ID\n\
                    uint value specifying the ID code of the window to return a pointer to.\n\
            \n\
                @return\n\
                    Pointer to the (first) Window object attached to this window that has\n\
                    the ID code  ID.\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if no window with the ID code  ID is attached to this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildAtIdx
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChildAtIdx_function_type )( ::size_t ) const;
            
            Window_exposer.def( 
                "getChildAtIdx"
                , getChildAtIdx_function_type( &::CEGUI::Window::getChildAtIdx )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the child window that is attached to 'this' at the\n\
                    given index.\n\
            \n\
                @param idx\n\
                    Index of the child window whos pointer should be returned.  This value\n\
                    is not bounds checked, client code should ensure that this is less than\n\
                    the value returned by getChildCount().\n\
            \n\
                @return\n\
                    Pointer to the child window currently attached at index position  idx\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildAtPosition
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChildAtPosition_function_type )( ::CEGUI::Vector2 const & ) const;
            
            Window_exposer.def( 
                "getChildAtPosition"
                , getChildAtPosition_function_type( &::CEGUI::Window::getChildAtPosition )
                , ( bp::arg("position") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return the child Window that is hit by the given pixel position\n\
            \n\
                @param position\n\
                    Vector2 object describing the position to check.  The position\n\
                    describes a pixel offset from the top-left corner of the display.\n\
            \n\
                @return\n\
                    Pointer to the child Window that was hit according to the location\n\
                     position, or 0 if no child of this window was hit.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildCount
        
            typedef ::size_t ( ::CEGUI::Window::*getChildCount_function_type )(  ) const;
            
            Window_exposer.def( 
                "getChildCount"
                , getChildCount_function_type( &::CEGUI::Window::getChildCount )
                , "*!\n\
                \n\
                    return the number of child Window objects currently attached to this\n\
                    Window.\n\
            \n\
                @return\n\
                    size_t value equal to the number of Window objects directly attached\n\
                    to this Window as children.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildRecursive
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChildRecursive_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "getChildRecursive"
                , getChildRecursive_function_type( &::CEGUI::Window::getChildRecursive )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the first attached child window with the specified\n\
                    name. Children are traversed recursively.\n\
            \n\
                    Contrary to the non recursive version of this function, this one will\n\
                    not throw an exception, but return 0 in case no child was found.\n\
            \n\
                \note\n\
                    WARNING! This function can be very expensive and should only be used\n\
                    when you have no other option available. If you decide to use it anyway,\n\
                    make sure the window hierarchy from the entry point is small.\n\
            \n\
                @param name\n\
                    String object holding the name of the child window for which a pointer\n\
                    is to be returned.\n\
            \n\
                @return\n\
                    Pointer to the Window object attached to this window that has the name\n\
                     name.\n\
            \n\
                    If no child is found with the name  name, 0 is returned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildRecursive
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getChildRecursive_function_type )( ::CEGUI::uint ) const;
            
            Window_exposer.def( 
                "getChildRecursive"
                , getChildRecursive_function_type( &::CEGUI::Window::getChildRecursive )
                , ( bp::arg("ID") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return a pointer to the first attached child window with the specified\n\
                    ID value. Children are traversed recursively.\n\
            \n\
                    Contrary to the non recursive version of this function, this one will\n\
                    not throw an exception, but return 0 in case no child was found.\n\
            \n\
                \note\n\
                    WARNING! This function can be very expensive and should only be used\n\
                    when you have no other option available. If you decide to use it anyway,\n\
                    make sure the window hierarchy from the entry point is small.\n\
            \n\
                @param ID\n\
                    uint value specifying the ID code of the window to return a pointer to.\n\
            \n\
                @return\n\
                    Pointer to the (first) Window object attached to this window that has\n\
                    the ID code  ID.\n\
                    If no child is found with the ID code  ID, 0 is returned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getChildWindowContentArea
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getChildWindowContentArea_function_type )( bool const ) const;
            
            Window_exposer.def( 
                "getChildWindowContentArea"
                , getChildWindowContentArea_function_type( &::CEGUI::Window::getChildWindowContentArea )
                , ( bp::arg("non_client")=(bool const)(false) )
                , "*!\n\
                \n\
                    Return a Rect that describes the area that is used to position\n\
                    and - for scale values - size child content attached to this Window.\n\
            \n\
                    By and large the area returned here will be the same as the unclipped\n\
                    inner rect (for client content) or the unclipped outer rect (for non\n\
                    client content), although certain advanced uses will require\n\
                    alternative Rects to be returned.\n\
            \n\
                \note\n\
                    The behaviour of this function is modified by overriding the\n\
                    protected Window.getClientChildWindowContentArea_impl andor\n\
                    Window.getNonClientChildWindowContentArea_impl functions.\n\
            \n\
                @param non_client\n\
                    - true to return the non-client child content area.\n\
                    - false to return the client child content area (default).\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getClipRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getClipRect_function_type )( bool const ) const;
            
            Window_exposer.def( 
                "getClipRect"
                , getClipRect_function_type( &::CEGUI::Window::getClipRect )
                , ( bp::arg("non_client")=(bool const)(false) )
                , "*!\n\
                \n\
                    Return a Rect that describes the rendering clipping rect for the Window.\n\
            \n\
                    This function can return the clipping rect for either the inner or outer\n\
                    area dependant upon the boolean values passed in.\n\
            \n\
                \note\n\
                    The areas returned by this function gives you the correct clipping rects\n\
                    for rendering within the Window's areas.  The area described may or may\n\
                    not correspond to the final visual clipping actually seen on the\n\
                    display; this is intentional and neccessary due to the way that imagery\n\
                    is cached under some configurations.\n\
            \n\
                @param non_client\n\
                    - true to return the non-client clipping area (based on outer rect).\n\
                    - false to return the client clipping area (based on inner rect).\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getCustomRenderedStringParser
        
            typedef ::CEGUI::RenderedStringParser * ( ::CEGUI::Window::*getCustomRenderedStringParser_function_type )(  ) const;
            
            Window_exposer.def( 
                "getCustomRenderedStringParser"
                , getCustomRenderedStringParser_function_type( &::CEGUI::Window::getCustomRenderedStringParser )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! Return the parsed RenderedString object for this window.\n\
            ! Return a pointer to any custom RenderedStringParser set, or 0 if none.\n" );
        
        }
        { //::CEGUI::Window::getEffectiveAlpha
        
            typedef float ( ::CEGUI::Window::*getEffectiveAlpha_function_type )(  ) const;
            
            Window_exposer.def( 
                "getEffectiveAlpha"
                , getEffectiveAlpha_function_type( &::CEGUI::Window::getEffectiveAlpha )
                , "*!\n\
                \n\
                    return the effective alpha value that will be used when rendering this\n\
                    window, taking into account inheritance of parent window(s) alpha.\n\
            \n\
                @return\n\
                    the effective alpha that will be applied to this Window when rendering.\n\
                    The value returned Will be between 0.0f and 1.0f.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getEventIterator
        
            typedef ::CEGUI::ConstBaseIterator< std::map<CEGUI::String, CEGUI::Event*, CEGUI::String::FastLessCompare, std::allocator<std::pair<CEGUI::String const, CEGUI::Event*> > > > ( ::CEGUI::Window::*getEventIterator_function_type )(  ) const;
            
            Window_exposer.def( 
                "getEventIterator"
                , getEventIterator_function_type( &::CEGUI::Window::getEventIterator )
                , "*!\n\
                \n\
                    Helper method that returns an EventSet.Iterator object that can be used\n\
                    to iterate over the events currently added to the EventSet of this Window.\n\
                \n\
                    This helper member is provided as an easy way to avoid some abiguity\n\
                    we have due to using multiple inheritence.  Ultimately it avoids the\n\
                    need to do things like this (which some people don't like!):\n\
                    .\n\
                     obtain an iterator for the EventSet\n\
                    EventSet.Iterator evt_iter = myWindow.EventSet.getIterator();\n\
            \n\
                     obtain an iterator for the PropertySet\n\
                    PropertySet.Iterator prp_iter = myWindow.PropertySet.getIterator();\n\
                    \n\n\
            \n\
                \note\n\
                    Iterating over events in the EventSet is of questionable use these days,\n\
                    since available Events are no longer added in one batch at creation time,\n\
                    but are added individually whenever an event is first subscribed.\n\
            \n\
                @return\n\
                    EventSet.Iterator object.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getFont
        
            typedef ::CEGUI::Font * ( ::CEGUI::Window::*getFont_function_type )( bool ) const;
            
            Window_exposer.def( 
                "getFont"
                , getFont_function_type( &::CEGUI::Window::getFont )
                , ( bp::arg("useDefault")=(bool)(true) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return the active Font object for the Window.\n\
            \n\
                @param useDefault\n\
                    Sepcifies whether to return the default font if this Window has no\n\
                    preferred font set.\n\
            \n\
                @return\n\
                    Pointer to the Font being used by this Window.  If the window has no\n\
                    assigned font, and  useDefault is true, then the default system font\n\
                    is returned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::Window::*getGeometryBuffer_function_type )(  ) ;
            
            Window_exposer.def( 
                "getGeometryBuffer"
                , getGeometryBuffer_function_type( &::CEGUI::Window::getGeometryBuffer )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return the GeometryBuffer object for this Window.\n\
            \n\
                @return\n\
                    Reference to the GeometryBuffer object for this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getHeight
        
            typedef ::CEGUI::UDim ( ::CEGUI::Window::*getHeight_function_type )(  ) const;
            
            Window_exposer.def( 
                "getHeight"
                , getHeight_function_type( &::CEGUI::Window::getHeight )
                , "*!\n\
                \n\
                    Get the window's height.\n\
            \n\
                    Gets the height of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UDim describing the height of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getHitTestRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getHitTestRect_function_type )(  ) const;
            
            Window_exposer.def( 
                "getHitTestRect"
                , getHitTestRect_function_type( &::CEGUI::Window::getHitTestRect )
                , "*!\n\
                \n\
                    Return the Rect that descibes the clipped screen area that is used for\n\
                    determining whether this window has been hit by a certain point.\n\
            \n\
                    The area returned by this function may also be useful for certain\n\
                    calculations that require the clipped Window area as seen on the display\n\
                    as opposed to what is used for rendering (since the actual rendering\n\
                    clipper rects should not to be used if reliable results are desired).\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getHorizontalAlignment
        
            typedef ::CEGUI::HorizontalAlignment ( ::CEGUI::Window::*getHorizontalAlignment_function_type )(  ) const;
            
            Window_exposer.def( 
                "getHorizontalAlignment"
                , getHorizontalAlignment_function_type( &::CEGUI::Window::getHorizontalAlignment )
                , "*!\n\
                \n\
                    Get the horizontal alignment.\n\
            \n\
                    Returns the horizontal alignment for the window.  This setting affects\n\
                    how the windows position is interpreted relative to its parent.\n\
            \n\
                @return\n\
                    One of the HorizontalAlignment enumerated values.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getID
        
            typedef ::CEGUI::uint ( ::CEGUI::Window::*getID_function_type )(  ) const;
            
            Window_exposer.def( 
                "getID"
                , getID_function_type( &::CEGUI::Window::getID )
                , "*!\n\
                \n\
                    return the ID code currently assigned to this Window by client code.\n\
            \n\
                @return\n\
                    uint value equal to the currently assigned ID code for this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getInnerRectClipper
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getInnerRectClipper_function_type )(  ) const;
            
            Window_exposer.def( 
                "getInnerRectClipper"
                , getInnerRectClipper_function_type( &::CEGUI::Window::getInnerRectClipper )
                , "*!\n\
                \n\
                    Return a Rect that describes the rendering clipping rect based upon the\n\
                    inner rect area of the window.\n\
            \n\
                \note\n\
                    The area returned by this function gives you the correct clipping rect\n\
                    for rendering within the Window's inner rect area.  The area described\n\
                    may or may not correspond to the final visual clipping actually seen on\n\
                    the display; this is intentional and neccessary due to the way that\n\
                    imagery is cached under some configurations.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getLookNFeel
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getLookNFeel_function_type )(  ) const;
            
            Window_exposer.def( 
                "getLookNFeel"
                , getLookNFeel_function_type( &::CEGUI::Window::getLookNFeel )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the name of the LookNFeel assigned to this window.\n\
            \n\
                @return\n\
                    String object holding the name of the look assigned to this window.\n\
                    Returns the empty string if no look is assigned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getMargin
        
            typedef ::CEGUI::UBox const & ( ::CEGUI::Window::*getMargin_function_type )(  ) const;
            
            Window_exposer.def( 
                "getMargin"
                , getMargin_function_type( &::CEGUI::Window::getMargin )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! set margin\n\
            ! retrieves currently set margin\n" );
        
        }
        { //::CEGUI::Window::getMaxSize
        
            typedef ::CEGUI::UVector2 const & ( ::CEGUI::Window::*getMaxSize_function_type )(  ) const;
            
            Window_exposer.def( 
                "getMaxSize"
                , getMaxSize_function_type( &::CEGUI::Window::getMaxSize )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the window's maximum size.\n\
            \n\
                    Gets the maximum size that this windows area may occupy (whether size\n\
                    changes occur by user interaction, general system operation, or by\n\
                    direct setting by client code).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UVector2 describing the maximum size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getMinSize
        
            typedef ::CEGUI::UVector2 const & ( ::CEGUI::Window::*getMinSize_function_type )(  ) const;
            
            Window_exposer.def( 
                "getMinSize"
                , getMinSize_function_type( &::CEGUI::Window::getMinSize )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the window's minimum size.\n\
            \n\
                    Gets the minimum size that this windows area may occupy (whether size\n\
                    changes occur by user interaction, general system operation, or by\n\
                    direct setting by client code).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UVector2 describing the minimum size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getModalState
        
            typedef bool ( ::CEGUI::Window::*getModalState_function_type )(  ) const;
            
            Window_exposer.def( 
                "getModalState"
                , getModalState_function_type( &::CEGUI::Window::getModalState )
                , "*!\n\
                \n\
                    Get whether or not this Window is the modal target.\n\
            \n\
                @return\n\
                    Returns true if this Window is the modal target, otherwise false.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getMouseCursor
        
            typedef ::CEGUI::Image const * ( ::CEGUI::Window::*getMouseCursor_function_type )( bool ) const;
            
            Window_exposer.def( 
                "getMouseCursor"
                , getMouseCursor_function_type( &::CEGUI::Window::getMouseCursor )
                , ( bp::arg("useDefault")=(bool)(true) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the mouse cursor image to use when the mouse cursor\n\
                    is within this window's area.\n\
            \n\
                @param useDefault\n\
                    Sepcifies whether to return the default mouse cursor image if this\n\
                    window specifies no preferred mouse cursor image.\n\
            \n\
                @return\n\
                    Pointer to the mouse cursor image that will be used when the mouse\n\
                    enters this window's area.  May return NULL indicating no cursor will\n\
                    be drawn for this window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getName
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getName_function_type )(  ) const;
            
            Window_exposer.def( 
                "getName"
                , getName_function_type( &::CEGUI::Window::getName )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    return a String object holding the name of this Window.\n\
            \n\
                @return\n\
                    String object holding the unique Window name.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getOuterRectClipper
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getOuterRectClipper_function_type )(  ) const;
            
            Window_exposer.def( 
                "getOuterRectClipper"
                , getOuterRectClipper_function_type( &::CEGUI::Window::getOuterRectClipper )
                , "*!\n\
                \n\
                    Return a Rect that describes the rendering clipping rect based upon the\n\
                    outer rect area of the window.\n\
            \n\
                \note\n\
                    The area returned by this function gives you the correct clipping rect\n\
                    for rendering within the Window's outer rect area.  The area described\n\
                    may or may not correspond to the final visual clipping actually seen on\n\
                    the display; this is intentional and neccessary due to the way that\n\
                    imagery is cached under some configurations.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getParent
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getParent_function_type )(  ) const;
            
            Window_exposer.def( 
                "getParent"
                , getParent_function_type( &::CEGUI::Window::getParent )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return the parent of this Window.\n\
            \n\
                @return\n\
                    Pointer to the Window object that is the parent of this Window.\n\
                    This value can be NULL, in which case the Window is a GUI sheet  root.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getParentPixelHeight
        
            typedef float ( ::CEGUI::Window::*getParentPixelHeight_function_type )(  ) const;
            
            Window_exposer.def( 
                "getParentPixelHeight"
                , getParentPixelHeight_function_type( &::CEGUI::Window::getParentPixelHeight )
                , "*!\n\
                \n\
                    Return the pixel Height of the parent element.  This always returns a\n\
                    valid number.\n\
            \n\
                @return\n\
                    float value that is equal to the pixel height of this Window objects\n\
                    parent\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getParentPixelSize
        
            typedef ::CEGUI::Size ( ::CEGUI::Window::*getParentPixelSize_function_type )(  ) const;
            
            Window_exposer.def( 
                "getParentPixelSize"
                , getParentPixelSize_function_type( &::CEGUI::Window::getParentPixelSize )
                , "*!\n\
                \n\
                    Return the pixel size of the parent element.  This always returns a\n\
                    valid object.\n\
            \n\
                @return\n\
                    Size object that describes the pixel dimensions of this Window objects\n\
                    parent\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getParentPixelWidth
        
            typedef float ( ::CEGUI::Window::*getParentPixelWidth_function_type )(  ) const;
            
            Window_exposer.def( 
                "getParentPixelWidth"
                , getParentPixelWidth_function_type( &::CEGUI::Window::getParentPixelWidth )
                , "*!\n\
                \n\
                    Return the pixel Width of the parent element.  This always returns a\n\
                    valid number.\n\
            \n\
                @return\n\
                    float value that is equal to the pixel width of this Window objects\n\
                    parent\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getPixelSize
        
            typedef ::CEGUI::Size ( ::CEGUI::Window::*getPixelSize_function_type )(  ) const;
            
            Window_exposer.def( 
                "getPixelSize"
                , getPixelSize_function_type( &::CEGUI::Window::getPixelSize )
                , "*!\n\
                \n\
                    Return the window size in pixels.\n\
            \n\
                @return\n\
                    Size object describing this windows size in pixels.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getPosition
        
            typedef ::CEGUI::UVector2 const & ( ::CEGUI::Window::*getPosition_function_type )(  ) const;
            
            Window_exposer.def( 
                "getPosition"
                , getPosition_function_type( &::CEGUI::Window::getPosition )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the window's position.\n\
            \n\
                    Gets the position of the area occupied by this window.  The position is\n\
                    offset from the top-left corner of this windows parent window or from\n\
                    the top-left corner of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UVector2 describing the position (top-left corner) of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getPropertyIterator
        
            typedef ::CEGUI::ConstBaseIterator< std::map<CEGUI::String, CEGUI::Property*, CEGUI::String::FastLessCompare, std::allocator<std::pair<CEGUI::String const, CEGUI::Property*> > > > ( ::CEGUI::Window::*getPropertyIterator_function_type )(  ) const;
            
            Window_exposer.def( 
                "getPropertyIterator"
                , getPropertyIterator_function_type( &::CEGUI::Window::getPropertyIterator )
                , "*!\n\
                \n\
                    Helper method that returns a PropertySet.Iterator object that can be\n\
                    used to iterate over the events currently added to the PropertySet of\n\
                    this Window.\n\
                \n\
                    This helper member is provided as an easy way to avoid some abiguity\n\
                    we have due to using multiple inheritence.  Ultimately it avoids the\n\
                    need to do things like this (which some people don't like!):\n\
                    .\n\
                     obtain an iterator for the EventSet\n\
                    EventSet. Iterator evt_iter = myWindow.EventSet.getIterator();\n\
            \n\
                     obtain an iterator for the PropertySet\n\
                    PropertySet.Iterator prp_iter = myWindow.PropertySet.getIterator();\n\
                    \n\n\
            \n\
                @return\n\
                    PropertySet.Iterator object.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getRenderedString
        
            typedef ::CEGUI::RenderedString const & ( ::CEGUI::Window::*getRenderedString_function_type )(  ) const;
            
            Window_exposer.def( 
                "getRenderedString"
                , getRenderedString_function_type( &::CEGUI::Window::getRenderedString )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! Return the parsed RenderedString object for this window.\n" );
        
        }
        { //::CEGUI::Window::getRenderedStringParser
        
            typedef ::CEGUI::RenderedStringParser & ( ::CEGUI::Window::*getRenderedStringParser_function_type )(  ) const;
            
            Window_exposer.def( 
                "getRenderedStringParser"
                , getRenderedStringParser_function_type(&::CEGUI::Window::getRenderedStringParser)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::Window::getRenderingContext
        
            typedef void ( ::CEGUI::Window::*getRenderingContext_function_type )( ::CEGUI::RenderingContext & ) const;
            
            Window_exposer.def( 
                "getRenderingContext"
                , getRenderingContext_function_type( &::CEGUI::Window::getRenderingContext )
                , ( bp::arg("ctx") )
                , "*!\n\
            \n\
                Fill in the RenderingContext  ctx with details of the RenderingSurface\n\
                where this Window object should normally do it's rendering.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::getRenderingContext_impl
        
            typedef void ( ::CEGUI::Window::*getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            typedef void ( Window_wrapper::*default_getRenderingContext_impl_function_type )( ::CEGUI::RenderingContext & ) const;
            
            Window_exposer.def( 
                "getRenderingContext_impl"
                , getRenderingContext_impl_function_type(&::CEGUI::Window::getRenderingContext_impl)
                , default_getRenderingContext_impl_function_type(&Window_wrapper::default_getRenderingContext_impl)
                , ( bp::arg("ctx") ) );
        
        }
        { //::CEGUI::Window::getRenderingSurface
        
            typedef ::CEGUI::RenderingSurface * ( ::CEGUI::Window::*getRenderingSurface_function_type )(  ) const;
            
            Window_exposer.def( 
                "getRenderingSurface"
                , getRenderingSurface_function_type( &::CEGUI::Window::getRenderingSurface )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                return the RenderingSurface currently set for this window.  May return\n\
                0.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::getRootWindow
        
            typedef ::CEGUI::Window const * ( ::CEGUI::Window::*getRootWindow_function_type )(  ) const;
            
            Window_exposer.def( 
                "getRootWindow"
                , getRootWindow_function_type( &::CEGUI::Window::getRootWindow )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Returns the window at the root of the hierarchy starting at this\n\
                    Window.  The root window is defined as the first window back up the\n\
                    hierarchy that has no parent window.\n\
            \n\
                @return\n\
                    A pointer to the root window of the hierarchy that this window is\n\
                    attched to.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getRootWindow
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getRootWindow_function_type )(  ) ;
            
            Window_exposer.def( 
                "getRootWindow"
                , getRootWindow_function_type( &::CEGUI::Window::getRootWindow )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Returns the window at the root of the hierarchy starting at this\n\
                    Window.  The root window is defined as the first window back up the\n\
                    hierarchy that has no parent window.\n\
            \n\
                @return\n\
                    A pointer to the root window of the hierarchy that this window is\n\
                    attched to.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getRotation
        
            typedef ::CEGUI::Vector3 const & ( ::CEGUI::Window::*getRotation_function_type )(  ) const;
            
            Window_exposer.def( 
                "getRotation"
                , getRotation_function_type( &::CEGUI::Window::getRotation )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return the rotations set for this window.\n" );
        
        }
        { //::CEGUI::Window::getSize
        
            typedef ::CEGUI::UVector2 ( ::CEGUI::Window::*getSize_function_type )(  ) const;
            
            Window_exposer.def( 
                "getSize"
                , getSize_function_type( &::CEGUI::Window::getSize )
                , "*!\n\
                \n\
                    Get the window's size.\n\
            \n\
                    Gets the size of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UVector2 describing the size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getTargetChildAtPosition
        
            typedef ::CEGUI::Window * ( ::CEGUI::Window::*getTargetChildAtPosition_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            
            Window_exposer.def( 
                "getTargetChildAtPosition"
                , getTargetChildAtPosition_function_type( &::CEGUI::Window::getTargetChildAtPosition )
                , ( bp::arg("position"), bp::arg("allow_disabled")=(bool const)(false) )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    return the child Window that is 'hit' by the given position, and is\n\
                    allowed to handle mouse events.\n\
            \n\
                @param position\n\
                    Vector2 object describing the position to check.  The position\n\
                    describes a pixel offset from the top-left corner of the display.\n\
            \n\
                @param allow_disabled\n\
                    - true specifies that a disabled window may be returned as the target.\n\
                    - false specifies that only enabled windows may be returned.\n\
            \n\
                @return\n\
                    Pointer to the child Window that was hit according to the location\n\
                     position, or 0 if no child of this window was hit.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getTargetRenderingSurface
        
            typedef ::CEGUI::RenderingSurface & ( ::CEGUI::Window::*getTargetRenderingSurface_function_type )(  ) const;
            
            Window_exposer.def( 
                "getTargetRenderingSurface"
                , getTargetRenderingSurface_function_type( &::CEGUI::Window::getTargetRenderingSurface )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
            \n\
                return the RenderingSurface that will be used by this window as the\n\
                target for rendering.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::getText
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getText_function_type )(  ) const;
            
            Window_exposer.def( 
                "getText"
                , getText_function_type( &::CEGUI::Window::getText )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    return the current text for the Window\n\
            \n\
                @return\n\
                    The String object that holds the current text for this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getTextVisual
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getTextVisual_function_type )(  ) const;
            
            Window_exposer.def( 
                "getTextVisual"
                , getTextVisual_function_type( &::CEGUI::Window::getTextVisual )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return text string with  e visual ordering of glyphs.\n" );
        
        }
        { //::CEGUI::Window::getTooltip
        
            typedef ::CEGUI::Tooltip * ( ::CEGUI::Window::*getTooltip_function_type )(  ) const;
            
            Window_exposer.def( 
                "getTooltip"
                , getTooltip_function_type( &::CEGUI::Window::getTooltip )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Return a pointer to the Tooltip object used by this Window.  The value\n\
                    returned may point to the system default Tooltip, a custom Window\n\
                    specific Tooltip, or be NULL.\n\
            \n\
                @return\n\
                    Pointer to a Tooltip based object, or NULL.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getTooltipText
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getTooltipText_function_type )(  ) const;
            
            Window_exposer.def( 
                "getTooltipText"
                , getTooltipText_function_type( &::CEGUI::Window::getTooltipText )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Return the current tooltip text set for this Window.\n\
            \n\
                @return\n\
                    String object holding the current tooltip text set for this window.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getTooltipType
        
            typedef ::CEGUI::String ( ::CEGUI::Window::*getTooltipType_function_type )(  ) const;
            
            Window_exposer.def( 
                "getTooltipType"
                , getTooltipType_function_type( &::CEGUI::Window::getTooltipType )
                , "*!\n\
                \n\
                    Return the custom tooltip type.\n\
            \n\
                @return\n\
                    String object holding the current custom tooltip window type, or an\n\
                    empty string if no custom tooltip is set.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getType
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getType_function_type )(  ) const;
            
            Window_exposer.def( 
                "getType"
                , getType_function_type( &::CEGUI::Window::getType )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    return a String object holding the type name for this Window.\n\
            \n\
                @return\n\
                    String object holding the Window type.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getUnclippedInnerRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedInnerRect_function_type )(  ) const;
            
            Window_exposer.def( 
                "getUnclippedInnerRect"
                , getUnclippedInnerRect_function_type( &::CEGUI::Window::getUnclippedInnerRect )
                , "*!\n\
            \n\
                Return a Rect that describes the unclipped inner rect area of the Window\n\
                in screen pixels.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::getUnclippedInnerRect_impl
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedInnerRect_impl_function_type )(  ) const;
            typedef ::CEGUI::Rect ( Window_wrapper::*default_getUnclippedInnerRect_impl_function_type )(  ) const;
            
            Window_exposer.def( 
                "getUnclippedInnerRect_impl"
                , getUnclippedInnerRect_impl_function_type(&::CEGUI::Window::getUnclippedInnerRect_impl)
                , default_getUnclippedInnerRect_impl_function_type(&Window_wrapper::default_getUnclippedInnerRect_impl) );
        
        }
        { //::CEGUI::Window::getUnclippedOuterRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedOuterRect_function_type )(  ) const;
            
            Window_exposer.def( 
                "getUnclippedOuterRect"
                , getUnclippedOuterRect_function_type( &::CEGUI::Window::getUnclippedOuterRect )
                , "*!\n\
            \n\
                Return a Rect that describes the unclipped outer rect area of the Window\n\
                in screen pixels.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::getUnclippedRect
        
            typedef ::CEGUI::Rect ( ::CEGUI::Window::*getUnclippedRect_function_type )( bool const ) const;
            
            Window_exposer.def( 
                "getUnclippedRect"
                , getUnclippedRect_function_type( &::CEGUI::Window::getUnclippedRect )
                , ( bp::arg("inner") )
                , "*!\n\
                \n\
                    Return a Rect that describes the unclipped area covered by the Window.\n\
            \n\
                    This function can return either the inner or outer area dependant upon\n\
                    the boolean values passed in.\n\
            \n\
                @param inner\n\
                    - true if the inner rect area should be returned.\n\
                    - false if the outer rect area should be returned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getUnprojectedPosition
        
            typedef ::CEGUI::Vector2 ( ::CEGUI::Window::*getUnprojectedPosition_function_type )( ::CEGUI::Vector2 const & ) const;
            
            Window_exposer.def( 
                "getUnprojectedPosition"
                , getUnprojectedPosition_function_type( &::CEGUI::Window::getUnprojectedPosition )
                , ( bp::arg("pos") )
                , "! return Vector2  pos after being fully unprojected for this Window.\n" );
        
        }
        { //::CEGUI::Window::getUpdateMode
        
            typedef ::CEGUI::WindowUpdateMode ( ::CEGUI::Window::*getUpdateMode_function_type )(  ) const;
            
            Window_exposer.def( 
                "getUpdateMode"
                , getUpdateMode_function_type( &::CEGUI::Window::getUpdateMode )
                , "*!\n\
                \n\
                    Return the current window update mode that is set for this Window.\n\
                    This mode controls the behaviour of the Window.update member function\n\
                    such that updates are processed for this window (and therefore it's\n\
                    child content) according to the set mode.\n\
            \n\
                \note\n\
                    Disabling updates can have negative effects on the behaviour of CEGUI\n\
                    windows and widgets; updates should be disabled selectively and\n\
                    cautiously - if you are unsure of what you are doing, leave the mode\n\
                    set to WUM_ALWAYS.\n\
                \n\
                @return\n\
                    One of the WindowUpdateMode enumerated values indicating the current\n\
                    mode set for this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getUserString
        
            typedef ::CEGUI::String const & ( ::CEGUI::Window::*getUserString_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "getUserString"
                , getUserString_function_type( &::CEGUI::Window::getUserString )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Returns a named user string.\n\
            \n\
                @param name\n\
                    String object holding the name of the string to be returned.\n\
            \n\
                @return\n\
                    String object holding the data stored for the requested user string.\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if a user string named  name does not exist.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getVerticalAlignment
        
            typedef ::CEGUI::VerticalAlignment ( ::CEGUI::Window::*getVerticalAlignment_function_type )(  ) const;
            
            Window_exposer.def( 
                "getVerticalAlignment"
                , getVerticalAlignment_function_type( &::CEGUI::Window::getVerticalAlignment )
                , "*!\n\
                \n\
                    Get the vertical alignment.\n\
            \n\
                    Returns the vertical alignment for the window.  This setting affects how\n\
                    the windows position is interpreted relative to its parent.\n\
            \n\
                @return\n\
                    One of the VerticalAlignment enumerated values.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getWidth
        
            typedef ::CEGUI::UDim ( ::CEGUI::Window::*getWidth_function_type )(  ) const;
            
            Window_exposer.def( 
                "getWidth"
                , getWidth_function_type( &::CEGUI::Window::getWidth )
                , "*!\n\
                \n\
                    Get the window's width.\n\
            \n\
                    Gets the width of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UDim describing the width of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getWindowRenderer
        
            typedef ::CEGUI::WindowRenderer * ( ::CEGUI::Window::*getWindowRenderer_function_type )(  ) const;
            
            Window_exposer.def( 
                "getWindowRenderer"
                , getWindowRenderer_function_type( &::CEGUI::Window::getWindowRenderer )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Get the currently assigned WindowRenderer. (Look'N'Feel specification).\n\
            \n\
                @return\n\
                    A pointer to the assigned window renderer object.\n\
                    0 if no window renderer is assigned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getWindowRendererName
        
            typedef ::CEGUI::String ( ::CEGUI::Window::*getWindowRendererName_function_type )(  ) const;
            
            Window_exposer.def( 
                "getWindowRendererName"
                , getWindowRendererName_function_type( &::CEGUI::Window::getWindowRendererName )
                , "*!\n\
                \n\
                    Get the factory name of the currently assigned WindowRenderer.\n\
                    (Look'N'Feel specification).\n\
            \n\
                @return\n\
                    The factory name of the currently assigned WindowRenderer.\n\
                    If no WindowRenderer is assigned an empty string is returned.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::getXPosition
        
            typedef ::CEGUI::UDim const & ( ::CEGUI::Window::*getXPosition_function_type )(  ) const;
            
            Window_exposer.def( 
                "getXPosition"
                , getXPosition_function_type( &::CEGUI::Window::getXPosition )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the window's X position.\n\
            \n\
                    Gets the x position (left edge) of the area occupied by this window.\n\
                    The position is offset from the left edge of this windows parent window\n\
                    or from the left edge of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UDim describing the x position of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::getYPosition
        
            typedef ::CEGUI::UDim const & ( ::CEGUI::Window::*getYPosition_function_type )(  ) const;
            
            Window_exposer.def( 
                "getYPosition"
                , getYPosition_function_type( &::CEGUI::Window::getYPosition )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Get the window's Y position.\n\
            \n\
                    Gets the y position (top edge) of the area occupied by this window.\n\
                    The position is offset from the top edge of this windows parent window\n\
                    or from the top edge of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @return\n\
                    UDim describing the y position of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::hide
        
            typedef void ( ::CEGUI::Window::*hide_function_type )(  ) ;
            
            Window_exposer.def( 
                "hide"
                , hide_function_type( &::CEGUI::Window::hide )
                , "*!\n\
                \n\
                    hide the Window.\n\
                \note\n\
                    If the window is the active window, it will become deactivated as a\n\
                    result of being hidden.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::inheritsAlpha
        
            typedef bool ( ::CEGUI::Window::*inheritsAlpha_function_type )(  ) const;
            
            Window_exposer.def( 
                "inheritsAlpha"
                , inheritsAlpha_function_type( &::CEGUI::Window::inheritsAlpha )
                , "*!\n\
                \n\
                    return true if the Window inherits alpha from its parent(s).\n\
            \n\
                @return\n\
                    - true if the Window inherits alpha from its parent(s)\n\
                    - false if the alpha for this Window is independant from its parents.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::inheritsTooltipText
        
            typedef bool ( ::CEGUI::Window::*inheritsTooltipText_function_type )(  ) const;
            
            Window_exposer.def( 
                "inheritsTooltipText"
                , inheritsTooltipText_function_type( &::CEGUI::Window::inheritsTooltipText )
                , "*!\n\
                \n\
                    Return whether this window inherits Tooltip text from its parent when\n\
                    its own tooltip text is not set.\n\
            \n\
                @return\n\
                    - true if the window inherits tooltip text from its parent when its own\n\
                      text is not set.\n\
                    - false if the window does not inherit tooltip text from its parent\n\
                      (and shows no tooltip when no text is set).\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::initialiseComponents
        
            typedef void ( ::CEGUI::Window::*initialiseComponents_function_type )(  ) ;
            typedef void ( Window_wrapper::*default_initialiseComponents_function_type )(  ) ;
            
            Window_exposer.def( 
                "initialiseComponents"
                , initialiseComponents_function_type(&::CEGUI::Window::initialiseComponents)
                , default_initialiseComponents_function_type(&Window_wrapper::default_initialiseComponents) );
        
        }
        { //::CEGUI::Window::insertText
        
            typedef void ( ::CEGUI::Window::*insertText_function_type )( ::CEGUI::String const &,::size_t const ) ;
            
            Window_exposer.def( 
                "insertText"
                , insertText_function_type( &::CEGUI::Window::insertText )
                , ( bp::arg("text"), bp::arg("position") )
                , "*!\n\
            \n\
                Insert the text string  text into the current text string for the\n\
                Window object at the position specified by  position.\n\
             \n\
            @param text\n\
                String object holding the text that is to be inserted into the Window\n\
                object's current text string.\n\
             \n\
            @param position\n\
                The characted index position where the string  text should be\n\
                inserted.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::invalidate
        
            typedef void ( ::CEGUI::Window::*invalidate_function_type )(  ) ;
            
            Window_exposer.def( 
                "invalidate"
                , invalidate_function_type( &::CEGUI::Window::invalidate )
                , "*!\n\
                \n\
                    Invalidate this window causing at least this window to be redrawn during\n\
                    the next rendering pass.\n\
            \n\
                @return\n\
                    Nothing\n\
            \n\
                 deprecated\n\
                    This function is deprecated in favour of the version taking a boolean.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::invalidate
        
            typedef void ( ::CEGUI::Window::*invalidate_function_type )( bool const ) ;
            
            Window_exposer.def( 
                "invalidate"
                , invalidate_function_type( &::CEGUI::Window::invalidate )
                , ( bp::arg("recursive") )
                , "*!\n\
                \n\
                    Invalidate this window and - dependant upon  recursive - all child\n\
                    content, causing affected windows to be redrawn during the next\n\
                    rendering pass.\n\
            \n\
                @param recursive\n\
                    Boolean value indicating whether attached child content should also be\n\
                    invalidated.\n\
                    - true will cause all child content to be invalidated also.\n\
                    - false will just invalidate this single window.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::invalidateRenderingSurface
        
            typedef void ( ::CEGUI::Window::*invalidateRenderingSurface_function_type )(  ) ;
            
            Window_exposer.def( 
                "invalidateRenderingSurface"
                , invalidateRenderingSurface_function_type( &::CEGUI::Window::invalidateRenderingSurface )
                , "*!\n\
            \n\
                Invalidate the chain of rendering surfaces from this window backwards to\n\
                ensure they get properly redrawn - but doing the minimum amount of work\n\
                possibe - next render.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::isActive
        
            typedef bool ( ::CEGUI::Window::*isActive_function_type )(  ) const;
            
            Window_exposer.def( 
                "isActive"
                , isActive_function_type( &::CEGUI::Window::isActive )
                , "*!\n\
                \n\
                    return true if this is the active Window.  An active window is a window\n\
                    that may receive user inputs.\n\
            \n\
                    Mouse events are always sent to the window containing the mouse cursor\n\
                    regardless of what this function reports (unless a window has captured\n\
                    inputs).  The active state mainly determines where send other, for\n\
                    example keyboard, inputs.\n\
            \n\
                @return\n\
                    - true if the window is active and may be sent inputs by the system.\n\
                    - false if the window is inactive and will not be sent inputs.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isAlwaysOnTop
        
            typedef bool ( ::CEGUI::Window::*isAlwaysOnTop_function_type )(  ) const;
            
            Window_exposer.def( 
                "isAlwaysOnTop"
                , isAlwaysOnTop_function_type( &::CEGUI::Window::isAlwaysOnTop )
                , "*!\n\
                \n\
                    returns whether or not this Window is an always on top Window.  Also\n\
                    known as a top-most window.\n\
            \n\
                @return\n\
                    - true if this Window is always drawn on top of other normal windows.\n\
                    - false if the Window has normal z-order behaviour.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isAncestor
        
            typedef bool ( ::CEGUI::Window::*isAncestor_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "isAncestor"
                , isAncestor_function_type( &::CEGUI::Window::isAncestor )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    return true if the specified Window is some ancestor of this Window\n\
            \n\
                @param name\n\
                    String object holding the name of the Window to check for.\n\
            \n\
                @return\n\
                    - true if a Window named  name is an ancestor (parent, or parent of\n\
                      parent, etc) of this Window.\n\
                    - false if a Window named  name is in no way an ancestor of this\n\
                      window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isAncestor
        
            typedef bool ( ::CEGUI::Window::*isAncestor_function_type )( ::CEGUI::uint ) const;
            
            Window_exposer.def( 
                "isAncestor"
                , isAncestor_function_type( &::CEGUI::Window::isAncestor )
                , ( bp::arg("ID") )
                , "*!\n\
                \n\
                    return true if any Window with the given ID is some ancestor of this\n\
                    Window.\n\
            \n\
                @param ID\n\
                    uint value specifying the ID to look for.\n\
            \n\
                @return\n\
                    - true if an ancestor (parent, or parent of parent, etc) was found with\n\
                      the ID code  ID.\n\
                    - false if no ancestor window has the ID code  ID.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isAncestor
        
            typedef bool ( ::CEGUI::Window::*isAncestor_function_type )( ::CEGUI::Window const * ) const;
            
            Window_exposer.def( 
                "isAncestor"
                , isAncestor_function_type( &::CEGUI::Window::isAncestor )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    return true if the specified Window is some ancestor of this Window.\n\
            \n\
                @param window\n\
                    Pointer to the Window object to look for.\n\
            \n\
                @return\n\
                    - true if  window was found to be an ancestor (parent, or parent of\n\
                      parent, etc) of this Window.\n\
                    - false if  window is not an ancestor of this window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isAutoWindow
        
            typedef bool ( ::CEGUI::Window::*isAutoWindow_function_type )(  ) const;
            
            Window_exposer.def( 
                "isAutoWindow"
                , isAutoWindow_function_type( &::CEGUI::Window::isAutoWindow )
                , "*!\n\
            \n\
                Returns whether this window is an auto-child window.\n\
                All auto-child windows have __auto_ in their name, but this is faster.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::isCapturedByAncestor
        
            typedef bool ( ::CEGUI::Window::*isCapturedByAncestor_function_type )(  ) const;
            
            Window_exposer.def( 
                "isCapturedByAncestor"
                , isCapturedByAncestor_function_type( &::CEGUI::Window::isCapturedByAncestor )
                , "*!\n\
                \n\
                    return true if an ancestor window has captured inputs.\n\
            \n\
                @return\n\
                    - true if input is captured by a Window that is some ancestor (parent,\n\
                      parent of parent, etc) of this Window.\n\
                    - false if no ancestor of this window has captured input.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isCapturedByChild
        
            typedef bool ( ::CEGUI::Window::*isCapturedByChild_function_type )(  ) const;
            
            Window_exposer.def( 
                "isCapturedByChild"
                , isCapturedByChild_function_type( &::CEGUI::Window::isCapturedByChild )
                , "*!\n\
                \n\
                    return true if a child window has captured inputs.\n\
            \n\
                @return\n\
                    - true if input is captured by a Window that is a child of this Window.\n\
                    - false if no child of this window has not captured input.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isCapturedByThis
        
            typedef bool ( ::CEGUI::Window::*isCapturedByThis_function_type )(  ) const;
            
            Window_exposer.def( 
                "isCapturedByThis"
                , isCapturedByThis_function_type( &::CEGUI::Window::isCapturedByThis )
                , "*!\n\
                \n\
                    return true if this Window has input captured.\n\
            \n\
                @return\n\
                    - true if this Window has captured inputs.\n\
                    - false if some other Window, or no Window, has captured inputs.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isChild
        
            typedef bool ( ::CEGUI::Window::*isChild_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "isChild"
                , isChild_function_type( &::CEGUI::Window::isChild )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    returns whether a Window with the specified name is currently attached\n\
                    to this Window as a child.\n\
            \n\
                @param name\n\
                    String object containing the name of the Window to look for.\n\
            \n\
                @return\n\
                    - true if a Window named  name is currently attached to this Window.\n\
                    - false if no such child Window is attached.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isChild
        
            typedef bool ( ::CEGUI::Window::*isChild_function_type )( ::CEGUI::uint ) const;
            
            Window_exposer.def( 
                "isChild"
                , isChild_function_type( &::CEGUI::Window::isChild )
                , ( bp::arg("ID") )
                , "*!\n\
                \n\
                    returns whether at least one window with the given ID code is attached\n\
                    to this Window as a child.\n\
            \n\
                \note\n\
                    ID codes are client assigned and may or may not be unique, and as such,\n\
                    the return from this function will only have meaning to the client code.\n\
            \n\
                @param ID\n\
                    uint ID code to look for.\n\
            \n\
                @return\n\
                    - true if at least one child window was found with the ID code  ID\n\
                    - false if no child window was found with the ID code  ID.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isChild
        
            typedef bool ( ::CEGUI::Window::*isChild_function_type )( ::CEGUI::Window const * ) const;
            
            Window_exposer.def( 
                "isChild"
                , isChild_function_type( &::CEGUI::Window::isChild )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    return true if the given Window is a child of this window.\n\
            \n\
                @param window\n\
                    Pointer to the Window object to look for.\n\
            \n\
                @return\n\
                    - true if Window object  window is attached to this window as a child.\n\
                    - false if Window object  window is not a child of this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isChildRecursive
        
            typedef bool ( ::CEGUI::Window::*isChildRecursive_function_type )( ::CEGUI::uint ) const;
            
            Window_exposer.def( 
                "isChildRecursive"
                , isChildRecursive_function_type( &::CEGUI::Window::isChildRecursive )
                , ( bp::arg("ID") )
                , "*!\n\
                \n\
                    returns whether at least one window with the given ID code is attached\n\
                    to this Window or any of it's children as a child.\n\
            \n\
                \note\n\
                    ID codes are client assigned and may or may not be unique, and as such,\n\
                    the return from this function will only have meaning to the client code.\n\
            \n\
                    WARNING! This function can be very expensive and should only be used\n\
                    when you have no other option available. If you decide to use it anyway,\n\
                    make sure the window hierarchy from the entry point is small.\n\
            \n\
                @param ID\n\
                    uint ID code to look for.\n\
            \n\
                @return\n\
                    - true if at least one child window was found with the ID code  ID\n\
                    - false if no child window was found with the ID code  ID.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isClippedByParent
        
            typedef bool ( ::CEGUI::Window::*isClippedByParent_function_type )(  ) const;
            
            Window_exposer.def( 
                "isClippedByParent"
                , isClippedByParent_function_type( &::CEGUI::Window::isClippedByParent )
                , "*!\n\
                \n\
                    return true if this Window is clipped so that its rendering will not\n\
                    pass outside of its parent Window area.\n\
            \n\
                @return\n\
                    - true if the window will be clipped by its parent Window.\n\
                    - false if the windows rendering may pass outside its parents area\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isDestroyedByParent
        
            typedef bool ( ::CEGUI::Window::*isDestroyedByParent_function_type )(  ) const;
            
            Window_exposer.def( 
                "isDestroyedByParent"
                , isDestroyedByParent_function_type( &::CEGUI::Window::isDestroyedByParent )
                , "*!\n\
                \n\
                    returns whether or not this Window is set to be destroyed when its\n\
                    parent window is destroyed.\n\
            \n\
                @return\n\
                    - true if the Window will be destroyed when its parent is destroyed.\n\
                    - false if the Window will remain when its parent is destroyed.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isDisabled
        
            typedef bool ( ::CEGUI::Window::*isDisabled_function_type )( bool ) const;
            
            Window_exposer.def( 
                "isDisabled"
                , isDisabled_function_type( &::CEGUI::Window::isDisabled )
                , ( bp::arg("localOnly")=(bool)(false) )
                , "*!\n\
                \n\
                    return whether the Window is currently disabled\n\
            \n\
                @param localOnly\n\
                    States whether to only return the state set for this window, and not to\n\
                    factor in inherited state from ancestor windows.\n\
            \n\
                @return\n\
                    - true if the window is disabled.\n\
                    - false if the window is enabled.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isDragDropTarget
        
            typedef bool ( ::CEGUI::Window::*isDragDropTarget_function_type )(  ) const;
            
            Window_exposer.def( 
                "isDragDropTarget"
                , isDragDropTarget_function_type( &::CEGUI::Window::isDragDropTarget )
                , "*!\n\
                \n\
                    Returns whether this Window object will receive events generated by\n\
                    the drag and drop support in the system.\n\
            \n\
                @return\n\
                    - true if the Window is enabled as a drag and drop target.\n\
                    - false if the window is not enabled as a drag and drop target.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isHit
        
            typedef bool ( ::CEGUI::Window::*isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            typedef bool ( Window_wrapper::*default_isHit_function_type )( ::CEGUI::Vector2 const &,bool const ) const;
            
            Window_exposer.def( 
                "isHit"
                , isHit_function_type(&::CEGUI::Window::isHit)
                , default_isHit_function_type(&Window_wrapper::default_isHit)
                , ( bp::arg("position"), bp::arg("allow_disabled")=(bool const)(false) ) );
        
        }
        { //::CEGUI::Window::isMouseAutoRepeatEnabled
        
            typedef bool ( ::CEGUI::Window::*isMouseAutoRepeatEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isMouseAutoRepeatEnabled"
                , isMouseAutoRepeatEnabled_function_type( &::CEGUI::Window::isMouseAutoRepeatEnabled )
                , "*!\n\
                \n\
                    Return whether mouse button down event autorepeat is enabled for this\n\
                    window.\n\
            \n\
                @return\n\
                    - true if autorepeat of mouse button down events is enabled for this\n\
                      window.\n\
                    - false if autorepeat of mouse button down events is not enabled for\n\
                      this window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isMouseInputPropagationEnabled
        
            typedef bool ( ::CEGUI::Window::*isMouseInputPropagationEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isMouseInputPropagationEnabled"
                , isMouseInputPropagationEnabled_function_type( &::CEGUI::Window::isMouseInputPropagationEnabled )
                , "*!\n\
                \n\
                    Return whether mouse input that is not directly handled by this Window\n\
                    (including it's event subscribers) should be propagated back to the\n\
                    Window's parent.\n\
            \n\
                @return\n\
                    - true if unhandled mouse input will be propagated to the parent.\n\
                    - false if unhandled mouse input will not be propagated.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isMousePassThroughEnabled
        
            typedef bool ( ::CEGUI::Window::*isMousePassThroughEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isMousePassThroughEnabled"
                , isMousePassThroughEnabled_function_type( &::CEGUI::Window::isMousePassThroughEnabled )
                , "*!\n\
                \n\
                    Returns whether this window should ignore mouse event and pass them\n\
                    through to and other windows behind it. In effect making the window\n\
                    transparent to the mouse.\n\
            \n\
                @return\n\
                    true if mouse pass through is enabled.\n\
                    false if mouse pass through is not enabled.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isNonClientWindow
        
            typedef bool ( ::CEGUI::Window::*isNonClientWindow_function_type )(  ) const;
            
            Window_exposer.def( 
                "isNonClientWindow"
                , isNonClientWindow_function_type( &::CEGUI::Window::isNonClientWindow )
                , "*!\n\
                \n\
                    Return whether the Window is a non-client window.\n\
            \n\
                    A non-client window is clipped, positioned and sized according to the\n\
                    parent window's full area as opposed to just the inner rect area used\n\
                    for normal client windows.\n\
            \n\
                @return\n\
                    - true if the window should is clipped, positioned and sized according\n\
                    to the full area rectangle of it's parent.\n\
                    - false if the window is be clipped, positioned and sized according\n\
                    to the inner rect area of it's parent.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isPropertyBannedFromXML
        
            typedef bool ( ::CEGUI::Window::*isPropertyBannedFromXML_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "isPropertyBannedFromXML"
                , isPropertyBannedFromXML_function_type( &::CEGUI::Window::isPropertyBannedFromXML )
                , ( bp::arg("property_name") )
                , "! Return whether the named property is banned from XML\n" );
        
        }
        { //::CEGUI::Window::isPropertyBannedFromXML
        
            typedef bool ( ::CEGUI::Window::*isPropertyBannedFromXML_function_type )( ::CEGUI::Property const * ) const;
            
            Window_exposer.def( 
                "isPropertyBannedFromXML"
                , isPropertyBannedFromXML_function_type( &::CEGUI::Window::isPropertyBannedFromXML )
                , ( bp::arg("property") )
                , "! Return whether the given property is banned from XML\n" );
        
        }
        { //::CEGUI::Window::isRiseOnClickEnabled
        
            typedef bool ( ::CEGUI::Window::*isRiseOnClickEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isRiseOnClickEnabled"
                , isRiseOnClickEnabled_function_type( &::CEGUI::Window::isRiseOnClickEnabled )
                , "*!\n\
                \n\
                    Return whether this window will rise to the top of the z-order when\n\
                    clicked with the left mouse button.\n\
            \n\
                \note\n\
                    This is distinguished from the issetZOrderingEnabled setting in that\n\
                    if rise on click is disabled it only affects the users ability to affect\n\
                    the z order of the Window by clicking the mouse; is still possible to\n\
                    programatically alter the Window z-order by calling the moveToFront,\n\
                    moveToBack, moveInFront and moveBehind member functions.  Whereas if z\n\
                    ordering is disabled those functions are also precluded from affecting\n\
                    the Window z position.\n\
            \n\
                @return\n\
                    - true if the window will come to the top of other windows when the left\n\
                      mouse button is pushed within its area.\n\
                    - false if the window does not change z-order position when the left\n\
                      mouse button is pushed within its area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::isTextParsingEnabled
        
            typedef bool ( ::CEGUI::Window::*isTextParsingEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isTextParsingEnabled"
                , isTextParsingEnabled_function_type( &::CEGUI::Window::isTextParsingEnabled )
                , "! return the active RenderedStringParser to be used\n\
            ! return whether text parsing is enabled for this window.\n" );
        
        }
        { //::CEGUI::Window::isUserStringDefined
        
            typedef bool ( ::CEGUI::Window::*isUserStringDefined_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "isUserStringDefined"
                , isUserStringDefined_function_type( &::CEGUI::Window::isUserStringDefined )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Return whether a user string with the specified name exists.\n\
            \n\
                @param name\n\
                    String object holding the name of the string to be checked.\n\
            \n\
                @return\n\
                    - true if a user string named  name exists.\n\
                    - false if no such user string exists.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isUsingAutoRenderingSurface
        
            typedef bool ( ::CEGUI::Window::*isUsingAutoRenderingSurface_function_type )(  ) const;
            
            Window_exposer.def( 
                "isUsingAutoRenderingSurface"
                , isUsingAutoRenderingSurface_function_type( &::CEGUI::Window::isUsingAutoRenderingSurface )
                , "*!\n\
                \n\
                    Returns whether  e automatic use of an imagery caching RenderingSurface\n\
                    (i.e. a RenderingWindow) is enabled for this window.  The reason we\n\
                    emphasise 'automatic' is because the client may manually set a\n\
                    RenderingSurface that does exactly the same job.\n\
            \n\
                @return\n\
                    - true if automatic use of a caching RenderingSurface is enabled.\n\
                    - false if automatic use of a caching RenderTarget is not enabled.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isUsingDefaultTooltip
        
            typedef bool ( ::CEGUI::Window::*isUsingDefaultTooltip_function_type )(  ) const;
            
            Window_exposer.def( 
                "isUsingDefaultTooltip"
                , isUsingDefaultTooltip_function_type( &::CEGUI::Window::isUsingDefaultTooltip )
                , "*!\n\
                \n\
                    Return whether this Window is using the system default Tooltip for its\n\
                    Tooltip window.\n\
            \n\
                @return\n\
                    - true if the Window will use the system default tooltip.\n\
                    - false if the window has a custom Tooltip object.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isVisible
        
            typedef bool ( ::CEGUI::Window::*isVisible_function_type )( bool ) const;
            
            Window_exposer.def( 
                "isVisible"
                , isVisible_function_type( &::CEGUI::Window::isVisible )
                , ( bp::arg("localOnly")=(bool)(false) )
                , "*!\n\
                \n\
                    return true if the Window is currently visible.\n\
            \n\
                    When true is returned from this function does not mean that the window\n\
                    is not completely obscured by other windows, just that the window will\n\
                    be processed when rendering, and is not explicitly marked as hidden.\n\
            \n\
                @param localOnly\n\
                    States whether to only return the state set for this window, and not to\n\
                    factor in inherited state from ancestor windows.\n\
            \n\
                @return\n\
                    - true if the window will be drawn.\n\
                    - false if the window is hidden and therefore ignored when rendering.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::isWritingXMLAllowed
        
            typedef bool ( ::CEGUI::Window::*isWritingXMLAllowed_function_type )(  ) const;
            
            Window_exposer.def( 
                "isWritingXMLAllowed"
                , isWritingXMLAllowed_function_type( &::CEGUI::Window::isWritingXMLAllowed )
                , "*!\n\
            \n\
                Returns whether this window is allowed to write XML.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::isZOrderingEnabled
        
            typedef bool ( ::CEGUI::Window::*isZOrderingEnabled_function_type )(  ) const;
            
            Window_exposer.def( 
                "isZOrderingEnabled"
                , isZOrderingEnabled_function_type( &::CEGUI::Window::isZOrderingEnabled )
                , "*!\n\
                \n\
                    Return whether z-order changes are enabled or disabled for this Window.\n\
            \n\
                \note\n\
                    This is distinguished from the issetRiseOnClickEnabled setting in that\n\
                    if rise on click is disabled it only affects the users ability to affect\n\
                    the z order of the Window by clicking the mouse; is still possible to\n\
                    programatically alter the Window z-order by calling the moveToFront,\n\
                    moveToBack, moveInFront and moveBehind member functions.  Whereas if z\n\
                    ordering is disabled those functions are also precluded from affecting\n\
                    the Window z position.\n\
            \n\
                @return\n\
                    - true if z-order changes are enabled for this window.\n\
                      moveToFront, moveToBack, moveInFront and moveBehind work normally.\n\
                    - false: z-order changes are disabled for this window.\n\
                      moveToFront, moveToBack, moveInFront and moveBehind are ignored.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::moveBehind
        
            typedef void ( ::CEGUI::Window::*moveBehind_function_type )( ::CEGUI::Window const * const ) ;
            
            Window_exposer.def( 
                "moveBehind"
                , moveBehind_function_type( &::CEGUI::Window::moveBehind )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Move this window immediately behind it's sibling  window in the z\n\
                    order.\n\
            \n\
                    No action will be taken under the following conditions:\n\
                    -  window is 0.\n\
                    -  window is not a sibling of this window.\n\
                    -  window and this window have different AlwaysOnTop settings.\n\
                    - z ordering is disabled for this window.\n\
            \n\
                @param window\n\
                    The sibling window that this window will be moved behind.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::moveInFront
        
            typedef void ( ::CEGUI::Window::*moveInFront_function_type )( ::CEGUI::Window const * const ) ;
            
            Window_exposer.def( 
                "moveInFront"
                , moveInFront_function_type( &::CEGUI::Window::moveInFront )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Move this window immediately above it's sibling  window in the z order.\n\
            \n\
                    No action will be taken under the following conditions:\n\
                    -  window is 0.\n\
                    -  window is not a sibling of this window.\n\
                    -  window and this window have different AlwaysOnTop settings.\n\
                    - z ordering is disabled for this window.\n\
            \n\
                @param window\n\
                    The sibling window that this window will be moved in front of.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::moveToBack
        
            typedef void ( ::CEGUI::Window::*moveToBack_function_type )(  ) ;
            
            Window_exposer.def( 
                "moveToBack"
                , moveToBack_function_type( &::CEGUI::Window::moveToBack )
                , "*!\n\
                \n\
                    Move the Window to the bottom of the Z order.\n\
            \n\
                    - If the window is non always-on-top the Window is sent to the very\n\
                      bottom of its sibling windows and the process repeated for all\n\
                      ancestors.\n\
                    - If the window is always-on-top, the Window is sent to the bottom of\n\
                      all sibling always-on-top windows and the process repeated for all\n\
                      ancestors.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::moveToFront
        
            typedef void ( ::CEGUI::Window::*moveToFront_function_type )(  ) ;
            
            Window_exposer.def( 
                "moveToFront"
                , moveToFront_function_type( &::CEGUI::Window::moveToFront )
                , "*!\n\
                \n\
                    Move the Window to the top of the z order.\n\
            \n\
                    - If the Window is a non always-on-top window it is moved the the top of\n\
                      all other non always-on-top sibling windows, and the process repeated\n\
                      for all ancestors.\n\
                    - If the Window is an always-on-top window it is moved to the of of all\n\
                      sibling Windows, and the process repeated for all ancestors.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::notifyDragDropItemDropped
        
            typedef void ( ::CEGUI::Window::*notifyDragDropItemDropped_function_type )( ::CEGUI::DragContainer * ) ;
            
            Window_exposer.def( 
                "notifyDragDropItemDropped"
                , notifyDragDropItemDropped_function_type( &::CEGUI::Window::notifyDragDropItemDropped )
                , ( bp::arg("item") )
                , "*!\n\
            \n\
                Internal support method for drag & drop.  You do not normally call\n\
                this directly from client code.  See the DragContainer class.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::notifyDragDropItemEnters
        
            typedef void ( ::CEGUI::Window::*notifyDragDropItemEnters_function_type )( ::CEGUI::DragContainer * ) ;
            
            Window_exposer.def( 
                "notifyDragDropItemEnters"
                , notifyDragDropItemEnters_function_type( &::CEGUI::Window::notifyDragDropItemEnters )
                , ( bp::arg("item") )
                , "*!\n\
            \n\
                Internal support method for drag & drop.  You do not normally call\n\
                this directly from client code.  See the DragContainer class.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::notifyDragDropItemLeaves
        
            typedef void ( ::CEGUI::Window::*notifyDragDropItemLeaves_function_type )( ::CEGUI::DragContainer * ) ;
            
            Window_exposer.def( 
                "notifyDragDropItemLeaves"
                , notifyDragDropItemLeaves_function_type( &::CEGUI::Window::notifyDragDropItemLeaves )
                , ( bp::arg("item") )
                , "*!\n\
            \n\
                Internal support method for drag & drop.  You do not normally call\n\
                this directly from client code.  See the DragContainer class.\n\
            *\n" );
        
        }
        { //::CEGUI::Window::notifyScreenAreaChanged
        
            typedef void ( ::CEGUI::Window::*notifyScreenAreaChanged_function_type )( bool ) ;
            
            Window_exposer.def( 
                "notifyScreenAreaChanged"
                , notifyScreenAreaChanged_function_type( &::CEGUI::Window::notifyScreenAreaChanged )
                , ( bp::arg("recursive")=(bool)(true) )
                , "*!\n\
                \n\
                    Inform the window, and optionally all children, that screen area\n\
                    rectangles have changed.\n\
            \n\
                @param recursive\n\
                    - true to recursively call notifyScreenAreaChanged on attached child\n\
                      Window objects.\n\
                    - false to just process  e this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::performChildWindowLayout
        
            typedef void ( ::CEGUI::Window::*performChildWindowLayout_function_type )(  ) ;
            typedef void ( Window_wrapper::*default_performChildWindowLayout_function_type )(  ) ;
            
            Window_exposer.def( 
                "performChildWindowLayout"
                , performChildWindowLayout_function_type(&::CEGUI::Window::performChildWindowLayout)
                , default_performChildWindowLayout_function_type(&Window_wrapper::default_performChildWindowLayout) );
        
        }
        { //::CEGUI::Window::releaseInput
        
            typedef void ( ::CEGUI::Window::*releaseInput_function_type )(  ) ;
            
            Window_exposer.def( 
                "releaseInput"
                , releaseInput_function_type( &::CEGUI::Window::releaseInput )
                , "*!\n\
                \n\
                    Releases input capture from this Window.  If this Window does not have\n\
                    inputs captured, nothing happens.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::removeChildWindow
        
            typedef void ( ::CEGUI::Window::*removeChildWindow_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "removeChildWindow"
                , removeChildWindow_function_type( &::CEGUI::Window::removeChildWindow )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Remove the named Window from this windows child list.\n\
            \n\
                @param name\n\
                    String object holding the name of the Window to be removed.  If the\n\
                    Window specified is not attached to this Window, nothing happens.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::removeChildWindow
        
            typedef void ( ::CEGUI::Window::*removeChildWindow_function_type )( ::CEGUI::Window * ) ;
            
            Window_exposer.def( 
                "removeChildWindow"
                , removeChildWindow_function_type( &::CEGUI::Window::removeChildWindow )
                , ( bp::arg("window") )
                , "*!\n\
                \n\
                    Remove the specified Window form this windows child list.\n\
            \n\
                @param window\n\
                    Pointer to the Window object to be removed.  If the  window is not\n\
                    attached to this Window, then nothing happens.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::removeChildWindow
        
            typedef void ( ::CEGUI::Window::*removeChildWindow_function_type )( ::CEGUI::uint ) ;
            
            Window_exposer.def( 
                "removeChildWindow"
                , removeChildWindow_function_type( &::CEGUI::Window::removeChildWindow )
                , ( bp::arg("ID") )
                , "*!\n\
                \n\
                    Remove the first child Window with the specified ID.  If there is more\n\
                    than one attached Window objects with the specified ID, only the fist\n\
                    one encountered will be removed.\n\
            \n\
                @param ID\n\
                    ID number assigned to the Window to be removed.  If no Window with ID\n\
                    code  ID is attached, nothing happens.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::rename
        
            typedef void ( ::CEGUI::Window::*rename_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "rename"
                , rename_function_type( &::CEGUI::Window::rename )
                , ( bp::arg("new_name") )
                , "*!\n\
                \n\
                    Renames the window.\n\
            \n\
                @param new_name\n\
                    String object holding the new name for the window.\n\
            \n\
                @exception AlreadyExistsException\n\
                    thrown if a Window named  new_name already exists in the system.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::render
        
            typedef void ( ::CEGUI::Window::*render_function_type )(  ) ;
            
            Window_exposer.def( 
                "render"
                , render_function_type( &::CEGUI::Window::render )
                , "*!\n\
                \n\
                    Causes the Window object to render itself and all of it's attached\n\
                    children\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::restoresOldCapture
        
            typedef bool ( ::CEGUI::Window::*restoresOldCapture_function_type )(  ) const;
            
            Window_exposer.def( 
                "restoresOldCapture"
                , restoresOldCapture_function_type( &::CEGUI::Window::restoresOldCapture )
                , "*!\n\
                \n\
                    Return whether this window is set to restore old input capture when it\n\
                    loses input capture.\n\
            \n\
                    This is only really useful for certain sub-components for widget\n\
                    writers.\n\
            \n\
                @return\n\
                    - true if the window will restore the previous capture window when it\n\
                      loses input capture.\n\
                    - false if the window will set the capture window to NULL when it loses\n\
                      input capture (this is the default behaviour).\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setAlpha
        
            typedef void ( ::CEGUI::Window::*setAlpha_function_type )( float ) ;
            
            Window_exposer.def( 
                "setAlpha"
                , setAlpha_function_type( &::CEGUI::Window::setAlpha )
                , ( bp::arg("alpha") )
                , "*!\n\
                \n\
                    Set the current alpha value for this window.\n\
            \n\
                \note\n\
                    The alpha value set for any given window may or may not be the final\n\
                    alpha value that is used when rendering.  All window objects, by\n\
                    default, inherit alpha from thier parent window(s) - this will blend\n\
                    child windows, relatively, down the line of inheritance.  This behaviour\n\
                    can be overridden via the setInheritsAlpha() method.  To return the true\n\
                    alpha value that will be applied when rendering, use the\n\
                    getEffectiveAlpha() method.\n\
            \n\
                @param alpha\n\
                    The new alpha value for the window.\n\
                    Value should be between 0.0f and 1.0f.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setAlwaysOnTop
        
            typedef void ( ::CEGUI::Window::*setAlwaysOnTop_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setAlwaysOnTop"
                , setAlwaysOnTop_function_type( &::CEGUI::Window::setAlwaysOnTop )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window is always on top, or not.\n\
            \n\
                @param setting\n\
                    - true to have the Window appear on top of all other non always on top\n\
                      windows\n\
                    - false to allow the window to be covered by other normal windows.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setArea
        
            typedef void ( ::CEGUI::Window::*setArea_function_type )( ::CEGUI::UDim const &,::CEGUI::UDim const &,::CEGUI::UDim const &,::CEGUI::UDim const & ) ;
            
            Window_exposer.def( 
                "setArea"
                , setArea_function_type( &::CEGUI::Window::setArea )
                , ( bp::arg("xpos"), bp::arg("ypos"), bp::arg("width"), bp::arg("height") )
                , "*!\n\
                \n\
                    Set the window area.\n\
            \n\
                    Sets the area occupied by this window.  The defined area is offset from\n\
                    the top-left corner of this windows parent window or from the top-left\n\
                    corner of the display if this window has no parent (i.e. it is the root\n\
                    window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param xpos\n\
                    UDim describing the new x co-ordinate (left edge) of the window area.\n\
            \n\
                @param ypos\n\
                    UDim describing the new y co-ordinate (top-edge) of the window area.\n\
            \n\
                @param width\n\
                    UDim describing the new width of the window area.\n\
            \n\
                @param height\n\
                    UDim describing the new height of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setArea
        
            typedef void ( ::CEGUI::Window::*setArea_function_type )( ::CEGUI::UVector2 const &,::CEGUI::UVector2 const & ) ;
            
            Window_exposer.def( 
                "setArea"
                , setArea_function_type( &::CEGUI::Window::setArea )
                , ( bp::arg("pos"), bp::arg("size") )
                , "*!\n\
                \n\
                    Set the window area.\n\
            \n\
                    Sets the area occupied by this window.  The defined area is offset from\n\
                    the top-left corner of this windows parent window or from the top-left\n\
                    corner of the display if this window has no parent (i.e. it is the root\n\
                    window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param pos\n\
                    UVector2 describing the new position (top-left corner) of the window\n\
                    area.\n\
            \n\
                @param size\n\
                    UVector2 describing the new size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setArea
        
            typedef void ( ::CEGUI::Window::*setArea_function_type )( ::CEGUI::URect const & ) ;
            
            Window_exposer.def( 
                "setArea"
                , setArea_function_type( &::CEGUI::Window::setArea )
                , ( bp::arg("area") )
                , "*!\n\
                \n\
                    Set the window area.\n\
            \n\
                    Sets the area occupied by this window.  The defined area is offset from\n\
                    the top-left corner of this windows parent window or from the top-left\n\
                    corner of the display if this window has no parent (i.e. it is the root\n\
                    window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param area\n\
                    URect describing the new area rectangle of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setAutoRepeatDelay
        
            typedef void ( ::CEGUI::Window::*setAutoRepeatDelay_function_type )( float ) ;
            
            Window_exposer.def( 
                "setAutoRepeatDelay"
                , setAutoRepeatDelay_function_type( &::CEGUI::Window::setAutoRepeatDelay )
                , ( bp::arg("delay") )
                , "*!\n\
                \n\
                    Set the current auto-repeat delay setting for this window.\n\
            \n\
                @param delay\n\
                    float value indicating the delay, in seconds, defore the first repeat\n\
                    mouse button down event should be triggered when autorepeat is enabled.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setAutoRepeatRate
        
            typedef void ( ::CEGUI::Window::*setAutoRepeatRate_function_type )( float ) ;
            
            Window_exposer.def( 
                "setAutoRepeatRate"
                , setAutoRepeatRate_function_type( &::CEGUI::Window::setAutoRepeatRate )
                , ( bp::arg("rate") )
                , "*!\n\
                \n\
                    Set the current auto-repeat rate setting for this window.\n\
            \n\
                @param rate\n\
                    float value indicating the rate, in seconds, at which repeat mouse\n\
                    button down events should be generated after the initial delay has\n\
                    expired.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setClippedByParent
        
            typedef void ( ::CEGUI::Window::*setClippedByParent_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setClippedByParent"
                , setClippedByParent_function_type( &::CEGUI::Window::setClippedByParent )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this Window will be clipped by its parent window(s).\n\
            \n\
                @param setting\n\
                    - true to have the Window clipped so that rendering is constrained to\n\
                      within the area of its parent(s).\n\
                    - false to have rendering constrained to the screen only.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setCustomRenderedStringParser
        
            typedef void ( ::CEGUI::Window::*setCustomRenderedStringParser_function_type )( ::CEGUI::RenderedStringParser * ) ;
            
            Window_exposer.def( 
                "setCustomRenderedStringParser"
                , setCustomRenderedStringParser_function_type( &::CEGUI::Window::setCustomRenderedStringParser )
                , ( bp::arg("parser") )
                , "! Return a pointer to any custom RenderedStringParser set, or 0 if none.\n\
            ! Set a custom RenderedStringParser, or 0 to remove an existing one.\n" );
        
        }
        { //::CEGUI::Window::setDestroyedByParent
        
            typedef void ( ::CEGUI::Window::*setDestroyedByParent_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setDestroyedByParent"
                , setDestroyedByParent_function_type( &::CEGUI::Window::setDestroyedByParent )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether or not this Window will automatically be destroyed when its\n\
                    parent Window is destroyed.\n\
            \n\
                @param setting\n\
                    - true to have the Window auto-destroyed when its parent is destroyed\n\
                      (default behaviour)\n\
                    - false to have the Window remain after its parent is destroyed.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setDistributesCapturedInputs
        
            typedef void ( ::CEGUI::Window::*setDistributesCapturedInputs_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setDistributesCapturedInputs"
                , setDistributesCapturedInputs_function_type( &::CEGUI::Window::setDistributesCapturedInputs )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether the window wants inputs passed to its attached\n\
                    child windows when the window has inputs captured.\n\
            \n\
                @param setting\n\
                    - true if System should pass captured input events to child windows.\n\
                    - false if System should pass captured input events to this window only.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setDragDropTarget
        
            typedef void ( ::CEGUI::Window::*setDragDropTarget_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setDragDropTarget"
                , setDragDropTarget_function_type( &::CEGUI::Window::setDragDropTarget )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Specifies whether this Window object will receive events generated by\n\
                    the drag and drop support in the system.\n\
            \n\
                @param setting\n\
                    - true to enable the Window as a drag and drop target.\n\
                    - false to disable the Window as a drag and drop target.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setEnabled
        
            typedef void ( ::CEGUI::Window::*setEnabled_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setEnabled"
                , setEnabled_function_type( &::CEGUI::Window::setEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window is enabled or disabled.  A disabled window\n\
                    normally can not be interacted with, and may have different rendering.\n\
            \n\
                @param setting\n\
                    - true to enable the Window\n\
                    - false to disable the Window.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setFalagardType
        
            typedef void ( ::CEGUI::Window::*setFalagardType_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setFalagardType"
                , setFalagardType_function_type( &::CEGUI::Window::setFalagardType )
                , ( bp::arg("type"), bp::arg("rendererType")="" )
                , "*!\n\
                \n\
                    Changes the widget's falagard type, thus changing its look'n'feel and optionally its\n\
                    renderer in the process.\n\
            \n\
                @param type\n\
                    New look'n'feel of the widget\n\
            \n\
                @param type\n\
                    New renderer of the widget\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setFont
        
            typedef void ( ::CEGUI::Window::*setFont_function_type )( ::CEGUI::Font * ) ;
            
            Window_exposer.def( 
                "setFont"
                , setFont_function_type( &::CEGUI::Window::setFont )
                , ( bp::arg("font") )
                , "*!\n\
                \n\
                    Set the font used by this Window.\n\
            \n\
                @param font\n\
                    Pointer to the Font object to be used by this Window.\n\
                    If  font is NULL, the default font will be used.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setFont
        
            typedef void ( ::CEGUI::Window::*setFont_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setFont"
                , setFont_function_type( &::CEGUI::Window::setFont )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Set the font used by this Window.\n\
            \n\
                @param name\n\
                    String object holding the name of the Font object to be used by this\n\
                    Window.  If  name == , the default font will be used.\n\
            \n\
                @return\n\
                    Nothing\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if the specified Font is unknown within the system.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setHeight
        
            typedef void ( ::CEGUI::Window::*setHeight_function_type )( ::CEGUI::UDim const & ) ;
            
            Window_exposer.def( 
                "setHeight"
                , setHeight_function_type( &::CEGUI::Window::setHeight )
                , ( bp::arg("height") )
                , "*!\n\
                \n\
                    Set the window's height.\n\
            \n\
                    Sets the height of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param height\n\
                    UDim describing the new height of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setHorizontalAlignment
        
            typedef void ( ::CEGUI::Window::*setHorizontalAlignment_function_type )( ::CEGUI::HorizontalAlignment const ) ;
            
            Window_exposer.def( 
                "setHorizontalAlignment"
                , setHorizontalAlignment_function_type( &::CEGUI::Window::setHorizontalAlignment )
                , ( bp::arg("alignment") )
                , "*!\n\
                \n\
                    Set the horizontal alignment.\n\
            \n\
                    Modifies the horizontal alignment for the window.  This setting affects\n\
                    how the windows position is interpreted relative to its parent.\n\
            \n\
                @param alignment\n\
                    One of the HorizontalAlignment enumerated values.\n\
            \n\
                @return\n\
                    Nothing.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setID
        
            typedef void ( ::CEGUI::Window::*setID_function_type )( ::CEGUI::uint ) ;
            
            Window_exposer.def( 
                "setID"
                , setID_function_type( &::CEGUI::Window::setID )
                , ( bp::arg("ID") )
                , "*!\n\
                \n\
                    Set the current ID for the Window.\n\
            \n\
                @param ID\n\
                    Client assigned ID code for this Window.  The GUI system assigns no\n\
                    meaning to any IDs, they are a device purely for client code usage.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setInheritsAlpha
        
            typedef void ( ::CEGUI::Window::*setInheritsAlpha_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setInheritsAlpha"
                , setInheritsAlpha_function_type( &::CEGUI::Window::setInheritsAlpha )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Sets whether this Window will inherit alpha from its parent windows.\n\
            \n\
                @param setting\n\
                    - true if the Window should use inherited alpha.\n\
                    - false if the Window should have an independant alpha value.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setInheritsTooltipText
        
            typedef void ( ::CEGUI::Window::*setInheritsTooltipText_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setInheritsTooltipText"
                , setInheritsTooltipText_function_type( &::CEGUI::Window::setInheritsTooltipText )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window inherits Tooltip text from its parent when its\n\
                    own tooltip text is not set.\n\
            \n\
                @param setting\n\
                    - true if the window should inherit tooltip text from its parent when\n\
                      its own text is not set.\n\
                    - false if the window should not inherit tooltip text from its parent\n\
                      (and so show no tooltip when no text is set).\n\
            \n\
                @return\n\
                    Nothing.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setLookNFeel
        
            typedef void ( ::CEGUI::Window::*setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            typedef void ( Window_wrapper::*default_setLookNFeel_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setLookNFeel"
                , setLookNFeel_function_type(&::CEGUI::Window::setLookNFeel)
                , default_setLookNFeel_function_type(&Window_wrapper::default_setLookNFeel)
                , ( bp::arg("look") ) );
        
        }
        { //::CEGUI::Window::setMargin
        
            typedef void ( ::CEGUI::Window::*setMargin_function_type )( ::CEGUI::UBox const & ) ;
            typedef void ( Window_wrapper::*default_setMargin_function_type )( ::CEGUI::UBox const & ) ;
            
            Window_exposer.def( 
                "setMargin"
                , setMargin_function_type(&::CEGUI::Window::setMargin)
                , default_setMargin_function_type(&Window_wrapper::default_setMargin)
                , ( bp::arg("margin") ) );
        
        }
        { //::CEGUI::Window::setMaxSize
        
            typedef void ( ::CEGUI::Window::*setMaxSize_function_type )( ::CEGUI::UVector2 const & ) ;
            
            Window_exposer.def( 
                "setMaxSize"
                , setMaxSize_function_type( &::CEGUI::Window::setMaxSize )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Set the window's maximum size.\n\
            \n\
                    Sets the maximum size that this windows area may occupy (whether size\n\
                    changes occur by user interaction, general system operation, or by\n\
                    direct setting by client code).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param size\n\
                    UVector2 describing the new maximum size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setMinSize
        
            typedef void ( ::CEGUI::Window::*setMinSize_function_type )( ::CEGUI::UVector2 const & ) ;
            
            Window_exposer.def( 
                "setMinSize"
                , setMinSize_function_type( &::CEGUI::Window::setMinSize )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Set the window's minimum size.\n\
            \n\
                    Sets the minimum size that this windows area may occupy (whether size\n\
                    changes occur by user interaction, general system operation, or by\n\
                    direct setting by client code).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param size\n\
                    UVector2 describing the new minimum size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setModalState
        
            typedef void ( ::CEGUI::Window::*setModalState_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setModalState"
                , setModalState_function_type( &::CEGUI::Window::setModalState )
                , ( bp::arg("state") )
                , "*!\n\
                \n\
                    Set the modal state for this Window.\n\
            \n\
                @param state\n\
                    Boolean value defining if this Window should be the modal target.\n\
                    - true if this Window should be activated and set as the modal target.\n\
                    - false if the modal target should be cleared if this Window is\n\
                      currently the modal target.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMouseAutoRepeatEnabled
        
            typedef void ( ::CEGUI::Window::*setMouseAutoRepeatEnabled_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setMouseAutoRepeatEnabled"
                , setMouseAutoRepeatEnabled_function_type( &::CEGUI::Window::setMouseAutoRepeatEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether mouse button down event autorepeat is enabled for this\n\
                    window.\n\
            \n\
                @param setting\n\
                    - true to enable autorepeat of mouse button down events.\n\
                    - false to disable autorepeat of mouse button down events.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMouseCursor
        
            typedef void ( ::CEGUI::Window::*setMouseCursor_function_type )( ::CEGUI::Image const * ) ;
            
            Window_exposer.def( 
                "setMouseCursor"
                , setMouseCursor_function_type( &::CEGUI::Window::setMouseCursor )
                , ( bp::arg("image") )
                , "*!\n\
                \n\
                    Set the mouse cursor image to be used when the mouse enters this window.\n\
            \n\
                @param image\n\
                    Pointer to the Image object to use as the mouse cursor image when the\n\
                    mouse enters the area for this Window.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMouseCursor
        
            typedef void ( ::CEGUI::Window::*setMouseCursor_function_type )( ::CEGUI::MouseCursorImage ) ;
            
            Window_exposer.def( 
                "setMouseCursor"
                , setMouseCursor_function_type( &::CEGUI::Window::setMouseCursor )
                , ( bp::arg("image") )
                , "*!\n\
                \n\
                    Set the mouse cursor image to be used when the mouse enters this window.\n\
            \n\
                @param image\n\
                    One of the MouseCursorImage enumerated values.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMouseCursor
        
            typedef void ( ::CEGUI::Window::*setMouseCursor_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setMouseCursor"
                , setMouseCursor_function_type( &::CEGUI::Window::setMouseCursor )
                , ( bp::arg("imageset"), bp::arg("image_name") )
                , "*!\n\
                \n\
                    Set the mouse cursor image to be used when the mouse enters this window.\n\
            \n\
                @param imageset\n\
                    String object that contains the name of the Imageset that contains the\n\
                    image to be used.\n\
            \n\
                @param image_name\n\
                    String object that contains the name of the Image on  imageset that\n\
                    is to be used.\n\
            \n\
                @return\n\
                    Nothing.\n\
            \n\
                @exception UnknownObjectException\n\
                    thrown if  imageset is not known, or if  imageset contains no Image\n\
                    named  image_name.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMouseInputPropagationEnabled
        
            typedef void ( ::CEGUI::Window::*setMouseInputPropagationEnabled_function_type )( bool const ) ;
            
            Window_exposer.def( 
                "setMouseInputPropagationEnabled"
                , setMouseInputPropagationEnabled_function_type( &::CEGUI::Window::setMouseInputPropagationEnabled )
                , ( bp::arg("enabled") )
                , "*!\n\
                \n\
                    Set whether mouse input that is not directly handled by this Window\n\
                    (including it's event subscribers) should be propagated back to the\n\
                    Window's parent.\n\
            \n\
                @param enabled\n\
                    - true if unhandled mouse input should be propagated to the parent.\n\
                    - false if unhandled mouse input should not be propagated.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setMousePassThroughEnabled
        
            typedef void ( ::CEGUI::Window::*setMousePassThroughEnabled_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setMousePassThroughEnabled"
                , setMousePassThroughEnabled_function_type( &::CEGUI::Window::setMousePassThroughEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Sets whether this window should ignore mouse events and pass them\n\
                    through to any windows behind it. In effect making the window\n\
                    transparent to the mouse.\n\
            \n\
                @param setting\n\
                    true if mouse pass through is enabled.\n\
                    false if mouse pass through is not enabled.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setNonClientWindow
        
            typedef void ( ::CEGUI::Window::*setNonClientWindow_function_type )( bool const ) ;
            
            Window_exposer.def( 
                "setNonClientWindow"
                , setNonClientWindow_function_type( &::CEGUI::Window::setNonClientWindow )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether the Window is a non-client window.\n\
            \n\
                    A non-client window is clipped, positioned and sized according to the\n\
                    parent window's full area as opposed to just the inner rect area used\n\
                    for normal client windows.\n\
            \n\
                @param setting\n\
                    - true if the window should be clipped, positioned and sized according\n\
                    to the full area rectangle of it's parent.\n\
                    - false if the window should be clipped, positioned and sized according\n\
                    to the inner rect area of it's parent.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setPosition
        
            typedef void ( ::CEGUI::Window::*setPosition_function_type )( ::CEGUI::UVector2 const & ) ;
            
            Window_exposer.def( 
                "setPosition"
                , setPosition_function_type( &::CEGUI::Window::setPosition )
                , ( bp::arg("pos") )
                , "*!\n\
                \n\
                    Set the window's position.\n\
            \n\
                    Sets the position of the area occupied by this window.  The position is\n\
                    offset from the top-left corner of this windows parent window or from\n\
                    the top-left corner of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param pos\n\
                    UVector2 describing the new position (top-left corner) of the window\n\
                    area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setRenderingSurface
        
            typedef void ( ::CEGUI::Window::*setRenderingSurface_function_type )( ::CEGUI::RenderingSurface * ) ;
            
            Window_exposer.def( 
                "setRenderingSurface"
                , setRenderingSurface_function_type( &::CEGUI::Window::setRenderingSurface )
                , ( bp::arg("surface") )
                , "*!\n\
                \n\
                    Set the RenderingSurface to be associated with this Window, or 0 if\n\
                    none is required.\n\
                \n\
                    If this function is called, and the option for automatic use of an\n\
                    imagery caching RenderingSurface is enabled, any automatically created\n\
                    RenderingSurface will be released, and the affore mentioned option will\n\
                    be disabled.\n\
                \n\
                    If after having set a custom RenderingSurface you then subsequently\n\
                    enable the automatic use of an imagery caching RenderingSurface by\n\
                    calling setUsingAutoRenderingSurface, the previously set\n\
                    RenderingSurface will be disassociated from the Window.  Note that the\n\
                    previous RenderingSurface is not destroyed or cleaned up at all - this\n\
                    is the job of whoever created that object initially.\n\
            \n\
                @param target\n\
                    Pointer to the RenderingSurface object to be associated with the window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setRestoreCapture
        
            typedef void ( ::CEGUI::Window::*setRestoreCapture_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setRestoreCapture"
                , setRestoreCapture_function_type( &::CEGUI::Window::setRestoreCapture )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window will remember and restore the previous window\n\
                    that had inputs captured.\n\
            \n\
                @param setting\n\
                    - true: The window will remember and restore the previous capture\n\
                      window.  The CaptureLost event is not fired on the previous window\n\
                      when this window steals input capture.  When this window releases\n\
                      capture, the old capture window is silently restored.\n\
            \n\
                    - false: Input capture works as normal, each window losing capture is\n\
                      signalled via CaptureLost, and upon the final release of capture, no\n\
                      previous setting is restored (this is the default behaviour).\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setRiseOnClickEnabled
        
            typedef void ( ::CEGUI::Window::*setRiseOnClickEnabled_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setRiseOnClickEnabled"
                , setRiseOnClickEnabled_function_type( &::CEGUI::Window::setRiseOnClickEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window will rise to the top of the z-order when clicked\n\
                    with the left mouse button.\n\
            \n\
                \note\n\
                    This is distinguished from the issetZOrderingEnabled setting in that\n\
                    if rise on click is disabled it only affects the users ability to affect\n\
                    the z order of the Window by clicking the mouse; is still possible to\n\
                    programatically alter the Window z-order by calling the moveToFront,\n\
                    moveToBack, moveInFront and moveBehind member functions.  Whereas if z\n\
                    ordering is disabled those functions are also precluded from affecting\n\
                    the Window z position.\n\
            \n\
                @param setting\n\
                    - true if the window should come to the top of other windows when the\n\
                      left mouse button is pushed within its area.\n\
                    - false if the window should not change z-order position when the left\n\
                      mouse button is pushed within its area.\n\
            \n\
                @return\n\
                    Nothing.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setRotation
        
            typedef void ( ::CEGUI::Window::*setRotation_function_type )( ::CEGUI::Vector3 const & ) ;
            
            Window_exposer.def( 
                "setRotation"
                , setRotation_function_type( &::CEGUI::Window::setRotation )
                , ( bp::arg("rotation") )
                , "! set the rotations for this window.\n" );
        
        }
        { //::CEGUI::Window::setSize
        
            typedef void ( ::CEGUI::Window::*setSize_function_type )( ::CEGUI::UVector2 const & ) ;
            
            Window_exposer.def( 
                "setSize"
                , setSize_function_type( &::CEGUI::Window::setSize )
                , ( bp::arg("size") )
                , "*!\n\
                \n\
                    Set the window's size.\n\
            \n\
                    Sets the size of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param size\n\
                    UVector2 describing the new size of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setText
        
            typedef void ( ::CEGUI::Window::*setText_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setText"
                , setText_function_type( &::CEGUI::Window::setText )
                , ( bp::arg("text") )
                , "*!\n\
                \n\
                    Set the current text string for the Window.\n\
            \n\
                @param text\n\
                    String object containing the text that is to be set as the Window text.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setTextParsingEnabled
        
            typedef void ( ::CEGUI::Window::*setTextParsingEnabled_function_type )( bool const ) ;
            
            Window_exposer.def( 
                "setTextParsingEnabled"
                , setTextParsingEnabled_function_type( &::CEGUI::Window::setTextParsingEnabled )
                , ( bp::arg("setting") )
                , "! return whether text parsing is enabled for this window.\n\
            ! set whether text parsing is enabled for this window.\n" );
        
        }
        { //::CEGUI::Window::setTooltip
        
            typedef void ( ::CEGUI::Window::*setTooltip_function_type )( ::CEGUI::Tooltip * ) ;
            
            Window_exposer.def( 
                "setTooltip"
                , setTooltip_function_type( &::CEGUI::Window::setTooltip )
                , ( bp::arg("tooltip") )
                , "*!\n\
                \n\
                    Set the custom Tooltip object for this Window.  This value may be 0 to\n\
                    indicate that the Window should use the system default Tooltip object.\n\
            \n\
                @param tooltip\n\
                    Pointer to a valid Tooltip based object which should be used as the\n\
                    tooltip for this Window, or 0 to indicate that the Window should use the\n\
                    system default Tooltip object.  Note that when passing a pointer to a\n\
                    Tooltip object, ownership of the Tooltip does not pass to this Window\n\
                    object.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setTooltipText
        
            typedef void ( ::CEGUI::Window::*setTooltipText_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setTooltipText"
                , setTooltipText_function_type( &::CEGUI::Window::setTooltipText )
                , ( bp::arg("tip") )
                , "*!\n\
                \n\
                    Set the tooltip text for this window.\n\
            \n\
                @param tip\n\
                    String object holding the text to be displayed in the tooltip for this\n\
                    Window.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setTooltipType
        
            typedef void ( ::CEGUI::Window::*setTooltipType_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setTooltipType"
                , setTooltipType_function_type( &::CEGUI::Window::setTooltipType )
                , ( bp::arg("tooltipType") )
                , "*!\n\
                \n\
                    Set the custom Tooltip to be used by this Window by specifying a Window\n\
                    type.\n\
            \n\
                    The Window will internally attempt to create an instance of the\n\
                    specified window type (which must be derived from the base Tooltip\n\
                    class).  If the Tooltip creation fails, the error is logged and the\n\
                    Window will revert to using either the existing custom Tooltip or the\n\
                    system default Tooltip.\n\
            \n\
                @param tooltipType\n\
                    String object holding the name of the Tooltip based Window type which\n\
                    should be used as the Tooltip for this Window.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setUpdateMode
        
            typedef void ( ::CEGUI::Window::*setUpdateMode_function_type )( ::CEGUI::WindowUpdateMode const ) ;
            
            Window_exposer.def( 
                "setUpdateMode"
                , setUpdateMode_function_type( &::CEGUI::Window::setUpdateMode )
                , ( bp::arg("mode") )
                , "*!\n\
                \n\
                    Set the window update mode.  This mode controls the behaviour of the\n\
                    Window.update member function such that updates are processed for\n\
                    this window (and therefore it's child content) according to the set\n\
                    mode.\n\
            \n\
                \note\n\
                    Disabling updates can have negative effects on the behaviour of CEGUI\n\
                    windows and widgets; updates should be disabled selectively and\n\
                    cautiously - if you are unsure of what you are doing, leave the mode\n\
                    set to WUM_ALWAYS.\n\
                \n\
                @param mode\n\
                    One of the WindowUpdateMode enumerated values indicating the mode to\n\
                    set for this Window.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setUserString
        
            typedef void ( ::CEGUI::Window::*setUserString_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setUserString"
                , setUserString_function_type( &::CEGUI::Window::setUserString )
                , ( bp::arg("name"), bp::arg("value") )
                , "*!\n\
                \n\
                   Sets the value a named user string, creating it as required.\n\
            \n\
                @param name\n\
                    String object holding the name of the string to be returned.\n\
            \n\
                @param value\n\
                    String object holding the value to be assigned to the user string.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setUsingAutoRenderingSurface
        
            typedef void ( ::CEGUI::Window::*setUsingAutoRenderingSurface_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setUsingAutoRenderingSurface"
                , setUsingAutoRenderingSurface_function_type( &::CEGUI::Window::setUsingAutoRenderingSurface )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Sets whether  e automatic use of an imagery caching RenderingSurface\n\
                    (i.e. a RenderingWindow) is enabled for this window.  The reason we\n\
                    emphasise 'atutomatic' is because the client may manually set a\n\
                    RenderingSurface that does exactlythe same job.\n\
                \n\
                    Note that this setting really only controls whether the Window\n\
                    automatically creates and manages the RenderingSurface, as opposed to\n\
                    the  e use of the RenderingSurface.  If a RenderingSurfaceis set for the\n\
                    Window it will be used regardless of this setting.\n\
                \n\
                    Enabling this option will cause the Window to attempt to create a\n\
                    suitable RenderingSurface (which will actually be a RenderingWindow).\n\
                    If there is an existing RenderingSurface assocated with this Window, it\n\
                    will be removed as the Window's RenderingSurface\n\
                    <em>but not destroyed<em>; whoever created the RenderingSurface in the\n\
                    first place should take care of its destruction.\n\
                \n\
                    Disabling this option will cause any automatically created\n\
                    RenderingSurface to be released.\n\
                \n\
                    It is possible that the renderer in use may not support facilities for\n\
                    RenderingSurfaces that are suitable for full imagery caching.  If this\n\
                    is the case, then calling getRenderingSurface after enabling this option\n\
                    will return 0.  In these cases this option will still show as being\n\
                    'enabled', this is because Window  e settings should not be influenced\n"
            "        by capabilities the renderer in use; for example, this enables correct\n\
                    XML layouts to be written from a Window on a system that does not\n\
                    support such RenderingSurfaces, so that the layout will function as\n\
                    preferred on systems that do.\n\
                \n\
                    If this option is enabled, and the client subsequently assigns a\n\
                    different RenderingSurface to the Window, the existing automatically\n\
                    created RenderingSurface will be released and this setting will be\n\
                    disabled.\n\
            \n\
                @param setting\n\
                    - true to enable automatic use of an imagery caching RenderingSurface.\n\
                    - false to disable automatic use of an imagery caching RenderingSurface.\n\
                *\n\
            " );
        
        }
        { //::CEGUI::Window::setVerticalAlignment
        
            typedef void ( ::CEGUI::Window::*setVerticalAlignment_function_type )( ::CEGUI::VerticalAlignment const ) ;
            
            Window_exposer.def( 
                "setVerticalAlignment"
                , setVerticalAlignment_function_type( &::CEGUI::Window::setVerticalAlignment )
                , ( bp::arg("alignment") )
                , "*!\n\
                \n\
                    Set the vertical alignment.\n\
            \n\
                    Modifies the vertical alignment for the window.  This setting affects\n\
                    how the windows position is interpreted relative to its parent.\n\
            \n\
                @param alignment\n\
                    One of the VerticalAlignment enumerated values.\n\
            \n\
                @return\n\
                    Nothing.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setVisible
        
            typedef void ( ::CEGUI::Window::*setVisible_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setVisible"
                , setVisible_function_type( &::CEGUI::Window::setVisible )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether the Window is visible or hidden.\n\
            \n\
                @param setting\n\
                    - true to make the Window visible.\n\
                    - false to make the Window hidden.\n\
            \n\
                \note\n\
                    Hiding the active window will cause that window to become deactivated.\n\
                    Showing a window does not, however, automatically cause that window to\n\
                    become the active window (call Window.activate after making the window\n\
                    visible to activate it).\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setWantsMultiClickEvents
        
            typedef void ( ::CEGUI::Window::*setWantsMultiClickEvents_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setWantsMultiClickEvents"
                , setWantsMultiClickEvents_function_type( &::CEGUI::Window::setWantsMultiClickEvents )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether this window will receive multi-click events or multiple\n\
                    'down' events instead.\n\
            \n\
                @param setting\n\
                    - true if the Window will receive double-click and triple-click events.\n\
                    - false if the Window will receive multiple mouse button down events\n\
                      instead of doubletriple click events.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setWidth
        
            typedef void ( ::CEGUI::Window::*setWidth_function_type )( ::CEGUI::UDim const & ) ;
            
            Window_exposer.def( 
                "setWidth"
                , setWidth_function_type( &::CEGUI::Window::setWidth )
                , ( bp::arg("width") )
                , "*!\n\
                \n\
                    Set the window's width.\n\
            \n\
                    Sets the width of the area occupied by this window.\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param width\n\
                    UDim describing the new width of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setWindowRenderer
        
            typedef void ( ::CEGUI::Window::*setWindowRenderer_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "setWindowRenderer"
                , setWindowRenderer_function_type( &::CEGUI::Window::setWindowRenderer )
                , ( bp::arg("name") )
                , "*!\n\
                \n\
                    Assign the WindowRenderer to specify the Look'N'Feel specification\n\
                    to be used.\n\
            \n\
                @param name\n\
                    The factory name of the WindowRenderer to use.\n\
            \n\
                \note\n\
                    Once a window renderer has been assigned it is locked - as in cannot be changed.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::setWritingXMLAllowed
        
            typedef void ( ::CEGUI::Window::*setWritingXMLAllowed_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setWritingXMLAllowed"
                , setWritingXMLAllowed_function_type( &::CEGUI::Window::setWritingXMLAllowed )
                , ( bp::arg("allow") )
                , "*!\n\
            \n\
                Sets whether this window is allowed to write XML\n\
            *\n" );
        
        }
        { //::CEGUI::Window::setXPosition
        
            typedef void ( ::CEGUI::Window::*setXPosition_function_type )( ::CEGUI::UDim const & ) ;
            
            Window_exposer.def( 
                "setXPosition"
                , setXPosition_function_type( &::CEGUI::Window::setXPosition )
                , ( bp::arg("x") )
                , "*!\n\
                \n\
                    Set the window's X position.\n\
            \n\
                    Sets the x position (left edge) of the area occupied by this window.\n\
                    The position is offset from the left edge of this windows parent window\n\
                    or from the left edge of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param x\n\
                    UDim describing the new x position of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setYPosition
        
            typedef void ( ::CEGUI::Window::*setYPosition_function_type )( ::CEGUI::UDim const & ) ;
            
            Window_exposer.def( 
                "setYPosition"
                , setYPosition_function_type( &::CEGUI::Window::setYPosition )
                , ( bp::arg("y") )
                , "*!\n\
                \n\
                    Set the window's Y position.\n\
            \n\
                    Sets the y position (top edge) of the area occupied by this window.\n\
                    The position is offset from the top edge of this windows parent window\n\
                    or from the top edge of the display if this window has no parent\n\
                    (i.e. it is the root window).\n\
            \n\
                \note\n\
                    This method makes use of Unified Dimensions.  These contain both\n\
                    parent relative and absolute pixel components, which are used in\n\
                    determining the final value used.\n\
            \n\
                @param y\n\
                    UDim describing the new y position of the window area.\n\
                 *\n" );
        
        }
        { //::CEGUI::Window::setZOrderingEnabled
        
            typedef void ( ::CEGUI::Window::*setZOrderingEnabled_function_type )( bool ) ;
            
            Window_exposer.def( 
                "setZOrderingEnabled"
                , setZOrderingEnabled_function_type( &::CEGUI::Window::setZOrderingEnabled )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Set whether z-order changes are enabled or disabled for this Window.\n\
            \n\
                \note\n\
                    This is distinguished from the issetRiseOnClickEnabled setting in that\n\
                    if rise on click is disabled it only affects the users ability to affect\n\
                    the z order of the Window by clicking the mouse; is still possible to\n\
                    programatically alter the Window z-order by calling the moveToFront,\n\
                    moveToBack, moveInFront and moveBehind member functions.  Whereas if z\n\
                    ordering is disabled those functions are also precluded from affecting\n\
                    the Window z position.\n\
            \n\
                @param setting\n\
                    - true if z-order changes are enabled for this window.\n\
                      moveToFront, moveToBack, moveInFront and moveBehind work normally.\n\
                    - false: z-order changes are disabled for this window.\n\
                      moveToFront, moveToBack, moveInFront and moveBehind are ignored.\n\
            \n\
                @return\n\
                    Nothing.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::show
        
            typedef void ( ::CEGUI::Window::*show_function_type )(  ) ;
            
            Window_exposer.def( 
                "show"
                , show_function_type( &::CEGUI::Window::show )
                , "*!\n\
                \n\
                    show the Window.\n\
            \n\
                \note\n\
                    Showing a window does not automatically activate the window.  If you\n\
                    want the window to also become active you will need to call the\n\
                    Window.activate member also.\n\
            \n\
                @return\n\
                    Nothing\n\
                *\n" );
        
        }
        { //::CEGUI::Window::testClassName
        
            typedef bool ( ::CEGUI::Window::*testClassName_function_type )( ::CEGUI::String const & ) const;
            
            Window_exposer.def( 
                "testClassName"
                , testClassName_function_type( &::CEGUI::Window::testClassName )
                , ( bp::arg("class_name") )
                , "*!\n\
                \n\
                    Return whether this window was inherited from the given class name at\n\
                    some point in the inheritance hierarchy.\n\
            \n\
                @param class_name\n\
                    The class name that is to be checked.\n\
            \n\
                @return\n\
                    true if this window was inherited from  class_name. false if not.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::unbanPropertyFromXML
        
            typedef void ( ::CEGUI::Window::*unbanPropertyFromXML_function_type )( ::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "unbanPropertyFromXML"
                , unbanPropertyFromXML_function_type( &::CEGUI::Window::unbanPropertyFromXML )
                , ( bp::arg("property_name") )
                , "! Remove the named property from the XML ban list for this window.\n" );
        
        }
        { //::CEGUI::Window::unbanPropertyFromXML
        
            typedef void ( ::CEGUI::Window::*unbanPropertyFromXML_function_type )( ::CEGUI::Property const * ) ;
            
            Window_exposer.def( 
                "unbanPropertyFromXML"
                , unbanPropertyFromXML_function_type( &::CEGUI::Window::unbanPropertyFromXML )
                , ( bp::arg("property") )
                , "! Remove the given property from the XML ban list for this window.\n" );
        
        }
        { //::CEGUI::Window::update
        
            typedef void ( ::CEGUI::Window::*update_function_type )( float ) ;
            typedef void ( Window_wrapper::*default_update_function_type )( float ) ;
            
            Window_exposer.def( 
                "update"
                , update_function_type(&::CEGUI::Window::update)
                , default_update_function_type(&Window_wrapper::default_update)
                , ( bp::arg("elapsed") ) );
        
        }
        { //::CEGUI::Window::wantsMultiClickEvents
        
            typedef bool ( ::CEGUI::Window::*wantsMultiClickEvents_function_type )(  ) const;
            
            Window_exposer.def( 
                "wantsMultiClickEvents"
                , wantsMultiClickEvents_function_type( &::CEGUI::Window::wantsMultiClickEvents )
                , "*!\n\
                \n\
                    Return whether this window will receive multi-click events or multiple\n\
                    'down' events instead.\n\
            \n\
                @return\n\
                    - true if the Window will receive double-click and triple-click events.\n\
                    - false if the Window will receive multiple mouse button down events\n\
                      instead of doubletriple click events.\n\
                *\n" );
        
        }
        { //::CEGUI::Window::writeXMLToStream
        
            typedef void ( ::CEGUI::Window::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            typedef void ( Window_wrapper::*default_writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            Window_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type(&::CEGUI::Window::writeXMLToStream)
                , default_writeXMLToStream_function_type(&Window_wrapper::default_writeXMLToStream)
                , ( bp::arg("xml_stream") ) );
        
        }
        Window_exposer.add_static_property( "AutoWidgetNameSuffix"
                        , bp::make_getter( &CEGUI::Window::AutoWidgetNameSuffix
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventActivated"
                        , bp::make_getter( &CEGUI::Window::EventActivated
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventAlphaChanged"
                        , bp::make_getter( &CEGUI::Window::EventAlphaChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventAlwaysOnTopChanged"
                        , bp::make_getter( &CEGUI::Window::EventAlwaysOnTopChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventCharacterKey"
                        , bp::make_getter( &CEGUI::Window::EventCharacterKey
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventChildAdded"
                        , bp::make_getter( &CEGUI::Window::EventChildAdded
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventChildRemoved"
                        , bp::make_getter( &CEGUI::Window::EventChildRemoved
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventClippedByParentChanged"
                        , bp::make_getter( &CEGUI::Window::EventClippedByParentChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDeactivated"
                        , bp::make_getter( &CEGUI::Window::EventDeactivated
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDestroyedByParentChanged"
                        , bp::make_getter( &CEGUI::Window::EventDestroyedByParentChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDestructionStarted"
                        , bp::make_getter( &CEGUI::Window::EventDestructionStarted
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDisabled"
                        , bp::make_getter( &CEGUI::Window::EventDisabled
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDragDropItemDropped"
                        , bp::make_getter( &CEGUI::Window::EventDragDropItemDropped
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDragDropItemEnters"
                        , bp::make_getter( &CEGUI::Window::EventDragDropItemEnters
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventDragDropItemLeaves"
                        , bp::make_getter( &CEGUI::Window::EventDragDropItemLeaves
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventEnabled"
                        , bp::make_getter( &CEGUI::Window::EventEnabled
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventFontChanged"
                        , bp::make_getter( &CEGUI::Window::EventFontChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventHidden"
                        , bp::make_getter( &CEGUI::Window::EventHidden
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventHorizontalAlignmentChanged"
                        , bp::make_getter( &CEGUI::Window::EventHorizontalAlignmentChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventIDChanged"
                        , bp::make_getter( &CEGUI::Window::EventIDChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventInheritsAlphaChanged"
                        , bp::make_getter( &CEGUI::Window::EventInheritsAlphaChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventInputCaptureGained"
                        , bp::make_getter( &CEGUI::Window::EventInputCaptureGained
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventInputCaptureLost"
                        , bp::make_getter( &CEGUI::Window::EventInputCaptureLost
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventKeyDown"
                        , bp::make_getter( &CEGUI::Window::EventKeyDown
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventKeyUp"
                        , bp::make_getter( &CEGUI::Window::EventKeyUp
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMarginChanged"
                        , bp::make_getter( &CEGUI::Window::EventMarginChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseButtonDown"
                        , bp::make_getter( &CEGUI::Window::EventMouseButtonDown
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseButtonUp"
                        , bp::make_getter( &CEGUI::Window::EventMouseButtonUp
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseClick"
                        , bp::make_getter( &CEGUI::Window::EventMouseClick
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseDoubleClick"
                        , bp::make_getter( &CEGUI::Window::EventMouseDoubleClick
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseEnters"
                        , bp::make_getter( &CEGUI::Window::EventMouseEnters
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseEntersArea"
                        , bp::make_getter( &CEGUI::Window::EventMouseEntersArea
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseLeaves"
                        , bp::make_getter( &CEGUI::Window::EventMouseLeaves
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseLeavesArea"
                        , bp::make_getter( &CEGUI::Window::EventMouseLeavesArea
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseMove"
                        , bp::make_getter( &CEGUI::Window::EventMouseMove
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseTripleClick"
                        , bp::make_getter( &CEGUI::Window::EventMouseTripleClick
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMouseWheel"
                        , bp::make_getter( &CEGUI::Window::EventMouseWheel
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventMoved"
                        , bp::make_getter( &CEGUI::Window::EventMoved
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventNonClientChanged"
                        , bp::make_getter( &CEGUI::Window::EventNonClientChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventParentSized"
                        , bp::make_getter( &CEGUI::Window::EventParentSized
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventRenderingEnded"
                        , bp::make_getter( &CEGUI::Window::EventRenderingEnded
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventRenderingStarted"
                        , bp::make_getter( &CEGUI::Window::EventRenderingStarted
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventRotated"
                        , bp::make_getter( &CEGUI::Window::EventRotated
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventShown"
                        , bp::make_getter( &CEGUI::Window::EventShown
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventSized"
                        , bp::make_getter( &CEGUI::Window::EventSized
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventTextChanged"
                        , bp::make_getter( &CEGUI::Window::EventTextChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventTextParsingChanged"
                        , bp::make_getter( &CEGUI::Window::EventTextParsingChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventVerticalAlignmentChanged"
                        , bp::make_getter( &CEGUI::Window::EventVerticalAlignmentChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventWindowRendererAttached"
                        , bp::make_getter( &CEGUI::Window::EventWindowRendererAttached
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventWindowRendererDetached"
                        , bp::make_getter( &CEGUI::Window::EventWindowRendererDetached
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventWindowUpdated"
                        , bp::make_getter( &CEGUI::Window::EventWindowUpdated
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "EventZOrderChanged"
                        , bp::make_getter( &CEGUI::Window::EventZOrderChanged
                                , bp::return_value_policy< bp::return_by_value >() ) );
        Window_exposer.add_static_property( "TooltipNameSuffix"
                        , bp::make_getter( &CEGUI::Window::TooltipNameSuffix
                                , bp::return_value_policy< bp::return_by_value >() ) );
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( Window_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&Window_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( Window_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&Window_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( Window_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            Window_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&Window_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        Window_exposer.staticmethod( "getCaptureWindow" );
        Window_exposer.def ("setUserData", &::Window_setUserData);;
        Window_exposer.def ("getUserData", &::Window_getUserData);;
    }

}
