#ifndef __CDW_UI_H
#define __CDW_UI_H

#include <ncurses.h>
#include <dirent.h>

typedef struct file_item {
	char filename[255];
	int type;
	int size;
} fileitem;

int fill_filelist(char *dir, fileitem **filei, struct dirent **eps, int n);

void fill_info(void);

void put_addwin(int width, int height, int y, int x);

void mainform_init(void);
int mainform_clean(void);

int conditional_volume_label_dialog(void);

int select_window(bool real);
int blank_method_selector(void);
int cdw_title_init(void);
void scroll_addlist(WINDOW *addwinlist, int menupos, fileitem *filei, int maxfiles);
void cdmenu_clean(void);
void menu_clean(void);
void title_clean(void);
int cdw_curses_init(void);


void delete_files(void);
void size_selector(void);

#endif /* _CDW_UI_H */
