/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <locale.h>
#include <libintl.h>
#include <fcntl.h> 
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <ncursesw/ncurses.h>
#include <regex.h>
#include <pthread.h>
#include <nl_types.h>
#include <time.h>
#include "options.h"
#include "gettext.h"
#include "config.h"
#include "isosize.h"


#ifdef GTK_GUI
#include <gtk/gtk.h>
#include <glib.h>
#include "gtkgui.h"
#include "gtk_thread.h"


#define BUFSIZE 1000
#define IMAGE_BUF 131072


static FILE *logf;
int    stdin_pipe[2];
int    stdout_pipe[2];
int    stderr_pipe[2];
char cmd[200], *window;
int total_size_gtk = 0;
struct conf config;
int size, lasttrack_gtk=0;
GtkWidget *dialog, *label[4], *progress, *vbox; 
GtkAdjustment *adj;
pthread_mutex_t gtk_mutex = PTHREAD_MUTEX_INITIALIZER;
time_t time0;
time_t time1;
int prev_percent_gtk=0;
int eta;
int eta_hour;
int eta_min;
int eta_sec;
char seta_hour[3];
char seta_min[3];
char seta_sec[3];

// I see CDrecorder version 0.1 source, and I write this code after this!!!
// THX to Sharad Mittal
gpointer print_stdout_gtk(gpointer data)
{
    regex_t *regex, *regex2, *regex3;
    regmatch_t *matches, *matches2, *matches3;
    int rv;
    char buf[BUFSIZE], buffer[BUFSIZE+1], done[10] = "\0", topstat[30], bottomstat[30], fifostr[30], etime[30];
    int data_processed;
    float per_done;
    
    // Image writing...    
    regex = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex, "Track ([0-9]+): ([ ]*)([0-9]+) of ([ ]*)([0-9]+) MB written ([(])fifo([ ]*)([0-9]+)", REG_EXTENDED);
    matches = (regmatch_t*) calloc (1, (regex->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
	regerror (rv, NULL, buf, sizeof(buf));
	fprintf (stderr, "ERROR regcomp: %s\n", buf);
	exit (1);
    }

    // Direct writing...
    regex3 = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex3, "Track ([0-9]+): ([ ]*)([0-9]+) MB written ([(])fifo([ ]*)([0-9]+)", REG_EXTENDED);
    matches3 = (regmatch_t*) calloc (1, (regex3->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
         regerror (rv, NULL, buf, sizeof(buf));
         fprintf (stderr, "ERROR regcomp: %s\n", buf);
         exit (1);
    }

    // Fixating...
    regex2 = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex2, _("Fixating..."), REG_EXTENDED);
    matches2 = (regmatch_t*) calloc (1, (regex2->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
	regerror (rv, NULL, buf, sizeof(buf));
	fprintf (stderr, "ERROR regcomp: %s\n", buf);
	exit (1);
    }
    
    while (1) {
	memset(buffer, '\0', sizeof(buffer));
	data_processed=read(stdout_pipe[0],buffer,BUFSIZE);
	pthread_mutex_lock(&gtk_mutex);
	if (data_processed != -1) {
	    int rv1,rv2,rv3;
	    fprintf(logf, buffer);	
	    fflush(logf);
	    rv1 = regexec (regex, buffer, regex->re_nsub+1, matches, 0);
	    if ( rv1 == 0 ) {
        	int i;
            	for (i = 0; i < (regex->re_nsub+1); ++i)
            	{
            	    int len = matches[i].rm_eo - matches[i].rm_so;
            	    strncpy (buf, (char *)&buffer[matches[i].rm_so], len);
            	    buf[len] = '\0';
            	    if ((i==8)) {
                        int fifo = atoi((char *)&buf);
			sprintf(fifostr, _("  Fifo: %d%%  "), fifo);
//			if (fifo<=25)
//			    wattrset(processwin, COLOR_PAIR(7));
			gtk_label_set_text(GTK_LABEL(label[2]), fifostr);	
            	    }
            	    if ((i==5)) {
                        int new_total = atoi((char *)&buf);
                        if (total_size_gtk < new_total) {
                	    total_size_gtk = new_total;
                        }
            	    }
            	    if ((i==3)&&(total_size_gtk)) {
                        int current_done = atoi((char *)&buf);
		        int pos;
                        per_done = ((float)current_done)/((float)total_size_gtk);
		        if ((per_done>=0.0)&&(per_done<=1.0)) {
			    //if (prev_percent_gtk!=per_done) {
				time1 = time(NULL);
				eta=(difftime(time1, time0)/current_done)*(total_size_gtk-current_done);
				eta_hour=(eta/60)/60;
				eta_min=(eta-((eta_hour*60)*60))/60;
				eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
				if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
				else sprintf(seta_hour, "%d", eta_hour);
				if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
				else sprintf(seta_min, "%d", eta_min);
				if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
				else sprintf(seta_sec, "%d", eta_sec);
				sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
				gtk_label_set_text(GTK_LABEL(label[3]), etime);
				prev_percent_gtk=per_done;
			    //}
			    sprintf(bottomstat, _("%d / %d MB done"),current_done, total_size_gtk);
			    gtk_label_set_text(GTK_LABEL(label[0]), bottomstat);
			    sprintf(topstat, _("%2.1f%% done"), per_done*100);
			    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), topstat);
			    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(per_done));
#ifdef DEBUG
			    g_print("%6.2f", (float)(per_done));
#endif
			}
            	    }
            	    if (i==3) {
                	int current_done = atoi((char *)&buf);
                	sprintf(done,_("%d MB"),current_done);
            	    }
            	    if ( (i==1) ) {
                	int tracknum = atoi((char *)&buf);
			int pos;
			if (tracknum!=lasttrack_gtk) {
			    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), 0);
#ifdef DEBUG
			    g_print("%6.2f", (float)0);
#endif
			}
			sprintf(bottomstat, _("Track: %d"),tracknum);
			gtk_label_set_text(GTK_LABEL(label[1]), bottomstat);
			lasttrack_gtk=tracknum;
            	    }
        	}
    	    }
	    rv3 = regexec (regex3, buffer, regex3->re_nsub+1, matches3, 0);
	    if ( rv3 == 0 ) {
        	int i;
            	for (i = 0; i < (regex3->re_nsub+1); ++i)
            	{
            	    int len = matches3[i].rm_eo - matches3[i].rm_so;
            	    strncpy (buf, (char *)&buffer[matches3[i].rm_so], len);
            	    buf[len] = '\0';
            	    if ((i==6)) {
                        int fifo = atoi((char *)&buf);
			sprintf(fifostr, _("  Fifo: %d%%  "), fifo);
//			if (fifo<=25)
//			    wattrset(processwin, COLOR_PAIR(7));
			gtk_label_set_text(GTK_LABEL(label[2]), fifostr);
            	    }
            	    if ((i==3) && (size)) {
                        int current_done = atoi((char *)&buf);
		        int pos;
                        per_done = ((float)current_done)/((float)size);
		        if ((per_done>=0.0)&&(per_done<=1.0)) {
			    //if (prev_percent_gtk!=per_done) {
				time1 = time(NULL);
				eta=(difftime(time1, time0)/current_done)*(total_size_gtk-current_done);
				eta_hour=(eta/60)/60;
				eta_min=(eta-((eta_hour*60)*60))/60;
				eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
				if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
				else sprintf(seta_hour, "%d", eta_hour);
				if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
				else sprintf(seta_min, "%d", eta_min);
				if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
				else sprintf(seta_sec, "%d", eta_sec);
				sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
				gtk_label_set_text(GTK_LABEL(label[3]), etime);
				prev_percent_gtk=per_done;
			    //}
			    sprintf(bottomstat, _("%d / %d MB done"),current_done, size);
			    gtk_label_set_text(GTK_LABEL(label[0]), bottomstat);
			    sprintf(topstat, _("%2.1f%% done"), per_done*100);
			    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), topstat);
			    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(per_done));
#ifdef DEBUG
			    g_print("%6.2f", (float)(per_done));
#endif
			}
            	    }
            	    if ( (i==3) && (!size) ) {
                	int current_done = atoi((char *)&buf);
			sprintf(bottomstat, _("%d MB done"),current_done);
			gtk_label_set_text(GTK_LABEL(label[0]), bottomstat);
            	    }
            	    if ( (i==1) ) {
                	int tracknum = atoi((char *)&buf);
			int pos;
			if (tracknum!=lasttrack_gtk) {
			    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), 0);
#ifdef DEBUG
			    g_print("%6.2f", (float)0);
#endif
			}
			sprintf(bottomstat, _("Track: %d"),tracknum);
			gtk_label_set_text(GTK_LABEL(label[1]), bottomstat);
			lasttrack_gtk=tracknum;
            	    }
        	}
    	    }
	    rv2 = regexec (regex2, buffer, regex2->re_nsub, matches2, 0);
	    if ((rv2 == 0)&&(rv1 != 0)) {
		int pos;
		gtk_label_set_text(GTK_LABEL(label[0]), "");
		gtk_label_set_text(GTK_LABEL(label[1]), "");
		gtk_label_set_text(GTK_LABEL(label[2]), "");
		sprintf(topstat, _("Fixating..."));
		gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), topstat);
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), 1);
#ifdef DEBUG
		g_print("%6.2f", (float)1);
#endif
	    }
	}
        while (gtk_events_pending())
              gtk_main_iteration();
	pthread_mutex_unlock(&gtk_mutex);
        if(data_processed == 0) break;
        usleep(10);
	
    }
    free(regex);
    free(regex2);
    return NULL;
}

gpointer print_stderr_gtk(gpointer data)
{
    char buffer_err[BUFSIZE+1];
    char buf[BUFSIZE], percent[30], etime[30];
    int data_processed_err, rv;
    regex_t *regex, *regex2;
    regmatch_t *matches, *matches2;


    // Mkisofs process
     regex = (regex_t*) calloc (1, sizeof(regex_t));
     rv = regcomp (regex, "([ ]*)([0-9]+).([0-9]+)% done,", REG_EXTENDED);
     matches = (regmatch_t*) calloc (1, (regex->re_nsub+1) * sizeof(regmatch_t));
     if (rv)
     {
          regerror (rv, NULL, buf, sizeof(buf));
          fprintf (stderr, "ERROR regcomp: %s\n", buf);
          exit (1);
     }
     // Mkisofs 100%
     regex2 = (regex_t*) calloc (1, sizeof(regex_t));
     rv = regcomp (regex2, "Total translation table size", REG_EXTENDED);
     matches2 = (regmatch_t*) calloc (1, (regex2->re_nsub+1) * sizeof(regmatch_t));
     if (rv)
     {
          regerror (rv, NULL, buf, sizeof(buf));
          fprintf (stderr, "ERROR regcomp: %s\n", buf);
          exit (1);
     }

    while (1) {
	memset(buffer_err, '\0', sizeof(buffer_err));
	data_processed_err=read(stderr_pipe[0],buffer_err,BUFSIZE);
	pthread_mutex_lock(&gtk_mutex);
	if (data_processed_err != -1) {
	    int rv1;
	    int rv2;
	    char c1[5], c2[5], c3[5], c4[5], c5[5], tmp[25];
	    int perc;
	    
	    fprintf(logf, buffer_err);
	    
	    // Cdda2wav process
	    // ??/??/??/???????   0%
	    if (sscanf(buffer_err, "%s %s %s %s %s %s", c1, c2, c3, c4, c5, tmp) == 5 ){
		perc=atoi(c5);
		
		if ( (strcmp(window, _("Grab Audio CD") )==0) && (perc<=100) ){
		    int pos;

		    //if (prev_percent_gtk!=perc) {
			time1 = time(NULL);
			eta=(difftime(time1, time0)/perc)*(100-perc);
			eta_hour=(eta/60)/60;
			eta_min=(eta-((eta_hour*60)*60))/60;
			eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			else sprintf(seta_hour, "%d", eta_hour);
			if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			else sprintf(seta_min, "%d", eta_min);
			if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			else sprintf(seta_sec, "%d", eta_sec);
			sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			gtk_label_set_text(GTK_LABEL(label[3]), etime);
			prev_percent_gtk=perc;
		    //}
		    gtk_label_set_text(GTK_LABEL(label[1]), "");
		    gtk_label_set_text(GTK_LABEL(label[2]), "");
		    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(perc)/100);
#ifdef DEBUG
		    g_print("%6.2f", (float)(perc)/100);
#endif
		    sprintf(percent, "  %d%% %s  ", perc, _("done"));
		    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), percent);
		    fflush(logf);
		    buffer_err[0]='\0';
		 }
	    }
	    
	    rv1 = regexec (regex, buffer_err, regex->re_nsub+1, matches, 0);
            if ((rv1 == 0) && (strcmp(window, _("Write direct"))!=0)) {
		int i;
                for (i = 0; i < (regex->re_nsub+1); ++i)
                {
		    int len = matches[i].rm_eo - matches[i].rm_so;
		    strncpy (buf, (char *)&buffer_err[matches[i].rm_so], len);
		    buf[len] = '\0';
                    if (i==2) {
			int current_done = atoi((char *)&buf);
			int pos;

			//if (prev_percent_gtk!=perc) {
			    time1 = time(NULL);
			    eta=(difftime(time1, time0)/current_done)*(100-current_done);
			    eta_hour=(eta/60)/60;
			    eta_min=(eta-((eta_hour*60)*60))/60;
			    eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			    if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			    else sprintf(seta_hour, "%d", eta_hour);
			    if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			    else sprintf(seta_min, "%d", eta_min);
			    if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			    else sprintf(seta_sec, "%d", eta_sec);
			    sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			    gtk_label_set_text(GTK_LABEL(label[3]), etime);
			    prev_percent_gtk=perc;
			//}
			sprintf(percent, _("%d%% done"),current_done);
			gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), percent);
			gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(current_done)/100);
#ifdef DEBUG
			g_print("%6.2f", (float)(current_done)/100);
#endif
                    }
                }
	    }
	    rv2 = regexec (regex2, buffer_err, regex2->re_nsub+1, matches2, 0);
            if ((rv2 == 0) && (strcmp(window, _("Write direct"))!=0)) {
		int i;
                for (i = 0; i < (regex2->re_nsub+1); ++i)
                {
		    int len = matches2[i].rm_eo - matches2[i].rm_so;
		    int current_done = 99;
		    int pos;
		    strncpy (buf, (char *)&buffer_err[matches2[i].rm_so], len);
		    buf[len] = '\0';
		    //if (prev_percent_gtk!=perc) {
			time1 = time(NULL);
			eta=(difftime(time1, time0)/current_done)*(100-current_done);
			eta_hour=(eta/60)/60;
			eta_min=(eta-((eta_hour*60)*60))/60;
			eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			else sprintf(seta_hour, "%d", eta_hour);
			if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			else sprintf(seta_min, "%d", eta_min);
			if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			else sprintf(seta_sec, "%d", eta_sec);
			sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			gtk_label_set_text(GTK_LABEL(label[3]), etime);
			prev_percent_gtk=perc;
		    //}
		    sprintf(percent, _("%d%% done"), current_done);
		    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), percent);
		    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(current_done)/100);
#ifdef DEBUG
		    g_print("%6.2f", (float)(current_done)/100);
#endif
                }
	    }
	}
        while (gtk_events_pending())
             gtk_main_iteration();
	pthread_mutex_unlock(&gtk_mutex);
        if(data_processed_err == 0) break;
          usleep(10);
/*
	buffer_err[BUFSIZE]='\0';
	usleep(1);*/
    }
    free(regex);
    return NULL;
}

void createwin_gtk(int is_process, char *msg)
{  
//    dialog=gtk_dialog_new_with_buttons(window, GTK_WINDOW(window1), GTK_DIALOG_MODAL, GTK_STOCK_CLOSE, GTK_RESPONSE_REJECT, NULL);
    dialog=gtk_dialog_new_with_buttons(window, GTK_WINDOW(window1), GTK_DIALOG_MODAL, NULL);
    g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
    gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
    label[0]=gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label[0], TRUE, TRUE, 0);
    adj = (GtkAdjustment *) gtk_adjustment_new(0, 0, 100, 0, 0, 0);
    progress=gtk_progress_bar_new_with_adjustment(GTK_ADJUSTMENT(adj));
    if (is_process){
	gtk_label_set_text(GTK_LABEL(label[0]), msg);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), _("Please wait..."));
    } else 
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), msg);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), progress, TRUE, TRUE, 0);
    label[3]=gtk_label_new("");
    gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->vbox), label[3], TRUE, TRUE, 0);
    label[1]=gtk_label_new(_(window));
    gtk_label_set_text(GTK_LABEL(label[1]), "");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label[1], TRUE, TRUE, 0);
    gtk_widget_show(label[1]);
    label[2]=gtk_label_new("");
    gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialog)->vbox), label[2], TRUE, TRUE, 0);
    gtk_widget_show_now(label[0]);
    gtk_widget_show_now(label[3]);
    gtk_widget_show_now(label[2]);
    gtk_widget_show_now(progress);
    gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), 20);
    gtk_widget_show_now(dialog);
    gdk_flush();
}

int copy_image_gtk(char *window_name)
{
    long imagesize, status=0;
    int cdimage, imagefile, current_done, pos, c;
    void *buf;
    size_t n;
    char percent[30], bottomstat[30];
    
    window=window_name;
    createwin_gtk(1, "");
    gtk_widget_show(dialog);
    buf=(void *)malloc(IMAGE_BUF);
    if ( (cdimage=open(config.cdrom, O_RDONLY)) == -1 ){
	return -1;
    }
    if ( (imagefile=open(config.tempdir, O_CREAT | O_WRONLY | O_TRUNC, S_IRWXU)) == -1 ){
	return -1;
    }
    imagesize=isosize(cdimage);
    while (status<imagesize){
	n=read(cdimage, buf, IMAGE_BUF);
	write(imagefile, buf, n);
	status+=n;
	current_done=status / (imagesize / 99);

	sprintf(bottomstat, _("%d / %d MB done"),status/1024/1024, imagesize/1024/1024);
	gtk_label_set_text(GTK_LABEL(label[0]), bottomstat);
	sprintf(percent, _("%d%% done"),current_done);
	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), percent);
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(current_done)/100);
#ifdef DEBUG
	g_print("%6.2f", (float)(current_done)/100);
#endif
        while (gtk_events_pending())
             gtk_main_iteration();
    }
    close(imagefile);
    close(cdimage);
}

int run_command_gtk(char command[200], char *window_name, int dsize, int wait, int is_process, char *msg)
{
     char* argv[4];
     char *shell = "sh";
     int fork_result;
     int c;
     pthread_t pout, perr;
//     FILE *logf;

    window=window_name;
    createwin_gtk(is_process, msg);
    gtk_widget_show(dialog);
    size=dsize / 1024 / 1024;
    if ( (logf=fopen(config.logfile, "w"))==NULL ){
	fprintf(stderr, _("Cannot create logfile..."));
	gtk_main_quit();
    }
    lasttrack_gtk=0;
    //track=0;
    time0 = time(NULL);
    fprintf(logf, "Time: %d\n", time0);
    fprintf(logf, "%s\n", command);	
    if( (socketpair(AF_UNIX,SOCK_STREAM,0,stdin_pipe) == 0) && (socketpair(AF_UNIX,SOCK_STREAM,0,stdout_pipe) == 0)
         && (socketpair(AF_UNIX,SOCK_STREAM,0,stderr_pipe) == 0) ){
          fcntl(stdout_pipe[1],F_SETFL,O_ASYNC);
          fcntl(stderr_pipe[1],F_SETFL,O_ASYNC);
          fcntl(stderr_pipe[0],F_SETFL, O_NONBLOCK);
          fork_result = fork();
          if(fork_result == -1){
               fprintf(stderr, _("Fork Failure\n"));
	       gtk_main_quit();
          }
          else if(fork_result == 0){
               close(0);
               dup(stdin_pipe[0]);
               close(stdin_pipe[0]);
               close(stdin_pipe[1]);
               close(1);
               dup(stdout_pipe[1]); 
               close(stdout_pipe[0]); 
               close(stdout_pipe[1]);
               close(2);
               dup(stderr_pipe[1]); 
               close(stderr_pipe[0]); 
               close(stderr_pipe[1]);
	       strcpy(cmd, command);
               argv[0] = shell;
               argv[1] = "-c";
               argv[2] = cmd;
               argv[3] = NULL;
               execvp (argv[0], argv);
	       gtk_main_quit();
          }
          else{
               close(stdin_pipe[0]);
               close(stdin_pipe[1]);
               close(stderr_pipe[1]);
               close(stdout_pipe[1]);
               pthread_create(&pout,NULL,(void *)print_stdout_gtk,NULL);
	       pthread_create(&perr,NULL,(void *)print_stderr_gtk,NULL);
               pthread_join(pout, NULL);
               pthread_join(perr, NULL);
               close(stderr_pipe[0]);
               close(stdout_pipe[0]);
	       fclose(logf);
	       gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), _("Done"));
	       gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress), (float)(100)/100);
	       if (wait)
		    gtk_dialog_add_buttons(GTK_DIALOG(dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_REJECT, NULL);
	       else
		    gtk_widget_destroy(dialog);
          }
     } else
	 gtk_main_quit();
     return 1;
}
#endif
