/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <fcntl.h> 
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ncurses.h>
#include <regex.h>
#include <nl_types.h>
#include <time.h>
#include <libintl.h>
#include "options.h"
#include "gettext.h"
#include "isosize.h"

#define BUFSIZE 1000
#define IMAGE_BUF 131072

int    stdin_pipe[2];
int    stdout_pipe[2];
int    stderr_pipe[2];
char cmd[200], *window;
WINDOW *processwin;
int total_size = 0;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
static FILE *logf;
struct conf config;
int size, lasttrack=0;
time_t time0;
time_t time1;
int prev_percent=0;
int eta;
int eta_hour;
int eta_min;
int eta_sec;
char seta_hour[3];
char seta_min[3];
char seta_sec[3];

// I see CDrecorder version 0.1 source, and I write this code after this!!!
// THX to Sharad Mittal
void *print_stdout()
{
    regex_t *regex, *regex2, *regex3;
    regmatch_t *matches, *matches2, *matches3;
    int rv;
    char buf[BUFSIZE], buffer[BUFSIZE+1], done[10] = "\0", topstat[30], bottomstat[30], fifostr[30], etime[30];
    int data_processed;
    float per_done;
    
    // Image writing...    
    regex = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex, "Track ([0-9]+): ([ ]*)([0-9]+) of ([ ]*)([0-9]+) MB written ([(])fifo([ ]*)([0-9]+)", REG_EXTENDED);
    matches = (regmatch_t*) calloc (1, (regex->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
	regerror (rv, NULL, buf, sizeof(buf));
	fprintf (stderr, "ERROR regcomp: %s\n", buf);
	exit (1);
    }

    // Direct writing...
    regex3 = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex3, "Track ([0-9]+): ([ ]*)([0-9]+) MB written ([(])fifo([ ]*)([0-9]+)", REG_EXTENDED);
    matches3 = (regmatch_t*) calloc (1, (regex3->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
         regerror (rv, NULL, buf, sizeof(buf));
         fprintf (stderr, "ERROR regcomp: %s\n", buf);
         exit (1);
    }

    // Fixating...
    regex2 = (regex_t*) calloc (1, sizeof(regex_t));
    rv = regcomp (regex2, _("Fixating..."), REG_EXTENDED);
    matches2 = (regmatch_t*) calloc (1, (regex2->re_nsub+1) * sizeof(regmatch_t));
    if (rv)
    {
	regerror (rv, NULL, buf, sizeof(buf));
	fprintf (stderr, "ERROR regcomp: %s\n", buf);
	exit (1);
    }
    
    while (1) {
	memset(buffer, '\0', sizeof(buffer));
	data_processed=read(stdout_pipe[0],buffer,BUFSIZE);
	pthread_mutex_lock(&mutex);
	if (data_processed != -1) {
	    int rv1,rv2,rv3;
	    fprintf(logf, buffer);	
	    fflush(logf);
	    rv1 = regexec (regex, buffer, regex->re_nsub+1, matches, 0);
	    if ( rv1 == 0 ) {
        	int i;
            	for (i = 0; i < (regex->re_nsub+1); ++i)
            	{
            	    int len = matches[i].rm_eo - matches[i].rm_so;
            	    strncpy (buf, (char *)&buffer[matches[i].rm_so], len);
            	    buf[len] = '\0';
            	    if ((i==8)) {
                        int fifo = atoi((char *)&buf);
			sprintf(fifostr, _("  Fifo: %d%%  "), fifo);
			if (fifo<=25)
			    wattrset(processwin, COLOR_PAIR(7));
			mvwprintw(processwin, 8, 15-(strlen(fifostr)/2), "%s", fifostr);
			wattrset(processwin, COLOR_PAIR(2));
            	    }
            	    if ((i==5)) {
                        int new_total = atoi((char *)&buf);
                        if (total_size < new_total) {
                	    total_size = new_total;
                        }
            	    }
            	    if ((i==3)&&(total_size)) {
                        int current_done = atoi((char *)&buf);
		        int pos;
                        per_done = ((float)current_done)/((float)total_size);
		        if ((per_done>=0.0)&&(per_done<=1.0)) {
			    if (prev_percent!=per_done) {
				time1 = time(NULL);
				eta=(difftime(time1, time0)/current_done)*(total_size-current_done);
				eta_hour=(eta/60)/60;
				eta_min=(eta-((eta_hour*60)*60))/60;
				eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
				mvwprintw(processwin, 9, 1, "                            ");
				if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
				else sprintf(seta_hour, "%d", eta_hour);
				if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
				else sprintf(seta_min, "%d", eta_min);
				if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
				else sprintf(seta_sec, "%d", eta_sec);
				sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
				mvwprintw(processwin, 9, 15-(strlen(etime)/2), "%s", etime);
				prev_percent=per_done;
			    }
			    sprintf(bottomstat, _("%d / %d MB done"),current_done, total_size);
			    mvwprintw(processwin,2, 15-(strlen(bottomstat)/2), "%s", bottomstat);
			    sprintf(topstat, _("%2.1f%% done"), per_done*100);
			    mvwprintw(processwin, 3, 15-(strlen(topstat)/2), "%s", topstat);
			    mvwprintw(processwin, 5, 5, "");
			    for (pos=0; pos<=((per_done*99)/5); pos++){
			        wattrset(processwin, COLOR_PAIR(5));
			        waddch(processwin, ACS_BLOCK);
			        wattrset(processwin, COLOR_PAIR(2));
			    }
			    mvwprintw(processwin, 9, 29, "");
			    wrefresh(processwin);
			}
            	    }
            	    if (i==3) {
                	int current_done = atoi((char *)&buf);
                	sprintf(done,_("%d MB"),current_done);
            	    }
            	    if ( (i==1) ) {
                	int tracknum = atoi((char *)&buf);
			int pos;
			if (tracknum!=lasttrack) {
			    //time0=time(NULL);
			    mvwprintw(processwin, 5, 5, "");
			    for (pos=0; pos<20; pos++){
			        wattrset(processwin, COLOR_PAIR(2));
			        waddch(processwin, ' ');
			        wattrset(processwin, COLOR_PAIR(2));
			    }
			}
			sprintf(bottomstat, _("Track: %d"),tracknum);
			mvwprintw(processwin,7, 15-(strlen(bottomstat)/2), "%s", bottomstat);
			wrefresh(processwin);
			lasttrack=tracknum;
            	    }
        	}
    	    }
	    rv3 = regexec (regex3, buffer, regex3->re_nsub+1, matches3, 0);
	    if ( rv3 == 0 ) {
        	int i;
            	for (i = 0; i < (regex3->re_nsub+1); ++i)
            	{
            	    int len = matches3[i].rm_eo - matches3[i].rm_so;
            	    strncpy (buf, (char *)&buffer[matches3[i].rm_so], len);
            	    buf[len] = '\0';
            	    if ((i==6)) {
                        int fifo = atoi((char *)&buf);
			sprintf(fifostr, _("  Fifo: %d%%  "), fifo);
			if (fifo<=25)
			    wattrset(processwin, COLOR_PAIR(7));
			mvwprintw(processwin, 8, 15-(strlen(fifostr)/2), "%s", fifostr);
			wattrset(processwin, COLOR_PAIR(2));
			
            	    }
            	    if ((i==3) && (size)) {
                        int current_done = atoi((char *)&buf);
		        int pos;
                        per_done = ((float)current_done)/((float)size);
		        if ((per_done>=0.0)&&(per_done<=1.0)) {
			    if (prev_percent!=per_done) {
				time1 = time(NULL);
				eta=(difftime(time1, time0)/current_done)*(size-current_done);
				eta_hour=(eta/60)/60;
				eta_min=(eta-((eta_hour*60)*60))/60;
				eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
				mvwprintw(processwin, 9, 1, "                            ");
				if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
				else sprintf(seta_hour, "%d", eta_hour);
				if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
				else sprintf(seta_min, "%d", eta_min);
				if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
				else sprintf(seta_sec, "%d", eta_sec);
				sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
				mvwprintw(processwin, 9, 15-(strlen(etime)/2), "%s", etime);
				prev_percent=per_done;
			    }
			    sprintf(bottomstat, _("%d / %d MB done"),current_done, size);
			    mvwprintw(processwin,2, 15-(strlen(bottomstat)/2), "%s", bottomstat);
			    sprintf(topstat, _("%2.1f%% done"), per_done*100);
			    mvwprintw(processwin, 3, 15-(strlen(topstat)/2), "%s", topstat);
			    mvwprintw(processwin, 5, 5, "");
			    for (pos=0; pos<=((per_done*99)/5); pos++){
			        wattrset(processwin, COLOR_PAIR(5));
			        waddch(processwin, ACS_BLOCK);
			        wattrset(processwin, COLOR_PAIR(2));
			    }
			    mvwprintw(processwin, 9, 29, "");
			    wrefresh(processwin);
			}
            	    }
            	    if ( (i==3) && (!size) ) {
                	int current_done = atoi((char *)&buf);
			sprintf(bottomstat, _("%d MB done"),current_done);
			mvwprintw(processwin,3, 15-(strlen(bottomstat)/2), "%s", bottomstat);
			wrefresh(processwin);
            	    }
            	    if ( (i==1) ) {
                	int tracknum = atoi((char *)&buf);
			int pos;
			if (tracknum!=lasttrack) {
			    mvwprintw(processwin, 5, 5, "");
			    for (pos=0; pos<20; pos++){
			        wattrset(processwin, COLOR_PAIR(2));
			        waddch(processwin, ACS_BLOCK);
			        wattrset(processwin, COLOR_PAIR(2));
			    }
			}
			sprintf(bottomstat, _("Track: %d"),tracknum);
			mvwprintw(processwin,7, 15-(strlen(bottomstat)/2), "%s", bottomstat);
			wrefresh(processwin);
			lasttrack=tracknum;
            	    }
        	}
    	    }
	    rv2 = regexec (regex2, buffer, regex2->re_nsub, matches2, 0);
	    if ((rv2 == 0)&&(rv1 != 0)) {
		int pos;
		mvwprintw(processwin,2, 1, "                            ");
		sprintf(topstat, _("Fixating..."));
		mvwprintw(processwin, 3, 15-(strlen(topstat)/2), "%s",topstat);
		mvwprintw(processwin, 5, 5, "");
		for (pos=0; pos<=19; pos++){
		    wattrset(processwin, COLOR_PAIR(5));
		    waddch(processwin, ACS_BLOCK);
		    wattrset(processwin, COLOR_PAIR(2));
		}
		wrefresh(processwin);
	    }
	}
	pthread_mutex_unlock(&mutex);
        if(data_processed == 0) break;
        usleep(10);
	
    }
    free(regex);
    free(regex2);
    return NULL;
}

void *print_stderr()
{
    char buffer_err[BUFSIZE+1];
    char buf[BUFSIZE], percent[30], etime[30];
    int data_processed_err, rv;
    regex_t *regex, *regex2;
    regmatch_t *matches, *matches2;

     // Mkisofs process
     regex = (regex_t*) calloc (1, sizeof(regex_t));
     rv = regcomp (regex, "([ ]*)([0-9]+).([0-9]+)% done,", REG_EXTENDED);
     matches = (regmatch_t*) calloc (1, (regex->re_nsub+1) * sizeof(regmatch_t));
     if (rv)
     {
          regerror (rv, NULL, buf, sizeof(buf));
          fprintf (stderr, "ERROR regcomp: %s\n", buf);
          exit (1);
     }
     // Mkisofs 100%
     regex2 = (regex_t*) calloc (1, sizeof(regex_t));
     rv = regcomp (regex2, "Total translation table size", REG_EXTENDED);
     matches2 = (regmatch_t*) calloc (1, (regex2->re_nsub+1) * sizeof(regmatch_t));
     if (rv)
     {
          regerror (rv, NULL, buf, sizeof(buf));
          fprintf (stderr, "ERROR regcomp: %s\n", buf);
          exit (1);
     }

    while (1) {
	memset(buffer_err, '\0', sizeof(buffer_err));
	data_processed_err=read(stderr_pipe[0],buffer_err,BUFSIZE);
	pthread_mutex_lock(&mutex);
	if (data_processed_err != -1) {
	    int rv1;
	    int rv2;
	    char c1[5], c2[5], c3[5], c4[5], c5[5], tmp[25];
	    int perc;
	    
	    fprintf(logf, buffer_err);
	    
	    // Cdda2wav process
	    // ??/??/??/???????   0%
	    if (sscanf(buffer_err, "%s %s %s %s %s %s", c1, c2, c3, c4, c5, tmp) == 5 ){
		perc=atoi(c5);
		
		if ( (strcmp(window, _("Grab Audio CD") )==0) && (perc<=100) ){
		    int pos;
			
		    if (prev_percent!=perc) {
			time1 = time(NULL);
			eta=(difftime(time1, time0)/perc)*(100-perc);
			eta_hour=(eta/60)/60;
			eta_min=(eta-((eta_hour*60)*60))/60;
			eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			mvwprintw(processwin, 9, 1, "                            ");
			if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			else sprintf(seta_hour, "%d", eta_hour);
			if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			else sprintf(seta_min, "%d", eta_min);
			if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			else sprintf(seta_sec, "%d", eta_sec);
			sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			mvwprintw(processwin, 9, 15-(strlen(etime)/2), "%s", etime);
			prev_percent=perc;
		    }
		     mvwprintw(processwin, 5, 5, "");
		     for (pos=0; pos<=((perc)/5)-1; pos++){
		         wattrset(processwin, COLOR_PAIR(5));
		         waddch(processwin, ACS_BLOCK);
		         wattrset(processwin, COLOR_PAIR(2));
		     }
		     sprintf(percent, "  %d%% %s  ", perc, _("done"));
    		     mvwprintw(processwin,3, 15-(strlen(percent)/2), "%s", percent);
    		     //mvwprintw(processwin, 5, 5, "");
		     //mvwprintw(processwin, 9, 29, "");
		     //mvwprintw(processwin, 7, 5, "T: %d P: %d L: %d   ", track, perc, lasttrack);
		     wrefresh(processwin);
		     //fprintf(log, "\nT: %d P: %d L: %d\n", track, perc, lasttrack);
		     fflush(logf);
		     buffer_err[0]='\0';
		     //track=perc;
		     //sleep(1);
		 }
	    }
	    
	    rv1 = regexec (regex, buffer_err, regex->re_nsub+1, matches, 0);
            if ((rv1 == 0) && (strcmp(window, _("Write direct"))!=0)) {
		int i;
                for (i = 0; i < (regex->re_nsub+1); ++i)
                {
		    int len = matches[i].rm_eo - matches[i].rm_so;
		    strncpy (buf, (char *)&buffer_err[matches[i].rm_so], len);
		    buf[len] = '\0';
                    if (i==2) {
			int current_done = atoi((char *)&buf);
    			int pos;

			if (prev_percent!=current_done) {
			    time1 = time(NULL);
			    eta=(difftime(time1, time0)/current_done)*(100-current_done);
			    eta_hour=(eta/60)/60;
			    eta_min=(eta-((eta_hour*60)*60))/60;
			    eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			    mvwprintw(processwin, 9, 1, "                            ");
			    if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			    else sprintf(seta_hour, "%d", eta_hour);
			    if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			    else sprintf(seta_min, "%d", eta_min);
			    if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			    else sprintf(seta_sec, "%d", eta_sec);
			    sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			    mvwprintw(processwin, 9, 15-(strlen(etime)/2), "%s", etime);
			    prev_percent=current_done;
			}
			sprintf(percent, _("%d%% done"),current_done);
			mvwprintw(processwin,3, 15-(strlen(percent)/2), "%s", percent);
			wrefresh(processwin);
			mvwprintw(processwin, 5, 5, "");
			for (pos=0; pos<=(current_done/5); pos++){
			    wattrset(processwin, COLOR_PAIR(5));
			    waddch(processwin, ACS_BLOCK);
			    wattrset(processwin, COLOR_PAIR(2));
			}
			mvwprintw(processwin, 9, 29, "");
			wrefresh(processwin);
                    }
                }
	    }
	    rv2 = regexec (regex2, buffer_err, regex2->re_nsub+1, matches2, 0);
            if ((rv2 == 0) && (strcmp(window, _("Write direct"))!=0)) {
		int i;
                for (i = 0; i < (regex2->re_nsub+1); ++i)
                {
		    int len = matches2[i].rm_eo - matches2[i].rm_so;
		    int current_done = 99;
		    int pos;
		    strncpy (buf, (char *)&buffer_err[matches2[i].rm_so], len);
		    buf[len] = '\0';
		    if (prev_percent!=current_done) {
			time1 = time(NULL);
			eta=(difftime(time1, time0)/current_done)*(100-current_done);
			eta_hour=(eta/60)/60;
			eta_min=(eta-((eta_hour*60)*60))/60;
			eta_sec=eta-(((eta_hour*60)*60)+(eta_min*60));
			mvwprintw(processwin, 9, 1, "                            ");
			if (eta_hour<10) sprintf(seta_hour, "0%d", eta_hour);
			else sprintf(seta_hour, "%d", eta_hour);
			if (eta_min<10) sprintf(seta_min, "0%d", eta_min);
			else sprintf(seta_min, "%d", eta_min);
			if (eta_sec<10) sprintf(seta_sec, "0%d", eta_sec);
			else sprintf(seta_sec, "%d", eta_sec);
			sprintf(etime, "ETA: %s:%s.%s", seta_hour, seta_min, seta_sec);
			mvwprintw(processwin, 9, 15-(strlen(etime)/2), "%s", etime);
			prev_percent=current_done;
		    }
		    sprintf(percent, _("%d%% done"), current_done);
		    mvwprintw(processwin,3, 15-(strlen(percent)/2), "%s", percent);
		    wrefresh(processwin);
		    mvwprintw(processwin, 5, 5, "");
		    for (pos=0; pos<=(current_done/5); pos++){
			wattrset(processwin, COLOR_PAIR(5));
			waddch(processwin, ACS_BLOCK);
			wattrset(processwin, COLOR_PAIR(2));
		    }
		    mvwprintw(processwin, 9, 29, "");
		    wrefresh(processwin);
                }
	    }
	}
	pthread_mutex_unlock(&mutex);
        if(data_processed_err == 0) break;
          usleep(10);
/*
	buffer_err[BUFSIZE]='\0';
	usleep(1);*/
    }
    free(regex);
    return NULL;
}

void createwin(int is_process, char *cmd)
{
    processwin=newwin(11,30,(LINES-11)/2,(COLS-30)/2);
    wbkgd(processwin, COLOR_PAIR(2));
    werase(processwin);
    box(processwin,0,0);
    mvwaddch(processwin, 0, 2, ACS_RTEE);
    wprintw(processwin, " %s ", window);
    waddch(processwin, ACS_LTEE);
    if ( is_process != 0 )
	box(derwin(processwin, 3, 22, 4, 4),0,0);
    else 
	mvwprintw(processwin, 5, 15-(strlen(window)/2), "%s", _(window));
    mvwprintw(processwin, 2, 15-(strlen(cmd)/2), "%s", cmd);
    wrefresh(processwin);
}

int copy_image(char *window_name)
{
    long imagesize, status=0;
    int cdimage, imagefile, current_done, pos, c;
    void *buf;
    size_t n;
    char percent[30], bottomstat[30];
    
    window=window_name;
    createwin(1, "");
    buf=(void *)malloc(IMAGE_BUF);
    if ( (cdimage=open(config.cdrom, O_RDONLY)) == -1 ){
	return -1;
    }
    if ( (imagefile=open(config.tempdir, O_CREAT | O_WRONLY | O_TRUNC, S_IRWXU)) == -1 ){
	return -1;
    }
    imagesize=isosize(cdimage);
    while (status<imagesize){
	n=read(cdimage, buf, IMAGE_BUF);
	write(imagefile, buf, n);
	status+=n;
	current_done=status / (imagesize / 99);

	sprintf(bottomstat, _("%d / %d MB done"),status/1024/1024, imagesize/1024/1024);
	mvwprintw(processwin,2, 15-(strlen(bottomstat)/2), "%s", bottomstat);
	sprintf(percent, _("%d%% done"),current_done);
	mvwprintw(processwin,3, 15-(strlen(percent)/2), "%s", percent);
	wrefresh(processwin);
	mvwprintw(processwin, 5, 5, "");
	for (pos=0; pos<=(current_done/5); pos++){
	    wattrset(processwin, COLOR_PAIR(5));
	    waddch(processwin, ACS_BLOCK);
	    wattrset(processwin, COLOR_PAIR(2));
	}
	mvwprintw(processwin, 9, 29, "");
	wrefresh(processwin);
    }
    close(imagefile);
    close(cdimage);
    mvwprintw(processwin,9,4,_("     Press any key     "));
    c=wgetch(processwin);
    delwin(processwin);
}

int run_command(char command[200], char *window_name, int dsize, int wait, int is_process, char *msg)
{
     char* argv[4];
     char *shell = "sh";
     int fork_result;
     int c;
     pthread_t pout,perr;

    window=window_name;
    size=dsize / 1024 / 1024;
    if ( (logf=fopen(config.logfile,"w"))==NULL){
	endwin();
	fprintf(stderr, _("Cannot create logfile..."));
	exit(-1);
    }
    lasttrack=0;
    //track=0;
    time0 = time(NULL);
    fprintf(logf, "Time: %d\n", time0);
    fprintf(logf, "%s\n", command);	
    createwin(is_process, msg);
    if( (socketpair(AF_UNIX,SOCK_STREAM,0,stdin_pipe) == 0) && (socketpair(AF_UNIX,SOCK_STREAM,0,stdout_pipe) == 0)
         && (socketpair(AF_UNIX,SOCK_STREAM,0,stderr_pipe) == 0) ){
          fcntl(stdout_pipe[1],F_SETFL,O_ASYNC);
          fcntl(stderr_pipe[1],F_SETFL,O_ASYNC);
          fcntl(stderr_pipe[0],F_SETFL, O_NONBLOCK);
          fork_result = fork();
          if(fork_result == -1){
               fprintf(stderr, _("Fork Failure\n"));
	       exit(-1);
          }
          else if(fork_result == 0){
               close(0);
               dup(stdin_pipe[0]);
               close(stdin_pipe[0]);
               close(stdin_pipe[1]);
               close(1);
               dup(stdout_pipe[1]); 
               close(stdout_pipe[0]); 
               close(stdout_pipe[1]);
               close(2);
               dup(stderr_pipe[1]); 
               close(stderr_pipe[0]); 
               close(stderr_pipe[1]);
	       strcpy(cmd, command);
               argv[0] = shell;
               argv[1] = "-c";
               argv[2] = cmd;
               argv[3] = NULL;
               execvp (argv[0], argv);
	       exit(0);
          }
          else{
	       int pos;
               close(stdin_pipe[0]);
               close(stdin_pipe[1]);
               close(stderr_pipe[1]);
               close(stdout_pipe[1]);
               pthread_create(&pout,NULL,(void *)print_stdout,NULL);
               pthread_create(&perr,NULL,(void *)print_stderr,NULL);
               pthread_join(pout,NULL);
               pthread_join(perr,NULL);
               close(stderr_pipe[0]);
               close(stdout_pipe[0]);
	       fclose(logf);	
		mvwprintw(processwin,3, 2, "                           ");
		mvwprintw(processwin,3, 15-(strlen(_("Done"))/2), _("Done"));
		wrefresh(processwin);
		mvwprintw(processwin, 5, 5, "");
		for (pos=0; pos<=5; pos++){
		    wattrset(processwin, COLOR_PAIR(5));
		    waddch(processwin, ACS_BLOCK);
		    wattrset(processwin, COLOR_PAIR(2));
		}
		mvwprintw(processwin, 9, 29, "");
		wrefresh(processwin);
	       if ( wait!= 0 ) {
	    	    mvwprintw(processwin,10,4,_("     Press any key     "));
	    	    c=wgetch(processwin);
	       }
          }
     } else
        exit(-1);
     delwin(processwin);
     return 1;
}
