/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef EXCEPTION_H
#define EXCEPTION_H

#include "error.h"
#include "mpmo.h"

// Debug Switches
extern int cdoDebug;
extern int cdoDebugExt;  //  Debug level for the KNMI extensions
                         // Subsystem Debug Switches
extern int PSTREAM;
extern int PROCESS;
extern int PIPE;
extern int PIPE_STREAM; 
extern int FILE_STREAM;
extern int ARGUMENT;
extern int PTHREAD;
extern int PROCESS_MANAGER;
extern int PIPE;

void printDebugOptions();
void SetDebug(int p_debug_level);
void query_user_exit(const char *argument);

namespace CdoOut
{

  extern void (*exitProgram)(void);
  extern const char *(*getContext)(void);
  void setExitFunction(void (*func)(void));
  void setContextFunction(const char *(*func)(void) );
}  // namespace CdoOut

void cdiOpenError(int cdiErrno, const std::string &format, const char *path);

template <typename... Args>
void
cdoAbort(const std::string &format, Args const &... args) noexcept
{
  fflush(stdout);
  MpMO::PrintCerr(Red("\n%s (Abort): ") + Black(format), CdoOut::getContext(), args...);
  if (MpMO::exitOnError) CdoOut::exitProgram();
}

template <typename... Args>
void
cdoPrint(const std::string &format, Args const &... args) noexcept
{
  if (!MpMO::silentMode) MpMO::PrintCerr(Green("%s: ") + Black(format), CdoOut::getContext(), args...);
}

#ifdef WITH_CALLER_NAME
#define cdoSysError(...) MpMO::SysError_(__func__, __VA_ARGS__)
#define cdoError(...) MpMO::Error_(__func__, __VA_ARGS__)
#define cdoWarning(...) MpMO::Warning_(__func__, __VA_ARGS__)
#else
#define cdoSysError(...) MpMO::SysError_("", __VA_ARGS__)
#define cdoError(...) MpMO::Error_("", __VA_ARGS__)
#define cdoWarning(...) MpMO::Warning_("", __VA_ARGS__)
#endif

#endif
