/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "GRID_F.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,lo_3,hi_1,hi_2,hi_3

c *************************************************************************
c ** SLOPEY **
c ** Compute the slope of nvar components of s in the y-direction
c *************************************************************************

      subroutine FORT_SLOPEY(s,sly,dyscr,DIMS,nvar,bcy_lo,bcy_hi,slope_order)

      implicit none

      integer DIMS
      integer nvar
      integer bcy_lo,bcy_hi
      integer slope_order

      REAL_T      s(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1,nvar)
      REAL_T    sly(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1,nvar)
      REAL_T  dyscr(lo_2-1:hi_2+1,4)

      integer cen,lim,flag,fromm

      parameter( cen = 1 )
      parameter( lim = 2 )
      parameter( flag = 3 )
      parameter( fromm = 4 )

      REAL_T dpls,dmin,ds
      REAL_T del,slim,sflag

      integer is,js,ks,ie,je,ke,i,j,k,iv

      is = lo_1
      js = lo_2
      ks = lo_3
      ie = hi_1
      je = hi_2
      ke = hi_3

c ::: HERE DOING 1ST ORDER
      if (slope_order .eq. 0) then
        do iv = 1,nvar 
          do k = ks-1,ke+1 
           do j = js-1,je+1 
            do i = is-1,ie+1 
              sly(i,j,k,iv) = zero
            enddo
           enddo
          enddo
        enddo

c ::: HERE DOING 2ND ORDER
      else if (slope_order .eq. 2) then

        do iv=1,nvar 
          do k = ks-1,ke+1 
          do j = js,je 
            do i = is-1,ie+1 

              del  = half*(s(i,j+1,k,iv) - s(i,j-1,k,iv))
              dpls = two *(s(i,j+1,k,iv) - s(i,j  ,k,iv))
              dmin = two *(s(i,j  ,k,iv) - s(i,j-1,k,iv))
              slim = min(abs(dpls),abs(dmin))
              slim = cvmgp(slim, zero, dpls*dmin)
              sflag = sign(one,del)
              sly(i,j,k,iv)= sflag*min(slim,abs(del))

            enddo
          enddo

          if (bcy_lo .eq. PERIODIC) then

            do i = is-1,ie+1 
              sly(i,js-1,k,iv) = sly(i,je,k,iv)
            enddo

          elseif (bcy_lo .eq. WALL  .or.  bcy_lo .eq. INLET) then

            do i = is-1,ie+1 
              sly(i,js-1,k,iv) = zero
              del = (s(i,js+1,k,iv)+three*s(i,js,k,iv)-
     $               four*s(i,js-1,k,iv)) * third
              dpls = two*(s(i,js+1,k,iv) - s(i,js  ,k,iv))
              dmin = two*(s(i,js  ,k,iv) - s(i,js-1,k,iv))
              slim = min(abs(dpls), abs(dmin))
              slim = cvmgp(slim, zero, dpls*dmin)
              sflag = sign(one,del)
              sly(i,js,k,iv)= sflag*min(slim,abs(del))
            enddo

          elseif (bcy_lo .eq. OUTLET) then

            do i = is-1,ie+1 
              sly(i,js-1,k,iv)= zero
            enddo

          endif

          if (bcy_hi .eq. PERIODIC) then

            do i = is-1,ie+1 
              sly(i,je+1,k,iv) = sly(i,js,k,iv)
            enddo

          elseif (bcy_hi .eq. WALL  .or.  bcy_hi .eq. INLET) then

            do i = is-1, ie+1 
              sly(i,je+1,k,iv) = zero
              del = -(s(i,je-1,k,iv)+three*s(i,je,k,iv)-
     $                four*s(i,je+1,k,iv)) * third
              dpls = two*(s(i,je+1,k,iv) - s(i,je  ,k,iv))
              dmin = two*(s(i,je  ,k,iv) - s(i,je-1,k,iv))
              slim = min(abs(dpls), abs(dmin))
              slim = cvmgp(slim, zero, dpls*dmin)
              sflag = sign(one,del)
              sly(i,je,k,iv)= sflag*min(slim,abs(del))
            enddo

          elseif (bcy_hi .eq. OUTLET) then
 
            do i = is-1,ie+1 
              sly(i,je+1,k,iv)= zero
            enddo

          endif

        enddo
        enddo

      else 

c ::: HERE DOING 4TH ORDER

      do iv=1,nvar 
        do k = ks-1,ke+1 
        do i = is-1,ie+1 
          do j = js,je 
            dyscr(j,cen) = half*(s(i,j+1,k,iv)-s(i,j-1,k,iv))
            dmin = two*(s(i,j  ,k,iv)-s(i,j-1,k,iv))
            dpls = two*(s(i,j+1,k,iv)-s(i,j  ,k,iv))
            dyscr(j,lim)  = min(abs(dmin),abs(dpls))
            dyscr(j,lim)  = cvmgp(dyscr(j,lim),zero,dpls*dmin)
            dyscr(j,flag) = sign(one,dyscr(j,cen))
            dyscr(j,fromm)= dyscr(j,flag)*min(dyscr(j,lim),abs(dyscr(j,cen)))
          enddo

          if (bcy_lo .eq. PERIODIC) then
            dyscr(js-1,fromm) = dyscr(je,fromm)
          else
            dyscr(js-1,fromm) = dyscr(js,fromm)
          endif
          if (bcy_hi .eq. PERIODIC) then
            dyscr(je+1,fromm) = dyscr(js,fromm)
          else
            dyscr(je+1,fromm) = dyscr(je,fromm)
          endif


          do j = js,je 

            ds = two * two3rd * dyscr(j,cen) - 
     $           sixth * (dyscr(j+1,fromm) + dyscr(j-1,fromm))
            sly(i,j,k,iv) = dyscr(j,flag)*min(abs(ds),dyscr(j,lim))

          enddo


          if (bcy_lo .eq. PERIODIC) then

            sly(i,js-1,k,iv) = sly(i,je,k,iv)

          elseif (bcy_lo .eq. WALL  .or.  bcy_lo .eq. INLET) then

            sly(i,js-1,k,iv) = zero
            del = -sixteen/fifteen*s(i,js-1,k,iv) +  half*s(i,js  ,k,iv) + 
     $                      two3rd*s(i,js+1,k,iv) - tenth*s(i,js+2,k,iv)
            dmin = two*(s(i,js  ,k,iv)-s(i,js-1,k,iv))
            dpls = two*(s(i,js+1,k,iv)-s(i,js  ,k,iv))
            slim = min(abs(dpls), abs(dmin))
            slim = cvmgp(slim, zero, dpls*dmin)
            sflag = sign(one,del)
            sly(i,js,k,iv)= sflag*min(slim,abs(del))

c           Recalculate the slope at js+1 using the revised dyscr(js,fromm)
            dyscr(js,fromm) = sly(i,js,k,iv)
            ds = two * two3rd * dyscr(js+1,cen) -
     $           sixth * (dyscr(js+2,fromm) + dyscr(js,fromm))
            sly(i,js+1,k,iv) = dyscr(js+1,flag)*min(abs(ds),dyscr(js+1,lim))

          elseif (bcy_lo .eq. OUTLET) then

            sly(i,js-1,k,iv) = zero

          endif

          if (bcy_hi .eq. PERIODIC) then

            sly(i,je+1,k,iv) = sly(i,js,k,iv)

          elseif (bcy_hi .eq. WALL  .or.  bcy_hi .eq. INLET) then

            sly(i,je+1,k,iv) = zero
            del = -( -sixteen/fifteen*s(i,je+1,k,iv) +  half*s(i,je  ,k,iv) 
     $            +            two3rd*s(i,je-1,k,iv) - tenth*s(i,je-2,k,iv) )
            dmin = two*(s(i,je  ,k,iv)-s(i,je-1,k,iv))
            dpls = two*(s(i,je+1,k,iv)-s(i,je ,k,iv))
            slim = min(abs(dpls), abs(dmin))
            slim = cvmgp(slim, zero, dpls*dmin)
            sflag = sign(one,del)
            sly(i,je,k,iv)= sflag*min(slim,abs(del))

c           Recalculate the slope at js+1 using the revised dyscr(js,fromm)
            dyscr(je,fromm) = sly(i,je,k,iv)
            ds = two * two3rd * dyscr(je-1,cen) -
     $           sixth * (dyscr(je-2,fromm) + dyscr(je,fromm))
            sly(i,je-1,k,iv) = dyscr(je-1,flag)*min(abs(ds),dyscr(je-1,lim))

          elseif (bcy_hi .eq. OUTLET) then

            sly(i,je+1,k,iv) = zero

          endif
        enddo
      enddo
      enddo

      endif
      return
      end
