{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetVariation: Single;
    procedure SetVariation(const Value: Single);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetSurfaceArea: Single;
    procedure SetSurfaceArea(const Value: Single);
  public
    property Speed: Single read GetSpeed write SetSpeed;
    property Variation: Single read GetVariation write SetVariation;
    property Mass: Single read GetMass write SetMass;
    property SurfaceArea: Single read GetSurfaceArea write SetSurfaceArea;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractParticleEmitterNode ----------------------------------------------- }

function TAbstractParticleEmitterNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TAbstractParticleEmitterNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TAbstractParticleEmitterNode.GetVariation: Single;
begin
  Result := FdVariation.Value;
end;

procedure TAbstractParticleEmitterNode.SetVariation(const Value: Single);
begin
  FdVariation.Send(Value);
end;

function TAbstractParticleEmitterNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure TAbstractParticleEmitterNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

function TAbstractParticleEmitterNode.GetSurfaceArea: Single;
begin
  Result := FdSurfaceArea.Value;
end;

procedure TAbstractParticleEmitterNode.SetSurfaceArea(const Value: Single);
begin
  FdSurfaceArea.Send(Value);
end;

{$endif read_implementation}
