{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetHorizontal: boolean;
    procedure SetHorizontal(const Value: boolean);
    function GetLanguage: string;
    procedure SetLanguage(const Value: string);
    function GetLeftToRight: boolean;
    procedure SetLeftToRight(const Value: boolean);
    function GetSize: Single;
    procedure SetSize(const Value: Single);
    function GetSpacing: Single;
    procedure SetSpacing(const Value: Single);
    function GetTopToBottom: boolean;
    procedure SetTopToBottom(const Value: boolean);
  public
    property Horizontal: boolean read GetHorizontal write SetHorizontal;
    property Language: string read GetLanguage write SetLanguage;
    property LeftToRight: boolean read GetLeftToRight write SetLeftToRight;
    property Size: Single read GetSize write SetSize;
    property Spacing: Single read GetSpacing write SetSpacing;
    property TopToBottom: boolean read GetTopToBottom write SetTopToBottom;

{$endif read_interface}

{$ifdef read_implementation}

{ TFontStyleNode ----------------------------------------------- }

function TFontStyleNode.GetHorizontal: boolean;
begin
  Result := FdHorizontal.Value;
end;

procedure TFontStyleNode.SetHorizontal(const Value: boolean);
begin
  FdHorizontal.Send(Value);
end;

function TFontStyleNode.GetLanguage: string;
begin
  Result := FdLanguage.Value;
end;

procedure TFontStyleNode.SetLanguage(const Value: string);
begin
  FdLanguage.Send(Value);
end;

function TFontStyleNode.GetLeftToRight: boolean;
begin
  Result := FdLeftToRight.Value;
end;

procedure TFontStyleNode.SetLeftToRight(const Value: boolean);
begin
  FdLeftToRight.Send(Value);
end;

function TFontStyleNode.GetSize: Single;
begin
  Result := FdSize.Value;
end;

procedure TFontStyleNode.SetSize(const Value: Single);
begin
  FdSize.Send(Value);
end;

function TFontStyleNode.GetSpacing: Single;
begin
  Result := FdSpacing.Value;
end;

procedure TFontStyleNode.SetSpacing(const Value: Single);
begin
  FdSpacing.Send(Value);
end;

function TFontStyleNode.GetTopToBottom: boolean;
begin
  Result := FdTopToBottom.Value;
end;

procedure TFontStyleNode.SetTopToBottom(const Value: boolean);
begin
  FdTopToBottom.Send(Value);
end;

{$endif read_implementation}
