/////////////////////////////////////////////////////////////////////////////
//
//  Captury - http://rm-rf.in/captury
//  $Id$
//
//  Copyright (c) 2007 by Christian Parpart <trapni@gentoo.org>
//
//  This file as well as its whole library is licensed under
//  the terms of GPL. See the file COPYING.
//
/////////////////////////////////////////////////////////////////////////////
#include "libGLcaptury.h"
#include "TScreenshot.h"
#include "log.h"

#include <captury/captury.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

#define GLX_GLXEXT_PROTOTYPES // required for glXGetProcAddressARB when using xorg-x11 GL headers
#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glx.h>

#include <dlfcn.h>

#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <assert.h>

#include <sys/types.h>
#include <fcntl.h>
#include <pthread.h>
#include <unistd.h>

// {{{ HUD
void drawHUD() {
	glPushAttrib(GL_DEPTH_BUFFER_BIT | GL_TEXTURE_BIT | GL_LIGHTING_BIT | /*GL_POLYGON_BIT | */GL_FOG_BIT);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDisable(GL_FOG);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
		glLoadIdentity();
		glOrtho(0, 10, 0, 10, -1, 1);

		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
			glLoadIdentity();

			// XXX for debugging'n'testing only. draw a cross
			glLineWidth(3);
			glBegin(GL_LINES);
				glColor4f(1, 0, 0, 1);
				glVertex2f(0, 0);
				glVertex2f(10, 10);

				glVertex2f(10, 0);
				glVertex2f(0, 10);
			glEnd();
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	glPopAttrib();
}
// }}}

void glXSwapBuffers(Display *dpy, GLXDrawable drawable) {
	if (captureMovie) {
		if (!cd) { // wanna capture, but not yet actually started (= first frame)
			if (FCurrentWidth == 0)
				updateGeometry(dpy, drawable);

			if (!startMovieCapture(dpy, drawable)) {
				captureMovie = false; // initialization failed

				hooked.glXSwapBuffers(dpy, drawable);
				return;
			}
		}

		// TODO draw water mark/logo, if enabled

		CapturyProcessFrame(cd);

//		if (takeScreenshot) {
//			takeScreenshot = false;
//			// TODO reuse the already captured frame used for the movie, so we can make a screenshot of it.
//		}

		// TODO draw an overlay current capturing state (fps, MiB/s)
	}

#if defined(__TEST_CAPTURY_HUD__)
	drawHUD();
#endif

	if (takeScreenshot) {
		if (FCurrentWidth == 0)
			updateGeometry(dpy, drawable);

		TScreenshot::capture();

		takeScreenshot = false;
	}

	hooked.glXSwapBuffers(dpy, drawable);
}

__GLXextFuncPtr glXGetProcAddress(const GLubyte *procName) {
	static struct {
		const char *name;
		__GLXextFuncPtr func;
	} fnmap[] = {
		{ "glXGetProcAddressARB", (__GLXextFuncPtr)glXGetProcAddressARB },
		{ "glXSwapBuffers", (__GLXextFuncPtr)glXSwapBuffers },
		{ 0, 0 }
	};

	debug("glXGetProcAddress: '%s'", procName);

	for (int i = 0; fnmap[i].name; ++i)
		if (!strcmp((char *)procName, fnmap[i].name))
			return fnmap[i].func;

	return (__GLXextFuncPtr) hooked.glXGetProcAddressARB(procName);
}

void (*glXGetProcAddressARB(const GLubyte *procName))() {
	return glXGetProcAddress(procName);
}

// vim:ai:noet:ts=4:nowrap
