/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_GUI_PREFERENCES_H
#define HAVE_GUI_PREFERENCES_H

#include <iostream>
#include <gtkmm.h>
#include <libglademm.h>
#include <libintl.h>
#include <list>
#include "gui_preftree.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)


class PreferencesWindow : public SigC::Object {
public:
  PreferencesWindow(std::string gladefile, std::string gladedomain);
  ~PreferencesWindow();
  
  /* Triggered whenever the CLOSE button has been clicked. */
  SigC::Signal0<void>                             signal_button_close_clicked;
  /* Triggered whenever any preference has been changed. */
  /* Emits the preference name, type (e.g. G_TYPE_BOOL) and its value. */
  SigC::Signal3<void, std::string, gint, void *>  signal_preference_changed;
  
  /* Make the window visible. If it does not exist yet, it will be created.
   */
  void show(void);
  
  /* Hide the window.
   */
  void hide(void);
  
  /* Updates one widget according to the given value.
   */
  bool update_widget(std::string name, int type, void *value);
  
private:
  /* Builds the complete preferences window and makes it visible.
   */
  void create(void);
  
  /* Adds all categories by iterating through the notebook tab labels.
   */
  void fill_tree(void);
  
  /* Connects all signals.
   */
  void connect_signals(void);
  
  /* Callback handler, triggered whenever another preferences category has been
   * selected.
   */
  void on_preftree_selection_changed(Gtk::TreeIter iter);
  
  /* Callback handler, triggered whenever the "close" button has been clicked.
   */
  void on_button_close_clicked(void);
  
  /* Callback handler, triggered whenever any of the preferences has been
   * edited.
   */
  void on_widget_changed(Gtk::Widget *widget);
  
  /* Given a container, this function returns a list of all children.
   * Other than "Gtk::Object::get_children()", this function works recursive.
   */
  void get_children_recursive(
                  Gtk::Container *container, std::list<Gtk::Widget*> *children);
  
  Glib::RefPtr<Gnome::Glade::Xml> refXml;       // Glade's XML-structure.
  std::string                     glade_file;   // The .glade filename.
  std::string                     glade_domain; // The .glade file domain.
  Gtk::Window                    *window;       // The toplevel window.
  Gtk::Notebook                  *notebook;     // The notebook holding prefs.
  Gtk::Viewport                  *viewport;     // Preftree parent.
  PreferencesTree                 preftree;     // Preftree.
};

#endif
