/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_filebrowser.h"

//#define _DEBUG_

static const gchar *defaultpattern[] = { "*.*", NULL };


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
FileBrowser::FileBrowser(void)
{
  curdir = getenv("HOME");
  
  filelist.set_directory(curdir);
  
  // Create the dirtree.
  dirtree_view  = new Gtk::TreeView;
  dirtree       = dirtree_create((GtkWidget*)dirtree_view->gobj());
  Gtk::ScrolledWindow *scroll = new Gtk::ScrolledWindow;
  scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  scroll->set_shadow_type(Gtk::SHADOW_IN);
  scroll->add(*dirtree_view);
  this->add1(*scroll);
  scroll->show();
  dirtree_view->show();
  
  // Connect the dirtree signals.
  dirtree_view->signal_row_activated().connect(
              SigC::slot(*this, &FileBrowser::on_dirtree_row_activated));
  dirtree_view->signal_row_expanded().connect(
              SigC::slot(*this, &FileBrowser::on_dirtree_row_expanded));
  dirtree_view->signal_row_collapsed().connect(
              SigC::slot(*this, &FileBrowser::on_dirtree_row_collapsed));
  dirtree_view->get_selection()->signal_changed().connect(
              SigC::slot(*this, &FileBrowser::on_dirtree_selection_changed));
  
  // Create the filelist.
  scroll = new Gtk::ScrolledWindow;
  scroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  scroll->set_shadow_type(Gtk::SHADOW_IN);
  scroll->add(filelist);
  add2(*scroll);
  scroll->show();
  filelist.show();
  filelist.set_rules_hint(TRUE);
  
  set_position(200);
  
  // Connect the filelist signals.
  filelist.get_selection()->signal_changed().connect(
          SigC::slot(*this, &FileBrowser::on_filelist_selection_changed), TRUE);
  
  update();  
}


FileBrowser::~FileBrowser(void)
{
  dirtree_destroy(dirtree);
}


/******************************************************************************
 * Public
 ******************************************************************************/
void FileBrowser::set_dir(std::string dir)
{
  struct stat filestat;
  if (dir.substr(dir.length(), 1) != "/")
    dir = dir + "/";
  if (!filelist.set_directory(dir))
    return;
  curdir = dir;
  update();
}


void FileBrowser::set_filepattern(const gchar **pfilepattern)
{
  filelist.set_filepattern(filepattern);
}


void FileBrowser::set_filepattern(std::string str)
{
  filelist.set_filepattern(str);
}


void FileBrowser::set_showhidden(gboolean show_hidden)
{
  filelist.set_showhidden(show_hidden);
  filelist.update();
}


void FileBrowser::update(bool hard)
{
  // Open the filelist.
  filelist.update(hard);
  if (!hard)
    return;
  // Open the directory.
  dirtree_open_directory((GtkTreeView*)dirtree_view->gobj(),
                         (GtkTreeModel*)dirtree,
                         curdir.c_str());
}


/******************************************************************************
 * Protected
 ******************************************************************************/
void FileBrowser::on_dirtree_row_activated(
                                      const Gtk::TreeModel::Path& path,
                                      Gtk::TreeViewColumn *column)
{
  if (dirtree_view->row_expanded(path))
    dirtree_view->collapse_row(path);
  else
    dirtree_view->expand_row(path, FALSE);
}


void FileBrowser::on_dirtree_row_expanded(
                                      const Gtk::TreeModel::iterator& iter,
                                      const Gtk::TreeModel::Path& path)
{
  dirtree_expand((GtkTreeModel*)dirtree, (GtkTreePath*)path.gobj(), showhidden);
}


void FileBrowser::on_dirtree_row_collapsed(
                                      const Gtk::TreeModel::iterator& iter,
                                      const Gtk::TreeModel::Path& path)
{
  dirtree_collapse((GtkTreeModel*)dirtree, (GtkTreePath*)path.gobj(), TRUE);
}


void FileBrowser::on_dirtree_selection_changed(void)
{
  const gchar *pathname = dirtree_path_get_selected(
                                            (GtkTreeView*)dirtree_view->gobj());
  if (!pathname)
    return;
  curdir = pathname;
  filelist.set_directory(pathname);
  filelist.update(TRUE);
}


void FileBrowser::on_filelist_selection_changed(void)
{
#ifdef _DEBUG_
  std::cout << "FileBrowser::on_filelist_selection_changed(): Called.\n";
#endif
  GList *selected = filelist.get_selection_glist();
  signal_filelist_selection_changed.emit(selected);
  if (selected)
    g_list_free(selected);
}
