/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gui_aboutbox.h"


AboutBox::AboutBox(void)
{
}


AboutBox::~AboutBox(void)
{
  if (image)
    delete image;
}


void AboutBox::create(void)
{
  Gtk::Label  *label  = NULL;
  Gtk::VBox   *vbox   = this->get_vbox();
  Gtk::Button *button = this->add_button(Gtk::Stock::OK, 0);
  gchar version[2048];
  
  image = new Gtk::Image(PACKAGE_PIXMAPS_DIR "/cantus_tag.png");
  vbox->pack_start(*image, FALSE, TRUE);
  
  snprintf(version, 2047, _("<i>Release %s %s</i>"), VERSION, SUBVERSION);
  
  label = new Gtk::Label(version, 0.5, 0.5);
  label->set_use_markup(TRUE);
  label->set_justify(Gtk::JUSTIFY_CENTER);
  label->set_line_wrap(TRUE);
  label->set_padding(10, 10);
  vbox->pack_start(*label, FALSE, TRUE);
  
  label = new Gtk::Label(
    _("The Cantus Tag Editor was written and published under the terms"
      " of the GPL (General Public License V2)\n"
      "by Samuel Abels.\n\n"
      "Thank You for choosing Cantus!\n\n"
       "<small>Copyright 2004. All rights reserved.</small>"),
    0.5, 0.5);
  
  //FIXME: Add this to the aboutbox text!
  //gchar *credits = _("translator_credits");
  //strcmp(credits, "translator_credits") != 0 ? credits : NULL, 
  
  label->set_use_markup(TRUE);
  label->set_justify(Gtk::JUSTIFY_CENTER);
  label->set_line_wrap(TRUE);
  label->set_padding(10, 10);
  vbox->pack_start(*label, FALSE, TRUE);
  
  vbox->show_all();
  
  button->signal_clicked().connect(SigC::slot(*this, &Gtk::Window::hide));
}
