/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "preferences.h"

//#define _DEBUG_


/******************************************************************************
 * Constructor/Destructor
 ******************************************************************************/
/* Constructor.
 */
Preferences::Preferences(void)
{
}


/* Destructor.
 */
Preferences::~Preferences(void)
{
  // Clear the prefs.
  std::map<std::string, CantusHashValue*>::iterator iter = prefs.begin();
  while (iter != prefs.end()) {
    CantusHashValue *chvalue = prefs[(*iter).first];
    if (chvalue)
      value_delete(chvalue);
    iter++;
  }
  
  // Clear the editedprefs.
  iter = editedprefs.begin();
  while (iter != editedprefs.end()) {
    CantusHashValue *chvalue = editedprefs[(*iter).first];
    if (chvalue)
      value_delete(chvalue);
    iter++;
  }
  editedprefs.clear();
}


/******************************************************************************
 * Public
 ******************************************************************************/
/* Test the edited preferences for sanity. If "key" is NULL, all preferences
 * will be checked.
 */
bool Preferences::check_commit(void)
{
  //FIXME!!!
  return TRUE;
}


/* Test the edited preferences for sanity. If "key" is NULL, all preferences
 * will be checked.
 */
bool Preferences::check_commit(std::string key)
{
  //FIXME!!!
  return TRUE;
}


/* Confirms all preferences. This also triggers a Preferences:Changed event.
 */
bool Preferences::commit(void)
{
  if (!check_commit())
    return FALSE;
  
  // Clear the prefs.
  std::map<std::string, CantusHashValue*>::iterator iter = prefs.begin();
  while (iter != prefs.end()) {
    CantusHashValue *chvalue = prefs[(*iter).first];
#ifdef _DEBUG_
    printf("Cleared Key: %s\n", (*iter).first.c_str());
#endif
    if (chvalue)
      value_delete(chvalue);
    iter++;
  }
  prefs.clear();
  
  // Copy the edited preferences into the preferences.
  iter = editedprefs.begin();
  while (iter != editedprefs.end()) {
    CantusHashValue *chvalue = editedprefs[(*iter).first];
#ifdef _DEBUG_
    printf("Added Key: %s\n", (*iter).first.c_str());
#endif
    if (chvalue)
      prefs[(*iter).first] = value_duplicate(chvalue);
    iter++;
  }
  
  signal_changed("");
  return TRUE;
}


/* Confirms the preference with the given key. This also triggers a
 * Preferences:Changed event.
 */
bool Preferences::commit(std::string key)
{
  if (!check_commit(key))
    return FALSE;
  
  CantusHashValue *chvalue = prefs[key];
  if (chvalue)
    value_delete(chvalue);
  prefs.erase(key);
  if ((chvalue = editedprefs[key]))
    prefs[key] = value_duplicate(chvalue);
#ifdef _DEBUG_
  printf("Changed Key: %s\n", key.c_str());
#endif
  signal_changed(key);
  return TRUE;
}


/* Set one preference value.
 */
bool Preferences::set(std::string key, int type, void *value)
{
  CantusHashValue *chvalue = new CantusHashValue;
  value_set(chvalue, type, value);
  editedprefs[key] = chvalue;
  return TRUE;
}


/* Set one preference value (integer).
 */
void Preferences::set_int(std::string key, int value)
{
  CantusHashValue *chvalue = new CantusHashValue;
  value_set_int(chvalue, value);
  editedprefs[key] = chvalue;
}


/* Get one preference value (int).
 */
int Preferences::get_int(std::string key)
{
  CantusHashValue *chvalue = prefs[key];
  return chvalue ? value_get_int(chvalue) : 0;
}


/* Set one preference value (boolean).
 */
void Preferences::set_bool(std::string key, bool value)
{
  CantusHashValue *chvalue = new CantusHashValue;
  value_set_bool(chvalue, value);
  editedprefs[key] = chvalue;
}


/* Get one preference value (char).
 */
bool Preferences::get_bool(std::string key)
{
  CantusHashValue *chvalue = prefs[key];
  return chvalue ? value_get_bool(chvalue) : FALSE;
}


/* Set one preference value (char).
 */
void Preferences::set_char(std::string key, std::string value)
{
  CantusHashValue *chvalue = new CantusHashValue;
  value_set_char(chvalue, value.c_str());
  editedprefs[key] = chvalue;
}


/* Get one preference value (char).
 */
std::string Preferences::get_char(std::string key)
{
  CantusHashValue *chvalue = prefs[key];
  return chvalue ? value_get_char(chvalue) : "";
}


/* Walks through all preferences calling the given slot.
 * Args passed to the slot are: The preference name, type and its value.
 * If the slot returns FALSE, list evaluation will be stopped.
 */
void Preferences::foreach(SigC::Slot3<bool, std::string, int, void*> slot)
{
  std::map<std::string, CantusHashValue*>::iterator iter = prefs.begin();
  while (iter != prefs.end()) {
    CantusHashValue *chvalue = prefs[(*iter).first];
    if (chvalue
      && !slot((*iter).first, value_get_type(chvalue), chvalue->value))
      return;
    iter++;
  }
}


/******************************************************************************
 * Protected
 ******************************************************************************/
