/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_PLUGINWRAPPERS_H
#define HAVE_PLUGINWRAPPERS_H

#ifdef HAVE_PLUGINWRAPPERS_C
#include "controller.h"
#endif
#include "plugins/cantushash.h"

// EventBus access.
glong eventbus_add_listener(const gchar *pattern, GClosure *closure);
glong eventbus_add_listener_sigc(const gchar *pattern,
                                 SigC::Slot1<void, void*> slot);
void eventbus_remove_listener(gint id);
void eventbus_emit(const gchar *name, const GValue *value);

// Preferences access.
void         preferences_set_int(const gchar *key, gint value);
gint         preferences_get_int(const gchar *key);
void         preferences_set_bool(const gchar *key, gboolean value);
gboolean     preferences_get_bool(const gchar *key);
void         preferences_set_char(const gchar *key, const gchar *value);
const gchar *preferences_get_char(const gchar *key);

// FileInfoManager access.
CantusHash  *fileinfomanager_get_info(const gchar *filename);
void         fileinfomanager_unlock_info(const gchar *filename);

#endif
