/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define HAVE_PLUGINWRAPPERS_C

#include "pluginwrappers.h"

extern Controller controller;


/******************************************************************************
 * EventBus functions.
 ******************************************************************************/
glong eventbus_add_listener(const gchar *pattern, GClosure *closure)
{
  return controller.eventbus->add_listener(pattern, closure);
}


glong eventbus_add_listener_sigc(const gchar *pattern,
                                 SigC::Slot1<void, void*> slot)
{
  return controller.eventbus->add_listener_sigc(pattern, slot);
}


void eventbus_remove_listener(gint id)
{
  controller.eventbus->remove_listener(id);
}


void eventbus_emit(const gchar *name, const GValue *value)
{
  controller.eventbus->emit_event(name, value);
}


/******************************************************************************
 * Preferences functions.
 ******************************************************************************/
void preferences_set_int(const gchar *key, gint value)
{
  controller.preferences->set_int(key, value);
}


gint preferences_get_int(const gchar *key)
{
  return controller.preferences->get_int(key);
}


void preferences_set_bool(const gchar *key, gboolean value)
{
  controller.preferences->set_bool(key, value);
}


gboolean preferences_get_bool(const gchar *key)
{
  return controller.preferences->get_bool(key);
}


void preferences_set_char(const gchar *key, const gchar *value)
{
  controller.preferences->set_char(key, value);
}


const gchar *preferences_get_char(const gchar *key)
{
  return controller.preferences->get_char(key).c_str();
}


/******************************************************************************
 * FileInfoManager functions.
 ******************************************************************************/
CantusHash *fileinfomanager_get_info(const gchar *filename)
{
  return controller.fileinfomanager->get_info_locked(filename);
}


void fileinfomanager_unlock_info(const gchar *filename)
{
  controller.fileinfomanager->unlock(filename);
}
