/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_TAGEDITOR_H
#define HAVE_TAGEDITOR_H

#define _CPLUSPLUS_

#include <iostream>
#include <gtkmm.h>
#include <libintl.h>
#include <list>
#include <map>
#include "../cantusplugin.h"
#include "../editarea.h"
#include "lib_vorbis.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

class TagEditor : public SigC::Object {
public:
  TagEditor(CantusHash *pplugindata);
  ~TagEditor();
  
  GtkWidget *editarea_build(gboolean vertical);
  void       set_from_hash(CantusHash *hash);
  void       gui_to_hash(CantusHash *hash);
  void       delete_if_not_in_hash(CantusHash *hash);
  void       show_tag(void);
  
private:
  void on_selection_changed_event(void *pfilenames);
  void on_file_read_finished_event(void *pinfo);
  void on_filelist_read_finished_event(void *trash);
  void on_editarea_button_save_clicked(void);
  void on_uiwidget_destroyed_event(void *widget);
  
  Editarea         editarea;
  std::map<const gchar*, void*> hashmap;  // Mapping between hash keys and tag.
  std::list<long>  listenerids;           // The ids of the eventbus listeners.
  GList           *selected;              // A list of all selected files.
  CantusHash      *plugindata;
  gboolean         isfirst;
  Tag              tag;
};

#endif
