/* lib_vorbis.
 * (c)2002, 2003 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_LIB_VORBIS_H
#define HAVE_LIB_VORBIS_H

#include <glib.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <vorbis/vorbisfile.h>
#include <vorbis/codec.h>
#include "../lib_charset.h"
#include "lib_vcedit.h"


typedef struct Tag_s
{
  char title[1024];
  char artist[1024];
  char album[1024];
  char year[5];
  char comment[1024];
  char track[20];
  char genre[512];
  unsigned int size;
  short int has_footer;
} Tag;

int get_vorbis_tag(Tag * tag, const char * filename);
int set_vorbis_tag(Tag * tag, const char * filename);
int del_vorbis_tag(const char * filename);

#endif
