/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_CANTUSPLUGIN_H
#define HAVE_CANTUSPLUGIN_H

#ifdef _CPLUSPLUS_
  #include <gtkmm.h>
#else
  #include <gtk/gtk.h>
#endif

#include "cantushash.h"


// Functions provided by plugins.
typedef void    *(*AnyFunc)      (void);
typedef gint     (*InitFunc)     (CantusHash *specs);
typedef gint     (*DestroyFunc)  (void);
typedef gboolean (*HandlesFunc)  (const gchar *filename);
typedef gint     (*ReadFunc)     (const gchar *filename, CantusHash *data);
typedef gint     (*WriteFunc)    (const gchar *filename, CantusHash *data);
typedef void    *(*UIPrefsFunc)  (void);
typedef void    *(*UIWidgetFunc) (gboolean vertical);
typedef void    *(*UIIconFunc)   (void);

// EventBus functions, provided by Cantus.
typedef void    *(*CantusPrefGetFunc)        (const gchar *); // FIXME.
typedef glong    (*CantusAddListenerFunc)    (const gchar *, GClosure *);
#ifdef _CPLUSPLUS_
typedef glong    (*CantusAddListenerSigCFunc)(const gchar *,
                                              SigC::Slot1<void, void*>);
#endif
typedef glong    (*CantusRemoveListenerFunc) (glong id);
typedef glong    (*CantusEmitFunc)           (const gchar *, const GValue *);

// Preferences functions, provided by Cantus.
typedef void         (*CantusPrefSet_intFunc)    (const gchar *key, gint value);
typedef gint         (*CantusPrefGet_intFunc)    (const gchar *key);
typedef void         (*CantusPrefSet_boolFunc)   (const gchar *key,
                                                  gboolean value);
typedef gboolean     (*CantusPrefGet_boolFunc)   (const gchar *key);
typedef void         (*CantusPrefSet_charFunc)   (const gchar *key,
                                                  const gchar *value);
typedef const gchar* (*CantusPrefGet_charFunc)   (const gchar *key);

// FileInfoManager functions, provided by Cantus.
typedef CantusHash  *(*CantusFileInfoGetFunc)   (const gchar *filename);
typedef void         (*CantusFileInfoUnlockFunc)(const gchar *filename);


#ifdef _CPLUSPLUS_
extern "C" {
#endif

/* Purpose: Plugin initializer.
 */
gint plugin_init(CantusHash *plugindata);

/* Purpose: Plugin destructor.
 */
gint plugin_destroy(void);

/* Purpose: Returns TRUE if the plugin is responsible for handling this
 * filetype, otherwise FALSE.
 */
gboolean plugin_handles(const gchar *filename);

/* Purpose: Will be called to read a file's information into a hash.
 * Returns an errorcode < 0, or 0.
 */
gint plugin_read(const gchar *filename, CantusHash *info);

/* Purpose: Will be called to write a file's information from a hash to the
 * filesystem.
 */
gint plugin_write(const gchar *filename, CantusHash *info);

/* Returns the widget tree to show as edit-area.
 * NULL as a return value is forbidden!
 * If this function returns NULL, the plugin will be deactivated.
 */
GtkWidget *plugin_get_uiwidget(gboolean vertical);

#ifdef _CPLUSPLUS_
} // extern "C"
#endif

#endif
