/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cantushash.h"

//#define _DEBUG_


/******************************************************************************
 * Statics.
 ******************************************************************************/
/* Helper function needed to free the complete cantushash including its data.
 */
static void g_hash_table_free_ghfunc(gpointer key,
                                     gpointer value,
                                     gpointer trash)
{
  value_delete((CantusHashValue*)value);
}


/* Helper function needed to copy the complete cantushash including its data.
 */
static void g_hash_table_insert_ghfunc(gpointer key,
                                       gpointer value,
                                       gpointer hash)
{
  CantusHashValue *copy = value_duplicate((CantusHashValue*)value);
  g_hash_table_insert((GHashTable*)hash, key, copy);
}


/******************************************************************************
 * Hash functions.
 ******************************************************************************/
CantusHash *cantushash_create(void)
{
  return (CantusHash*)g_hash_table_new(g_str_hash, g_str_equal);
}


void cantushash_destroy(CantusHash *hash)
{
  g_hash_table_foreach(hash, g_hash_table_free_ghfunc, NULL);
  g_hash_table_destroy(hash);
}


CantusHash *cantushash_duplicate(CantusHash *hash)
{
  CantusHash *copy = cantushash_create();
  g_hash_table_foreach(hash, g_hash_table_insert_ghfunc, (gpointer)copy);
  return copy;
}


void cantushash_set(CantusHash *hash, const gchar *key, gint type, gpointer val)
{
  CantusHashValue *value = NULL;
  if (value = (CantusHashValue*)g_hash_table_lookup(hash, key))
    value_delete(value);
  value = new_value();
  value_set(value, type, val);
  g_hash_table_insert(hash, (gpointer)key, value);
}


void cantushash_set_int(CantusHash *hash, const gchar *key, gint val)
{
  CantusHashValue *value = NULL;
  if (value = (CantusHashValue*)g_hash_table_lookup(hash, key))
    value_delete(value);
  value = new_value();
  value_set_int(value, val);
  g_hash_table_insert(hash, (gpointer)key, value);
}


gint cantushash_get_int(CantusHash *hash, const gchar *key)
{
  CantusHashValue *value = (CantusHashValue*)g_hash_table_lookup(hash, key);
  return value ? value_get_int(value) : 0;
}


void cantushash_set_char(CantusHash *hash, const gchar *key, const gchar *val)
{
  CantusHashValue *value = NULL;
  if (value = (CantusHashValue*)g_hash_table_lookup(hash, key))
    value_delete(value);
  value = new_value();
  value_set_char(value, val);
  g_hash_table_insert(hash, (gpointer)key, value);
}


const gchar *cantushash_get_char(CantusHash *hash, const gchar *key)
{
  CantusHashValue *value = (CantusHashValue*)g_hash_table_lookup(hash, key);
  return value ? value_get_char(value) : "";
}


void cantushash_set_bool(CantusHash *hash, const gchar *key, gboolean val)
{
  CantusHashValue *value = NULL;
  if (value = (CantusHashValue*)g_hash_table_lookup(hash, key))
    value_delete(value);
  value = new_value();
  value_set_bool(value, val);
  g_hash_table_insert(hash, (gpointer)key, value);
}


gboolean cantushash_get_bool(CantusHash *hash, const gchar *key)
{
  CantusHashValue *value = (CantusHashValue*)g_hash_table_lookup(hash, key);
  return value ? value_get_bool(value) : FALSE;
}


void cantushash_set_pointer(CantusHash *hash, const gchar *key, gpointer val)
{
  CantusHashValue *value = NULL;
  if (value = (CantusHashValue*)g_hash_table_lookup(hash, key))
    value_delete(value);
  value = new_value();
  value_set_pointer(value, val);
  g_hash_table_insert(hash, (gpointer)key, value);
}


gpointer cantushash_get_pointer(CantusHash *hash, const gchar *key)
{
  CantusHashValue *value = (CantusHashValue*)g_hash_table_lookup(hash, key);
  return value ? value_get_pointer(value) : NULL;
}
