/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_PLUGINHANDLER_H
#define HAVE_PLUGINHANDLER_H

class PluginHandler;

#include <iostream>
#include <glibmm.h>
#include <string>
#include <list>
#include <map>
#include "plugin.h"


class PluginHandler : public SigC::Object {
protected:
  // Prevent copys.
  PluginHandler(PluginHandler &p) { g_assert_not_reached(); }
  // Prevent assignments.
  PluginHandler& operator=(PluginHandler &p) { g_assert_not_reached(); }
  
public:
  PluginHandler();
  ~PluginHandler();
  
  /* Triggered whenever a plugin has successfully been loaded. */
  SigC::Signal1<void, Plugin*> signal_plugin_loaded;
  /* Triggered whenever a plugin has been removed (= when the refcounter has */
  /* been decreased). */
  SigC::Signal1<void, Plugin*> signal_plugin_removed;
  /* Triggered straight before a plugin is being deleted (= when the */
  /* refcounter has reached a value <= 0). */
  SigC::Signal1<void, Plugin*> signal_plugin_deleted;
  
  /* Register a new input plugin.
   * Returns 0 on success, an errorcode < 0 otherwise.
   * Emits the Plugin::Registered signal.
   */
  gint reg(const gchar *filename, gint priority);
  
  /* Unregister an input plugin (=decrease the plugin's refcounter).
   * Emits the Plugin::Unregistered signal.
   */
  void unreg(const gchar *filename);
  
  /* Return an std::list of all plugins responsible for the given file type.
   * Don't forget to delete the list AND UNREF EVERY PLUGIN!!
   */
  std::list<Plugin*> *get_responsible_plugins(const gchar *filename);
  
  /* Given a list of filenames, this function returns a std::list of all
   * responsible plugins for the given filetypes.
   * Don't forget to delete the list AND UNREF EVERY PLUGIN!!
   */
  std::list<Plugin*> *get_responsible_plugins_from_list(GList *filenames);
  
  /* This function returns a list of all plugins. Don't forget to delete the
   * list AND UNREF EVERY PLUGIN!!
   */
  std::list<Plugin*> *get_plugins(void);
  
protected:
          // Holds mappings between plugin filenames and "Plugin" objects.
  std::map<std::string, Plugin*> plugins_str;
  std::map<int, Plugin*>         plugins_int;
};

#endif
