/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

class Controller;

#ifndef HAVE_CONTROLLER_H
#define HAVE_CONTROLLER_H

#include <iostream>
#include <gtkmm.h>
#include "eventbus.h"
#include "pluginhandler.h"
#include "fileinfomanager.h"
#include "preferences.h"
class FileInfo;  // from "fileinfo.h"


class Controller : public SigC::Object {
protected:
  // Prevent copys.
  Controller(Controller &c) { g_assert_not_reached(); }
  // Prevent assignments.
  Controller& operator=(Controller &c) { g_assert_not_reached(); }
  
public:
  Controller();
  ~Controller();
  
  /* Loads the preferences from the configfile.
   */
  int configfile_load(void);
  
  /* Saves the preferences to the configfile.
   */
  int configfile_save(void);
  
  PluginHandler   *pluginhandler;
  FileInfoManager *fileinfomanager;
  Preferences     *preferences;
  ConfigFile      *configfile;
  EventBus        *eventbus;
  
private:
  /* Triggers eventbus events and queues the files to the FileInfoManager.
   */
  void on_filelist_selection_changed(void *filenames);
  
  /* Whenever a new plugin has been registered, this updates the
   * FileInfoManager.
   */
  void on_plugins_registered(Plugin *plugin);
  
  /* This signal indicates that some file's data needs to be written to the
   * filesystem. May, for example, be triggered by a plugin when a "save" button
   * has been pressed.
   */
  void on_filelist_save_request(void *list);
  
  /* Emits an eventbus event.
   */
  void emit_file_read_finished_event(FileInfo *info);
  
  /* Emits an eventbus event.
   */
  void emit_file_read_failed_event(FileInfo *info);
  
  /* Emits an eventbus event.
   */
  void emit_file_write_failed_event(FileInfo *info);
  
  /* Emits an eventbus event.
   */
  void emit_file_rename_finished_event(FileInfo *info);
  
  /* Emits an eventbus event.
   */
  void emit_file_rename_failed_event(FileInfo *info);
  
  /* Emits an eventbus event.
   */
  void emit_filenames_read_finished_event(void);
  
  /* Emits an eventbus event.
   */
  void emit_preferences_changed_event(std::string key);
};

#endif
