/* The Cantus project.
 * (c)2002, 2003, 2004 by Samuel Abels (spam debain org)
 * This project's homepage is: http://www.debain.org/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef HAVE_CONFIGFILE_H
#define HAVE_CONFIGFILE_H

#include <glibmm.h>
#include <bits/stl_pair.h>
#include <sigc++/class_slot.h>
#include <iostream>
#include <fstream>
#include <list>
#include <string>
#include <sstream>


class ConfigFile : public SigC::Object {
public:
  ConfigFile();
  ~ConfigFile();
  
  /* Defines which file to read/write from.
   */
  void set_filename(std::string newfilename);
  
  /* Check, whether or not the file exists and is read-/writable.
   * Returns  0 if the file is read/writeable.
   *         -1 if no filename has been set yet or the file does not exist.
   *         -2 if the file is not readable.
   *         -3 if the file is not writeable.
   */
  int check(void);
  
  /* This function opens the configfile and saves all option/value pairs in the
   * given map. Returns an errorcode, or 0 on success.
   */
  int load(void);
  
  /* This function writes the configfile contents from the memory to the
   * configfile. Returns an errorcode, or 0 on success.
   */
  int save(void);
  
  /* Clear the configfile content (only in the memory).
   */
  void clear(void);
  
  /* Appends one key/value pair to the configfile (only in the memory).
   * Args passed to the method are: The key name, the value type (e.g.
   * G_TYPE_INT) and the value.
   * Returns always TRUE.
   */
  bool append(std::string key, int type, void *value);
  
  /* Walks through all lines of the file, passing every option to the slot.
   * Args passed to the slot are: The key name, the value type (e.g.
   * G_TYPE_INT) and the value.
   */
  void foreach_line(SigC::Slot3<bool, std::string, int, void*> slot);
  
protected:
  /* Given one line of a file, this function returns the extracted key/value
   * pair.
   */
  std::pair<std::string, std::string> get_pair(const gchar *pline);
  
  /* Given one value string, this function extracts the value in the right data
   * type.
   */
  std::pair<int, void*> grab_value(std::string value);
  
  std::list<std::pair<std::string, std::string> > content;  // The file content.
  std::string filename;                                     // The file name.
};

#endif
