/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "popups.h"
#include "support.h"
#include "interface.h"
#include "memory.h"
#include "lib_id3v1.h"
#include "lib_id3v2.3.h"
#include "mp3info.h"
#include "gui_filelist.h"
#include "gui_dirtree.h"
#include "configfile.h"
#include "queue.h"
#include "gui_queue.h"
#include "shared.h"

/***************************************************************************************
 * BELOW FOLLOW THE STATICS
 ***************************************************************************************/

// Returns the datapointer to the queueitems data with the given fullfilename
static Mp3Info *
g_list_find_matching_fullfilename(GList *haystack, gchar *fullfilename)
{
	GList *haystack_item = NULL;
	Mp3Info *haystack_mp3info = NULL;
	gchar haystack_fullfilename[2048];

	haystack_item = g_list_first(haystack);
	while(haystack_item)
	{
		haystack_mp3info = (Mp3Info *)haystack_item->data;
		haystack_item = g_list_next(haystack_item);
		
		snprintf(haystack_fullfilename, 2047, "%s%s", haystack_mp3info->directory, haystack_mp3info->filename);
		if(strncmp(fullfilename, haystack_fullfilename, 2048)==0)
			return haystack_mp3info;
	}
	return NULL;
}

// Returns the datapointer to the first matching queueitems data with the given directory
static Mp3Info *
g_list_find_matching_directory(GList *haystack, gchar *directory)
{
	GList *haystack_item = NULL;
	Mp3Info *haystack_mp3info = NULL;

	haystack_item = g_list_first(haystack);
	while(haystack_item)
	{
		haystack_mp3info = (Mp3Info *)haystack_item->data;
		haystack_item = g_list_next(haystack_item);
		
		if(strncmp(directory, haystack_mp3info->directory, strlen(directory))==0)
			return haystack_mp3info;
	}
	return NULL;
}

// Removes all items from haystack that have a filename that is in needle.
static GList *
g_list_remove_matching_filenames (GList *haystack, GList *needle)
{
	GList *haystack_item = NULL;
	GList *needle_item = NULL;
	Mp3Info *haystack_mp3info = NULL;
	gchar haystack_fullfilename[4096] = "";
	gchar *needle_fullfilename = NULL;

	haystack_item = g_list_first (haystack);
	while (haystack_item)
	{
		haystack_mp3info = (Mp3Info *)haystack_item->data;
		haystack_item = g_list_next (haystack_item);
		snprintf (haystack_fullfilename, 4095, "%s%s", haystack_mp3info->directory, haystack_mp3info->filename);

		needle_item = g_list_first (needle);
		while(needle_item)
		{
			needle_fullfilename = needle_item->data;
			needle_item = g_list_next (needle_item);
			
			if ( strncmp (needle_fullfilename, haystack_fullfilename, 4095) == 0 )
			{
				haystack = mem_free_1 (haystack, haystack_mp3info);
				break;
			}
		}
	}
	
	return g_list_first (haystack);
}

/***************************************************************************************
 * END OF STATICS
 ***************************************************************************************/








void clist_cantus_queue_rightclicked(GtkCList *clist, gint x, gint y)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	GList* node = g_list_first(clist->selection);
	gint row, col;
	gboolean selected = FALSE;

	lastclick_x=x;
	lastclick_y=y;

	gtk_clist_get_selection_info(clist, x, y, &row, &col);
	while (node)
	{
		if (row == (int)node->data) selected=TRUE;
		node = g_list_next(node);
	}
	if(!selected)
	{
		gtk_clist_unselect_all(clist);
		gtk_clist_select_row(clist, row, col);
	}
}



void popup_cantus_queue_remove(GtkCList *clist)
{
	queue_files_remove_selected(clist);
}


void popup_cantus_queue_select(GtkCList *clist_cantus_queue, const gchar *status)
{
	Mp3Info *mp3info = NULL;
	GList* node = NULL;
	gboolean selected = FALSE;
	gint row = -1;
	gchar fullfilename[2048];

	if(strncmp(status, "invert", 6)==0)
	{
		while((mp3info = (Mp3Info *)gtk_clist_get_row_data (clist_cantus_queue, ++row)))
		{
			selected = FALSE;
			node = g_list_first(clist_cantus_queue->selection);
			while (node)
			{
				if (row == (int)node->data)
					selected = TRUE;
				node = g_list_next(node);
			}
			if(!selected)
				gtk_clist_select_row(clist_cantus_queue, row, 0);
			else
				gtk_clist_unselect_row(clist_cantus_queue, row, 0);
		}
		return;
	}

	if(strncmp(status, "id3v1", 5)==0)
	{
		id3Tag *tag = calloc(1,sizeof(id3Tag));
		
		while((mp3info = (Mp3Info *)gtk_clist_get_row_data (clist_cantus_queue, ++row)))
		{
			snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
			if(get_id3v1_tag(tag, fullfilename)==0)
				gtk_clist_select_row(clist_cantus_queue, row, 0);
		}
		free(tag);
		return;
	}

	if(strncmp(status, "id3v2", 5)==0)
	{
		id3Tag *tag = calloc(1,sizeof(id3Tag));
		
		while((mp3info = (Mp3Info *)gtk_clist_get_row_data (clist_cantus_queue, ++row)))
		{
			snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
			if(get_id3v2_tag(tag, fullfilename)==0)
				gtk_clist_select_row(clist_cantus_queue, row, 0);
		}
		free(tag);
		return;
	}

	if(strncmp(status, "notag", 5)==0)
	{
		id3Tag *tag = calloc(1,sizeof(id3Tag));
		
		while((mp3info = (Mp3Info *)gtk_clist_get_row_data (clist_cantus_queue, ++row)))
		{
			snprintf(fullfilename, 2047, "%s%s", mp3info->directory, mp3info->filename);
			if( get_id3v1_tag(tag, fullfilename)!=0
				&& get_id3v2_tag(tag, fullfilename)!=0 )
				gtk_clist_select_row(clist_cantus_queue, row, 0);
		}
		free(tag);
		return;
	}

	while((mp3info = (Mp3Info *)gtk_clist_get_row_data (clist_cantus_queue, ++row)))
	{
		if(strcmp(mp3info->status, status)==0)
			gtk_clist_select_row(clist_cantus_queue, row, 0);
	}
}







void clist_cantus_filelist_rightclicked(gint x, gint y)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	extern GtkWidget *cantus;
	GList* node = g_list_first(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist"))->selection);
	gint row = 0, col = 0;
	gboolean selected = FALSE;

	lastclick_x = x;
	lastclick_y = y;

	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist")), x, y, &row, &col);
	while (node)
	{
		if (row == (int)node->data) selected=TRUE;
		node = g_list_next(node);
	}
	if(!selected)
	{
		gtk_clist_unselect_all(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist")));
		gtk_clist_select_row(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist")), row, col);
	}
}






void popup_cantus_filelist_refresh(void)
{
	extern GtkWidget *cantus;
	extern gchar *current_dir;
	extern Cfg cfg;
	
	clist_filelist_update( GTK_CLIST(lookup_widget(cantus, "clist_cantus_filelist")),
		current_dir,
		cfg.showhidden );
}




void popup_cantus_filelist_rename_file(void)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	extern GtkWidget *cantus;
	extern GtkWidget *popup_rename_file;
	gint row = -1, col = -1;
	gchar *filename = NULL;

	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;
	guint8 i = 0;
	
	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist")), lastclick_x, lastclick_y, &row, &col);
	if(row != -1)
	{
		popup_rename_file = create_rename_file();
		gtk_clist_get_pixtext(GTK_CLIST(lookup_widget (cantus, "clist_cantus_filelist")), row, 0, &filename, &i, &pixmap, &mask);
		gtk_entry_set_text(GTK_ENTRY(lookup_widget(popup_rename_file, "entry_cantus_rename_file_name")), filename);
		gtk_widget_show(popup_rename_file);
	}
}




void popup_cantus_filelist_rename_file_ok(void)
{
	extern GtkWidget *popup_rename_file;
	extern GtkWidget *cantus;
	extern GList *queue;
	extern Cfg cfg;
	extern gchar *current_dir;
	extern gint lastclick_x;
	extern gint lastclick_y;
	gint row = -1, col = -1;
	gchar fileold[4000];
	gchar filenew[4000];

	gchar *filename = NULL;

	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;
	guint8 i = 0;
	
	Mp3Info *mp3info = NULL;
	
	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "clist_cantus_filelist")), lastclick_x, lastclick_y, &row, &col);
	gtk_clist_get_pixtext(GTK_CLIST(lookup_widget (cantus, "clist_cantus_filelist")), row, 0, &filename, &i, &pixmap, &mask);

	snprintf(fileold, 3999, "%s%s", current_dir, filename);
	snprintf(filenew, 3999, "%s%s", current_dir,
		gtk_entry_get_text(GTK_ENTRY(lookup_widget(popup_rename_file, "entry_cantus_rename_file_name")))); 
	
	mp3info = g_list_find_matching_fullfilename(queue, fileold);
	
	if( rename(fileold, filenew) == 0
		&& queue != NULL
		&& mp3info != NULL )
	{
		strncpy (mp3info->filename, strrchr(filenew, '/')+1, 2047);
		clist_file_update (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update (GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
	}
	
	gtk_widget_destroy(popup_rename_file);
	
	clist_filelist_update( GTK_CLIST(lookup_widget(cantus, "clist_cantus_filelist")),
		current_dir,
		cfg.showhidden );
}









void popup_cantus_dirtree_rename_directory(void)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	extern GtkWidget *cantus;
	extern GtkWidget *popup_rename_directory;
	gint row, col;
	gchar directory[2000];
	GtkCTreeNode *node;

	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "ctree_cantus_directories")), lastclick_x, lastclick_y, &row, &col);
	if(row!=-1)
	{
		node = gtk_ctree_node_nth (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), row);
		popup_rename_directory = create_rename_directory();
		
		strcpy(directory,
			gtk_ctree_node_get_row_data (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node));
		*strrchr(directory, '/')='\0';
		sprintf(directory, "%s", strrchr(directory, '/') + 1);
		
		gtk_entry_set_text(GTK_ENTRY(lookup_widget (popup_rename_directory, "entry_cantus_rename_directory_name")), 
			(char *)directory);
		gtk_widget_show(popup_rename_directory);
	}
}






void popup_cantus_dirtree_rename_directory_ok(void)
{
	extern GtkWidget *popup_rename_directory;
	extern GtkWidget *cantus;
	extern gchar *active_tag;
	extern GList *queue;
	extern gint lastclick_x;
	extern gint lastclick_y;
	gchar dirold[4000];
	gchar dirnew[4000];
	gchar diroldslashed[2047];
	gchar dirnewmerge[2047];
	gchar parentdir[4000];
	extern gchar *current_dir;
	Mp3Info *mp3info = NULL;
	gint row, col;
	gchar *foo;
	GdkPixmap *pm;
	GdkBitmap *mask;
	GtkCTreeNode *node;

	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "ctree_cantus_directories")), lastclick_x, lastclick_y, &row, &col);
	
	node = gtk_ctree_node_nth (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), row);
	
// determine full parentdir
	strcpy(parentdir,
		gtk_ctree_node_get_row_data (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node));
	*strrchr(parentdir, '/')='\0';
	*strrchr(parentdir, '/')='\0';

// full path old dir
	strcpy(dirold,
		gtk_ctree_node_get_row_data (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node));
	*strrchr(dirold, '/')='\0';

// if a "/" is found in the new filename, dont do anything.
	if(strchr(gtk_entry_get_text(
		GTK_ENTRY(lookup_widget (popup_rename_directory, "entry_cantus_rename_directory_name"))), '/')!=NULL)
	{
		gtk_widget_destroy(popup_rename_directory);
		return;
	}
	
// and full path new dir
	sprintf(dirnew, "%s/%s", parentdir,
		gtk_entry_get_text(GTK_ENTRY(lookup_widget (popup_rename_directory, "entry_cantus_rename_directory_name")))); 
		
	gtk_widget_destroy(popup_rename_directory);
	
// if unsuccesful, dont update node info.
	if(rename(dirold, dirnew)!=0)
		return;
	
	snprintf(current_dir, 2047, "%s/", dirnew);
	snprintf(diroldslashed, 2047, "%s/", dirold);
	
// Update files that are already in queue
	while( (mp3info = g_list_find_matching_directory(queue, diroldslashed)) )
	{
		snprintf(dirnewmerge, 2047, "%s/%s", dirnew, (mp3info->directory)+strlen(diroldslashed));
		strncpy( (mp3info->directory), dirnewmerge, 2047 );
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queue")), mp3info);
		clist_file_update(GTK_CLIST(lookup_widget(cantus, "clist_cantus_queueonly_queue")), mp3info);
	}
	
	*active_tag = '\0';
	
	gtk_ctree_node_get_pixtext(GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node, 0, &foo, NULL, &pm, &mask);
	gtk_ctree_node_set_pixtext(GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node, 0, strrchr(dirnew, '/') + 1,
		5, pm, mask);
	sprintf(gtk_ctree_node_get_row_data (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), node), "%s/", dirnew);

	gtk_ctree_sort_recursive(GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), GTK_CTREE_ROW(node)->parent);
}














void
popup_cantus_dirtree_delete_directory(void)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	extern GtkWidget *cantus;
	extern GtkWidget *popup_really_do;
	gint row = -1, col = -1;
	gchar message[2048];
	GtkCTreeNode *node = NULL;

	gtk_clist_get_selection_info(GTK_CLIST (lookup_widget (cantus, "ctree_cantus_directories")), lastclick_x, lastclick_y, &row, &col);
	if(row != -1)
	{
		node = gtk_ctree_node_nth (GTK_CTREE (lookup_widget (cantus, "ctree_cantus_directories")), row);
		popup_really_do = create_really_do();
		
		snprintf(message, 2047, "Really delete directory %s?", (gchar *)gtk_ctree_node_get_row_data(GTK_CTREE(lookup_widget(cantus, "ctree_cantus_directories")), node));
		
		gtk_label_set_text(GTK_LABEL(lookup_widget (popup_really_do, "label_cantus_really_do")), 
			(char *)message);
		gtk_widget_show(popup_really_do);
	}
}







void
popup_cantus_dirtree_really_do_ok(void)
{
	extern GtkWidget *popup_really_do;
	extern GtkWidget *cantus;
	extern GList *queue;
	extern gchar *current_dir;
	extern gchar *active_tag;
	extern gint lastclick_x;
	extern gint lastclick_y;
	
	GtkCTree *ctree = NULL;
	GtkCTreeNode *node = NULL;
	GtkCTreeNode *child = NULL;
	GList *selection = NULL;
	GList *item = NULL;
	gint row, col;
	Mp3Info *mp3info = NULL;
	gchar *directory = NULL;
	gchar *label = NULL;
	gchar command[4096];

	*active_tag = '\0';
	
	gtk_label_get(GTK_LABEL(lookup_widget(popup_really_do, "label_cantus_really_do")), &label);
	if( strncmp(label, "Really delete directory", 22) == 0 )
	{
		ctree = GTK_CTREE(lookup_widget(cantus, "ctree_cantus_directories"));
		gtk_clist_freeze (GTK_CLIST(ctree));
		
		gtk_clist_get_selection_info(GTK_CLIST(ctree), lastclick_x, lastclick_y, &row, &col);
		node = gtk_ctree_node_nth(ctree, row);
// full path dir
		directory = gtk_ctree_node_get_row_data(ctree, node);

		snprintf(command, 4095, "rm -r \"%s\"", directory);
		system(command);
		
		snprintf(current_dir, 2047, "%s", directory);
		*strrchr(current_dir, '/') = '\0';
		*(strrchr(current_dir, '/')+1) = '\0';
		
// Update files that are already in queue
		while( (mp3info = g_list_find_matching_directory (queue, directory)) != NULL )
			queue = mem_free_1 (queue, mp3info);
		
		queue_update (TRUE);
		
// We have to do a rescan of the current ctree branch
		ctree_collapse_dirtree (ctree, node);
		child = GTK_CTREE_ROW(node)->children;
		remove_node (ctree, child, NULL);
		remove_node (ctree, node, NULL);
		gtk_clist_thaw (GTK_CLIST(ctree));
		
		ctree_dirtree_open_directory (ctree, current_dir);
		return;
	}
	else if( strncmp(label, "Really delete file", 18) == 0
		|| strncmp(label, "Are you sure you want to delete ", 32) == 0 )
	{
// get a list of selected files
		selection = clist_filenames_get_selected (GTK_CLIST(lookup_widget (cantus, "clist_cantus_filelist")), current_dir);
		if ( !selection )
			return;
	
// Count selected files
		item = g_list_first (selection);
		while ( item != NULL )
		{
			snprintf (command, 4096, "rm \"%s\"", (gchar *)item->data);
			queue = g_list_remove_matching_filenames (queue, selection);
			system (command);
			item = item->next;
		}
		
		queue_update (TRUE);
		return;
	}
	else
		return;
}



void
popup_cantus_filelist_delete_file(void)
{
	extern GtkWidget *cantus;
	extern GtkWidget *popup_really_do;
	extern gchar *current_dir;
	
	GList *selection = NULL;
	GList *item = NULL;
	gint cur = 0;
	gchar message[2048];

// prepare popup
	popup_really_do = create_really_do();
	
// get a list of selected files
	selection = clist_filenames_get_selected(GTK_CLIST(lookup_widget (cantus, "clist_cantus_filelist")), current_dir);
	if(!selection)
		return;
	
// Count selected files
	item = g_list_first(selection);
	while(item)
	{
		item = item->next;
		cur++;
	}
	item = g_list_first(selection);
	
	if(cur==1)
		snprintf(message, 2047, "Really delete file %s?", (gchar *)item->data);
	else
		snprintf(message, 2047, "Are you sure you want to delete %i files?", cur);
		
	gtk_label_set_text(GTK_LABEL(lookup_widget (popup_really_do, "label_cantus_really_do")), 
		(char *)message);
	gtk_widget_show(popup_really_do);
}






void
popup_cantus_createdir_ok (void)
{
	extern gint lastclick_x;
	extern gint lastclick_y;
	extern GtkWidget *cantus;
	extern GtkWidget *popup_create_directory;
	gint row = -1, col = -1;
	gchar command[4096];
	GtkCTree *ctree = NULL;
	GtkCTreeNode *node = NULL;

	gtk_clist_get_selection_info (GTK_CLIST (lookup_widget (cantus, "ctree_cantus_directories")), lastclick_x, lastclick_y, &row, &col);
	ctree = GTK_CTREE(lookup_widget(cantus, "ctree_cantus_directories"));
	gtk_clist_freeze (GTK_CLIST(ctree));
	
	if ( row != -1 )
	{
		node = gtk_ctree_node_nth(ctree, row);
		
		snprintf( command, 4096, "mkdir \"%s%s\"",
			(gchar *)gtk_ctree_node_get_row_data(ctree, node),
			gtk_entry_get_text(GTK_ENTRY(lookup_widget(popup_create_directory, "entry_create_directory"))) );
		system(command);
		
// We have to do a rescan of the ctree branch
		if ( GTK_CTREE_ROW(node)->children != NULL )
			ctree_collapse_dirtree (ctree, node);
	}
	
	gtk_clist_thaw (GTK_CLIST(ctree));
// expand the current dir.		
	gtk_ctree_expand (ctree, node);
}
