/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "support.h"
#include "memory.h"
#include "options.h"
#include "configfile.h"
#include "shared.h"


/**********************************************************************
 * Adds a new entered server to the freedb server list
 **********************************************************************/
void
options_freedb_server_add(void)
{
	extern GtkWidget *options;
	gchar *row[5];
	gint i = -1;
	
// Server name and port are mandatory
	if( *gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_freedb_server")))=='\0'
		|| *gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_freedb_port")))=='\0' )
		return;
	
	row[0] = malloc(2048);
	strncpy(row[0], gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_freedb_server"))), 2047);
	row[1] = malloc(2048);
	strncpy(row[1], gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_freedb_port"))), 2047);
	if(!GTK_WIDGET_IS_SENSITIVE(lookup_widget(options, "entry_options_freedb_path")))
	{
		row[2] = strdup("FREEDB\0");
		row[3] = malloc(1);
		*row[3] = '\0';
	}
	else
	{
		row[2] = strdup("HTTP\0");
		row[3] = malloc(2048);
		strncpy(row[3], gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_freedb_path"))), 2047);
	}
	row[4] = NULL;
	
	gtk_clist_append(GTK_CLIST(lookup_widget(options, "clist_options_freedb_server")), row);
	
	while(row[++i])
		free(row[i]);
}





/**********************************************************************
 * Deletes a server from the freedb server list
 **********************************************************************/
void
options_freedb_server_delete(void)
{
	extern GtkWidget *options;
	GtkCList *clist_options_freedb_server = NULL;
	GList *selection = NULL;
	gint row = 0;

	clist_options_freedb_server = GTK_CLIST (lookup_widget (options, _("clist_options_freedb_server")));
	selection = clist_options_freedb_server->selection;

	while (selection)
	{
		row = (gint)selection->data;
		selection = selection->next;
		gtk_clist_remove(clist_options_freedb_server, row);
	}
}






/**********************************************************************
 * Checks, which columns are available to customize the queue
 * and updates the itemlist with this info. (still avialable items)
 **********************************************************************/
void
options_listview_items_update(GtkCList *clist)
{
	gchar *items[31]={
		"Directory",
		"Destinationname",
		"Filename",
		"Size",
		"Owner",
		"Group",
		"Mode",
		"V1-Artist",
		"V1-Song",
		"V1-Album",
		"V1-Year",
		"V1-Comment",
		"V1-Track",
		"V1-Genre",
		"V2-Artist",
		"V2-Song",
		"V2-Album",
		"V2-Year",
		"V2-Comment",
		"V2-Track",
		"V2-Genre",
		"Ogg-Artist",
		"Ogg-Song",
		"Ogg-Album",
		"Ogg-Year",
		"Ogg-Comment",
		"Ogg-Track",
		"Ogg-Genre",
		"Status",
		"Time",
		NULL };
	extern GtkWidget *options;
	gchar *foo = NULL;
	gint cur = -1, i = -1;
	gboolean found = FALSE;
	gchar *output[1];
	
	while(items[++i])
	{
		found = FALSE;
		cur = -1;
		while(gtk_clist_get_text(GTK_CLIST(lookup_widget(options, "clist_options_listview_columns")), ++cur, 0, &foo))
		{
			if(strcmp(foo, items[i])==0)
				found = TRUE;
		}
		output[0] = items[i];
		if(!found)
			gtk_clist_append(clist, output);
	}
	gtk_clist_sort(clist);	
}







/**********************************************************************
 * Move a selected row in clist_items to listview_columns.
 **********************************************************************/
void
options_listview_add(GtkCList *clist_from, GtkCList *clist_to)
{
	gchar *foo[1];

	if(!clist_from->selection)
		return;
	
// add the selected row in the itemlist to the columnlist
// and remove it from the itemlist
	if(gtk_clist_get_text(clist_from, (gint)(clist_from->selection)->data, 0, &foo[0]))
	{
		gtk_clist_append(clist_to, foo);
		gtk_clist_remove(clist_from, (gint)clist_from->selection->data);
	}
}



// This saves the config in the configfile.
gint
options_dialog_save(void)
{
	gchar *my_options[200][3]={
	/* Tab "Preferences" */
		{ "check_options_preferences_splash", "program general", "hide splash" },
		
		{ "check_options_preferences_showhidden", "program general", "show hidden files" },
		
		{ "check_options_preferences_togglebg", "program general", "toggle queue background" },
		
		{ "entry_options_preferences_defaultdir", "program general", "default directory" },
		
		{ "radio_options_preferences_defaulttag_v1", "program general", "default tag v1" },
		{ "radio_options_preferences_defaulttag_v2", "program general", "default tag v2" },
		{ "radio_options_preferences_defaulttag_both", "program general", "default tag both" },
	/* Tab "FreeDB" */
		{ "clist_options_freedb_server", "freedb servers", "server" },
		{ "check_options_freedb_proxy", "freedb", "enable proxy" },
		{ "entry_options_freedb_proxy", "freedb", "proxy address" },
		{ "entry_options_freedb_proxy_port", "freedb", "proxy port" },
		{ "entry_options_freedb_path_local", "freedb", "cgi-path" },
	/* Tab "Customize list view" */
		{ "clist_options_listview_columns", "queue columns", "column" },
	/* Tab "Special Characters" */
		{ "clist_options_characters_list", "special characters", "char" },
		{ "\0", "\0", "\0" }
	};
	
	extern GtkWidget *options;
	gchar *config = malloc(10000);
	gchar *foo[5];
	gchar temp[2048];
	gint i = -1, f = 0;
	
// read old configfile
	config_read(config, 10000);
	
	while(my_options[++i][0] && *(my_options[i][0])!='\0')
	{
		if(!strncmp(my_options[i][0], "check", 5))
		{
			if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0]))) )
				configfile_option_add(config, my_options[i][1], my_options[i][2], "TRUE");
			else
				configfile_option_add(config, my_options[i][1], my_options[i][2], "FALSE");
		}
		else if(!strncmp(my_options[i][0], "radio", 5))
		{
			if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0]))) )
				configfile_option_add(config, my_options[i][1], my_options[i][2], "TRUE");
			else
				configfile_option_add(config, my_options[i][1], my_options[i][2], "FALSE");
		}
		else if(!strncmp(my_options[i][0], "entry", 5))
		{
			configfile_option_add(config, my_options[i][1], my_options[i][2],
				gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, my_options[i][0]))));
		}
		else if(!strncmp(my_options[i][0], "clist", 5))
		{
// remove all list entries from the config, to then add the current again.
			configfile_category_remove(config, my_options[i][1]);
			f = -1;
			while(gtk_clist_get_text(GTK_CLIST(lookup_widget(options, my_options[i][0])), ++f, 0, &foo[0]))
			{
				if(!gtk_clist_get_text(GTK_CLIST(lookup_widget(options, my_options[i][0])), f, 1, &foo[1]))
					foo[1] = NULL;
				if(!gtk_clist_get_text(GTK_CLIST(lookup_widget(options, my_options[i][0])), f, 2, &foo[2]))
					foo[2] = NULL;
				if(!gtk_clist_get_text(GTK_CLIST(lookup_widget(options, my_options[i][0])), f, 3, &foo[3]))
					foo[3] = NULL;
				
				if(foo[0])
				{
// append a row and column number to the option name.
					snprintf(temp, 2048, "%s%i#1", my_options[i][2], f);
// and add the option to the config.
					configfile_option_add(config, my_options[i][1], temp, foo[0]);
				}
				if(foo[1])
				{
					snprintf(temp, 2048, "%s%i#2", my_options[i][2], f);
					configfile_option_add(config, my_options[i][1], temp, foo[1]);
				}
				if(foo[2])
				{
					snprintf(temp, 2048, "%s%i#3", my_options[i][2], f);
					configfile_option_add(config, my_options[i][1], temp, foo[2]);
				}
				if(foo[3])
				{
					snprintf(temp, 2048, "%s%i#4", my_options[i][2], f);
					configfile_option_add(config, my_options[i][1], temp, foo[3]);
				}
			}
		}
	}

// Put to configfile
	config_write(config);
	
	free(config);
	return 0;
}





// This loads the config from the configfile.
gint
options_dialog_load(void)
{
	gchar *my_options[200][3]={
	/* Tab "Preferences" */
		{ "check_options_preferences_splash", "program general", "hide splash" },
		
		{ "check_options_preferences_showhidden", "program general", "show hidden files" },
		
		{ "check_options_preferences_togglebg", "program general", "toggle queue background" },
		
		{ "entry_options_preferences_defaultdir", "program general", "default directory" },
		
		{ "radio_options_preferences_defaulttag_v1", "program general", "default tag v1" },
		{ "radio_options_preferences_defaulttag_v2", "program general", "default tag v2" },
		{ "radio_options_preferences_defaulttag_both", "program general", "default tag both" },
	/* Tab "FreeDB" */
		{ "clist_options_freedb_server", "freedb servers", "server" },
		{ "check_options_freedb_proxy", "freedb", "enable proxy" },
		{ "entry_options_freedb_proxy", "freedb", "proxy address" },
		{ "entry_options_freedb_proxy_port", "freedb", "proxy port" },
		{ "entry_options_freedb_path_local", "freedb", "cgi-path" },
	/* Tab "Customize list view" */
		{ "clist_options_listview_columns", "queue columns", "column" },
	/* Tab "Special Characters" */
		{ "clist_options_characters_list", "special characters", "char" },
		{ "\0", "\0", "\0" }
	};
	
	extern GtkWidget *options;
	gchar *config = malloc(10000);
	gint i = -1, f = -1;
	gchar value[2048];
	gchar *foo[4];
	gchar option[2048];
	
// Get from configfile
	config_read(config, 10000);

	i = -1;
	while(*my_options[++i][0] != '\0')
	{
		if(!strncmp(my_options[i][0], "check", 5))
		{
			configfile_option_get(config, my_options[i][1], my_options[i][2], value);
			if( !strncmp(value, "TRUE", 4) )
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0])), TRUE);
			else
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0])), FALSE);
		}
		else if(!strncmp(my_options[i][0], "radio", 5))
		{
			configfile_option_get(config, my_options[i][1], my_options[i][2], value);
			if( !strncmp(value, "TRUE", 4) )
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0])), TRUE);
			else
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(options, my_options[i][0])), FALSE);
		}
		else if(!strncmp(my_options[i][0], "entry", 5))
		{
			configfile_option_get(config, my_options[i][1], my_options[i][2], value);
			gtk_entry_set_text(GTK_ENTRY(lookup_widget(options, my_options[i][0])), value);
		}
		else if(!strncmp(my_options[i][0], "clist", 5))
		{
			f = -1;
			value[0] = '\0';
			snprintf(option, 2048, "%s%i#1", my_options[i][2], ++f);
			while(configfile_option_get(config, my_options[i][1], option, value))
			{
				foo[0] = malloc(2048);
				foo[1] = malloc(2048);
				foo[2] = malloc(2048);
				foo[3] = malloc(2048);
				*foo[0] = '\0';
				*foo[1] = '\0';
				*foo[2] = '\0';
				*foo[3] = '\0';
				
				if(value)
					strncpy(foo[0], value, 2047);
				
// append a row and column number to the option name.
				snprintf(option, 2048, "%s%i#2", my_options[i][2], f);
				configfile_option_get(config, my_options[i][1], option, value);
				if(value)
					strncpy(foo[1], value, 2047);
				
				snprintf(option, 2048, "%s%i#3", my_options[i][2], f);
				configfile_option_get(config, my_options[i][1], option, value);
				if(value)
					strncpy(foo[2], value, 2047);
				
				snprintf(option, 2048, "%s%i#4", my_options[i][2], f);
				configfile_option_get(config, my_options[i][1], option, value);
					strncpy(foo[3], value, 2047);
				
				gtk_clist_append(GTK_CLIST(lookup_widget(options, my_options[i][0])), foo);
				gtk_clist_columns_autosize(GTK_CLIST(lookup_widget(options, my_options[i][0])));
				
				free(foo[0]);
				free(foo[1]);
				free(foo[2]);
				free(foo[3]);
				snprintf(option, 2048, "%s%i#1", my_options[i][2], ++f);
			}
		}
	}

	free(config);
	return 0;
}










void
options_specialchar_add(void)
{
	extern GtkWidget *options;
	GtkCList *clist = NULL;
	gchar *row[2];
	gchar *source = NULL;
	gchar *destination = NULL;
	gboolean replaced = FALSE;
	gint i = -1;
	
	clist = GTK_CLIST(lookup_widget(options, "clist_options_characters_list"));
	
	source = gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_source")));
	destination = gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_destination")));

// Source char is mandatory
	if(*source == '\0')
		return;
	
// the destination char MUST be a valid filename char, or empty
	if(!is_valid_filename_char(*destination) && *destination != '\0')
		return;
	
// go through the list, looking if the source char already exists.	
	while(gtk_clist_get_text(clist, ++i, 0, &row[0]))
	{
		if(strcmp(row[0], source)==0)
		{
			gtk_clist_set_text(clist, i, 1, destination);
			replaced = TRUE;
		}
	}
	
	if(!replaced)
	{
		row[0] = source;
		row[1] = destination;
		gtk_clist_append(clist, row);
	}
}





void
options_specialchar_del(void)
{
	extern GtkWidget *options;
	GtkCList *clist = NULL;
	gchar *row[2];
	gchar *source = NULL;
	gchar *destination = NULL;
	gint i = -1;
	
	clist = GTK_CLIST(lookup_widget(options, "clist_options_characters_list"));
	
	source = gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_source")));
	destination = gtk_entry_get_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_destination")));

// Source char is mandatory. Special chars CANT be deleted, cause they MUST be replaced.
	if(*source == '\0' || !is_valid_filename_char(*source))
		return;
	
// go through the list, looking if the source char already exists.	
	while(gtk_clist_get_text(clist, ++i, 0, &row[0]))
	{
		gtk_clist_get_text(clist, i, 1, &row[1]);
		
		if( strcmp(row[0], source)==0
			&& strcmp(row[1], destination)==0 )
			gtk_clist_remove(clist, i);
	}
}




void
options_specialchar_update(void)
{
	extern GtkWidget *options;
	GtkCList *clist = NULL;
	GList *selection = NULL;
	gchar *source = NULL;
	gchar *destination = NULL;
	gint row = 0;
	
	clist = GTK_CLIST(lookup_widget(options, "clist_options_characters_list"));

// if nothing is selected, return.
	if(!(selection = clist->selection))
		return;

	row = (gint)selection->data;
	gtk_clist_get_text(clist, row, 0, &source);
	gtk_clist_get_text(clist, row, 1, &destination);
	
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_source")), source);
	gtk_entry_set_text(GTK_ENTRY(lookup_widget(options, "entry_options_characters_destination")), destination);
}


