/* the cantus project.
 * (c)2002 by Samuel Abels (sam@manicsadness.com)
 * This project's homepage is: http://software.manicsadness.com/cantus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "gui_log.h"
#include "support.h"

GtkCTreeNode *
log_add(GtkCTreeNode *parent, gchar *text, gint status)
{
	extern GtkWidget *cantus;
	GtkCTree *ctree = NULL;
	
	GtkCTreeNode *node = NULL;
	gchar *column[1];
	gchar *temp = NULL;

	GdkColormap *colormap = NULL;
	GdkPixmap *pixmap_title = NULL;
	GdkPixmap *pixmap_done = NULL;
	GdkPixmap *pixmap_error = NULL;
	GdkBitmap *mask_title = NULL;
	GdkBitmap *mask_done = NULL;
	GdkBitmap *mask_error = NULL;

	colormap = gtk_widget_get_colormap (cantus);
	
	ctree = GTK_CTREE(lookup_widget(cantus, "ctree_cantus_log_log"));
	
	gtk_clist_freeze(GTK_CLIST(ctree));
	gtk_ctree_set_indent(ctree, 10);

// Init the pixmap for title branches
	temp = g_strconcat(PACKAGE_PIXMAPS_DIR, "/todo.xpm", NULL);
	pixmap_title = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask_title, NULL, temp);
	free(temp);
// Init the pixmap for logentries, successful
	temp = g_strconcat(PACKAGE_PIXMAPS_DIR, "/done.xpm", NULL);
	pixmap_done = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask_done, NULL, temp);
	free(temp);
// Init the pixmap for logentries, errors
	temp = g_strconcat(PACKAGE_PIXMAPS_DIR, "/error.xpm", NULL);
	pixmap_error = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask_error, NULL, temp);
	free(temp);

// Insert log node into ctree
	column[0] = text;
	
	switch(status)
	{
		case 1:
			node = gtk_ctree_insert_node(ctree, parent, NULL, column, 5, pixmap_title, mask_title, pixmap_title, mask_title, FALSE, FALSE);
			break;
		
		case 2:
			node = gtk_ctree_insert_node(ctree, parent, NULL, column, 5, pixmap_done, mask_done, pixmap_done, mask_done, FALSE, FALSE);
			break;
		
		case 3:
			node = gtk_ctree_insert_node(ctree, parent, NULL, column, 5, pixmap_error, mask_error, pixmap_error, mask_error, FALSE, FALSE);
			gtk_ctree_expand(ctree, parent);
			break;
	}
	
	gtk_clist_thaw(GTK_CLIST(ctree));
	return node;
}


