%define name cantus
%define version 1.07
%define release 1
%define summary A GUI tool to rename and tag mp3 and ogg/vorbis files

Summary: %{summary}
Name: %{name}
Version: %{version}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
License: GPL
URL: http://software.manicsadness.com/cantus
Group: Applications/Multimedia
Packager: Samuel Abels <sam@manicsadness.com>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: gtk+ >= 1.2.3 gnome-libs-devel >= 1.2.8 libogg-devel libvorbis-devel
Requires: gtk+ >= 1.2.3 gnome-libs >= 1.2.8 libogg libvorbis
Obsoletes: gmp3

%description
cantus is a suite to rename and tag mp3 and ogg/vorbis files.
It is free software, and distributed under the terms of the GPL.
It was written by sam (Samuel Abels, sam@manicsadness.com) and implemented in C using the GTK.

Features:

- define rules for renaming, which you can proceed on a list of files
- mass renaming/tagging of mp3s
- define rules to apply on a queue of mp3files
- dynamically tagging is implemented, that means, you can generate a tag out of the filename and/or directory name
- renaming of files through freedb
- a LOT more

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" %configure

make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
#%doc COPYING
%{_bindir}/%{name}
%{_datadir}/pixmaps/%{name}/*.xpm

%changelog
* Tue May 20 2003 Samuel Abels <sam@manicsadness.com> 1.07
- FLAC support has been added.
- Fixed some bugs.
* Tue Apr 01 2003 Samuel Abels <sam@manicsadness.com> 1.06
- The complete FreeDB library has been replaced, this should fix some bugs.
* Tue Feb 24 2003 Samuel Abels <sam@manicsadness.com> 1.05
- Bugfix: ID3V2 tag display error.
* Tue Nov 30 2002 Samuel Abels <sam@manicsadness.com> 1.04
- Some bugfixes in the ID3V2 library.
* Tue Oct 08 2002 Samuel Abels <sam@manicsadness.com> 1.03
- Many bugfixes in FreeDB
- Bugfixes in ID3V1
- More bugfixes.
* Sun Oct 06 2002 Samuel Abels <sam@manicsadness.com> 1.02
- Fixed a bug in Freedb.
- Translated the ID3 libraries to ANSI-C.
- The program must not be restarted after customizing the queue view
- Directory tree will be updated when collapsing a branch and opening it again.
- Fixed small bugs in the ID3V2 library.
- Shift/Tab works on all machines (Tageditor).
* Wed Oct 02 2002 Uwe Hartmann  <u.hartl@gmx.de>
- added Buildrequires: libogg-devel libvorbis-devel and Obsoletes: gmp3
* Sun Sep 28 2002 Samuel Abels <sam@manicsadness.com> 1.01
- Fixed a bug in id3v1!
* Sun Sep 28 2002 Samuel Abels <sam@manicsadness.com> 1.0
- Renamed to project to "cantus" (former "gmp3")
- Thousands of bugfixes.
- Cleanups, cleanups, cleanups.
- Rewrite of ID3V2lib.
- Better OGG support.
- much more.
* Sun Sep 08 2002 Samuel Abels <sam@manicsadness.com> 1.0pre5
- Minor bugfixes (e.g. memleaks)
- Minor feature changes (e.g. a moved checkbutton)
* Sun Sep 08 2002 Samuel Abels <sam@manicsadness.com> 1.0pre4
- Fixed bug that the queue didn't work.
- Fixed some stability problems.
- Disabled profiling in the cflags.
* Sun Sep 08 2002 Samuel Abels <sam@manicsadness.com> 1.0pre4
- Minor bugfixes.
- Possible to choose a default tag.
- "--disable-ogg" flag for the configure script
- Minor feature enhancements
* Sun Sep 08 2002 Samuel Abels <sam@manicsadness.com> 1.0pre3
- A bug in the Filename->Tag tool was fixed.
- The queue will be updated after using the Filename->Tag tool.
- Errors in the install script were fixed.
* Sat Sep 07 2002 Samuel Abels <sam@manicsadness.com> 1.0pre3
- OGG/Vorbis support!
- Bugfixes (FreeDB)
* Sat Sep 01 2002 Samuel Abels <sam@manicsadness.com> 1.0pre2
- Problems with the automatic special character replacement have been fixed.
* Sat Sep 01 2002 Samuel Abels <sam@manicsadness.com> 1.0pre2
- FreeDB support fix.
* Sat Aug 31 2002 Samuel Abels <sam@manicsadness.com> 1.0pre1
- Bugfix: No memleak when adding files to queue via the "Find Custom Files" dialog.
- Added filesystem operations: Delete file, delete directory, create directory.
- Added a new rule: Move file to ...
- Some more, I don't remember
* Sun Aug 25 2002 Samuel Abels <sam@manicsadness.com> 0.84-4
- Added some new rules
- Fixed a bug in the tag->filename rule, which didn't check for existing files.
* Sat Aug 24 2002 Samuel Abels <sam@manicsadness.com> 0.84-4
- Made the program more idiot-proof.
- Added a new rule: Strip all characters before the first occurence of a string
- Rule example uptade when a rule ist removed.
- Added a new tab to the rules dialog.
* Sat Aug 24 2002 Samuel Abels <sam@manicsadness.com> 0.84-3
- Removed most of the known bugs.
- Special charaters shouldn't hurt anymore.
- Freedb support cleanup. Removed a bunch of bugs there.
- Queue autoupdate after freedb rename.
* Mon Aug 12 2002 Samuel Abels <sam@manicsadness.com> 0.84-1
- have a look on http://software.manicsadness.com/cantus :-)
* Sat Aug 10 2002 Samuel Abels <sam@manicsadness.com> 0.83-1
- It's now possible to hide files and directories beginning with a dot.
- Complete new configfile structure.
- Save multiple presets.
- Bugfix: A weird bug, which sometimes caused the program to crash in the rules dialog.
- File extensions accepted are now "mp3", "MP3", "Mp3" and "mP3" (now case insensitive).
* Sat Jul 21 2002 Samuel Abels <sam@manicsadness.com> 0.82-2
- FreeDB requests work again.
* Sat Jul 21 2002 Samuel Abels <sam@manicsadness.com> 0.82-1
- Coose between viewing V1 or V2 tags in queue.
- Small GUI improvements, better look on themes with big fonts.
- Bugfixes, bugfixes, bugfixes...
* Sat Jul 20 2002 Samuel Abels <sam@manicsadness.com> 0.81-1
- Choose between viewing the v1 or v2 tag in the tageditor.
- Also, you can now choose which tags to write (v1, v2 or both).
- The dialog "Choose Album" and "Sort Tracks" have been merged together. (FreeDB request).
- Added a new tab "Tag -> Filename" for quicker usage then the rules dialog.
- Tracks in ID3V2 tags are now saved as twodigit, always.
- The source (ID3V1 or ID2V2) of "Tag2filename" can now be chosen (in the new tab as well as in the rules dialog).
- Bugfix: Program won't crash when renaming manually (by rightclick), when the queue is empty.
- Bugfix: Program won't crash when trying to use the replace rule without arguments.
- The ID2V2 track number can now be displayed as two digit number, too. (e.g. "01")
- Added a new rule "set permissions".
- The background color in the queue list is now toggled.
- The FreeDB tool won't overwrite existing files.
- More (small) bugfixes.
- Code cleanups.
* Sat Jun 29 2002 Samuel Abels <sam@manicsadness.com> 0.8-1
- Added more filters to the find dialog
- removed unused buttons "freedb auto get"
- removed button "select all" (use CTRL/a instead)
- the genre list is now sorted alphabetically
- some more...
* Sat Jun 29 2002 Uwe Hartmann <u.hartl@gmx.de> 0.8pre2-2
- fixed bug in tag -> filename with patchfile 
* Thu Jun 27 2002 Uwe Hartmann <u.hartl@gmx.de> 0.8pre2-1
- new version
* Mon Jun 24 2002 Uwe Hartmann <u.hartl@gmx.de> 0.8pre1-1
- new version
* Wed Jun 12 2002 Uwe Hartmann <u.hartl@gmx.de> 0.15a-1
- new version
* Wed Jun 12 2002 Uwe Hartmann <u.hartl@gmx.de> 0.14-1
- first Redhat (7.3) package
