
#include "VideoDeviceOptions.h"

static const char *option[][2] = {
   { "width",      "176"   },
   { "height",     "144"   },
   { "framerate",  "10"    },
   { "brightness", "32768" },
   { "contrast",   "32768" },
   { "saturation", "32768" },
   { "gamma",      "32768" },
   { "hue",        "32768" },
   { 0, 0 }
};



CVideoDeviceOptions::CVideoDeviceOptions()
{
   DeclareVariables();
}

CVideoDeviceOptions::~CVideoDeviceOptions()
{
}



void CVideoDeviceOptions::DeclareVariables()
{
   int i;

   for (i = 0; option[i][0] != 0; i++)
      DeclareVariable(option[i][0], option[i][1]);
}



QSize CVideoDeviceOptions::GetSize() const
{
   int w, h;

   w = GetInt("width");
   h = GetInt("height");
   return QSize(w, h);
}

void CVideoDeviceOptions::SetSize(const QSize &size)
{
   Set("width", size.width());
   Set("height", size.height());
}

int CVideoDeviceOptions::GetFramerate() const
{
   return GetInt(option[2][0]);
}

void CVideoDeviceOptions::SetFramerate(int fps)
{
   Set(option[2][0], fps);
}

int CVideoDeviceOptions::GetBrightness() const
{
   return GetInt(option[3][0]);
}

void CVideoDeviceOptions::SetBrightness(int b)
{
   Set(option[3][0], b);
}

int CVideoDeviceOptions::GetContrast() const
{
   return GetInt(option[4][0]);
}

void CVideoDeviceOptions::SetContrast(int c)
{
   Set(option[4][0], c);
}

int CVideoDeviceOptions::GetGamma() const
{
   return GetInt(option[5][0]);
}

void CVideoDeviceOptions::SetGamma(int g)
{
   Set(option[5][0], g);
}

int CVideoDeviceOptions::GetSaturation() const
{
   return GetInt(option[6][0]);
}

void CVideoDeviceOptions::SetSaturation(int s)
{
   Set(option[6][0], s);
}

int CVideoDeviceOptions::GetHue() const
{
   return GetInt(option[7][0]);
}

void CVideoDeviceOptions::SetHue(int h)
{
   Set(option[7][0], h);
}

