#ifndef VIDEODEVICETUNER_HPP
#define VIDEODEVICETUNER_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>

class CVideoDevice;

class CVideoDeviceTuner: public QObject
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   int Tuner;
   
   QString Name;
   int Flags, Norm;
   float FreqLow, FreqHigh;
   float FreqStep;
   ulong ufreq;

public:
   enum {
     PAL,
     NTSC,
     SECAM,
     PAL_NC,
     PAL_M,
     PAL_N,
     NTSC_JAPAN,
     MAX,
   } TunerNorms;

   CVideoDeviceTuner(CVideoDevice *_video, int _tuner);
   
   const QString GetName();

   float GetLowestFrequency() const;
   float GetHighestFrequency() const;
   float GetFrequency() const;
   bool SetFrequency(float freq);

   bool HasNorm() const;
   void SetNorm(int norm);
   int GetNorm() const;
};

#endif
