(* $Id: rpc_program.mli 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)

(* An RPC server offers its procedures as parts of a "program". Here,
 * the notion of programs is introduced.
 * A program is identified by a program number and a version number.
 * The service of a program is a set of procedures that are described
 * by procedure numbers and signatures. The signature of a procedure is a
 * pair (s,u) of XDR types that should be interpreted as function
 * s -> u.
 * To make work easier, programs are encapsulated as an opaque type t.
 * This data structure can store procedure names in addition to the plain
 * numbers, so you can refer to procedures by their names. But note that
 * these names are only local identifiers that are not transferred in the
 * RPC protocol. The signature can be formulated upon a type system
 * (a set of definitions of type names).
 *)

open Rtypes
open Xdr

type t

val create :
    uint4 ->                        (* which program *)
    uint4 ->                        (* which version *)
    xdr_type_system ->              (* the type system helping to formulate *)
    ( string * (uint4 * xdr_type_term * xdr_type_term)) list ->
                                      (* (procname, (procnr, input, output)) *)
    t

val update :
      ?program_number:uint4 ->
      ?version_number:uint4 ->
      t ->
	t


val program_number :
    t ->
      uint4

val version_number :
    t ->
      uint4

val signature :
    t ->
      string ->                         (* procedure name *)
	(uint4 * xdr_type * xdr_type)   (* procedure number,
				         * input type,
				         * output type
				         *)

val procedure_number :
    t ->
      string ->
	uint4
