/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef IMAGEACQUISITION_COMPONENT_H
#define IMAGEACQUISITION_COMPONENT_H

// -- CamiTK Core stuff
#include <Component.h>

namespace camitk {
/**
  * @brief
  * This class describes what is a generic Image Acquisition Component  which derives from Component.
  * To add a ImageAcquisitionComponent to the LoCalIm CEP, write a new class that inherits from this class.
  *
  * In order to inherits from this class, the followed methods have to be redefined:
  * -init
  * -run
  * -stop
  * -acquireImage
  */
class CAMITK_API ImageAcquisitionComponent : public Component {

    Q_OBJECT

public:

    /// constructor
    ImageAcquisitionComponent (Component * component, const QString &name);

    /// constructor
    ImageAcquisitionComponent (const QString &file, const QString &name);

    /// destructor
    virtual ~ImageAcquisitionComponent();

    /// pure virtual method to define a way to initialize your ImageComponent
    virtual void init() = 0;

    /// pure virtual method to define a way to start the acquisition done with the ImageComponent (i.e : running a acquisition in live...)
    virtual void run() = 0;

    /// pure virtual method to define a way to stop the acqusition performed during the process of your ImageComponent
    virtual void stop() = 0;

    /// pure virtual method to define a way to acquire an imageComponent during the process of your ImageComponent
    virtual void acquireImage() = 0;
};

}
#endif //IMAGEACQUISITION_COMPONENT_EXTENSION_H
