/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


// pml
#include <pml/Component.h>
#include <pml/MultiComponent.h>
#include <pml/StructuralComponent.h>
#include <pml/PhysicalModel.h>


#include "MultiComponentDC.h"
#include "MultiComponentDCPopup.h"
#include "StructuralComponentDC.h"
#include "PMManagerDC.h"

#include <vtkUnstructuredGrid.h>
#include <vtkPoints.h>

// -------------------- default constructor/destructor  --------------------
MultiComponentDC::MultiComponentDC(camitk::Component *parent, PMManagerDC * pmManagerDC, MultiComponent *mc) : ComponentDC(parent, pmManagerDC, dynamic_cast< ::Component *>(mc)) {
    myPopupMenu = NULL;

    // name
    // if there are no name set a default proper one
    QString name = getMultiComponent()->getName().c_str();

    if (name.isEmpty()) {
        if (mc->isExclusive()) {
            name = "Exclusive Components";
        } else {
            name = "Informative Components";
        }
    }

    camitk::Component::setName(name);

    // create the sub items (=create and register the sub-DCs)
    ::Component * c;
    for (unsigned int i = 0; i < getMultiComponent()->getNumberOfSubComponents(); i++) {
        // ask my multi component for its i-th sub item
        c = getMultiComponent()->getSubComponent(i);

        // check wether it is a multi component or a structural component
        if (dynamic_cast<MultiComponent *>(c)!=NULL)
            addSubMC(dynamic_cast<MultiComponent *>(c));
        else
            // this is a sc
            addSubSC(dynamic_cast<StructuralComponent *>(c));
    }

    // associate this DC with this SC in the map
    myPMManagerDC->addMultiComponentDCPair(std::ComponentDCPair(getMultiComponent(), this));

}


MultiComponentDC::~MultiComponentDC() {
    if (myPopupMenu)
        delete myPopupMenu;
}

// -------------------- getPopupMenu --------------------
QMenu * MultiComponentDC::getPopupMenu(QWidget* parent) {
    if (!myPopupMenu) {
        myPopupMenu = new MultiComponentDCPopup(this, parent);
    }

    return myPopupMenu;
}

// -------------------- addSubMC --------------------
MultiComponentDC * MultiComponentDC::addSubMC(MultiComponent *mc) {
    // check if a dc already exist for this mc
    MultiComponentDC *mcdc = myPMManagerDC->getDC(mc);

    if (!mcdc) {
        // create a new mcdc (that will register itself as a child)
        mcdc = new MultiComponentDC(this, myPMManagerDC, mc);
    } else
        // add the sub node here as well but without changing the initial parent
        camitk::Component::attachChild(mcdc);

    return mcdc;
}

// -------------------- addSubSC --------------------
StructuralComponentDC * MultiComponentDC::addSubSC(StructuralComponent *sc) {
    // check if a dc already exist for this sc
    StructuralComponentDC *scdc = myPMManagerDC->getDC(sc);

    if (!scdc) {
        // create a new scdc (that will register itself as a child)
        scdc = new StructuralComponentDC(this, myPMManagerDC, sc);
    } else
        // add the sub node here as well but without changing the initial parent
        camitk::Component::attachChild(scdc);

    return scdc;
}

//-------------------- addChild --------------------
void MultiComponentDC::addChild(InterfaceNode *childNode) {
    ComponentDC *cdc = dynamic_cast<ComponentDC *>(childNode);

    if (cdc) {
        ::Component *c = cdc->getComponent();
        // add only if the component is not already there
        if (c && getMultiComponent()->getComponentByName(c->getName()) != c)
            getMultiComponent()->addSubComponent(c);
    }

    camitk::Component::addChild(childNode);

}

//-------------------- removeChild -------------------
void MultiComponentDC::removeChild(InterfaceNode *childNode) {
    camitk::Component *dc = dynamic_cast<camitk::Component *>(childNode);
    ::Component *c = NULL;

    if (dc->isInstanceOf("MultiComponentDC") || dc->isInstanceOf("StructuralComponentDC"))
        c = dynamic_cast<ComponentDC *>(dc)->getComponent();

    if (c) {
        getMultiComponent()->removeSubComponent(c);
        camitk::Component::removeChild(childNode);
    }

}

//------------------------ getPixmap ---------------------
#include "multicomponent_20x20.xpm"
QPixmap * MultiComponentDC::myPixmap = NULL;
QPixmap MultiComponentDC::getIcon() {
    if (!myPixmap) {
        myPixmap = new QPixmap(multicomponent_20x20);
    }

    return (*myPixmap);
}


